<?php
//PJC 07-01-2020 v1.3 Added Yealink Firmware Link
//PJC 24-03-2019 v1.2 Update Phone GUID
//PJC 20-03-2019 v1.1 Check if values are set
//PJC 18-12-2018 v1.0 SIP Phone Update

session_start();
$page_id = "094";
include ".access.php";
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}

include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME']; 	
$getIp = NULL;

ini_set('default_socket_timeout', 5); // 5 Seconds
$getIp = @file_get_contents('http://splicepbx.uk/ip/index.php?mode=ip');
$externalIp = (isset($getIp) && strlen($getIp > 1)) ? trim($getIp) : "x.x.x.x";

$sr = @ldap_read($ds,"cn=yl,cn=system","objectclass=updateserver"); 
if ($sr) { $info = ldap_get_entries($ds,$sr); $ylserver = $info[0]['url'][0]; }
$ylserver = (isset($ylserver) && strlen($ylserver)>1) ? $ylserver : "";

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>SIP Phone Update Server</title>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<style type="text/css">
	@import "css/codes/codes_page.css";
	@import "css/codes/codes_table.css";
	@import "css/codes/custom.css";
	div.srv {overflow:hidden; }
	div.srv label {width:175px; display:block; float:left; text-align:left; vertical-align:middle; }
	div.srv.input {margin-left:4px; float:left; vertical-align:middle; }
</style>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/codes/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/sipphones.js" type="text/javascript"></script>
<script type="text/javascript" src="js/jquery.timepicker.js"></script>
<link rel="stylesheet" type="text/css" href="css/jquery.timepicker.css" />


</head>
<body id="dt_excodes">
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script ?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_sipphoneupgrade.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div style="position:absolute; top:30px; right:8px">
<?php link_check('094','<a onClick="centeredPopup(\'yealinkfirmware.php\',\'Yealink Firmware\',\'850\',\'750\',\'yes\');return false" href="#" class="orange">Yealink Firmware List</a><br/>', $ma_acl); ?>
<?php link_check("052","<a href='ssl.php' class='orange'>SSL/PCS Phone Update</a>", $ma_acl); ?>
</div>

<div id="container"><div id="codes">
<h3><img src='images/settings.png' style="vertical-align:middle;">&nbsp;SIP Phone Update</h3>

<br><h3>Firmware Settings</h3>
<div class='srv'>
<label><a href='#' class='tooltip' title='Enter Yealink Server Address. eg: http://<?php echo $externalIp?>/update/'><img src='images/tooltip.jpg'></a>&nbsp;<b>Yealink Upgrade Server:</b></label>
<img src='images/blank.gif' width='18px'><input type='text' name='yl' id='yl' value='<?php echo $ylserver ?>' style='width:255px'>
<input type='button' id='setyl' name='setyl' value='Update Yealink Server' style='width:145px'>
</div>

<span id="srvStatus" style="display:none;"></span><br>

<div class='srv'>
<label><a href='#' class='tooltip' title='Firmware File Name eg: T41-36.80.0.136.rom'><img src='images/tooltip.jpg'></a>&nbsp;<b>Firmware File Name:</b></label>
<img src='images/blank.gif' width='18px'><input type='text' name='ylfirmware' id='ylfirmware' value='' style='width:255px' placeholder='enter filename eg: T41-36.80.0.136.rom'/>
<input type='button' name='firmwareset' id='firmwareset' value='Set File' style='width:70px'><input type='button' name='firmwarereset' id='firmwarereset' value='Clear File'style='width:70px'>
</div>

<br><br>
<?php

		// build user array
       $sr = ldap_list($ds,"cn=Users","objectclass=user",array('cn','telephonenumber','initialphone'));
 	   $info = ldap_get_entries($ds, $sr); 
       		for ($m=0; $m<$info['count']; $m++) {
				$users[$info[$m]['initialphone'][0]] = array("name"=>$info[$m]['cn'][0],"extn"=>$info[$m]['telephonenumber'][0]);
			}
			
			
		$sr = ldap_search($ds,"cn=Modules","(&(objectclass=Phone)(typeofphone=3)(cn=SIP*))",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr); 
		
       		for ($m=0; $m<$info['count']; $m++) {
	       		$cn[$m] = $info[$m]['cn'][0];
	       		$guid[$m] = $info[$m]['guid'][0];
       		}
 	echo "<form method='post' id='frm' action='$script'>";
	echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead>
			<tr class='header'>
			<th width='3%'><input type='checkbox' name='select' onclick='checkedAll(frm)'>
			<th width='15%'>Name (serial)</th>
			<th width='10%'>Model</th>
			<th width='10%'>Username</th>
			<th width='10%'>Extension</th>
			<th width='15%'>Current Firmware</th>
			<th width='15%'>Upgrade Firmware File</th>
			<th width='3%'>Reboot</th>
			<th width='3%'>AutoProvision</th>
			<th width='10%'>Update Time</th>
			</tr>
		</thead>
		
		<tfoot>
			<tr class='header'>
			<th><input type='checkbox' name='select' onclick='checkedAll(frm)'>
			<th>Name (serial)</th>
			<th>Model</th>
			<th>Username</th>
			<th>Extension</th>
			<th>Current Firmware</th>
			<th>Upgrade Firmware File</th>
			<th>Reboot</th>
			<th>AutoProvision</th>
			<th>Update Time</th>
			</tr>
		</tfoot>
		<tbody>";


       		foreach ($cn as $cnk => $cnv) {
				
   			$sr2 = ldap_read($ds,"cn=1,guid=$guid[$cnk],cn-Modules","(objectclass=GenericIPPhone)", array('serialnumber','update','pnpmodel', 'filename', 'doreboot', 'doprovision')); 
			$info2 = ldap_get_entries($ds,$sr2); 
			
				$serial = ( strlen($info2[0]['serialnumber'][0]) >=1 ) ? "(" . $info2[0]['serialnumber'][0] . ")" : ""; 
				$model = ( strlen($info2[0]['pnpmodel'][0]) >=1 ) ? $info2[0]['pnpmodel'][0] : ""; 
				$update = ( strlen($info2[0]['update'][0]) >=1 ) ? $info2[0]['update'][0] : "";
				$reboot = ( strlen($info2[0]['doreboot'][0]) >=1 ) ? $info2[0]['doreboot'][0] : "";
				$autop = ( strlen($info2[0]['doprovision'][0]) >=1 ) ? $info2[0]['doprovision'][0] : "";
				$filename = ( strlen($info2[0]['filename'][0]) >=1 ) ? $info2[0]['filename'][0] : "";
				
				$rebootchecked = ($reboot == 1) ? 'checked' : '';
				$autopchecked = ($autop == 1) ? 'checked' : '';
				
			$sr2 = ldap_read($ds,"guid=$guid[$cnk],cn-Modules","objectclass=Phone"); 
			$info2 = ldap_get_entries($ds,$sr2); 
			
				$product_version = $info2[0]['productversion'][0];
   			
			if (array_key_exists($guid[$cnk],$users)) {
				$name = $users[$guid[$cnk]]['name']; 
				$extn = $users[$guid[$cnk]]['extn'];
			} else {
				$name = $extn = "<b>Not Set</b>"; 
			}
				
			echo "<tr>
					<td><input type='hidden' name='phones[$cnk]' value='0'><input type='checkbox' id='phones' name='phones[$cnk]' value='$guid[$cnk]'></td>
					<td>$cn[$cnk] <span style='font-size:7pt; font-style: italic;'>$serial</span></td>
					<td>$model</td>
					<td>$name</td>
					<td>$extn</td>
					<td style='color:#006600; font-weight:600'>$product_version</td>
					<td><input type='text' id='firmwareupgrade' name='firmwareupgrade[$cnk]' class='hidden' value='$filename' disabled></td>
					<td><input type='hidden' name='reboot[$cnk]' value='0'><input class='ignore' type='checkbox' id='reboot' name='reboot[$cnk]' value='1' $rebootchecked></td>
					<td><input type='hidden' name='autop[$cnk]' value='0'><input class='ignore' type='checkbox' id='autop' name='autop[$cnk]' value='1' $autopchecked></td>
					<td>$update</td>
				 </tr>";				
}
?>

	</table>
	<br><b>Create System Backup :</b> <input class='ignore' type='checkbox' name='backup' id='backup' checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.jpg'></a><br><br>
	

	<div class="srv"><label>Set Update Time: </label>
	<input type='submit' id="setNow" value='Set Now' style='width:75px'/><input type='hidden' name="ylset" value='set' />
	<input id='setUpdateTime' type='text' class='time' name='time' style='width:70px; height:18px;' placeholder='click to set' /></div>
	
	<div class="srv"><label>Set Update Mode: </label>
	<select name="mode" id="mode">
		<option value="update">Apply Commands</option>
		<option value="clear">Clear Commands</option>
	</select>
	</div>
	
	<input type='submit' name='update' id='update' value='Update Phone(s)' onclick="return confirm('Update Phone(s) ?')" >
	<input type='hidden' name='model' id='model' value='yl'>
	<span id="Status" style="display:none;"></span>
</form>
</body>
</html>