<?php
//PJC 16-07-2019 v1.2 Added $ent arrays
//PJC 24-03-2019 v1.2 Update Phone GUID

include "tzone.php"; // include timezone
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
        echo "LDAP connect failure<br>";
} else {
        $r = ldap_bind($ds,"INTERNAL","0123456");
        if ( ! $r) {
                echo "LDAP bind failure<br>";
                $ds = false;
        }
}

$model = (isset($_REQUEST['model']) && strlen($_REQUEST['model']) >= 1) ? $_REQUEST['model'] : NULL;

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
        $backup = "Backup ".date('d.m.y His')." - PreSSLUpdateTime.txt";
        $ent["dobackupto"][0] = $backup;
        ldap_modify($ds,"cn=Commands", $ent);
        ldap_modify($ds,"cn=Commands", $ent); $ent='';
}


if ($model === 'pcs') {
        $ent = array();
        if (isset($_POST['time']) && isset($_POST['phones'])) {
        $time = str_replace(":","",$_POST['time']);
        $phone = $_POST['phones'];

        foreach ($phone as $k => $guid) {
                        $dn = "cn=1,guid=$guid";
                        $ent["update"][0] = $time;
                        ldap_modify($ds, $dn, $ent); unset ($ent);
                }

        }
}


if ($model === 'yl') {
        $ent = array();

        if (isset($_POST['time']) && isset($_POST['phones'])) {

                $phone = (isset($_REQUEST['phones']) && count($_REQUEST['phones']) >= 1) ? $_REQUEST['phones'] : NULL;
                $mode = (isset($_REQUEST['mode']) && count($_REQUEST['mode']) >= 1) ? $_REQUEST['mode'] : NULL;

                if ($mode === 'update') {
                        $time = str_replace(":", "" ,$_POST['time']);
                        $reboot = (isset($_REQUEST['reboot']) && count($_REQUEST['reboot']) >= 1) ? $_REQUEST['reboot'] : NULL;
                        $autop = (isset($_REQUEST['autop']) && count($_REQUEST['autop']) >= 1) ? $_REQUEST['autop'] : NULL;


                } else {
                        $time = $reboot = $autop = '';
                }

                foreach ($phone as $k => $guid) {
                        if (strlen($guid) > 1) {
                                $dn = "cn=1,guid=$guid";
                                $ent["update"][0] = trim($time);
                                $ent["doReboot"][0] = trim($reboot[$k]);
                                $ent["doProvision"][0] = trim($autop[$k]);
                                ldap_modify($ds, $dn, $ent); unset ($ent);
                        }
                }
        }
}


if (isset($_REQUEST['ylsetrom']) && $_REQUEST['ylsetrom']=="1")  {

        $setphone = (isset($_REQUEST['setphones']) && count($_REQUEST['setphones']) >= 1) ? $_REQUEST['setphones'] : NULL;
        $firmwarerom = (isset($_REQUEST['firmwarerom']) && count($_REQUEST['firmwarerom']) >= 1) ? $_REQUEST['firmwarerom'] : NULL;
        $requiredversion = str_replace('.rom', '', trim(substr($firmwarerom, strpos($firmwarerom, '-') + 1)));

        foreach ($setphone as $k => $guid){
                $dn = "cn=1,guid=$guid";
                $ent["requiredversion"][0] = trim($requiredversion);
                $ent["filename"][0] = trim($firmwarerom);
                ldap_modify($ds, $dn, $ent); unset ($ent);
        }
}


if (isset($_REQUEST['ylclear']) && $_REQUEST['ylclear']=="1")  {

        $setphone = (isset($_REQUEST['setphones']) && count($_REQUEST['setphones']) >= 1) ? $_REQUEST['setphones'] : NULL;

        foreach ($setphone as $k => $guid){
                $dn = "cn=1,guid=$guid";
                $ent["requiredversion"][0] = '';
                $ent["filename"][0] = '';
                ldap_modify($ds, $dn, $ent); unset ($ent);
        }
}


if (isset($_REQUEST['pcsserver']) && $_REQUEST['pcsserver']=="1")  {
        $url = trim($_REQUEST['url']);

        $sr = @ldap_read($ds,"cn=pcs,cn=system","objectclass=updateserver");
        if ($sr) {
                        $ent["url"][0] = $url;
                        ldap_modify($ds,"cn=PCS,cn=System", $ent);
                } else {
                        $att=array('objectclass'=>'updateserver','cn'=>'PCS', 'url'=>$url);
                        ldap_add($ds,"cn=PCS,cn=System",$att);
                }
}

if (isset($_REQUEST['sslserver']) && $_REQUEST['sslserver']=="1")  {
        $url = trim($_REQUEST['url']);

        $sr = @ldap_read($ds,"cn=ssl,cn=system","objectclass=updateserver");
        if ($sr) {
                        $ent["url"][0] = $url;
                        ldap_modify($ds,"cn=SSL,cn=System", $ent);
                } else {
                        $att=array('objectclass'=>'updateserver','cn'=>'SSL', 'url'=>$url);
                        ldap_add($ds,"cn=SSL,cn=System",$att);
                }
}


if (isset($_REQUEST['ylserver']) && $_REQUEST['ylserver']=="1")  {
        $url = trim($_REQUEST['url']);

        $sr = @ldap_read($ds,"cn=yl,cn=system","objectclass=updateserver");
        if ($sr) {
                        $ent["url"][0] = $url;
                        ldap_modify($ds,"cn=YL,cn=System", $ent);
                } else {
                        $att=array('objectclass'=>'updateserver','cn'=>'YL', 'url'=>$url);
                        ldap_add($ds,"cn=YL,cn=System",$att);
                }
}


function var_error_log( $object=null ){
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

?>