<?php
session_start();
$page_id = "040";
include ".access.php";
$script=$_SERVER['SCRIPT_NAME'];
include "tzone.php"; // include timezone
// v2.06
//PJC 24-SEP-2018 Remove []!~= from Number match for DDI checking
//PJC 26-JAN-2017 Link Updates
//PJC 16Jan2013
?>
<html>
<head>
<title>System Check - Check For Config Errors</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_systemcheck.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='images/ok.png' style="vertical-align:middle;">&nbsp;System Check - Check For Config Errors</h2>
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
	$r=ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}


	$pwd = array("password","managerpassword","1234","0000","999","0");
	$chars = preg_quote(implode(' ', $pwd));


	echo "This script will check key areas of the system configuration and will alert you to potential issues.<br/><br/>";
  	echo "Array of entries being checked for :  <b>" .stripslashes($chars). "</b><br/><br/>";

	echo "<h2>Administrators</h2>";
	echo " Check if Administrators are using default password or any password included in the array<br/><br/>";
        $sr=ldap_search($ds,"cn=System","(objectclass=Administrator)",array('cn','userpassword','guid'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $pass = $info[$n]['userpassword'][0]; $guid = $info[$n]['guid'][0];

            $check ="";	$check =(in_array($pass, $pwd)) ? "<a href='../manager.cgi?pagename=administrator&index=$guid' target='_blank'><img src='images/error.jpg'></a>" : "<a href='../manager.cgi?pagename=administrator&index=$guid' target='_blank'><img src='images/ok.jpg'></a>";
			echo "<tr><td width='40%'>".$check ." ". $cn."</td></tr><br/>";
	    	}


	echo "<h2>Maintainer Passwords</h2>";
	echo " Check if any Maintainers passwords are default password or any password included in the array<br/><br/>";
        $sr=ldap_read($ds,"cn=System","(objectclass=*)",array('cn','webpassword','callloggingpassword','diagnosticengineeringpassword','maintainerpassword'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $wp = $info[$n]['webpassword'][0]; $cp = $info[$n]['callloggingpassword'][0]; $dp = $info[$n]['diagnosticengineeringpassword'][0]; $mp = $info[$n]['maintainerpassword'][0];

            $check ="";
            if (in_array($wp, $pwd))  {
	           $check = "<a href='../manager.cgi?pagename=system' target='_blank'><img src='images/error.jpg'></a>";
               echo "<tr><td width='40%'>$check Web Password</td></tr><br/>";
	    	}

	    	if (in_array($cp, $pwd)) {
		       $check = "<a href='../manager.cgi?pagename=system' target='_blank'><img src='images/error.jpg'></a>";
               echo "<tr><td width='40%'>$check Call Logging Password</td></tr><br/>";
           }

          	if (in_array($dp, $pwd)) {
	           $check = "<a href='../manager.cgi?pagename=system' target='_blank'><img src='images/error.jpg'></a>";
               echo "<tr><td width='40%'>$check Diagnostic Engineering Password</td></tr><br/>";
           }

           	if (in_array($mp, $pwd)) {
	           $check = "<a href='../manager.cgi?pagename=system' target='_blank'><img src='images/error.jpg'></a>";
               echo "<tr><td width='40%'>$check Maintainer Password</td></tr><br/>";
           }
	    	 	}

	echo "<h2>WANLinks</h2>";
	echo " Check if WANLinks are using default password or any password included in the array<br/><br/>";
        $sr=ldap_search($ds,"cn=Modules","(objectclass=wanlink)",array('cn','accountpasswordin','guid'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $passin = $info[$n]['accountpasswordin'][0]; $guid = $info[$n]['guid'][0];

            $check ="";	$check =(in_array($passin, $pwd)) ? "<a href='../manager.cgi?pagename=wanlink&index=$guid' target='_blank'><img src='images/error.jpg'></a>" : "<a href='../manager.cgi?pagename=wanlink&index=$guid' target='_blank'><img src='images/ok.jpg'></a>";
			echo "<tr><td width='40%'>".$check." ".$cn."</td></tr><br/>";
	    	}
	echo "<h2>VoicePorts</h2>";
	echo " Check if Voicemail Ports are using the Standard DialPlan<br/><br/>";
		$sr=ldap_read($ds, "cn=standard, cn=dialplans","(objectclass=dialplan)", array());
        $info = ldap_get_entries($ds, $sr); $dialplan =  $info[0]['guid'][0];
        $sr=ldap_search($ds,"cn=voicemailports","(objectclass=voicemailport)",array('cn','dialplan','guid'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $vmdialplan = $info[$n]['dialplan'][0]; $guid = $info[$n]['guid'][0];

            $check ="";	$check =($vmdialplan === $dialplan) ? "<a href='../manager.cgi?pagename=voicemailport&index=$guid' target='_blank'><img src='images/error.jpg'></a>" : "<a href='../manager.cgi?pagename=voicemailport&index=$guid' target='_blank'><img src='images/ok.jpg'></a>";
			echo "<tr><td width='40%'>".$check." ".$cn."</td></tr><br/>";
	    	}

	echo "<h2>Departments</h2>";
	echo " Check if Departments are using any voicemail access code listed in the array, or matching the department extension number<br/><br/>";
        $sr=ldap_search($ds,"cn=Departments","(objectclass=Department)",array('cn','voicemailaccesscode','telephonenumber','guid','voicemailenabled'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $vmcode = $info[$n]['voicemailaccesscode'][0]; $guid = $info[$n]['guid'][0]; $tele = $info[$n]['telephonenumber'][0]; $vmon = $info[$n]['voicemailenabled'][0];

            $check ="";
            if (in_array($vmcode, $pwd))
  				{
  					$check = "<a href='../manager.cgi?pagename=dept&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = "";
  				}
			elseif ($vmcode && ($vmcode == $tele))
  				{
  					$check = "<a href='../manager.cgi?pagename=dept&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = " ( Extension and code match )";
  				}
  			elseif (!$vmcode && $vmon =="1")
  				{
  					$check = "<a href='../manager.cgi?pagename=dept&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = " ( Enabled but no access code )";
  				}
			else
  				{
  					$check = "<a href='../manager.cgi?pagename=dept&index=$guid' target='_blank'><img src='images/ok.jpg'></a>"; $warn = "";
  				}
			echo "<tr><td width='40%'>".$check." ".$cn."</td><td width='40%'> <font size='2' color='grey'><i>".$warn."</i></font></td></tr><br/>";
	    	}

	echo "<h2>Users</h2>";
	echo " Check if Users are using any voicemail access code listed in the array or matching the users extension number<br/><br/>";
        $sr=ldap_search($ds,"cn=Users","(objectclass=user)",array('cn','voicemailaccesscode','telephonenumber','guid', 'voicemailenabled'));
            $info = ldap_get_entries($ds, $sr);
                 for ($n=0; $n<$info['count']; $n++) {
                    $cn = $info[$n]['cn'][0]; $vmcode = $info[$n]['voicemailaccesscode'][0]; $guid = $info[$n]['guid'][0]; $tele = $info[$n]['telephonenumber'][0]; $vmon = $info[$n]['voicemailenabled'][0];

           $check ="";
           if (in_array($vmcode, $pwd))
  				{
  					$check = "<a href='../manager.cgi?pagename=user&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = "";
  				}
			elseif ($vmcode && ($vmcode == $tele))
  				{
  					$check = "<a href='../manager.cgi?pagename=user&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = " ( Extension and code match )";
  				}
  			elseif (!$vmcode && $vmon =="1")
  				{
  					$check = "<a href='../manager.cgi?pagename=user&index=$guid' target='_blank'><img src='images/error.jpg'></a>"; $warn = " ( Enabled but no access code )";
  				}
			else
  				{
  					$check = "<a href='../manager.cgi?pagename=user&index=$guid' target='_blank'><img src='images/ok.jpg'></a>"; $warn = "";
  				}
   			echo "<tr><td width='40%'>".$check." ".$cn."</td><td width='40%'> <font size='2' color='grey'><i>".$warn."</i></font></td></tr><br/>";
	    	}



	echo "<h2>DDI's</h2>";
	echo " Check if voicemail access code matchs DDI digits. <br/>eg: Number match = 287700, voicemail access code is 4 digits, check if last 4 digits of DDI match access code.  ie: 7700.<br/><br/>";
        $sr=ldap_search($ds,"cn=ddicallplans","(objectclass=ddientry)",array('numbermatch','translateto'));
            $info = ldap_get_entries($ds, $sr);
              for ($n=0; $n<$info['count']; $n++) {
	            $nm = $info[$n]['numbermatch'][0]; 
				$tr = str_replace(array('[]','=','!','~'), '', $info[$n]['translateto'][0]);
				$tr = str_replace(array(')', '('),  array('\)', '\('), $tr);

	            if($nm) {

	              $sp=ldap_search($ds,"cn=users","(&(objectclass=user)(|(telephonenumber=$tr)(cn=$tr)))",array('telephonenumber','voicemailaccesscode','guid'));
					$inf = ldap_get_entries($ds, $sp);
					    for ($o=0; $o<$inf['count']; $o++) {
	            			$tp = $inf[$o]['telephonenumber'][0]; $vac = $inf[$o]['voicemailaccesscode'][0]; $guid = $inf[$o]['guid'][0];
		
	            	$check ="";
	            	$check = (substr($nm, -strlen($vac)) == $vac) ? "<a href='../manager.cgi?pagename=user&index=$guid&tab=7' target='_blank'><img src='images/error.jpg'></a>" : "<a href='../manager.cgi?pagename=user&index=$guid&tab=7' target='_blank'><img src='images/ok.jpg'></a>";
	             	echo $check." User DDI NumberMatch - ".$nm."<br/>";
	             	}

	              $sp=ldap_search($ds,"cn=departments","(&(objectclass=department)(|(telephonenumber=$tr)(cn=$tr)))",array('telephonenumber','voicemailaccesscode','guid'));
					$inf = ldap_get_entries($ds, $sp);
					    for ($o=0; $o<$inf['count']; $o++) {
	            			$tp = $inf[$o]['telephonenumber'][0]; $vac = $inf[$o]['voicemailaccesscode'][0]; $guid = $inf[$o]['guid'][0];
	            	$check ="";
	            	$check = (substr($nm, -strlen($vac)) == $vac) ? "<a href='../manager.cgi?pagename=dept&index=$guid&tab=3' target='_blank'><img src='images/error.jpg'></a>" : "<a href='../manager.cgi?pagename=dept&index=$guid&tab=3' target='_blank'><img src='images/ok.jpg'></a>";
	             	echo $check." Department DDI NumberMatch - ".$nm."<br/>";
	             	}

	    	}

    	}
		ldap_close($ds);

?>
</div>
</body>
</html>
