<?php
session_start();

//v4.62
//PJC 18JUL2019 - Updated MoH Source Server Selection
//PJC 28DEC2018 - Updated message if folder exists with wrong permissions
//PJC 20MAY2016 - Updated Voicemail PC to ignore BuiltIn
//PJC 16MAY2016 - Module Update
//PJC 12APR2016 - Wording Change
//PJC 07MAR2016 - Add GUID Folder creation inc .ht files
//PJC 29DEC2015 - Add Upload to Voicemail PC
//PJC 14OCT2015 - update warning for overwrite files on wav upload
//PJC 25-JUN-2015 Upload Wav Files - Select either /SpliceCom/ftp/ & /SpliceCom/Web/
//PJC 22-DEC-2014 Support for multiple destination CallServers when copying Wav files
//PJC 24-OCT-2014 Fixes for S8000
//PJC 01-SEPT-2014 - 127.0.0.1 set as default for MOH no source server
//PJC 28-Aug-2014 - copy files now looks at local IP / added MOH no source server
//PJC 29-July-2014 - mime type for wav files
//PJC 28-July-2014
//pjc 08/APR2014 - WAV 
//pjc 07/FEB2014
//pjc 07/OCT2013
$page_id = "075";
include ".access.php";
include "tzone.php"; // include timezone
include "ftpclass.php";
$script=$_SERVER['SCRIPT_NAME'];

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : "";
if (isset($_REQUEST['module']) && $_REQUEST['module'] == 'vmpc') $action = "9";
$module = (isset($_REQUEST['module'])) ? $_REQUEST['module'] : "";
$ftp_path = (isset($_REQUEST['ftplocation'])) ? $_REQUEST['ftplocation'] : "ftp";

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}

 $sr = ldap_list($ds,"cn=Modules","(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19))",array('guid','ipaddress','cn'));
   $info = ldap_get_entries($ds,$sr);
   for ($n=0;$n<$info['count'];$n++) {
      $moduleIP[$info[$n]['guid'][0]] = $info[$n]['ipaddress'][0];
      $moduleCN[$info[$n]['guid'][0]] = $info[$n]['cn'][0];
  }
  
 $sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
 $info=ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];
 $debug = FALSE;
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
    "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Wav Upload - Users, Departments, AA & MoH</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script type="text/javascript">
	function formSubmit()
		{
		document.getElementById("frm1").submit();
		}
</script>
<style type="text/css">
div.block { overflow:hidden; }
div.block label { width:225px; display:block; float:left; text-align:left; }
div.block .input { margin-left:4px; float:left; }
</style>
<script language="javascript">
	var popupWindow = null;
	function centeredPopup(url,winName,w,h,scroll){
	LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
	TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
	settings ='height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
	popupWindow = window.open(url,winName,settings)
}
</script>
<script>
$(document).ready(function () {
	var action = "<?php echo ($action); ?>";
	console.log (action)
		if (action == 6) { alert('You can only copy files from the callserver this script is currently running on'); }
				
		$('form').on('change', 'select[name="uvm"],select[name="dvm"]', function (event) {
			    if($(this).val()=="remove" || $(this).val()=="reset") {
				    $('#wavfile').hide();
			    } else {
				    $('#wavfile').show();
			    }
		});
		
	$('#ftplocation').change(function() {
		$('#ftppathheader').html(this.value);
		$('#ftppath').html(this.value);
	})
		
	$("#upload").click(function() {
		if ($("#module").val() =='' && action == 4 ) { alert('No Source Server Selected. Wav file will be uploaded to the server this script is being run on'); };
		if ( $("#user").val() == null && action == 1) { alert('No User Selected'); return false; }
				
		if ( $("#vmpc").val() == null && action == 9) { alert('No Voicemail PC(s) Selected'); return false; }
		
		if ( $("#uvm").val() == "remove" && action == 1) { 
			if (confirm ('Remove All Greeting Files ?')) {
	        	return;
        	} else {
	        	return false;
        	}
		}
		else if ( $("#uvm").val() == "reset" && action == 1) { 
			if (confirm ('Remove All Files & Reset MailBox ?')) {
	        	return;
        	} else {
	        	return false;
        	}
		}
		else if ( $("#uvm").val() == "" && action == 1) { 
			alert('No User Message Type Selected'); return false; 
		}
		
		if ( $("#dept").val() == null && action == 2) { alert('No Department Selected'); return false; }
		
		if ( $("#dvm").val() == "remove" && action == 2) { 
			if (confirm ('Remove All Greeting Files ?')) {
	        	return;
        	} else {
	        	return false;
        	}
		}
		else if ( $("#dvm").val() == "reset" && action == 2) { 
			if (confirm ('Remove All Files & Reset MailBox ?')) {
	        	return;
        	} else {
	        	return false;
        	}
		}
		else if ( $("#dvm").val() == "" && action == 2) { 
			alert('No Department Message Type Selected'); return false; 
		}
		
		if ( $("#aa").val() == null && action == 3) { alert('No AutoAttendant Selected'); return false; }
		if ( $("#moh").val() == null && action == 4) { alert('No Music Channel Selected'); return false; }
		if ( $("#wav").val() == "") { alert('No Wav File Selected'); return false; }
	});
});
</script>
</head>

<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_wavupload.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div style="position:absolute; top:30px; right:8px" >
<?php link_check("032","<a href='guid.php' target='_blank'>Voicemail GUIDS</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='images/wizards.png' style="vertical-align:middle;">&nbsp;Wav Upload - Users, Departments, AA & MoH</h2>
This script can be used to upload a wav file to a User or Department voicemailbox, an AutoAttendant Greeting or for updating a Music Channel.<br/>
The maximum file size supported is <b>10MB</b><br/>
Wav Files must be in the following format : <b>CCITT A-Law 8.000kHz 8bit mono</b><br/><br/>
<b>Please note:</b><br/>This script will only upload to the CallServer it is running on.<br/>You may receive a warning of you try to upload to a mailbox, auto attendant or music channel that isn't on this module or doesn't exist.<br/>Wav files uploaded to Music Channels will be renamed. Eg: MOH.wav will be renamed to MOHxxx.wav - where xxx is a random number between 01-999<br/><br/>

<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">

<b>Select Source:</b><br/>
<select onchange="formSubmit()" name="module" id="module">
<option value="" > </option>
<?php
if ($action == '6') {
		echo "<option value='$self' selected>$moduleCN[$self]</option>";
} else {
	foreach ($moduleCN as $cnk => $cnv){
		echo "<option value='$cnk'"; if ($cnk == $module) echo 'selected'; echo ">$cnv</option>";
	}
}

echo "<option value='vmpc'"; if ($module == 'vmpc') echo 'selected'; echo ">Voicemail PC</option>";
?>

</select>&nbsp;<a href='#' class='tooltip' title='<strong>CallServer / S8000</strong>: Mailbox or Wav is located on or to be uploaded to.<br/><strong>Voicemail PC</strong>: For wav file upload only. Voicemail PC to upload wav file to.'><img src='images/tooltip.jpg'></a><br/><br/>

<?php if ($module != "vmpc") {
?>

<b>Select Action:</b><br/>
<select onchange="formSubmit()" name="action">
<option value="0"></option>
<option value="1" <?php if ($action == '1') echo 'selected'; ?> >Users</option>
<option value="2" <?php if ($action == '2') echo 'selected'; ?> >Departments</option>
<option value="3" <?php if ($action == '3') echo 'selected'; ?> >Auto Attendant</option>
<option value="4" <?php if ($action == '4') echo 'selected'; ?> >Music On Hold</option>
<option value="5" <?php if ($action == '5') echo 'selected'; ?> >Wav Files</option>
<option value="6" <?php if ($action == '6') echo 'selected'; ?> >Copy Wav Files</option>
</select>&nbsp;<a href='#' class='tooltip' title='Users - Upload users voicemail greeting<br/>Department - Upload department voicemail greeting<br/>Auto Attendant - Upload auto attendant greeting<br/>Music On Hold - upload and update music channels<br/>Wav Files - Upload wav files to /SpliceCom/ftp/ or /SpliceCom/Web<br/>Copy Wav Files- Copy wav files from one CallServer to another.'><img src='images/tooltip.jpg'></a><br/><br/>

<?php } // if module?> 
</form>

<?php
if (isset($_REQUEST['action']) && isset($_REQUEST['module']) ) {
	
if ($_REQUEST['action'] =='1' && $module != "vmpc") {
echo "<h2> Upload Wav to Users </h2>";
		   echo "Module Selected: <b>$moduleCN[$module]</b><br/><br/>";
           $sr=ldap_list($ds,"cn=users", "(&(&(objectclass=user)(voicemailenabled=1)(currenthome=$module)))", array('cn','guid','telephonenumber'));
 	   	   ldap_sort($ds, $sr, 'cn'); $info = ldap_get_entries($ds, $sr);
		   if($info['count']<1) {
			   echo "No users have their Voicemail Box located on this server. Please run this script from the correct CallServer/S8000.";
			   exit;
		   }
		   echo "<form id='wavs' method='post' enctype='multipart/form-data'>";
		   echo "<div class='block'><label><b>Users </b>:<br/>";
 	   	   echo "<select name='user[]' size=6 multiple style='min-width: 175px' id='user'>";
 	   	   for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0]; $tele = $info[$n]['telephonenumber'][0];
				echo "<option value='$guid:$cn:$tele'>$cn ($tele)</option>";
				}
           echo "</select></label></div><br/><br/>";
           
echo "<div class='block'><label><b>Users Message Type </b>:
           <select name='uvm' id='uvm'>
           		<option value=''></option>
           		<optgroup label='Message Type'>
					<option value='Greeting.wav'>Normal Daily Greeting</option>
					<option value='GreetingPermanent.wav'>Permanent Daily Greeting</option>
					<option value='OOOGreeting1.wav'>In Meeting Greeting</option>
					<option value='OOOGreeting2.wav'>At Lunch Greeting</option>
					<option value='OOOGreeting3.wav'>On Holiday Greeting</option>
					<option value='OOOGreeting4.wav'>Off Site Greeting</option>
				</optgroup>
				<optgroup label='Actions'>
					<option value='remove'>Remove All Greetings</option>
					<option value='reset'>Reset MailBox</option>
				</optgroup>
           </select></label></div><br/><br/>";
echo "<div id='wavfile'><label for='file'><b>Wav File</b> : <br/></label><input type='file' name='wav' id='wav'><br/></div>
	  <input type='hidden' name='set'><input type='hidden' name='mtype' value='user'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'>
	  <input type='hidden' name='action' value='1'><input type='submit' name='upload' id='upload' value=' Submit '><br/></form>";
}

if ($_REQUEST['action'] =='2' && $module != "vmpc") {
echo "<h2> Upload Wav to Departments </h2>";
		   echo "Module Selected: <b>$moduleCN[$module]</b><br/><br/>";
           $sr=ldap_list($ds,"cn=departments", "(&(&(objectclass=department)(voicemailenabled=1)(currenthome=$module)))", array('cn','guid','telephonenumber'));
 	   	   $info = ldap_get_entries($ds, $sr);
 	   	   if($info['count']<1) {
			   echo "No departments have their Voicemail Box located on this server. Please run this script from the correct CallServer/S8000.";
			   exit;
		   }
 	   	   echo "<form id='wavs' method='post' enctype='multipart/form-data'>";
		   echo "<div class='block'><label><b>Departments </b>:<br/>
           <select name='dept[]' size=6 multiple style='min-width: 175px' id='dept'>";
 	   	   for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0];$tele = $info[$n]['telephonenumber'][0];
				echo "<option value='$guid:$cn:$tele'>$cn ( $tele )</option>";
				}
           echo "</select></label></div><br/><br/>";
echo "<div class='block'><label><b>Department Message Type </b>:
           <select name='dvm' id='dvm'>
           		<option value=''></option>
           		<optgroup label='Message Type'>
					<option value='Greeting.wav'>Normal Daily Greeting</option>
					<option value='OOHGreeting.wav'>Out Of Hours Greeting</option>
					<option value='OOOGreeting1.wav'>In Meeting Greeting</option>
					<option value='OOOGreeting2.wav'>At Lunch Greeting</option>
					<option value='OOOGreeting3.wav'>On Holiday Greeting</option>
					<option value='OOOGreeting4.wav'>Off Site Greeting</option>
					<option value='announcementInitial.wav'>Initial Announcement</option>
					<option value='announcementRepeat.wav'>Repeat Announcement</option>
				<optgroup label='Actions'>
					<option value='remove'>Remove All Greetings</option>
					<option value='reset'>Reset MailBox</option>
				</optgroup>
           </select></label></div><br/><br/>";
echo "<div id='wavfile'><label for='file'><b>Wav File</b> : <br/></label><input type='file' name='wav' id='wav'><br/></div>
	<input type='hidden' name='set'><input type='hidden' name='mtype' value='dept'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'>
	<input type='hidden' name='action' value='2'><input type='submit' name='upload' id='upload' value=' Submit '><br/></form>";
}

if ($_REQUEST['action'] =='3' && $module != "vmpc") {
echo "<h2> Upload Wav to AutoAttendant </h2>";
echo "Module Selected: <b>$moduleCN[$module]</b><br/><br/>";
echo "<form id='wavs' method='post' enctype='multipart/form-data'>";
echo "<div class='block'><label><b>Auto Attendants </b>:<br/>
           <select name='aa[]' size=6 multiple style='min-width: 175px' id='aa'>
           		<option value=':Default AA'>Default Auto Attendant </option>";
           $sr=ldap_list($ds,"cn=companies", "(objectclass=company)", array('cn','guid'));
 	   	   $info = ldap_get_entries($ds, $sr); for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0];
				echo "<option value='$guid:$cn'>$cn (company)</option>";
				}
           echo "</select></label></div><br/><br/>";
echo "<label for='file'><b>Wav File</b> : <br/></label><input type='file' name='wav' id='wav'><br/>
	<input type='hidden' name='set'><input type='hidden' name='mtype' value='aa'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'>
	<input type='hidden' name='action' value='3'><input type='submit' name='upload' id='upload' value=' Submit '><br/></form>";
}

if ($_REQUEST['action'] =='4' && $module != "vmpc") {
	echo "<h2> Upload Wav to Music on Hold </h2>";
	
	if (isset($module) && strlen($module)>1) {
		echo "Module Selected: <b>$moduleCN[$module]</b><br/><br/>";
	} else {
		echo "Module Selected: <b>No Source Server</b><br/><br/>";
		$module='00000000-0000-0000-0000-000000000000';
	}

echo "<form id='wavs' method='post' enctype='multipart/form-data'>";
echo "<div class='block'><label><b>Music Channels </b>:<br/>
      <select name='moh[]' size=6 multiple style='min-width: 175px' id='moh'>";
           $sr=ldap_list($ds,"cn=musicchannels", "(&(objectclass=musicchannel)(|(sourcemodule=$module)(sourcemodule=00000000-0000-0000-0000-000000000000)))", array('cn','guid','sourcemodule'));
 	   	   $info = ldap_get_entries($ds, $sr); for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0]; $src = $info[$n]['sourcemodule'][0];
				$sourceModule = ($src == '00000000-0000-0000-0000-000000000000') ? 'No Source Server Set' : $moduleCN[$src];
				echo ($cn == "DefaultHoldMusic") ? "<option value='$guid:$cn'>$cn - $sourceModule</option>" : "<option value='$guid:$cn'>$cn</option>";;
				}
      echo "</select></label></div><br/><br/>";
echo "<label for='file'><b>Wav File</b> : <br/></label><input type='file' name='wav' id='wav'><br/>
	<input type='hidden' name='set'><input type='hidden' name='mtype' value='moh'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'>
	<input type='hidden' name='action' value='4'><input type='submit' name='upload' id='upload' value=' Submit '><br/></form>";
	}
	
	
if ($_REQUEST['action'] =='5' && $module != "vmpc") {
echo "<h2> Upload Wav to /SpliceCom/<span id='ftppathheader'>$ftp_path</span>/</h2>";
echo "<b>Please Note:</b> Uploading files via this page to <b>/$moduleIP[$module]/SpliceCom/<span id='ftppath'>$ftp_path</span>/</b> will <span class='boldred'>overwrite any existing file of the same name</span>.<br/><br/>";
echo "Module Selected: <b>$moduleCN[$module]</b><br/><br/>";
echo "<form id='wavs' method='post' enctype='multipart/form-data'>";
echo "<label><b>Upload Location</b> : <br/>/SpliceCom/</label><select id='ftplocation' name='ftplocation'><option value='ftp'>ftp</option><option value='Web'>Web</option></select>&nbsp;<a href='#' class='tooltip' title='ftp = MoH, DialPlan and DDIPlan Entries<br/>Web = VXML Scripts'><img src='images/tooltip.jpg'></a><br/><br/>";
echo "<label for='file'><b>Wav File</b> : <br/></label><input type='file' name='wav' id='wav'><br/>
	<input type='hidden' name='set'><input type='hidden' name='mtype' value='vxml'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'>
	<input type='hidden' name='action' value='5'><input type='submit' name='upload' id='upload' value=' Submit '><br/></form>";
}

if ($_REQUEST['action'] =='6' && $module != "vmpc") {
echo "<h2> Copy Wav files from /SpliceCom/ftp to remote server </h2>";
$module_ip = $_SERVER['SERVER_ADDR'];
echo "You can only copy files from the callserver this script is currently running on.<br/>";
echo "CallServer IP Address : <b>$module_ip</b><br/><br/>";

if (isset($module_ip)) {
	$ftp = new ftp();
	$ftp->debug = $debug;

	if (!$ftp->ftp_connect($module_ip)) {
		die("Cannot connect\n");
	}

	if (!$ftp->ftp_login("admin", "password")) {
		$ftp->ftp_quit(); die("Login failed\n");
	}

	$list=$wavs= array();
	$wavlist = $ftp->ftp_nlist("*.wav");
	
echo "<br/><form id='copy' method='post'>";
foreach ($wavlist as $wavk => $wavv) {
	if (strlen($wavv)>1) echo "<input type='checkbox' name='copywavs[]' value='$wavv'>$wavv<br/>";
}
	
echo "<br/><b>Destination CallServer</b><br/><br/>
Selecting multiple options vary in different operating systems and browsers:<br/>
<b>For windows</b>: Hold down the control (ctrl) button to select multiple individual CallServers. Hold down the shift button to select a range.<br/>
<b>For Mac</b>: Hold down the command button to select multiple individual CallServers. Hold down the shift button to select a range.<br/><br/>

	  <select name='destmodule[]'  multiple='multiple' size='6'>
      <option value='' > </option>";

foreach ($moduleCN as $cnk => $cnv){
	echo "<option value='$cnk'>$cnv</option>";
}
echo "</select>";

echo "<input type='hidden' name='set'><input type='hidden' name='mtype' value='copy'><input type='hidden' name='module' value='$module'><input type='hidden' name='module_ip' value='$moduleIP[$module]'><input type='hidden' name='action' value='6'>
<br/><input type='submit' name='upload' id='ftpupload' value=' Submit '><br/></form>";	
	}
}

if ($module == "vmpc") {
	echo "<h2>Upload Wav to Voicemail PC</h2>";
	echo "<b>Please Note:</b> Uploading files via this page to selected Voicemail PC's' will <span class='boldred'>overwrite any existing file of the same name</span>.<br/><br/>";
	
	echo "<form id='vmpc-moh' method='post' enctype='multipart/form-data'>";
	echo "<div class='block'><label><b>Voicemail PC:</b>&nbsp;<a href='#' class='tooltip' title='Only Voicemail PC&apos;s with a valid IP Address configured in the H323 Address field will be shown.'><img src='images/tooltip.jpg'></a><br/>
      <select name='vmpc[]' size=6 multiple style='min-width: 175px' id='vmpc'>";
	  
		   $sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];
           $sr=ldap_list($ds,"cn=voicemailports", "(&(objectclass=voicemailport)(location=$self)(!(cn=BuiltIn)))", array('cn','guid','sourcemodule','h323address'));
 	   	   $info = ldap_get_entries($ds, $sr); 
		   if ($info['count'] >= '1') {
				for ($n=0; $n<$info['count']; $n++) {
					$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0]; $h323 = $info[$n]['h323address'][0];
				
					if (strlen($h323) >=1 && preg_match('/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/', $h323)==1 ) {
						echo "<option value='$cn:$h323'>$cn - $h323</option>";
					}
				}
			} else {
				echo "<option value='' disabled>No Voicemail PC Found</option>";
			}
			
			
    echo "</select></label></div><br/>";
	
	$sr = ldap_read($ds,"cn=System","objectclass=*"); $info = ldap_get_entries($ds,$sr); 
	$maint_pass = $info[0]['maintainerpassword'][0];
	
	echo "<div class='block'><label><b>FTP Admin Username:</b>&nbsp;<a href='#' class='tooltip' title='Admin FTP Username - Default is normally admin'><img src='images/tooltip.jpg'></a></label></div> <input type='text' name='vmpc_ftp_username' value='admin' size='11'><br/><br/>";
	echo "<div class='block'><label><b>FTP Admin Password:</b>&nbsp;<a href='#' class='tooltip' title='Admin FTP Password - Field has been pre filled with Maintainer Password.'><img src='images/tooltip.jpg'></a></label></div> <input type='password' name='vmpc_ftp_password' value='$maint_pass' size='11'><br/><br/>";
	  
	echo "<label for='file'><b>Wav File:</b><br/></label><input type='file' name='wav' id='wav'><br/><br/>
	<input type='hidden' name='set'><input type='hidden' name='module' value='vmpc'><input type='hidden' name='mtype' value='voicemailpc'>
	<input type='hidden' name='action' value='9'><input type='submit' name='upload' id='upload' value=' Submit '><br/><br/></form>";
	
}


}//END ACTION


if (isset($_REQUEST["set"])) {
if ($_FILES) {
	if (strlen($_FILES['wav']['name']) > '1') {
	
	if ($_FILES["wav"]["error"] > 0) {
		$file_errors = array("There is no error, the file uploaded with success","The uploaded file exceeds the upload_max_filesize directive in php.ini","The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form","The uploaded file was only partially uploaded","No file was uploaded","Missing a temporary folder","Failed to write file to disk","A PHP extension stopped the file upload");
		echo "Sorry there has been an error.<br />";
		echo "Return Code: <b>" . $file_errors[$_FILES["wav"]["error"]] . "</b><br />";
		exit;
	}
	
	$mime_wav = array('audio/wav', 'audio/x-wav', 'audio/wave','audio/x-pn-wav');
	if (!in_array($_FILES["wav"]["type"], $mime_wav)) {
		echo "<script>alert(\"Error: Wrong File Type. Only wav files are supported.\");</script>";
		exit;
	}

	if($_FILES["wav"]["size"]>"10485760") {
		echo "<script>alert(\"Error: File Size Exceeded. Maximum File Size 10MB.\");</script>";
		exit;
	}
}

	$tmp_name = $_FILES['wav']['tmp_name'];
	$fp = fopen($tmp_name, 'r');
	fseek($fp, 20); $d = fread($fp, 18); $data = unpack('vfmt/vch/Vsr/Vdr/vbs/vbis/vext', $d);
	$format = array(0x0001 => 'PCM',0x0003 => 'IEEE Float',0x0006 => 'A-LAW',0x0007 => 'MuLAW',0xFFFE => 'Extensible',);
	$bit = rtrim($data['sr'],"0") * rtrim($data['dr'],"0");
	$chn = ($data['ch'] = 1) ? "Mono" : "Stereo";

	if ($format[$data['fmt']]!="A-LAW" || $data['ch']>1 ||$data['dr']>8000 || $bit>64) echo "<b>Warning</b> : The wav file needs to be A-LAW 8000Hz 8bit mono. Your file is <b>".$format[$data['fmt']]." ".$data['sr']."Hz ".$bit."bit ".$chn."</b><br/><br/>";
	}

	$module_ip = $_REQUEST['module_ip'];
	$sr = ldap_read($ds,"cn=System","objectclass=*"); $info = ldap_get_entries($ds,$sr); 
	$maint_pass = $info[0]['maintainerpassword'][0]; $web_pass = $info[0]['webpassword'][0];


switch ($_REQUEST['mtype'])
{
case "user":
  $user=$_REQUEST['user']; $file=$_REQUEST['uvm']; $ftp_user = "voice"; $ftp_pass = $maint_pass;
  break;
case "dept":
  $dept=$_REQUEST['dept']; $file=$_REQUEST['dvm']; $ftp_user = "voice"; $ftp_pass = $maint_pass;
  break;
case "aa":
  $aa=$_REQUEST['aa']; $file="AAGreeting.wav"; $ftp_user = "voice"; $ftp_pass = $maint_pass;
  break;
case "moh":
  $moh=$_REQUEST['moh']; $file=substr($_FILES["wav"]["name"],0,-4).mt_rand(01, 999).".wav"; $ftp_user = "admin"; $ftp_pass = $maint_pass;
  break;
case "vxml":
  $file = $_FILES['wav']['name']; $ftp_path = $_REQUEST['ftplocation']; $ftp_user = ($ftp_path == "ftp") ? "admin" : "web"; $ftp_pass = ($ftp_path == "ftp") ? $maint_pass : $web_pass;
  break;
case "copy":
  $ftp_user = "admin"; $ftp_pass = $maint_pass;
  break;  
case "voicemailpc":
	$file = $_FILES['wav']['name']; $ftp_user = $_REQUEST['vmpc_ftp_username']; $ftp_pass = $_REQUEST['vmpc_ftp_password']; $voicemail_pc = $_REQUEST['vmpc'];
	break;
default:
  echo "Warning..";
}

$greet = array('Greeting.wav'=>'Normal Daily Greeting','OOHGreeting.wav'=>'Out Of Hours Greeting','OOOGreeting1.wav'=>'In Meeting Greeting','OOOGreeting2.wav'=>'At Lunch Greeting','OOOGreeting3.wav'=>'On Holiday Greeting','OOOGreeting4.wav'=>'Off Site Greeting','GreetingPermanent.wav'=>'Permanent Daily Greeting','AAGreeting.wav'=>'Auto Attendant Greeting');

$ftp = new ftp();
$ftp->debug = $debug;

if($_REQUEST['mtype']=="user"){
echo "<h2> User Greetings </h2>";

foreach ($user as $k => $v) {
	$val =explode(":", $v);
	
	if ($file=="remove") {  // remove greeting files
		ftp_action_del ($ftp, $val[0], $val[1], "*Greeting*.wav");
	}

	else if ($file=="reset") { // remove all files
		ftp_action_del ($ftp, $val[0], $val[1], "*");
	}

	else {
		ftp_action ($ftp, $val[0], $val[1], $file, $val[2]);
	}
	
  }
	if (isset($tmp_name)) unlink($tmp_name);
}

if($_REQUEST['mtype']=="dept"){
echo "<h2> Department Greetings </h2>";
foreach ($dept as $k => $v) {
	$val =explode(":", $v);

	if ($file=="remove") {  // remove greeting files
		ftp_action_del ($ftp, $val[0], $val[1], "*Greeting*.wav");
	}

	else if ($file=="reset") { // remove all files
		ftp_action_del ($ftp, $val[0], $val[1], "*");
	}

	else {
		ftp_action ($ftp, $val[0], $val[1], $file, $val[2]);
	}
	
  }
	if (isset($tmp_name)) unlink($tmp_name);
}

if($_REQUEST['mtype']=="aa"){
echo "<h2> Auto Attendant Greetings </h2>";
foreach ($aa as $k => $v) {
	$val =explode(":", $v);
	$autoattendant = ($val[1]==="Default AA") ? " the Default Auto Attendant" : " to company Auto Attendant : <b>$val[0]</b>";
	ftp_action ($ftp, $val[0], $val[1], $file, NULL);
  }
	unlink($tmp_name);
}

if($_REQUEST['mtype']=="moh"){
$module_ip = (isset($module_ip) && strlen($module_ip)>1) ? $module_ip : "127.0.0.1";
foreach ($moh as $k => $v) {
	$val =explode(":", $v);
	echo "<h2> Music on Hold </h2>";
	
	ftp_action ($ftp, $val[0], $val[1], $file, NULL); 
	
		$sr = ldap_search($ds,"cn=musicchannels","guid=$val[0]",array("playlist"));
		$info = ldap_get_entries($ds, $sr);
			for ($n=0; $n<$info["count"]; $n++) {
            $dn = ($info[$n]["dn"]); $ent["playlist"][0] = $file;
            ldap_modify($ds, $dn, $ent);
        }
	}
	unlink($tmp_name);
	}


if($_REQUEST['mtype']=="vxml"){
echo "<h2>Wav File Upload </h2>";
	$val=array('','');
	ftp_action ($ftp, $val[0], $val[1], $file, NULL);
	unlink($tmp_name);
	}

	
if($_REQUEST['mtype']=="copy"){
echo "<h2> Copy Wav Files </h2>";
	$val=array('','');
	$copywavs = $_REQUEST['copywavs'];
	$modules= $_REQUEST['destmodule'];
	foreach ($modules as $module_k => $module_v) {
		$module_ip = $moduleIP[$module_v];
		echo "Module IP Address : <b>$module_ip</b><br/>";
		foreach ($copywavs as $k => $v) {
			ftp_action ($ftp, $val[0], $val[1], $v, NULL);
		}
		echo "<br/>";
	}
}


/// voicemailPC
if ($_REQUEST['mtype'] == "voicemailpc"){
	foreach ($voicemail_pc as $vmpck => $vmpcv){
	$vmpcv = explode(":",$vmpcv); $vmpc_cn = $vmpcv[0]; $vmpc_ip = $vmpcv[1];
	
		if (!$ftp->ftp_connect($vmpc_ip)) {
			echo "<b>$vmpc_cn <i>($vmpc_ip)</i></b><br/>";			
			echo "Cannot Connect<br/><br/>";
			continue;
		}	

		if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
			$ftp->ftp_quit();
			echo "<b>$vmpc_cn <i>($vmpc_ip)</i></b><br/>";			
			echo "Login Failed<br/><br/>";
			continue;
		}	
			
		echo "<b>$vmpc_cn <i>($vmpc_ip)</i></b><br/>";			
		if ($ftp->ftp_put("$file", $tmp_name)) {
			echo "<b>$file</b> has been uploaded to /SpliceCom/ftp/<br/><br/>";
			$ftp->ftp_quit();
		} else {
			$ftp->ftp_quit(); 
			die("<b>Warning:</b> unable to upload to /SpliceCom/ftp/<br/><br/>");
		}
	} 
}
/// voicemailPC

	
}//SET
?>


</div>

<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            Uploading large WAV files via your browser uses additional system resources and could cause system instability.<br/><br/>
           	We suggest uploading is only done out of hours or during quiet periods..<br/><br/>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
</div>

<?php if (!isset($_SESSION['wavs'])) {?>
<script type="text/javascript">
		$(function() {
			$('#overlay').fadeIn('fast',function(){
            $('#alert').animate({'top':'100px'},500);
        });
        $('#alertclose').click(function(){
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            document.location.href='assist.php';
        	});
        });
        $('#alertOK').click(function(){
	    	$.ajax({ url : 'log/reset.php?wavs=1' });
        	$('#alert').animate({'top':'-600px'},500,function(){
        	$('#overlay').fadeOut('fast');
           	});
        });
		});
</script>
<?php } 

function ftp_action ($ftp, $mbox, $name, $filename, $extn) {
	
global $module_ip, 	$ftp_user, $ftp_pass, $module_ip, $tmp_name, $greet, $ftp_path, $ds;

	if (!$ftp->ftp_connect($module_ip)) {
		die("Cannot connect\n");
	}

	if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
		$ftp->ftp_quit(); die("Login failed\n");
	}	
	
	
	if ($_REQUEST['mtype'] == 'copy') { // copy
	if ($ftp->ftp_put($filename, "/SpliceCom/ftp/$filename")) {
			echo "<b>$filename</b> has been uploaded to /SpliceCom/ftp/<br/>";
			$ftp->ftp_quit();
	} else {
			$ftp->ftp_quit(); 
			die("<b>Warning:</b> unable to upload to /SpliceCom/ftp/<br/>");
		}
	} 
	
	else if ($_REQUEST['mtype'] == 'moh') {  // MOH
		if ($ftp->ftp_put("$filename", $tmp_name)) {
					echo "<b>$filename</b> has been uploaded and applied to Music Channel <b>$name</b><br/>";
				$ftp->ftp_quit();
		} else {
				$ftp->ftp_quit(); 
				die("<b>Warning:</b> unable to upload to /$module_ip/SpliceCom/ftp/<br/>");
		}
	}
	else if ($_REQUEST['mtype'] == 'vxml') {  // VXML
		if ($ftp->ftp_put($filename, $tmp_name)) {
					echo "<b>$filename</b> has been uploaded to /$module_ip/SpliceCom/$ftp_path/<br/>";
				$ftp->ftp_quit();
		} else {
				$ftp->ftp_quit(); 
				die("<b>Warning:</b> unable to upload to /$module_ip/SpliceCom/$ftp_path/<br/>");
		}		
		
	} else { // users, departs, aa, 
	
	if ($ftp->ftp_file_exists("$mbox/$filename") == 1) {
		$ftp->ftp_quit(); die("$mbox/$filename already exists\n");
	}
	
	if ($mbox) {
		
	if (!$ftp->ftp_chdir($mbox)) {
		
		if ($ftp->ftp_mkdir($mbox)) {
			echo "Creating folder <b>$mbox</b><br/>";	
			// create access files
			if ($_REQUEST['mtype'] != "aa") {
				
			$type = ( $_REQUEST['mtype'] == "user" ) ? "Users" : "Departments";
			$sr = ldap_read($ds,"cn={$name},cn={$type}","objectclass=*"); 
			$info = ldap_get_entries($ds,$sr);  $voicemailaccess = $info[0]['voicemailaccesscode'][0];
						
				$hta = "AuthType Basic\nAuthName Voicemail\nAuthUserFile /SpliceCom/Mailbox/$mbox/.htpassword\nRequire valid-user";
				$fh = fopen("/tmp/htaccess", 'w') or die("can't open file"); fwrite($fh, $hta); fclose($fh);
			if (!$ftp->ftp_put("$mbox/.htaccess","/tmp/htaccess")) die("unable to create access file");
				unlink ("/tmp/htaccess");
			
				$htp = "$extn:".crypt($voicemailaccess, base64_encode($voicemailaccess));
				$fh = fopen("/tmp/htpass", 'w') or die("can't open file"); fwrite($fh, $htp); fclose($fh);
			if (!$ftp->ftp_put("$mbox/.htpassword","/tmp/htpass")) die("unable to create access file");
				unlink ("/tmp/htpass");
			}
			
		if (!$ftp->ftp_chdir($mbox)) die("<b>Warning:</b> Unable to access folder <b>$mbox</b> - please confirm this exists and is accessible.<br/>");
		} else {
			
			if (file_exists("/SpliceCom/Mailbox/$mbox")) {
				die ("<b>Warning:</b> Folder <b>$mbox</b> exists with wrong permissions.. exiting<br>");
			} else {
				die("<b>Warning:</b> Unable to create folder <b>$mbox</b>.. exiting<br/>");
			}
			
			
		}
		
	}
	
	}

	if ($ftp->ftp_put($filename, $tmp_name)) {
			echo "<b>$greet[$filename]</b> has been uploaded to <b>$name</b>"; if ($mbox) echo " Mailbox : <b>$mbox</b><br/>";
			$ftp->ftp_quit();
	} else {
			$ftp->ftp_quit(); 
			die("<b>Warning:</b> Skipping <b>$name</b> as the Mailbox ($mbox) doesn't exist or isn't accessible.<br/>");
		}
	}

}

function ftp_action_del ($ftp, $mbox, $name, $filename) {
global $module_ip, 	$ftp_user, $ftp_pass, $module_ip, $tmp_name, $greet;

if (!$ftp->ftp_connect($module_ip)) {
		die("Cannot connect\n");
	}

	if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
		$ftp->ftp_quit(); die("Login failed\n");
	}

	if (!$ftp->ftp_chdir("$mbox")) {
		$ftp->ftp_quit(); die("<b>Change directory error:</b>");
	}

	$wavlist = $ftp->ftp_nlist($filename);

	if (!$wavlist) die("No files to delete");

	foreach ($wavlist as $wavK => $wavV){
	if (strlen($wavV)>1) {
		if (!$ftp->ftp_delete($wavV)) { 
			$ftp->ftp_quit(); die("<b>Error deleting files from:</b> $mbox"); 
			} else {
				echo "File <b>$wavV</b> has been deleted.<br/>";
			}
		}
	}
}
?>
