<?php
//PJC 01-09-2020 v1.1 Sorted Firmware List
//PJC 07-01-2020 v1.0 Yealink Firmware List

$page_id = "094";
include ".access.php";
header('Content-type: text/html; charset=UTF-8') ;
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
?>
<html>
<head>
<title>Yealink Firmware</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link href="css/Styles.css" rel="stylesheet" type="text/css">

<script type="text/javascript">
	var state = {};
	var title = 'Assist';
	var url   = '/manager/assist/';
	history.pushState(state, title, url);
</script>

</head>
<body>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Yealink Firmware</h2>
<?php
echo "<p>There are the recommended Yealink firmware versions for the installed SV1000.</p>";

if (!file_exists('/SpliceCom/Web/prov/firmware/webIndex.txt')) {
	
	echo "Sorry webIndex.txt not found !<br/>";
	exit;
	
} else {
	
	$latestYL = file('/SpliceCom/Web/prov/firmware/webIndex.txt');
	sort ($latestYL);

	echo "<table border=1 width='750px' id='tbl2'><tbody class='fbody'>";
	echo "<tr><th width='150px'>Model</th><th width='150px'></th><th width='300px'>ROM</th></tr>";
	
	
	foreach ($latestYL as $YLver) {
		if (substr( $YLver, 0, 1 ) != "#") {
			$YLver = explode(',',$YLver);
			$YLmodel = $YLver[0];
			$YLrom = $YLver[1];
			
			$YLimage = str_replace(array("SIP-", "SIP", "VP-", " "), "", $YLmodel);
			$YLimage = substr($YLimage, 0, 3);
			$YLimage = strtolower($YLimage);
			
			
			if (glob("images/$YLimage*.jpg")) {
				$YLimage = glob("images/$YLimage*.jpg")[0];
			} else {
				$YLimage = '';
			}

			echo "<tr align='center'>";
			echo "<td><strong>$YLmodel</strong></td>";
			echo "<td><img src='$YLimage' /></td>";
			echo "<td>$YLrom</td>";
			echo "</tr>";
		
		}
	}
	
		
	
	
	print "</tbody></table>";
}
?>
</div>
</body>
</html>
