<?php
// PJC blacnkcp.php
// v0.1 14OCT2019 

$host = "tls://127.0.0.1";
$port = 4018;
$timeout = 10;

## Don't Change Anything Below Here ##

$mode = (isset($_REQUEST['blank']) && $_REQUEST['blank'] == 'on') ? 'BLANK' : 'UNBLANK';
$extn = (isset($_REQUEST['extn']) && strlen($_REQUEST['extn']) >1) ? $_REQUEST['extn'] : NULL;
$user = (isset($_REQUEST['user']) && strlen($_REQUEST['user']) >1) ? $_REQUEST['user'] : NULL;

# connect to LDAP #
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}

echo "Connecting\n";
$opts = array(
  'ssl' => array(
      'verify_peer' => false,
	  'verify_peer_name' => false,
      )
  );


$context = stream_context_create($opts);
$socket = stream_socket_client (
  "$host:$port", $errno, $errstr, $timeout,
  STREAM_CLIENT_CONNECT, $context);

if (!$socket) {
    echo "Failure $errno errstr $errstr.<br>";
	
} else {
	stream_set_timeout($fp,1); //otherwise defaults to 60 seconds
    echo "Success<br>";
	
	# get users / extensions details #
	$att=array('cn','telephonenumber','loginaccesscode');
	if ($extn != "") {
		$sr = @ldap_list($ds, "cn=Users","(&(telephonenumber=$extn)(objectclass=User))", $att);
	} elseif ($user != "") {
		$sr = @ldap_list($ds, "cn=Users","(&(cn=$user)(objectclass=User))", $att);
	}
	
	$info = @ldap_get_entries($ds,$sr);
	$user = $info[0]['cn'][0];
	$extn = $info[0]['telephonenumber'][0];
	$loginaccesscode=$info[0]['loginaccesscode'][0];

	# login to CP #
	$cmd = "LOGIN,$extn,$loginaccesscode,\n";
	fwrite($socket, $cmd, strlen($cmd));
	$read = fread($socket, 1024);
	echo "LOGIN: $read<br><br>";
	
	# get current call #
	$cmd = "CALLINFO\n";
	fwrite($socket, $cmd, strlen($cmd));
	$read = fread($socket, 128);
	echo "CALLINFO: $read<br><br>";
	
	$callinfo = explode (',', $read);
	$call = ($callinfo[0] == 'CALLINFO') ? $callinfo[2] : NULL;
	
	# send blanking #
	if ($call != NULL) {
		$cmd = "$mode,$call,\n";
		fwrite($socket, $cmd, strlen($cmd));
		
		$read = fread($socket, 128);
		echo "MODE: $mode - $read<br>";
	}	
	
	echo "Exiting...";
	$cmd = "LOGOUT\n";
	fwrite($socket, $cmd, strlen($cmd));
}


?>