<?php
// PJC 07 July 2020 Updated wording to SoftPBX
// PJCNOV2013
session_start();
$page_id = "068";
include "assist/.access.php";
include "assist/tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];

$ds = ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
ldap_bind($ds,"INTERNAL","001122334455") or exit("<p>EXIT: LDAP bind failure</p>");

if (isset($_REQUEST['modules'])) {

	  // get selected modules
		$modules = 	$_REQUEST['modules'];

	  // clear session and set session selected = 1.
		$_SESSION=array();
		$_SESSION['selected'] = "1";

	  // find self
		$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
      	$info=ldap_get_entries($ds,$sr);
      	$self = $info[0]['location'][0];

      // find master and put at start of array
      	$sr=@ldap_search($ds,"cn=Modules","(&(objectclass=AdministrationModule)(administrationmode=1))");
	  	$info=ldap_get_entries($ds,$sr);
	    $sa = explode(",",$info[0]['dn']);
	  	$s = substr($sa[1],3);
	  	$_SESSION['modules']['cn'][0] = $s;
	  	$_SESSION['modules']['guid'][0]="";
      	$_SESSION['modules']['lastseen'][]=0;
	  	$_SESSION['modules']['ipaddress'][0]="";
      	$_SESSION['modules']['ipaddress0'][0]="";
      	$_SESSION['modules']['version'][0]="";
      	$_SESSION['modules']['type'][0]="";

	 // build array of nodes only showing current CallServer and Selected Modules
	  	foreach ($modules as $key => $value) {
     	$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0)(|(cn={$_SESSION['modules']['cn'][0]})(guid=$value)))");
	  	$info=ldap_get_entries($ds,$sr);

      // loop nodes adding them to SESSION['modules']
		for($n=0; $n<$info['count'];$n++) {
		if ($info[$n]['cn'][0] == $_SESSION['modules']['cn'][0]) $n2 = 0;
         	else $n2 = count($_SESSION['modules']['cn']);
		$_SESSION['modules']['cn'][$n2] = $info[$n]['cn'][0];
		$_SESSION['modules']['guid'][$n2] = $info[$n]['guid'][0];
        $_SESSION['modules']['version'][$n2] = $info[$n]['productversion'][0];
		$_SESSION['modules']['lastseen'][$n2] = floor((time(0)-$info[$n]['lastseen'][0])/(60*60*24));
        if ($info[$n]['moduletype'][0]==1) $_SESSION['modules']['type'][$n2]="4100";
        if ($info[$n]['moduletype'][0]==1 and substr($info[$n]['serialnumber'][0],0,8)!="00-07-d9") $_SESSION['modules']['type'][$n2]="XS";
        if ($info[$n]['moduletype'][0]==10) $_SESSION['modules']['type'][$n2]="4140";
        if ($info[$n]['moduletype'][0]==11) $_SESSION['modules']['type'][$n2]="5100";
        if ($info[$n]['moduletype'][0]==12) $_SESSION['modules']['type'][$n2]="5108";
        if ($info[$n]['moduletype'][0]==17) $_SESSION['modules']['type'][$n2]="SoftPBX Linux";
        if ($info[$n]['moduletype'][0]==18) $_SESSION['modules']['type'][$n2]="SoftPBX Apple";
	    if ($info[$n]['moduletype'][0]==19) $_SESSION['modules']['type'][$n2]="5500 (NSG)";

      // add IP Address and set Public IP to match
   	    $_SESSION['modules']['ipaddress'][$n2] = $info[$n]['ipaddress'][0];
        $_SESSION['modules']['ipaddress0'][$n2] = $info[$n]['ipaddress'][0];

      // check each DN and find Public IP. Set if found.
        $dn = "cn=1,".$info[$n]['dn'];
        $sr=ldap_read($ds,$dn,"objectclass=*");
        $infox=ldap_get_entries($ds,$sr);
        $_SESSION['modules']['publicipaddress'][$n2] = $infox[0]['publicipaddress'][0];
        if ($infox[0]['publicipaddress'][0]!="") $_SESSION['modules']['ipaddress0'][$n2] = $infox[0]['publicipaddress'][0];

      //
        $dn="guid=$self";
        $search="(&(objectclass=Member)(member=".$info[$n]['guid'][0]."))";
        $sr=ldap_search($ds,$dn,$search);
        $info_m=ldap_get_entries($ds,$sr);
        if ($info_m['count']) {
           $dn=substr($info_m[0]['dn'],strpos($info_m[0]['dn'],',')+1);
           $sr=ldap_read($ds,$dn,"objectclass=*");
           $info_imt=ldap_get_entries($ds,$sr);
           if ($info_imt[0]['ipaddress'][0]!="") $_SESSION['modules']['ipaddress0'][$n2]=$info_imt[0]['ipaddress'][0];
        }
        if ($info[$n]['guid'][0]==$self) $_SESSION['modules']['ipaddress0'][$n2]="127.0.0.1";
	 }
  }

	 // Set Zero Location
		$_SESSION['modules']['cn'][] = "Zero Location";
		$_SESSION['modules']['guid'][]='00000000-0000-0000-0000-000000000000';
		$_SESSION['modules']['lastseen'][]=0;
		$_SESSION['modules']['ipaddress'][]="127.0.0.1";
		$_SESSION['modules']['publicipaddress'][]="&nbsp";
		$_SESSION['modules']['ipaddress0'][]="127.0.0.1";
		$_SESSION['modules']['version'][]="&nbsp";
		$_SESSION['modules']['type'][]="&nbsp";

		$_SESSION['modules']['selected'] = "1";

		header("Location: users.php");
  }
?>

<html>
<head>
<title>User Location Database Check - Select Modules</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link href="assist/css/Styles.css" rel="stylesheet" type="text/css">
</head>
<body onLoad="window.scrollTo(<?php echo $x*1?>,<?php echo $y*1?>)">
<div id="toTop">^ Back to Top</div>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='assist/images/backup.png' style="vertical-align:middle;">&nbsp;User Location Database Check - Select Modules</h2>
This script will allow you to select which modules the User Location Database Check script (users.php) will check.<br/>
The Primary Master and the CallServer this script is being run from are highlighted below.<br/>
The Primary Master and Zero Location automatically added to the modules to be checked. <i>(even if de-selected)</i><br/><br/>
Selecting multiple options vary in different operating systems and browsers:<br/>
<b>For windows</b>: Hold down the control (ctrl) button to select multiple individual CallServers. Hold down the shift button to select a range.<br/>
<b>For Mac</b>: Hold down the command button to select multiple indiviual CallServers. Hold down the shift button to select a range.<br/><br/>

<?php
		$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
      	$info=ldap_get_entries($ds,$sr);
      	$self = $info[0]['location'][0];

      // find primary master.  $s = cn
		$sr=@ldap_search($ds,"cn=Modules","(&(objectclass=AdministrationModule)(administrationmode=1))");
		$info=ldap_get_entries($ds,$sr); $sa = explode(",",$info[0]['dn']); $s = substr($sa[1],3);

	  // find master guid from $s
		$sr=ldap_read($ds,"cn={$s},cn=Modules","objectclass=*"); $info=ldap_get_entries($ds,$sr); $master = $info[0]['guid'][0];

	  // Find all modules - set dropdown size either a quarter of the count or 10
		$sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))", array('cn','guid'));
	  	$info=ldap_get_entries($ds,$sr); $size = ($info['count']>15) ? ($info['count']/2) : "10";

		echo "<div><form action='$script' method='post'><b>CallServer Modules :</b><br/><br/><input type='submit' value='Select Modules'><br/><select name='modules[]' multiple  style='min-width: 300px' size='{$size}'>";
	  	for($n=0; $n<$info['count'];$n++) {
		$selected = ($info[$n]['guid'][0]==$master || $info[$n]['guid'][0]==$self) ? "Selected" : "";
		echo "<option value='{$info[$n]['guid'][0]}' $selected>{$info[$n]['cn'][0]}</option>";
	  	}
		echo "</select><br/><input type='submit' value='Select Modules'></form></div>";
		echo "</div>";

ldap_close($ds);
?>