<?php
//PJC 24-Nov-2020 - PHP Updates, check if file to read is available and if file to write to is writable.


//bob/g 9feb10 22feb 10nov 22nov 30oct11 15mar12/
// extract sip from Admin.log
if (!isset($argv[3])) {
  print "searches Admin logs for CallCentre records for a particular sip call\n";
  print "syntax: php -n sipx.php <input file> <output file> <search> [search]\n";
  print "IP addresses / names listed in /SpliceCom/Web/download/sipx.hide.txt will be hidden. (Also OPT,REG,SUB,NOT.) \n";
  print "IP addresses / names listed in /SpliceCom/Web/download.sipx.show.txt will be shown, if not hidden. (*.*.*.*=all)\n";
  exit ();
}
// the following files may contain a list of ip address which should be hidden or shown *.*.*.* will show all not hidden.
if ($hidelist = file("/SpliceCom/Web/download/sipx.hide.txt")); else $hidelist=array();
if ($showlist = file("/SpliceCom/Web/download/sipx.show.txt")); else $showlist=array();


$opt = $reg = $sub = $not = $n = $repeat = 0;
$sip = $port = $packet = NULL;

foreach ($hidelist as $k => $v) {
   $hidelist[$k] = trim($hidelist[$k]);
   if ($v[0]=='#') unset($hidelist[$k]);
   elseif (substr($v,0,3)=="OPT") $opt=1;
   elseif (substr($v,0,3)=="REG") $reg=1;
   elseif (substr($v,0,3)=="SUB") $sub=1;
   elseif (substr($v,0,3)=="NOT") $not=1;
   elseif (!strpos($v,'.')) unset($hidelist[$k]);
}


foreach ($showlist as $k => $v) {
   $showlist[$k] = trim($showlist[$k]);
   if ($v[0]=='#') unset($showlist[$k]);
   elseif (!strpos($v,'.')) unset($showlist[$k]);
}
print "Hide: (/SpliceCom/Web/download/sipx.hide.txt)\n";
print_r ($hidelist);
print "then Show: (/SpliceCom/Web/download/sipx.show.txt)\n";
print_r ($showlist);
$callids=array($argv[3]);
if(isset($argv[4])) $callids[]=$argv[4];

while (1) {
$callidst=count($callids);
$sipin = $sipout = 0;

$fp=@fopen($argv[1],'r');
$fpo=@fopen($argv[2],'w');

if ( ! file_exists($argv[1]) ) {
	echo "\n\nError Exiting... The file $argv[1] does not exist\n\n";
	exit;
}
if ( ! is_writable($argv[2]) ) {
	echo "\n\nError Exiting... The file $argv[2] is not writable\n\n";
	exit;
}

while (!feof($fp)) {
//if ($limit++>100) exit;
   if ($repeat) $repeat=0;
   else {
      $line=trim(fgets($fp));
      $n++;
   }
   if (!$sip ) {
      if (strpos($line,'(transport/addr/port)')) {
//print '.';
         foreach ($hidelist as $kh => $vh) {
            if (strpos($line,$vh)) continue 2;
         }
         $showaddr=0;
         foreach ($showlist as $ks => $vs) {
            if ($vs=="*.*.*.*" OR strpos($line,$vs)) $showaddr=1;
         }
         $sip=1;
         $lc=0;
//            $audio=$ip=$port="";
         $lines=array();
      }
    }
    if ($sip) {
        $lines[$lc++]=$line;
        if ($line=="" and $lc==2) $sip=9;
        if ($opt and substr($line,0,5)=="CSeq:" and strpos($line,'OPT')) $sip=9;
        if ($reg and substr($line,0,5)=="CSeq:" and strpos($line,'REG')) $sip=9;
        if ($sub and substr($line,0,5)=="CSeq:" and strpos($line,'SUB')) $sip=9;
        if ($not and substr($line,0,5)=="CSeq:" and strpos($line,'NOT')) $sip=9;
        if ($sip>4) {
            $sip=0;
            continue;
        }
		
		if ( isset($line[5]) ) {
			if ($line[5] == ':' and $line[2] == ':') {
				$sip++;
				if (strlen($line)==12) {
					unset($lines[$lc-1]);
					$sip--;
				}
				elseif ($line[12]==' ' and $line[13]==' ') {
					if ($line[14]=='S' and $line[15]=='I') ;
					else {
						$lines[$lc-1]= $lines[$lc-2].substr($line,14);
						unset($lines[$lc-2]);
						$sip--;
					}
				}
			}
		}
        if ($sip>2) {
            unset($lines[$lc-1]);
            $repeat=1;
            $sip=0;
            $show=$to=$from=$callid="";

            foreach($lines as $k => $v) {
//                print "$v\n";

                if ($k==0) {
                    $ptime=substr($v,0,12);
                    if (strpos($v,'INPUT')) $input=1; else $input=0;
                }
                if ($k==1) {
                    $z=strpos($v,' ');
                    $packet=substr($v,0,$z);
                    if ($packet=='SIP/2.0') $packet=$v;
                }
                if ($packet=="INVITE") {
                    if (substr($v,0,3)=="To:") $to=$v;
                    if (substr($v,0,3)=="Fro") $from=$v;

                    if ($input) {
                      if (substr($v,0,8)=="Call-ID:") $sipin++;
                        $inptime=$ptime;
                        $incallid=$callid;
                        if (substr($v,0,8)=="c=IN IP4") {
                            sscanf($v,"c=IN IP4 %s",$ip);
                            $audio="(".$ip.":".$port.")";
                        }
                        if (substr($v,0,8)=="m=audio ") {
                            sscanf($v,"m=audio %s RTP/AVP",$port);
                            $audio="(".$ip.":".$port.")";
                        }
                    } else {
                      if(substr($v,0,8)=="Call-ID:") $sipout++;
                         $outptime=$ptime;
                         $outcallid=$callid;
                         $callida=substr($callid,0,strpos($callid,'@'));
                    }
                }
                if (substr($v,0,8)=="Call-ID:") {
                    $callid=substr($v,strpos($v,' ')+1);
                    foreach($callids as $kc =>$vc){
//print "\n$v";
                        if (strpos($to,$vc) or strpos($from,$vc) or strpos($v,$vc)) {
                            $show=1;
                            if(!in_array($callid,$callids)) $callids[]=$callid;
//                            print " +\n";
                        }
                    }
                }
            }
            if ($showaddr) $show=1;

            if ($show) foreach($lines as $k => $v) {
                print "$v\n";
                fputs($fpo,"$v\n");
            }

//print "----- $lc $n $audio $callida Done.\n\n";
            if ($show) {
               $s="\n\n";
               print $s;
               fputs($fpo,$s);
            }
            continue;
        }
        if ($sip<3) continue;

    }
	if ( isset($audio) ) {
		if ($audio!="" and strpos($line,$audio)) {
		//print "##### $n $line\n#####\n";
			if ($x=strpos($line,'confId=')) {
				$confid=substr($line,$x+7,36);
				$t= substr($line,0,12);
				$s= "$t ##### IN ##### $inptime zcallid=$incallid zconfid=$confid #####\n\n";
				print $s;
				fputs($fpo,$s);
				$audio="";
				if(in_array($callid,$callids) or in_array($confid,$callids)) {
					if(!in_array($callid,$callids))$callids[]=$callid;
					if(!in_array($confid,$callids))$callids[]=$confid;
				}
			}
		}
	}
    if (strpos($line,'Bend::AddHoldMusic -')){
//print "##### $line\n";
        if ($x=strpos($line,'confId') and $y=strpos($line,'callId')){
            $line_confid=substr($line,$x+7,36);
            $line_callid=substr($line,$y+7,36);
            $t= substr($line,0,12);
            $s = "$t ##### MUSIC ##### callid=$line_callid confid=$line_confid ######\n\n";
            print $s;
            fputs($fpo,$s);
        }
    }
	if (isset ($callida) ) {
		if ($callida!="" and $line_callid==$callida) {
			$t= substr($line,0,12);
			//print "##### $n $line\n#####\n";
			$s= "$t ##### OUT ##### $outptime zcallid=$outcallid zconfid=$line_confid #####\n\n";
			print $s;
			fputs($fpo,$s);
			$callida="";
			if(in_array($outcallid,$callids) or in_array($line_confid,$callids)) {
				if(!in_array($outcallid,$callids))$callids[]=$outcallid;
				if(!in_array($line_confid,$callids))$callids[]=$line_confid;
	
			}
		}
	}
    if ($x=strpos($line,'zconfid') and $y=strpos($line,'zcallid')){
//print "##### $n $line\n#####\n";
            $line_confid=substr($line,$x+8,36);
            $line_callid=substr($line,$y+8,$x-$y-9);
            $t= substr($line,0,12);
        if(in_array($line_callid,$callids) or in_array($line_confid,$callids)) {
            if(!in_array($line_callid,$callids))$callids[]=$line_callid;
            if(!in_array($line_confid,$callids))$callids[]=$line_confid;
        }
        $s= "$t ##### IN/OUT ##### zcallid=$line_callid zconfid=$line_confid #####\n\n";
        print $s;
        fputs($fpo,$s);
    }
    }
    fclose ($fp);
    fclose ($fpo);
    print_r($callids);
    $c = count($callids);
    print "SIP in = $sipin, SIP out = $sipout (".($sipout/2).")\n";
    if ($c==$callidst or $c>30) break;
    print "\n##### new calls - restarting #####\n";
    sleep(3);
}
print "################\n";
?>

