<?php

/* PJC 16-06-2015 PCS582 Update
   PJC May 2015 5x3 Support
   PJC May 2014 542 Support
   PJC May 2014 wording layout
   bobg 20dec06 30mar07 18may07 12sep 31aug08 14oct 21dec 4dec 24apr09 24aug 26aug 31aug11 6sep11 11sep
   This script telnets into all the modules registered on the call server and issues commands to upgrade them.
   You can issue the command php -n /WebManager/upgrade.php and watch it do it.
   If the file /ftp/upgrade.done has the same date and the AdminModule software then nothing happens unless you use
   the -f option on the command line to force an upgrade.
   put a list of ip addresses in /ftp/upgrade.skip to avoid certain units.
   the following entry in /etc/crontab will run each morning at 04:04
4 4 * * *       root php -n /WebManager/upgrade.php > /dev/null
   If it has nothing else to do on Mondays it will set the modules time and log its build date.
   the -t option on the command line will do set time.
*/

////// updates
if(!isset($argv[1])) $argv[1] = NULL;
$six= NULL;
//////

if(substr(phpversion(),0,1)=="4") $checkfile = "/SpliceCom/AdminModule";  else $checkfile = "/SpliceCom/bin/AdminModule";
$donefile = "/SpliceCom/ftp/upgrade.done";
$dofile = "/SpliceCom/ftp/upgrade.todo";
$skipfile = "/SpliceCom/ftp/upgrade.skip";
$logfile = "/SpliceCom/logs/upgrade.log";

$script=basename($_SERVER['SCRIPT_NAME']);
if (isset($_SERVER['HTTP_HOST'])) die("Run via telnet.");

$ds = @ldap_connect("127.0.0.1", 4000)or die("LDAP connect failure\n");
ldap_bind($ds, "INTERNAL", "001122334455")or die("LDAP bind failure\n");

function guid_print($guid,$name="n/a") {
    global $ds;
    if (($guid=="00000000-0000-0000-0000-000000000000") or (strlen($guid)!=36)) {
        print "[$name $guid]\n";
        return;
    }
    $sr = ldap_read($ds,"guid=$guid","objectclass=*");
    $info = ldap_get_entries($ds, $sr);
    print "[$name GUIDcn=".$info[0]['cn'][0]."(".$info[0]['objectclass'][0].")]\n";
}
function pcs5xxfile(){
   global $pcs5xxver_file;
   $file="/ftp/tftp/pcs5xx-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -f tpcs -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs5xxver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs5xx $pcs5xxver_file[0].$pcs5xxver_file[1]($pcs5xxver_file[2]) available\n";
   }
}
function pcs582file(){
   global $pcs582ver_file;
   $file="/ftp/tftp/pcs5lxg-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -f tpcs -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs582ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs582 $pcs582ver_file[0].$pcs582ver_file[1]($pcs582ver_file[2]) available\n";
   }
}
function pcs5x1file(){
   global $pcs5x1ver_file;
   $file="/ftp/tftp/pcs5x1-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -f tpcs -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs5x1ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs5x1 $pcs5x1ver_file[0].$pcs5x1ver_file[1]($pcs5x1ver_file[2]) available\n";
   }
}
function pcs5x3file(){
   global $pcs5x3ver_file;
   $file="/ftp/tftp/pcs5x3-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -f tpcs -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs5x3ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs5x3 $pcs5x3ver_file[0].$pcs5x3ver_file[1]($pcs5x3ver_file[2]) available\n";
   }
}
function pcs542file(){
   global $pcs542ver_file;
   $file="/ftp/tftp/pcs54x-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -f tpcs -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs542ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs542 $pcs542ver_file[0].$pcs542ver_file[1]($pcs542ver_file[2]) available\n";
   }
}
function pcs100file(){
   global $pcs100ver_file;
   $file="/ftp/tftp/pcs100.jffs2";
   if (file_exists($file)) {
      $s="ver -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs100ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs100 $pcs100ver_file[0].$pcs100ver_file[1]($pcs100ver_file[2]) available\n";
   }
}
function pcs400file(){
   global $pcs400ver_file;
   $file="/ftp/tftp/pcs400-32M.jffs2";
   if (file_exists($file)) {
      $s="ver -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      $pcs400ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs400 $pcs400ver_file[0].$pcs400ver_file[1]($pcs400ver_file[2]) available\n";
   }
}
function pcs410file(){
   global $pcs410ver_file;
   global $pcs480;
   $file="/ftp/tftp/pcs410-256M.jffs2";
   if (file_exists($file)) {
      $s="ver -j $file";
      $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
      if (strlen($r)==0) {
         $s="ver -f tpcs -j $file";
         $r=system($s,$retval);
//print "[r=$r, retval=$retval]";
         if (strlen($r)>0) {
            $pcs480=1;
            print "pcs480/";
            }
      }
      $pcs410ver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "pcs410 $pcs410ver_file[0].$pcs410ver_file[1]($pcs410ver_file[2]) available\n";
   }
}
function trunkfile(){
   global $trunkver_file;
   $file="/ftp/tftp/tm5204-256M.rdimg";
   if (file_exists($file)) {
      $s="ver $file";
      $r=system($s,$retval);
      $trunkver_file=sscanf($r,"SWMODULE: %d.%d(%d)");
      print "trunk $trunkver_file[0].$trunkver_file[1]($trunkver_file[2]) available\n";
   }
}

function getip() {
	global $self;
   global $ftp_password;
    global $skipfile;
    global $dofile;
    global $ds;
    global $cn, $tn, $pw;
    global $fpl;
    global $learn;
// get ipaddress of self
	$sr = ldap_read($ds, "cn=Self,cn=Modules", "objectclass=*");
	$info = ldap_get_entries($ds, $sr);
	$guid = $info[0]['location'][0];
	$sr = ldap_read($ds, "guid=$guid", "objectclass=*");
	$info = ldap_get_entries($ds, $sr);
	$self = $info[0]['ipaddress'][0];
   $vera = explode(' ',$info[0]['productversion'][0]);
   foreach($vera as $k => $ver) {
         if ($ver > 1) break;
    }
    if ($ver>=3.2) $ver32=1; else  $ver32=0;
//    print "$ver $ver32\n";
   $sr = ldap_read($ds, "cn=System", "objectclass=*");
	$info = ldap_get_entries($ds, $sr);
	$ftp_password = $info[0]['maintainerpassword'][0];

// get units we know to avoid
	$skip = array();
	if ($fp = @fopen($skipfile, "r")) {
		while (!feof($fp)) {
			$skip[] = rtrim(fgets($fp));
		}
		fclose($fp);
    }
    $ip = $ipa = $v = $controlport = $hardware = $hardwareid = $object= array();
    if ($fp = @fopen($dofile, "r")) {
        if ($learn) $log="Learning from the $dofile file.\n";
        else $log = "\nFile $dofile found, using that instead of registrations.\n";
        print $log;
        fputs($fpl, $log);
		while (!feof($fp)) {
			$ipaddr = rtrim(fgets($fp));
            $ipaddr =str_replace("\t", " ",$ipaddr);
            if ($sp=strpos($ipaddr," ")) $ipaddr=substr($ipaddr,0,$sp);
            if (in_array($ipaddr, $skip)) continue;
            $ipa[] = $ipaddr;
	    	$va = explode('.', $ipaddr);
            $v[] = ($va[0] * 256 * 256 * 256) + ($va[1] * 256 * 256) + ($va[2] * 256) + ($va[3]);
// print "\ncn=".$info[$n]['cn'][0]." ";
            $controlport[] =  "0";
            $hardware[] =  "?";
            $hardwareid[] =  "?";
            $object[] =  "?";
		}
		@fclose($fp);
        $ver32=0; // avoid looking up password
    } if (!(@fopen($dofile, "r"))or $learn) {
        if ($learn) $log = "Learning from registrations.\n";
        else $log = "File $dofile not found, using registrations.\n";
        print $log;
        fputs($fpl, $log);
        //get sorted ipaddresses of registered units
        $tim = time();
    	$sr = @ldap_list($ds, "cn=Registrations", "objectclass=RegistrationRecord");
	    $info = @ldap_get_entries($ds, $sr);

	    for ($n = 0; $n < $info['count']; $n++) {
            if (in_array($info[$n]['ipaddress'][0], $skip)) continue;
            if (strpos($info[$n]['cn'][0],"oicemailPorts.")) continue;
            if ( ! strpos($info[$n]['hardwareid'][0]," 00-07-d9-")) continue;
            //check if regitered in last 15 mins if not ditch (seems to happen on multi call server)
            $lrta=sscanf($info[$n]['lastregisteredtime'][0], "%d:%d %d/%d/%d");
            $timr=strtotime("$lrta[3]/$lrta[2]/$lrta[4] $lrta[0]:$lrta[1]");
            if ($tim-$timr>1000) { print"-"; continue;}
            $ipa[] = $info[$n]['ipaddress'][0];
		      $va = explode('.', $info[$n]['ipaddress'][0]);
            $v[] = ($va[0] * 256 * 256 * 256) + ($va[1] * 256 * 256) + ($va[2] * 256) + ($va[3]);
// print "\ncn=".$info[$n]['cn'][0]." ";
            $controlport[] =  $info[$n]['controlport'][0];
            $hardware[] =  $info[$n]['hardware'][0];
            $hardwareid[] =  $info[$n]['hardwareid'][0];
            $object[] =  $info[$n]['object'][0];
        }
    }
	$last = "?";
	array_multisort($v, $ipa, $controlport, $hardware, $hardwareid, $object);
	foreach($ipa as $k => $v) {
        //remove duplicates
		if (($last == $v) || ($v == "")|| ($v == $self)) {
			unset($ipa[$k]);
			continue;
		}
		$last = $v;
        //find out more info
        if ($controlport[$k] >5000) {
            $sr = ldap_read($ds,"guid=".$object[$k],"objectclass=*");
            $info = ldap_get_entries($ds, $sr);
            $cn[$v]=$info[0]['cn'][0];
            $tn[$v]="ext: ".$info[0]['telephonenumber'][0];
//  print "cn=".$info[0]['cn'][0].", tn=".$info[0]['telephonenumber'][0]."\n";
        }
        if ($ver32) {
            // in v3.2 we introduces module password other than 7388
            // trunks and compressors dont play the $hardware game
            if ($hardware[$k]=="00000000-0000-0000-0000-000000000000") {
               $sn=substr($hardwareid[$k],-17,17);
                $sr=ldap_list($ds,"cn=modules","serialnumber=$sn");
                $info = ldap_get_entries($ds, $sr);
            } else {
                //users this way
                $sr = ldap_list($ds,"guid=".$hardware[$k],"serialnumber=*");
                $info = ldap_get_entries($ds, $sr);
                if ($info['count']==0) {
                    //pots serial number are up one
                    $sr = ldap_read($ds,"guid=".$hardware[$k],"objectclass=*");
                    $info = ldap_get_entries($ds, $sr);
                    $a=explode(',',$info[0]['dn']);
                    $dn=$a[1].",".$a[2];
                    $sr=ldap_read($ds,$dn,"serialnumber=*");
                    $info = ldap_get_entries($ds, $sr);
                }
            }
//            print "sn=".$info[0]['serialnumber'][0]."\n";
//            print "password=".$info[0]['password'][0]."\n";
            $password=$info[0]['password'][0];
            if ($password=="") $password="7388";
            if (substr($password,0,4)=="Auto") {    // once upon a time I autogenerated passwords. opps...
                $entry['password'] = "";
                print "Clearing Auto-xyz password\n";
                $dn=$info[0]['dn'];
                if ( ! ldap_modify($ds,$dn,$entry)) die("LDAP modify failure\n");
            }
        } else $password="7388";
        $pw[$v]=$password;
        $ip[]=$v;
   	}
      if ($learn) {
         print "\nCreating/updating $dofile containing:\n";
         $fp = @fopen($dofile, "w");
         foreach ($ip as $k => $v){
            fputs($fp,"$v\n");
            print ($k+1)." $v\n";
         }
         fclose ($fp);
         chmod($dofile,0666);
      }
	return ($ip);
}
function upgrade($units) {
	global $self;
   global $ftp_password;
	global $fpl;
	global $ip_fail;
   global $monday;
   global $cn, $tn, $pw;
   global $do_mac, $do_uptime, $do_poweroff;
   global $argv,$pcs5xxver_file,$pcs5xx,$pcs582ver_file,$pcs582,$pcs5x1ver_file,$pcs5x1,$pcs5x3ver_file,$pcs5x3,$pcs542,$pcs542ver_file,$trunk,$trunkver_file,$pcs100ver_file,$pcs100,$pcs400ver_file,$pcs400,$pcs410ver_file,$pcs410;
   global $pcs480;
	$ip_fail = array();
	foreach($units as $key => $value) {
		print "\n\n".date("Ymd H:i ", time())."***** Connecting to: $value ***** ".($key+1)."/".count($units)."\n";
      $s=sprintf("%3d ",$key+1);
		$log = $s.date("Ymd H:i ", time()).$value."\t";
 		if (!$fp = fsockopen($value, 23, $errno, $errstr, 5)) {
         $log .="connect failed $tn[$value] $cn[$value]";
		   fputs($fpl, $log."\n");
			continue;
		}
		stream_set_timeout($fp, 3);
      $wait=10;
		$n = $done = $ready = $splice = $load_ok = $main_ok = $password_count = 0;
// loop waiting for data
		while (!feof($fp)) {
			$sa = trim(fgets($fp));
			if (!$sa) {
// nothing recieved
				if ($n++ > $wait) {
					break;
				}
//			print "[$n]";
				continue;
			}
			if ($done++ < 4) {
				fputs($fp, $sa);
				continue;
			}
			print"$sa\n";
			
	
			if (strpos($sa, 'TM52') !== FALSE || strpos($sa, 'Splice') !== FALSE && $splice==0) {
				$splice = 1;
            	$model = trim(substr($sa, 13));
            if (substr($model,0,3)=='PCS') $model=str_replace(' ','',$model);
				$log .= "$model\t";
				$n = 0;
			}
			if (!$splice) {
				continue;
			}
			if (strpos($sa, "ogin:")) {
				fputs($fp, "diag\n");
			}
			if (strpos($sa, "word:")) {
                $password_count++;
                if ($password_count==1) fputs($fp, "7388\n");
                else fputs($fp,$pw[$value]."\n");
			}
			if (strpos($sa, "process")) {
				$log .= "loader done\t";
				$load_ok = 1;
			}
			if (strpos($sa, "booting")) {
				$log .= "upgrade done\t";
				$main_ok = 1;
			}
         // pcs5xx ftp upgrade
         if (strpos($sa, "next reboot")) {
            fputs($fp,"poweroff\n");
				$log .= "upgrade done\t";
				$main_ok = 1;
            $load_ok = 1; // ok its a cheat
			}
         // pcs5xx ftp upgrade failed
         if (strpos($sa, "failed")) {
            fputs($fp,"poweroff\n");
				$log .= "ftp failed\t";
			}
            // log time adjustment
			if ((strpos($sa,$self)!==false) && (strpos($sa,$self)==0)){
				$t=sscanf($sa,"%s %s %s");
				$log .= "adj: ".$t[1]." ";
			}
            // pcs5xx time offset
         if (strpos($sa," UTC ")) {
            $t=sscanf($sa,"%s %s %s %s %s %s");
            $s="$t[3] $t[1] $t[2] $t[5] $t[4]";
            $r=(time()-(strtotime($s)));
            if (($r>10 or $r<-10)and $ready==6) {
               $six=1;
               $ready=4;
            }
            $log .= "offset: $r ";
         }

            // log build date
            if (strpos($sa,"root")) {
                $d=sscanf($sa,"%s %s %s %s %s %s %s %s" );
                $log .="built: ".$d[5]." ".$d[6]." ".$d[7]." ";
             }
             // log uptime
             if (strpos($sa,"load average")) {
                $u =sscanf($sa,"%s up %s %s %s load average: %s");
                $sx="";
                for ($nx=1;$nx<4;$nx++){
                    if ($u[$nx]=="load") break;
                    $sx .=$u[$nx]."\t";
                }
                $log .="up: $sx\t";
            }
            // log mac address
            if (strpos($sa,"HWaddr")) {
                $d=sscanf($sa,"eth0      Link encap:Ethernet  HWaddr %s" );
                $log .="mac: ".$d[0]."\t";
             }
             // log ver
            if (strpos($sa,"WMODULE:") && $argv > 1) {
               $log .="ver: ".trim(substr($sa,10))."\t";
               if(!strpos($argv[1],'t') and substr($model,0,4)=="PCS5") {
                  if (substr($model,4,1)=="8"){
                     $pcs582ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                     if (isset($pcs582ver_file) and $pcs582ver_file[0]==$pcs582ver[0] and $pcs582ver_file[1]==$pcs582ver[1] and $pcs582ver_file[2]!=$pcs582ver[2]){
                        $pcs582[]=$value;
                        $log .="marked for upgrade\t";
                        print "### marked for upgrade ###\n";
                     }
                  }
                  elseif (substr($model,5,1)=="1"){
                     $pcs5x1ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                     if (isset($pcs5x1ver_file) and $pcs5x1ver_file[0]==$pcs5x1ver[0] and $pcs5x1ver_file[1]==$pcs5x1ver[1] and $pcs5x1ver_file[2]!=$pcs5x1ver[2]){
                        $pcs5x1[]=$value;
                        $log .="marked for upgrade\t";
                        print "### marked for upgrade ###\n";
                     }
                  }
                  elseif (substr($model,5,1)=="2"){
                     $pcs542ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                     if (isset($pcs542ver_file) and $pcs542ver_file[0]==$pcs542ver[0] and $pcs542ver_file[1]==$pcs542ver[1] and $pcs542ver_file[2]!=$pcs542ver[2]){
                        $pcs542[]=$value;
                        $log .="marked for upgrade\t";
                        print "### marked for upgrade ###\n";
                     }
                  }
                  elseif (substr($model,5,1)=="3"){
                     $pcs5x3ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                     if (isset($pcs5x3ver_file) and $pcs5x3ver_file[0]==$pcs5x3ver[0] and $pcs5x3ver_file[1]==$pcs5x3ver[1] and $pcs5x3ver_file[2]!=$pcs5x3ver[2]){
                        $pcs5x3[]=$value;
                        $log .="marked for upgrade\t";
                        print "### marked for upgrade ###\n";
                     }
                  }
                  else {
                     $pcs5xxver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                     if (isset($pcs5xxver_file) and $pcs5xxver_file[0]==$pcs5xxver[0] and $pcs5xxver_file[1]==$pcs5xxver[1] and $pcs5xxver_file[2]!=$pcs5xxver[2]){
                        $pcs5xx[]=$value;
                        $log .="marked for upgrade\t";
                        print "### marked for upgrade ###\n";
                     }
                  }
               }
               if(!strpos($argv[1],'t') and $model=="PCS100") {
                  $pcs100ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                  if (isset($pcs100ver_file) and $pcs100ver_file[0]==$pcs100ver[0] and $pcs100ver_file[1]==$pcs100ver[1] and $pcs100ver_file[2]!=$pcs100ver[2]){
                     $pcs100[]=$value;
                     $log .="marked for upgrade\t";
                     print "### marked for upgrade ###\n";
                  }
               }
               if(!strpos($argv[1],'t') and $model=="PCS400") {
                  $pcs400ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                  if (isset($pcs400ver_file) and $pcs400ver_file[0]==$pcs400ver[0] and $pcs400ver_file[1]==$pcs400ver[1] and $pcs400ver_file[2]!=$pcs400ver[2]){
                     $pcs400[]=$value;
                     $log .="marked for upgrade\t";
                     print "### marked for upgrade ###\n";
                  }
               }
               if(!strpos($argv[1],'t') and $model=="PCS410") {
                  $pcs410ver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                  if (isset($pcs410ver_file) and $pcs410ver_file[0]==$pcs410ver[0] and $pcs410ver_file[1]==$pcs410ver[1] and $pcs410ver_file[2]!=$pcs410ver[2]){
                     $pcs410[]=$value;
                     $log .="marked for upgrade\t";
                     print "### marked for upgrade ###\n";
                  }
               }
               
               echo "*****  $model ******";
               if(!strpos($argv[1],'t') and $model=="trunk") {
                  $trunkver=sscanf(trim(substr($sa,10)),"%d.%d(%d)");
                  if (isset($trunkver_file) and $trunkver_file[0]==$trunkver[0] and $trunkver_file[1]==$trunkver[1] and $trunkver_file[2]!=$trunkver[2]){
                     $trunk[]=$value;
                     $log .="marked for upgrade\t";
                     print "### marked for upgrade ###\n";
                  }
               }
             }
			if ($sa == "#") {
				$ready++;
            $n=0;
            $wait=0;
			}
			if (strpos($sa, "0007D9") && strpos($sa, "#")) {
				$ready++;
            $n=0;
            $wait=0;
			}
         if ($ready == 1) {
				$ready++;
            if ($monday) fputs($fp, "ls -l | grep \"image_timestamp\"\n");
            else {
               fputs($fp, "upgrade loader $self\n");
               $self2=$self;
               $wait=100;
            }
			}
         if ($ready == 3) {
            $ready++;
            if ($monday) {
               if(substr($model,0,4)=="PCS5") fputs($fp,"ver /mnt2/tpcs\n");
               elseif ($model=="PCS400") fputs($fp,"ver /mnt2/gtk_pcs/xpcs\n");
               elseif ($model=="PCS410") {
                  if ($pcs480) fputs($fp,"ver /mnt2/tpcs\n");
                  else fputs($fp,"ver /mnt2/gtk_pcs/xpcs\n");
               }
               elseif ($model=="PCS100") fputs($fp,"ver /Splicecom/xpcs\n");
               elseif ($model=="Phone Module") fputs($fp,"ver /SpliceCom/PhoneModule\n");
               elseif ($model=="Trunk Module") fputs($fp,"ver /SpliceCom/GatewayApp\n");
               elseif ($model=="Voice Compression Module") fputs($fp,"ver /SpliceCom/CompressorApp\n");
               else fputs($fp, "\n");
            }
            else {
               if(substr($model,0,4)=="PCS5") {
                  fputs($fp,"getupg $self admin $ftp_password\n");
                  $wait=300;
               }
               else fputs($fp,"upgrade now $self2\n");
            }
         }
         if ($ready == 4 and !$monday and strpos($sa,"over write")) {
            fputs($fp, "n\n");
            $ready=2;
            $self2="";
         }
         if ($ready == 3) $six=0;
         if ($ready == 5) {
				$ready++;
            if ($monday) {
               if(isset($six) and (substr($model,0,4)=="PCS5")) fputs($fp, "date -u\n");
               else fputs($fp, "netdate $self\n");
            }
				else fputs($fp, "\n");
			}
			if ($ready == 7) {
				$ready++;
            if ($monday) {
               if ($do_uptime) fputs($fp, "uptime\n");
               else fputs($fp, "\n");
            }
				else fputs($fp, "exit\n");
			}
         if ($ready == 9) {
				$ready++;
            if ($monday) {
               if ($do_mac) fputs($fp, "ifconfig | grep eth0\n");
               else fputs($fp, "\n");
            }
				else fputs($fp, "exit\n");
			}

         if ($ready == 11) {
            $ready++;
            if ($monday && $do_poweroff) fputs($fp,"poweroff\n");
            else fputs($fp,"exit\n");
         }
		}
		fclose($fp);
      $log .="$tn[$value] $cn[$value]";
		fputs($fpl, $log."\n");
		if (($splice == 1) && (($load_ok == 0) || ($main_ok == 0))) {
			$ip_fail[] = $value;
		}
	}
}

// it all starts here
//@unlink($donefile); // always run for testing
print "\n$script: This upgrades the firmware on Phone Modules, PCSxxx, etc.\n\n";
print "Uses current registrations unless a $dofile file is found, always skips address in the $skipfile file.\n\n";
print "Syntax: php -n $script <-ltmu> and the results are logged to $logfile.\n";
print "Options are:\n -l = learn: Create / update $dofile file - does nothing else.\n -t = time: set time only on modules/PCSxxx hardware.\n";
print " -m = mac: Log Mac addresses.\n -p = poweroff: Poweroff reboot when done.\n\n";
print "Suggested /etc/crontab entries:\n";
print "4 4 * * *       root php -n /WebManager/upgrade.php > /dev/null    - this is for daily updates/checks when its quiet.\n";
print "4 9-16 * * *       root php -n /WebManager/upgrade.php -l > /dev/null    - this will learn registrations through the working day.\n\n";
$fpl = fopen($logfile, "a");
if (isset($argv[1])and strpos($argv[1], "m")) $do_mac =1; else $do_mac = 0;
if (isset($argv[1])and strpos($argv[1], "u")) $do_uptime =1; else $do_uptime = 1;  // now always on
if (isset($argv[1])and strpos($argv[1], "d")) $do_daily =1; else $do_daily = 0;
if (isset($argv[1])and strpos($argv[1], "p")) $do_poweroff = 1; else $do_poweroff = 0;
if (isset($argv[1])and strpos($argv[1], "l")) {
 $learn=1;
 $ip=getip();
   $s = date("Ymd H:i ", time())."Learn: $dofile now has ".count($ip)." entries.\n";
   print $s;
	fputs($fpl, $s);
   fclose($fpl);
 exit ("Learn completed.\n\n");
}

if (((filemtime($checkfile) != @filemtime($donefile)) && (!strpos($argv[1], "t"))) || (strpos($argv[1], "f"))) {
	$s = date("Ymd H:i ", time())."Upgrades to do...\n";
	print $s;
	fputs($fpl, $s);
	$ip = getip();
    $s = count($ip)." IP Addresses\n\n";
	print $s;
	fputs($fpl, $s);
   sleep(10);
	upgrade($ip);
	$s = date("Ymd H:i ", time())."Done.\n";
	print $s;
	fputs($fpl, $s);
	if (count($ip_fail) > 0) {
	   print_r($ip_fail);
		print"Some units appeared not to upgrade, pausing for 3 minutes before retrying...\n";
		sleep(180);
		upgrade($ip_fail);
		$s = date("Ymd H:i ", time())."Retries Done.\n";
		print $s;
		fputs($fpl, $s);
	}
// update done file to avoid unnecessary upgrades
	$fp = fopen($donefile, "w");
	fputs($fp, date("Ymd H:i", time()).
	" delete this file to rerun upgrade on this call server version.\n");
	fclose($fp);
	@chmod($donefile, 0666);
	@touch($donefile, filemtime($checkfile));
} else {
   if ((date('w')==1) || (strpos($argv[1], "t")) || (strpos($argv[1], "d")) or true) {
      $s = date("Ymd H:i ", time())."Set time and show build date & version...\n\n";
      print $s;
	   fputs($fpl, $s);
//      if(!strpos($argv[1], "t")) {
         pcs5xxfile(); // find out if we have a 5xx version for upgrades
         pcs582file(); // find out if we have a 582 version for upgrades
         pcs5x1file(); // find out if we have a 5x1 version for upgrades
		 pcs5x3file(); // find out if we have a 5x3 version for upgrades
         pcs542file(); // find out if we have a 542 version for upgrades
         pcs100file(); // find out if we have a 100 version for upgrades
         pcs400file(); // find out if we have a 400 version for upgrades
         pcs410file(); // find out if we have a 410/480 version for upgrades
         trunkfile(); // find out if we have a trunk version for upgrades
         
//      }
      $monday=1;
      $ip=getip();
      $s = count($ip)." IP Addresses\n\n";
	  print $s;
	  fputs($fpl, $s);
     sleep(10);
      upgrade($ip);
      if (isset($pcs5xx)) {
         print "Some PCS5xx require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs5xx);
      }
      if (isset($pcs582)) {
         print "Some PCS582 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs582);
      }
      if (isset($pcs5x1)) {
         print "Some PCS5x1 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs5x1);
      }
      if (isset($pcs5x3)) {
         print "Some PCS5x3 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs5x3);
      }
      if (isset($pcs542)) {
         print "Some PCS542 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs542);
      }
      if (isset($pcs100)) {
         print "Some PCS100 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs100);
      }
        if (isset($pcs400)) {
         print "Some PCS400 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs400);
      }
      if (isset($pcs410)) {
         print "Some PCS410 require an upgrade - proceeding\n";
         unset($monday);
         upgrade($pcs410);
      }
      if (isset($trunk)) {
         print "Some Trunk Modules require an upgrade - proceeding\n";
         unset($monday);
         upgrade($trunk);
      }      
      $s = date("Ymd H:i ", time())."Done.\n";
	   print $s;
	   fputs($fpl, $s);
   } else {
	   $s = date("Ymd H:i ", time())."Nothing to do\n";
	   print $s;
	   fputs($fpl, $s);
   }
}

fclose($fpl);
@chmod($logfile, 0666);
?>



