#!/bin/bash

# CGI script for configuration of VLAN settings for 5100/5315/5330

# NOTE: This file contains 3 different languages: bash, HTML & JavaScript

hostname=`hostname`
CONFIG=/tmp/vlan.cfg

# Determine hardware type
MODEL="UNKNOWN"
BUILD="00"
[ -f /proc/driver/build ] && BUILD=`cat /proc/driver/build`
grep -q sata_sil /proc/bus/pci/devices

if [ $? -eq 0 ]; then
	# Has SATA disk
        HW=CS
        STYLES="css/Styles.css"
        [ $BUILD = "0F" ] && MODEL="5100"
else
	# Has no SATA disk
        HW=PM
        STYLES="css/Styles.css"
	[ $BUILD = "FF" ] && MODEL="5330"
	[ $BUILD = "F0" ] && MODEL="5315"
	[ -f $CONFIG ] || grep os_vlan /tmp/os_env > $CONFIG
fi

if [ $MODEL = "UNKNOWN" ]; then
	cat <<- EOF
	Cache-Control: no-cache, no-store, max-age=1, must-revalidate
	Content-type: text/html

	<html>
	<link href="css/Styles.css" rel="stylesheet" type="text/css">
	<div style="position:absolute; top:8px; right:8px" >
	<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
	<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
	<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
	</div>
	VLAN operation not supported on this type of Maximiser unit
	</html>
	EOF
	exit
fi

if [ "$REQUEST_METHOD" = "POST" ]; then
	post=`awk -F"&" '{ \
	for (x=1;x<=NF;x++) { \
	        gsub(/\+/," ",$x); \
	        gsub(/=/,"=\"",$x); \
		gsub(/%2F/,"/",$x); \
		gsub(/%2B/,"+",$x); \
	        printf "%s\" ",$x \
	} \
	}'`

	if false; then
		cat <<- EOF
		Cache-Control: no-cache, no-store, max-age=1, must-revalidate
		Content-type: text/html

		<html>
		<head>
		<title>Post info</title>
		</head>
		<body><pre>
		EOF

		echo $post
		echo "</pre></body></html>"
		exit 0
	fi

	eval $post

	# save config ...
	[ -f $CONFIG ] && mv $CONFIG $CONFIG.old

	for x in 0 1 2 3 4 5; do
	  	n="pvid$x"
	  	[ "${!n}" ] && echo "os_vlan_$n=${!n}" >> $CONFIG
	done

	for x in 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15; do
	  	n="vid$x"
		m="mem$x"
	  	if [ "${!n}" -a "${!m}" ]; then
			echo "os_vlan_$n=${!n}" >> $CONFIG
	  		echo "os_vlan_$m=${!m}" >> $CONFIG
		fi
	done

	if [ "$vlan_enable" ]; then
		echo "os_vlan_enable=y" >> $CONFIG
	else
		echo "os_vlan_enable=n" >> $CONFIG
	fi

	if [ $HW = "PM" ]; then
		insmod flashenv >/dev/null 2>&1
		cat $CONFIG > /dev/flash_env_multiple
		rmmod flashenv
	fi
fi

# Read config here ...
if [ $HW = "CS" ]; then
	. $CONFIG
else
	if [ -f /tmp/vlan.cfg ]; then
		# form must have been submitted
		. /tmp/vlan.cfg
	else
		. $CONFIG
	fi
fi

[ "$os_vlan_enable" = "y" ] && enb_checked="CHECKED"

cat << EOF
Cache-Control: no-cache, no-store, max-age=1, must-revalidate
Content-type: text/html

<html>
<head>
<link href="$STYLES" rel="stylesheet" type="text/css">
<script type="text/javascript" language="JavaScript1.2">

// Copy shell variables to Javascript environment
//var model="$model"
var pvid=["$os_vlan_pvid0", "$os_vlan_pvid1", "$os_vlan_pvid2", "$os_vlan_pvid3", "$os_vlan_pvid4", "$os_vlan_pvid5"]
var vid=["$os_vlan_vid0", "$os_vlan_vid1", "$os_vlan_vid2", "$os_vlan_vid3", "$os_vlan_vid4", "$os_vlan_vid5", "$os_vlan_vid6", "$os_vlan_vid7", "$os_vlan_vid8", "$os_vlan_vid9", "$os_vlan_vid10", "$os_vlan_vid11", "$os_vlan_vid12", "$os_vlan_vid13", "$os_vlan_vid14", "$os_vlan_vid15"]
var mem=["$os_vlan_mem0", "$os_vlan_mem1", "$os_vlan_mem2", "$os_vlan_mem3", "$os_vlan_mem4", "$os_vlan_mem5", "$os_vlan_mem6", "$os_vlan_mem7", "$os_vlan_mem8", "$os_vlan_mem9", "$os_vlan_mem10", "$os_vlan_mem11", "$os_vlan_mem12", "$os_vlan_mem13", "$os_vlan_mem14", "$os_vlan_mem15"]

function click_port(field)
{
  with (field)
  {
    if (value=="U") value="T"
    else if (value=="T") value=" "
    else value="U"
  }
}

function validate_required(field,alerttxt)
{
  with (field)
  {
    if (value==null||value=="")
      {alert(alerttxt);return false}
    else {return true}
  }
}

function validate_vid(field)
{
  with (field)
  {
    if (value==null||value=="")
    {
      alert('Enter VID');
      return false;
    }

    if ((value<1)||(value>4094))
    {
      alert('Valid VID/PVID range is 1-4094');
      return false;
    }
    return true;
  }
}


function validate_form(thisform)
{
  with (thisform)
  {
    var z;
    var i;
    var v;

    for (i=0; i<6; i++)
    {
      if (validate_vid(document.getElementById('pvid'+i))==false)
        return false;
    }

    for (i=0; i<16; i++)
    {
      v = document.getElementById('vid'+i);
      if (v)
      {
        var bname;
	var y;

	if (validate_vid(v) == false) return false;

        // set hidden membership control value
	z=document.getElementById('mem'+i);
	for (var j=0; j<6; j++)
	{
          bname="B_"+i+"_"+j;
          y=document.getElementById(bname).value;
	  if (y == " ")
	  {
	    z.value=z.value+"_";
	  }
	  else
	  {
	    z.value=z.value+y;
	  }
	}
      }
    }
  }
  return true
}

function reset_form(thisform)
{
  with (thisform)
  {
    var z;
    var i;
    var v;

    for (i=0; i<6; i++)
    {
      z = 'pvid' + i;
      v = document.getElementById(z);
      if (v)
      {
        v.value = "1";
        v.defaultValue = "1";
      }
      pvid[i] = "1";
    }
    v = document.getElementById('vid0');
    if (v)
    {
      v.value = "1";
      v.defaultValue = "1";
      for (i=0; i<6; i++)
      {
        z="B_0_"+i;
        v = document.getElementById(z);
	if (v)
	{
	  // seem to need both these to satisfy IE and Firefox
          v.defaultValue = "U";
          v.value = "U";
	}
      }
    }

    var t = document.getElementById('pvidtab');
    if (t)
    {
      var l = t.rows.length;
      for (i=l-1; i>1; i--)
      {
        t.deleteRow(i);
      }
    }

    l = vid.length;
    for (i=1; i<l; i++)
      vid[i] = "";
  }
}

function add_vlan(thisform)
{
  with (thisform)
  {
    var i;
    var b;

    // find empty slot
    for (i=0; i<16; i++)
    {
      if (!vid[i]) break;
    }
    if (i == 16)
    {
    	alert("16 VLANs already configured");
	return;
    }
    vid[i] = "1";
    mem[i] = "UUUUUU";
    var tab = document.getElementById('pvidtab');
    if (tab)
    {
      var cells = new Array(9);
      var row = tab.insertRow(i+1);
      var j;
      for (j=0; j<8; j++)
      {
      	cells[j] = row.insertCell(j);
      }
      cells[0].innerHTML = i+"<input type=\"hidden\" name=\"mem"+i+"\" id=\"mem"+i+"\" value=\"\">";
      cells[0].align = "center";
      cells[1].innerHTML = "<input type=\"text\" name=\"vid"+i+"\" id=\"vid"+i+"\" size=\"4\" value=\""+vid[i]+"\">";
      cells[1].align = "center";
      for (j=2; j<8; j++)
      {
	b = "B_"+i+"_"+(j-2);
      	cells[j].innerHTML = "<input type=\"button\" onClick=click_port(this) id=\""+b+"\" name=\""+b+"\" value=\"U\">";
	cells[j].align = "center";
      }
      cells[8] = row.insertCell(8);
      cells[8].innerHTML = "<input type=\"button\" onClick=del_vlan(this) value=\"DEL\">";
      cells[8].align = "center";
    }
  }
}

function del_vlan(thisform)
{
  var row=thisform.parentNode.parentNode.rowIndex;
  if (row > 0)
  {
    var t = document.getElementById('pvidtab');
    var c = t.rows[row].cells[0];
    var h = c.innerHTML;
    var i = h.substr(0,1);
    t.deleteRow(row);
    vid[i] = "";
  }
}

function gen_tab()
{
  for (var i=0; i<16; i++)
  {
    if (vid[i])
    {
      var m;
      var b;
      document.write("<tr><td width=\"10%\" align=\"center\">"+i);
      document.write("<input type=\"hidden\" name=\"mem"+i+"\" id=\"mem"+i+"\" value=\"\"></td>");
      document.write("<td width=\"10%\" align=\"center\"><input type=\"text\" name=\"vid"+i+"\" id=\"vid"+i+"\" size=\"4\" value=\""+vid[i]+"\"></td>");
      for (var j=0; j<6; j++)
      {
        m = mem[i].substr(j,1);
	if (m == "_") m = " ";
	b = "B_"+i+"_"+j;
	document.write("<td width=\"10%\" align=\"center\"><input type=\"button\" onClick=click_port(this) id=\""+b+"\" name=\""+b+"\" value=\""+m+"\"></td>");
      }
      document.write("<td align=\"center\"><input type=\"button\" onClick=del_vlan(this) value=\"DEL\"></td></tr>");
    }
  }
}

</script>
<title>VLAN Configuration</title>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('assist/help/help_vlans.php','help','600','500','yes');return false" src="assist/images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">

<h1>Maximiser $MODEL</h1>
<h2>VLAN Configuration for $hostname</h2>

<hr><h3>Overview</h3>VLAN technology allows a single network to be partitioned into separate virtual LANs that behave as though each
VLAN is an independent network. VLANs are configured using two techniques:
<ol>
<li>Network packets may have an extra control field (the VLAN tag or VID) inserted that determines which VLAN they belong to.</li>
<li>Packets may be assigned to a VLAN by virtue of the physical port by which they enter/exit a VLAN aware switch.</li>
</ol>
VLAN technology is defined under the IEEE 802.1q specifications.
<form action="vlan.cgi" onsubmit="return validate_form(this)" onreset="reset_form(this)" method="post">
<hr><h3>VLAN Enable</h3>
<p>
Check this box to enable VLAN functionality on this unit based on the settings in the rest of this form.
If left unchecked the settings below will be ignored.
<p><input type="checkbox" name="vlan_enable" id="vlan_enable" value="ON" $enb_checked>Enable
<hr><h3>VLAN Ports</h3>
Tagged packets entering the switch keep their tag. Untagged packets are tagged as specified by the port's Permanent VLAN Identification (PVID).
This section allows you to specify the PVID for each port.
<p>
<table border="0" width="70%">
  <tr>
    <td width="16%" align="center"><b>LINK</b></td>
    <td width="17%" align="center"><b>LAN1</b></td>
    <td width="17%" align="center"><b>LAN2</b></td>
    <td width="17%" align="center"><b>LAN3</b></td>
    <td width="17%" align="center"><b>LAN4</b></td>
    <td width="16%" align="center"><b>CPU</b></td>
  </tr>
  <tr>
    <td width="16%" align="center">PVID <input type="text" name="pvid0" id="pvid0" size="4" value="$os_vlan_pvid0"></td>
    <td width="17%" align="center">PVID <input type="text" name="pvid1" id="pvid1" size="4" value="$os_vlan_pvid1"></td>
    <td width="17%" align="center">PVID <input type="text" name="pvid2" id="pvid2" size="4" value="$os_vlan_pvid2"></td>
    <td width="17%" align="center">PVID <input type="text" name="pvid3" id="pvid3" size="4" value="$os_vlan_pvid3"></td>
    <td width="17%" align="center">PVID <input type="text" name="pvid4" id="pvid4" size="4" value="$os_vlan_pvid4"></td>
    <td width="16%" align="center">PVID <input type="text" name="pvid5" id="pvid5" size="4" value="$os_vlan_pvid5"></td>
  </tr>
</table>
<hr><h3>VLANs</h3>
These settings control the port membership of each VLAN for transmitting data (egress).
These settings also determine whether transmitted data packets are tagged with VLAN and priority information.
The CPU port represents the internal connection between the unit's software and the switch.
<p>
<table border="1" width="70%" id="pvidtab">
  <tr>
    <td width="10%" align="center"><b>Index</b></td>
    <td width="10%" align="center"><b>VID</b></td>
    <td width="10%" align="center"><b>LINK</b></td>
    <td width="10%" align="center"><b>LAN1</b></td>
    <td width="10%" align="center"><b>LAN2</b></td>
    <td width="10%" align="center"><b>LAN3</b></td>
    <td width="10%" align="center"><b>LAN4</b></td>
    <td width="10%" align="center"><b>CPU</b></td>
    <td width="8%" align="center"></td>
  </tr>
 <script type="text/javascript">gen_tab();</script>
</table>
<p>U = Untag egress packets, T = Tag egress packets, blank = not a member<p>
<br><input type="button" onClick=add_vlan(this) value="Add New VLAN">
<hr><input type="submit" value="Submit"><input type="reset" value="Reset">
</form>
</div>
</body>
</html>
EOF


