<?php

// 	error_reporting(0);

	$ldap = ldap_connect("127.0.0.1", 4000);
	if (!$ldap)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	if (!ldap_bind($ldap, "INTERNAL", "112233445566"))
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}

	$mac = $_GET['mac'];

//	print "search (PhoneSerialNumber=".$mac.")\n";
	$phoneAttr = array('objectclass','ipaddress','pnpvendor','pnpmodel','pnpversion','usestun', 'stunaddr', 'stunport', 'password', 'siplicense', 'filename', 'requiredversion', 'dectlines', 'masteripaddress');
	$result = ldap_get_entries($ldap, ldap_search($ldap, "", "(PhoneSerialNumber=".$mac.")", $phoneAttr, 0, 1));
	if (!$result || count($result) < 1)
	{
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}
	if ($result[0]['objectclass'][0] == "SlavePhoneDevice")
	{
		$isSlave = TRUE;
		$sipLicence = 0;
		$phone_rqdv = "";
		$requestedLines = 0;
		$masterIP  = $result[0]['masteripaddress'][0];
	}
	else if ($result[0]['objectclass'][0] == "GenericIPPhone")
	{
		$isSlave = FALSE;
		$sipLicence = $result[0]['siplicense'][0];
		$phone_rqdv = $result[0]['requiredversion'][0];
		$requestedLines = $result[0]['dectlines'][0];
		if ($requestedLines < 1)
			$requestedLines  = 1; //We must have at least one hot desk user
	}
	else
	{
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}
	$phone_fw   = $result[0]['filename'][0];

//	print_r($result);

	//Check whether the client is using https and vary URLs accordingly
	$useHttps = false;
	$proto = "http";
	if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443)
	{
		$useHttps = true;
		$proto = "https";
	}

	$pnpvendor  = $result[0]['pnpvendor'][0];
	$pnpmodel   = $result[0]['pnpmodel'][0];
	$pnpversion = $result[0]['pnpversion'][0];
	if (!$useHttps && strcasecmp($pnpvendor, "fanvil") == 0)
	{
		//force fanvil to use https so at least the config isn't so easily read on a local LAN
		error_log("Forcing Fanvil to use https for $mac");
		if (!isset($_GET["reload"]))
			$location = 'https://'.$_SERVER['HTTP_HOST']."/prov/$mac.cfg";
		else
			$location = 'https://'.$_SERVER['HTTP_HOST']."/prov/reload/$mac.cfg";
		header('HTTP/1.1 301 Moved Permanently');
		header('location: '.$location);
		exit;
	}

	$phonepassword = $result[0]['password'][0];
	if (strlen($phonepassword)==0)
		$phonepassword = "7388";
	
	$ipaddress  = $result[0]['ipaddress'][0];
	
	$usestun  = $result[0]['usestun'][0];
	$stunaddr = $result[0]['stunaddr'][0];
	$stunport = $result[0]['stunport'][0];

	$phone_1_dn = $result[0]['dn'];
	$dna = ldap_explode_dn($phone_1_dn, 0);
//	print "dn ".$phone_1_dn."\n";
//	print_r($dna);

	$phone_dn = $dna[1];
	for ($i=2; $i<$dna['count']; $i++)
		$phone_dn .= ",".$dna[$i];

	$module_dn = $dna[2];
	for ($i=3; $i<$dna['count']; $i++)
		$module_dn .= ",".$dna[$i];

	$result = ldap_get_entries($ldap, ldap_read($ldap, "cn=1,".$module_dn, "(objectclass=*)", array('publicIPAddress', 'dontValidateIPAddress', 'provUser', 'provPw', 'provKey'), 0, 1));
	if (!$result || count($result) < 1)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$provUser = $result[0]['provuser'][0];
	$provPw   = $result[0]['provpw'][0];
	$provKey  = $result[0]['provkey'][0];
	if (!$isSlave && publicPhone())
	{
		if ($provUser && $provPw && strlen($provUser)>0 && strlen($provPw)>0)
		{
			if (!isset($_SERVER['PHP_AUTH_USER'])) {
				error_log("Not authenticated: $mac");
				header('WWW-Authenticate: Basic realm="SpliceCom"');
				header('HTTP/1.0 401 Unauthorized');
				exit;
			}
			if (strcmp($_SERVER['PHP_AUTH_USER'], $provUser)!=0 || strcmp($_SERVER['PHP_AUTH_PW'], $provPw)!=0)
			{
				error_log("Bad username/password: $mac");
				header('HTTP/1.1 404 Not Found'); //Not going to send "not authenticated" as they might try again
				exit;
			}
		}
		if (strcasecmp($pnpvendor, "fanvil") == 0)
		{
			//Only provision remote Fanvil phones with encryption
			if ($provKey===NULL || strlen($provKey)!=64)
			{
				error_log("Bad key for Fanvil for $mac");
				header('HTTP/1.1 404 Not Found');
				exit;
			}
		}
	}

	$dontvalidateipaddress = $result[0]['dontvalidateipaddress'][0];
	$provAddr = $result[0]['publicipaddress'][0];
	$phoneAddr = $_SERVER['REMOTE_ADDR'];
	//Check for phone operating locally even when set for STUN
	if (!$usestun || !publicPhone() || strcmp($provAddr, $phoneAddr) == 0)
	{
		$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('ipaddress'), 0, 1));
		if (!$result || count($result) < 1)
		{
		    header('HTTP/1.1 500 Internal Server Error');
		    exit;
		}
		$serveraddr = $result[0]['ipaddress'][0];
		if (!$usestun)
			$provAddr = $serveraddr; //Always provision from a local server if STUN not set
		$usestun = FALSE;
	}
	else // Using STUN on a public phone that doesn't share the same public address as the server
	{
		$serveraddr = $result[0]['publicipaddress'][0];
		$ldaps_server   = "ldaps-$serveraddr";
		if (!file_exists($ldaps_server))
		{
			//generate a key for this server if it's our home
			$info = ldap_get_entries($ldap, ldap_read($ldap, "cn=Self, cn=Modules", "(objectclass=*)", array('location'), 0, 1));
			$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('location'), 0, 1));
			if (!$result || !$info || count($result) < 1 || count($info) < 1)
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}
			$self=$info[0]['location'][0];
			$home=$result[0]['location'][0];
			if ($home==$self)
				setLdapsServerKey($ldaps_server, $serveraddr);
			else
				error_log("LDAP key generation skipped as this module is not the phone's home");
		}
	}

	if (!$dontvalidateipaddress && $phoneAddr != $ipaddress)
	{
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}

//	print "search dn=".$phone_dn."\n";
	$result = ldap_get_entries($ldap, ldap_read($ldap, $phone_dn, "(objectclass=*)", array('guid', 'productversion'), 0, 1));
	if (!$result || count($result) < 1)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$phone = $result[0];
	$phone_guid = $phone['guid'][0];
	$phone_version = $phone['productversion'][0];

	$ok = false;	
	$output ="";
	if (strcasecmp($pnpvendor, "yealink") == 0)
	{
		$model = strtoupper($pnpmodel);
		if (strncmp($model, "SIP-T", 5) == 0)
			$model = substr($model, 4); //loose leading SIP-
		$fullModel = $model; //will need to know exact model for firmware
		if ($model[0] === "T")
			$model = substr($model, 0, 3); //loose trailing letters
		$maxlines = 1; //set up one account by default
		$havelinekeys = false;
		$supportexpmodule = false;
		$supportLDAP  = false;
		$is530 = false;
		$supportpaging = false;
		$isDect = false;
		$supportDect = false;
		switch ($model)
		{
			case "IP 530":
				$is530 = true;
				break;
			case "VP59":
			case "T57":
			case "T54":
			case "T53":
				$supportDect = true;
				$maxlines = 5;// main phone and 4 handsets
				//and fall through
			case "T58":
			case "T56":
			case "T52":
			case "T48":
			case "T46":
			case "T43":
			case "T29":
			case "T27":
				$supportexpmodule = true;
				//and fall through
			case "SIP-CP960":
			case "SIP VP-T49G":
			case "T42":
			case "T41":
			case "T40":
			case "T33":
			case "T31":
			case "T23":
			case "T21":
				$havelinekeys = true;
				//and fall through
			case "CP920":
			case "CP860":
			case "T30":
			case "T19":
				$supportLDAP  = true;
				$supportpaging = true;
				break;
			case "W52P":
			case "W56P":
				$isDect = true;
				$supportDect = true;
				$maxlines = 5;// this number of handsets on the base
				$supportLDAP  = true;
				break;
			case "SIP-W60B":
				$isDect = true;
				$supportDect = true;
				$maxlines = 8;// this number of handsets on the base
				$supportLDAP  = true;
				$supportpaging = true;
				break;
			case "SIP-W80DM":
				$isDect = true;
				$supportDect = true;
				$maxlines = 100;// this number of handsets on the base
				$supportLDAP  = true;
				break;
			case "SIP-W80BM":
				$maxlines = 0;
				$isDect = true;
				$supportDect = true;
				break;
		}
		$isAndroid = false;
		switch ($model)
		{
			case "VP59":
			case "T58":
			case "T56":
			case "SIP-CP960":
				$isAndroid = true;
				break;
		}

		$haveuser = false;
		$user_guid = "";
		$userIsRestricted = false;
		
		$users = array();
		if (!$isSlave)
		{
			$attrs = array('guid','cn','telephonenumber','loginaccesscode', 'siplicense', 'userclass', 'dectline');
			$users = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Users", "(initialPhone=".$phone_guid.")", $attrs, 0, $maxlines));
		}
		
		$susers = array();
		// Sort users according to preferred DECT line
		$susers = SortLines($users, $maxlines, $requestedLines);
		if ($users && $users['count'] > 0)
		{
			//print_r($users);

			$haveuser = true;
			//First user credentials set up LDAP et al
			if (array_key_exists('1', $susers) && $susers['1']['isdefined'])
				$user = $susers['1'];
			else
				$user = reset($susers); //Line 1 is not logged in so use first logged in user we come across
			
			$user_guid            = $user['guid'][0];
			$user_cn              = $user['cn'][0];
			$user_telephoneNumber = $user['telephonenumber'][0];
			$user_loginAccessCode = $user['loginaccesscode'][0];
			if (!$sipLicence)
				$sipLicence = $user['siplicense'][0];
			if ($user['userclass'][0] > 0)
				$userIsRestricted = true;
		}

		if (!$sipLicence)
		{
			$havelinekeys = false;
			$supportexpmodule = false;
			$supportLDAP  = false;
			$supportpaging = false;
		}

		if ($is530)
		{
			// IP530
			print "[ account ]\n";
			print "path = /config/voip/sipAccount0.cfg\n";
			print "Enable = 1\n";
			if ($haveuser)
			{
				print "Label = ".$user_telephoneNumber." - ".$user_cn."\n";
				print "DisplayName = ".$user_cn."\n";
				print "UserName = ".$user_telephoneNumber."\n";
				print "AuthName = ".$user_telephoneNumber."\n";
				print "password = ".$user_loginAccessCode."\n";
			}
			print "SIPServerHost = ".$serveraddr."\n";
			print "SIPServerPort = 5060\n";
			print "SubscribeMWI = 1\n";

			$ok = true;
		}
		else
		{
			// Yealink T41P, etc
			$output = "#!version:1.0.0.1\n";

			// Read in any customer supplied code
			$webServerAddr = $serveraddr;
			$custom = "custom_yealink.php";
			$customParam = "";
			if (file_exists($custom))
			{
				include $custom;
				if ($useHttps)
				{
					if (isset($httpsPort))
					{
						$webServerAddr .= ":$httpsPort";
						$provAddr .= ":$httpsPort";
					}
				}
				else if (isset($httpPort))
				{
					$webServerAddr .= ":$httpPort"; //Some customers hate opening port 80
					$provAddr .= ":$httpPort";
				}
			}

			//--------------------------
			//Common Setup for all lines
			//--------------------------
			$screensize = "";
			$expscreensize = "";
			switch ($model)
			{
				case "SIP-CP960":
					$screensize = "720x1280";
					break;
				case "VP59":
					$expscreensize = "272x480";
					$screensize = "1280x800";
					break;
				case "T57":
					$expscreensize = "272x480";
					$screensize = "800x480";
					break;
				case "T56":
				case "T58":
					$expscreensize = "272x480";
					$screensize = "1024x600";
					break;
				case "T53":
					$expscreensize = "272x480";
					break;
				case "T52":
					$expscreensize = "272x480";
					$screensize = "320x240";
					break;
				case "T48":
					$screensize = "800x480";
					break;
				case "T54":
					$expscreensize = "272x480";
					//And deliberate drop through
				case "T46":
				case "T29":
					$screensize = "480x272";
					break;
				case "SIP VP-T49G":
					$screensize = "1280x800";
					break;
				case "T33":
					$screensize = "320x240";
					break;
			}
			if ($screensize)
			{
				$imagedir = "SIPimages";
				$wallpaperfile = "wallpaper$screensize.jpg";
				if (file_exists("$imagedir/$wallpaperfile"))
				{
					$output .= "phone_setting.backgrounds = Config:$wallpaperfile\n";
					$output .= "wallpaper_upload.url = $proto://".$webServerAddr."/prov/$imagedir/$wallpaperfile\n";
				}
				$screensaverfile = "saver$screensize-1.jpg";
				if (file_exists("$imagedir/$screensaverfile"))
				{
					$output .= "screensaver.wait_time = 600\n";
					$output .= "screensaver.type = 1\n";
					$output .= "screensaver.picture_change_interval = 300\n";
					$inum=1;
					do
					{
						$output .= "screensaver.upload_url = $proto://".$webServerAddr."/prov/$imagedir/$screensaverfile\n";
						$inum++;
						$screensaverfile = "saver$screensize-$inum.jpg";
					}
					while (file_exists("$imagedir/$screensaverfile"));
				}
			}
			if ($expscreensize)
			{
				$imagedir = "SIPimages";
				$wallpaperfile = "wallpaper$expscreensize.jpg";
				if (file_exists("$imagedir/$wallpaperfile"))
				{
					$output .= "expansion_module.backgrounds = Config:$wallpaperfile\n";
					$output .= "wallpaper_upload.url = $proto://".$webServerAddr."/prov/$imagedir/$wallpaperfile\n";
				}
			}
/* No longer needed
			$logosize = "";
			switch ($model)
			{
				case "T27":
					$logosize = "240x120";
					break;
				case "T42":
				case "T41":
				case "CP860":
					$logosize = "192x64";
					break;
				case "T40":
				case "T23":
				case "T21":
				case "T19":
					$logosize = "132x64";
					break;
			}
			if ($logosize)
			{
				$output .= "phone_setting.lcd_logo.mode = 2\n";
				$output .= "lcd_logo.url = $proto://".$webServerAddr."/SIPimages/logo".$logosize.".dob\n";
			}
*/

			// Ensure the phone displays the display names in the SIP call control messages and not LDAP etc for calls. Avoids Busy-username on pickup
			$output .= "phone_setting.call_display_name.mode=1\n";

			// Add LDAP directory scanning - uses first configured user for authentication
			if ($supportLDAP)
			{
				$output .= "directory_setting.url = $proto://".$webServerAddr."/prov/favorite_setting.xml\n";
				$output .= "super_search.recent_call = 0\n";
				$output .= "super_search.url = $proto://".$webServerAddr."/prov/super_search.xml\n";

				$output .= "ldap.name_filter = (GlobalKeyword=%)\n";
				$output .= "ldap.number_filter = (GlobalKeyword=%)\n";
				$output .= "ldap.host = ".$serveraddr."\n";
				if ($usestun == 1)
				{
					$output .= "ldap.tls_mode = 2\n";  //LDAPS
					$output .= "ldap.port = 4100\n";
					$output .= "trusted_certificates.url = $proto://$webServerAddr/prov/ldaps.cer\n";
				}
				else
				{
					$output .= "ldap.tls_mode = 0\n";  //LDAP
					$output .= "ldap.port = 4000\n";
				}
				if ($haveuser)
				{
					$output .= "ldap.enable = 1\n";
					$output .= "ldap.user = ".$user_telephoneNumber."\n";
					$output .= "ldap.password = ".$user_loginAccessCode."\n";
				}
				else
				{
					$output .= "ldap.enable = 0\n";
					$output .= "ldap.user = -\n";
					$output .= "ldap.password = -\n";
				}
				$output .= "ldap.name_attr = DNDcn ignorenullvalues\n";
				$output .= "ldap.numb_attr = telephonenumber mobileTelephoneNumber homeTelephoneNumber spare2TelephoneNumber pager\n"; //pager used due to Yealink limited field length
				$output .= "ldap.display_name = %DNDcn\n";
				$output .= "ldap.version = 2\n";
				$output .= "ldap.ldap_sort = 0\n";
				$output .= "ldap.max_hits = 10\n";
			}
			else
				$output .= "ldap.enable = 0\n"; //to be sure

			$timeZoneFile = "timeZone.php";
			$timeZones = "timeZones.csv";
			if (file_exists($timeZoneFile) && !file_exists($timeZones))
			{
				include $timeZoneFile;
			}
			else
				setTimeZone($timeZoneFile, $timeZones);

			$output .= "features.missed_call_popup.enable = 0\n"; //disable missed call popup

			$output .= "features.play_hold_tone.enable = 0\n";    // disable hold beep until Yealink fix the call selection
			$output .= "features.play_hold_tone.delay = 3\n";     // hold beep every x seconds

			if ($sipLicence)
			{
				$output .= "bw.feature_key_sync = 1\n";					//sync DND and call forwarding
				$output .= "phone_setting.ring_type = Resource:Ring2.wav\n"; //default ring type matches SpliceCom external
				//Set up distinctive ringing
				$output .= "distinctive_ring_tones.alert_info.1.ringer = 1\n";
				$output .= "distinctive_ring_tones.alert_info.1.text = Internal\n";
				$output .= "distinctive_ring_tones.alert_info.2.ringer = 2\n";
				$output .= "distinctive_ring_tones.alert_info.2.text = External\n";
				$output .= "distinctive_ring_tones.alert_info.3.ringer = 3\n";
				$output .= "distinctive_ring_tones.alert_info.3.text = RingTune3\n";
				$output .= "distinctive_ring_tones.alert_info.4.ringer = 4\n";
				$output .= "distinctive_ring_tones.alert_info.4.text = RingTune4\n";
				$output .= "distinctive_ring_tones.alert_info.5.ringer = 5\n";
				$output .= "distinctive_ring_tones.alert_info.5.text = RingTune5\n";
				$output .= "distinctive_ring_tones.alert_info.6.ringer = 6\n";
				$output .= "distinctive_ring_tones.alert_info.6.text = RingTune6\n";
				$output .= "distinctive_ring_tones.alert_info.7.ringer = 7\n";
				$output .= "distinctive_ring_tones.alert_info.7.text = RingTune7\n";
				$output .= "distinctive_ring_tones.alert_info.8.ringer = 8\n";
				$output .= "distinctive_ring_tones.alert_info.8.text = RingTune8\n";
				$output .= "distinctive_ring_tones.alert_info.9.ringer = 10\n";
				$output .= "distinctive_ring_tones.alert_info.9.text = RingTune9\n";
				$output .= "distinctive_ring_tones.alert_info.10.ringer = 4\n";
				$output .= "distinctive_ring_tones.alert_info.10.text = System\n";
			}
			$output .= "phone_setting.ringing_timeout = 3600\n"; //Keep ringing for up to an hour - the maximum allowed

			$output .= "trusted_certificates.url = $proto://".$webServerAddr."/prov/SpliceComCA.cer\n";
			$output .= "push_xml.sip_notify = 1\n"; //*****
			$output .= "features.direct_ip_call_enable = 0\n";
			$output .= "features.key_as_send = 0\n"; //only use # key as # and ignore the word SEND on it
			$output .= "sip.trust_ctrl = 1\n";
			if ($havelinekeys)
			{
				$output .= "features.blf_led_mode = 0\n";
				$output .= "blf.enhanced.dnd.enable = 1\n";
				$output .= 'blf.enhanced.dnd.led = $LEDg1000o500$'."\n"; //green for 1s and off for 0.5s. repeating
				if ($supportexpmodule)
				{
					//set to 0 to load BLFs onto the phone before loading expansion modules 
					//set to 1 to load BLFs onto expansion modules before loading the phone
					$output .= "phone_setting.blf_list_sequence_type = 1\n";
				}
				$output .= "phone_setting.page_tip = 1\n";
				$output .= "transfer.dsskey_deal_type = 1\n";
				$output .= "features.auto_linekeys.enable = 1\n";
				//Set hot desking if we have no user
				if (!$haveuser)
				{
					if (strcasecmp($model, "T57")==0)
					{
						$output .= "linekey.2.type = 27\n"; //set XML browser
						$output .= "linekey.2.label = Login/out\n";
						$output .= "linekey.2.value = $proto://$webServerAddr/prov/login.php?mac=$mac&phase=clear\n";
					}
					else
					{
						$output .= "linekey.1.type = 27\n"; //set XML browser
						$output .= "linekey.1.label = Login/out\n";
						$output .= "linekey.1.value = $proto://$webServerAddr/prov/login.php?mac=$mac&phase=clear\n";
					}
					$output .= "default_input_method.xml_browser_input_screen=123\n";
					// OLD clear call history on logout
					//{
						//$output .= "features.action_uri.enable = 1\n";    // Enable remote control of phone
						//$output .= "features.action_uri_limit_ip = 127.0.0.1\n"; //from the phone
						//$output .= "action_url.registered = $proto://admin:$phonepassword@127.0.0.1/servlet?key=CANCEL;F1;F3;DOWN;DOWN;DOWN;OK;OK;F1\n"; //delete call history on logon
						//$output .= "action_url.unregistered = $proto://admin:$phonepassword@127.0.0.1/servlet?key=CANCEL;F1;F3;DOWN;DOWN;DOWN;OK;OK;F1\n"; //delete call history on logoff
					//}

				}
			}
			if ($usestun == 1)
			{
				$output .= "sip.nat_stun.enable = 1\n";
				$output .= "sip.nat_stun.server = ".$stunaddr."\n";
				$output .= "sip.nat_stun.port = ".$stunport."\n";
			}
			else
			{
				$output .= "sip.nat_stun.enable = 0\n";
			}
			
			if ($supportpaging)
			{
				loadMulticastPaging($ldap, $phone_guid, $user_guid);
				$output .= "multicast.receive.use_speaker = 1\n"; //Always play out through speaker not earpiece
			}

			// After Yealink RPS, phone will need to know where to get it's config from
			//  Location priority is SIP PnP -> DHCP -> this config URL
			//  RPS is only consulted if all the above fail and the phone is coming up from a factory reset
			// Set the URL so we don't do a firmware upgrade after the first provision
			//  pnp & dhcp provisioning is enabled so if the phone is local to the PBX, local provisioning takes precedence
			$output .= "auto_provision.pnp_enable = 1\n";
			$output .= "auto_provision.dhcp_option.enable = 1\n";
			$output .= "auto_provision.server.url = $proto://".$provAddr."/prov/reload/\n";
			// ********* Provisioning will re-assert logins to initial phones so don't do this automatically
			$output .= "auto_provision.weekly.enable = 0\n";
			// and keep up to date each night
			//$output .= "auto_provision.weekly.enable = 1\n";
			//$output .= "auto_provision.weekly.begin_time = 02:00\n";
			//$output .= "auto_provision.weekly.end_time = 03:00\n";
			$output .= "auto_provision.custom.protect = 1\n"; //local changes are not lost

			//Change phone passwords
			$output .= "security.user_password = user:$phonepassword\n";
			$output .= "security.user_password = admin:$phonepassword\n";
			$output .= "security.user_password = var:$phonepassword\n";
			if ($supportDect)
			{
				$pwnum = preg_replace('/[^0-9]/','',$phonepassword); //only digits allowed
				$output .= "base.pin_code = $pwnum\n";
			}

			//Load required firmware
			//Check for upgrade of phone firmware
			if ($sipLicence && strlen($phone_rqdv)!=0 && strlen($phone_fw)!=0 && strlen($phone_version)!=0)
			{
				//See if we are already at the required level
				if (strpos($phone_version,$phone_rqdv)===false)
				{
					//get upgrade URL
					$result = ldap_get_entries($ldap, @ldap_read($ldap, "cn=YL, cn=System", "(objectclass=*)", array('url'), 0, 1));
					$fw_url = trim($result[0]['url'][0]);
					if (strlen($fw_url)==0)
						$fw_url = "http://max.splicecom.com/Yealink/firmware/";
					else if (substr($fw_url, -1) != '/')
						$fw_url .= '/';
					$fw_url .= $phone_fw;
					//error_log("Using url $fw_url");
					$output .= "firmware.url = $fw_url\n";
				}
			}
			else if ($isSlave && strlen($phone_fw)!=0) //No way of knowing what the slave is currently using
			{
				//get upgrade URL
				$result = ldap_get_entries($ldap, @ldap_read($ldap, "cn=YL, cn=System", "(objectclass=*)", array('url'), 0, 1));
				$fw_url = trim($result[0]['url'][0]);
				if (strlen($fw_url)==0)
					$fw_url = "http://max.splicecom.com/Yealink/firmware/";
				else if (substr($fw_url, -1) != '/')
					$fw_url .= '/';
				$fw_url .= $phone_fw;
				//error_log("Using url $fw_url");
				$output .= "firmware.url = $fw_url\n";
			}
			else if (!isset($_GET["reload"]))
				setFirmware($fullModel, $webServerAddr, $proto, $phone_version);

			// Fix number of users for W60B unit
			$fixW60B = FALSE;
			if (count($susers) > 4 && strcasecmp($model, "SIP-W60B")==0)
			{
				$fixW60B = TRUE;
				$output .= "phone_setting.max_number_of_handset = 8\n";
				$output .= "base.active_handset.number = 8\n";
			}

			//Configure call logging
			$LDAPCallLogging = false;
			if ($supportLDAP)
			{
				switch ($fullModel)
				{
					case "VP59":
					case "T58":
					case "T56A":
					case "T57W":
					case "T54W":
					case "T53W":
					case "T53":
					case "T48S":
					case "T46S":
					case "T42S":
					case "T41S":
					case "T40G":
					case "T19P_E2":
					case "T48U":
					case "T46U":
					case "T43U":
					case "T42U":
					case "T41U":
					case "T30P":
					case "T31P":
					case "T33P":
					case "T31G":
					case "T33G":
						$LDAPCallLogging = true;
						break;
				}
			}
			if ($LDAPCallLogging)
			{
				$output .= "custom.multi_voice_mail.enable=1\n";
				$output .= "custom.multi_voice_mail.history_url= https://$webServerAddr/prov/getcalllog.php?type=all\n";
				$output .= "custom.multi_voice_mail.vm_url= https://$webServerAddr/prov/getcalllog.php?type=vm\n";
				$output .= "custom.multi_voice_mail.delete_url= https://$webServerAddr/prov/getcalllog.php?type=delete&code=\$deletecode\n";
				$output .= "voice_mail.message_key.mode=1\n";
				$output .= "security.var_enable = 1\n";
				$output .= "security.default_access_level = 2\n";
				$output .= "web_item_level.url=https://$webServerAddr/prov/WebItemsLevel.cfg\n";
			}
			//phone call history must be on for the missed call indicator to work.
			if ($haveuser) //Ensure local phone call logging is switched on if we have a user.
				$output .= "features.save_call_history = 1\n";

			//Restricted users have no DND key
			if ($userIsRestricted === true)
				$output .= "features.dnd.allow = 0\n"; // disable key
			else
				$output .= "features.dnd.allow = 1\n"; // enable key

			// Set up call recording on phones that can support it
			switch ($fullModel)
			{
				case "VP59":
				case "T58":
				case "T56A":
				case "T57W":
				case "T54W":
				case "T53W":
				case "T53":
				case "T48S":
				case "T46S":
				case "T42S":
				case "T41S":
				case "T48U":
				case "T46U":
				case "T43U":
				case "T42U":
				case "T41U":
				case "T30P":					
				case "T31P":
				case "T33P":
				case "T31G":
				case "T33G":
					$output .= "features.call_recording_conf.enable=0\n"; //Turn off recording in SV1.3
					$output .= "features.call_recording_conf.url= Record@$serveraddr\n";
					$output .= "features.call_supervisor.enable=1\n";
					$output .= "features.voice_mail_tone_enable=0\n"; //Stop beeps when we end call recording in the middle of a call
					break;
			}

			// Set up W80DM
			if (strcasecmp($model, "SIP-W80DM")==0)
			{
				$output .= "template.1.name = Splicecom\n";
				$output .= "template.1.sip_server.1.address = ".$serveraddr."\n";
				if ($usestun == 1)
				{
					$output .= "template.1.sip_server.1.transport_type = 2\n"; //TLS
					$output .= "template.1.sip_server.1.port = 5061\n";
				}
				else
				{
					$output .= "template.1.sip_server.1.transport_type = 1\n"; //TCP=1, UDP=0
					$output .= "template.1.sip_server.1.port = 5060\n";
				}
				//Load bases
				$output .= LoadW80BMs($ldap, $mac);
			}
			if (strcasecmp($model, "SIP-W80BM")==0 && strlen($masterIP)!=0)
			{
				$output .= "features.dect_management.ip_address = $masterIP\n";
			}

			// Re-arrange keys for Call Select key
			if (strcasecmp($model, "T57")==0)
			{
				$output .= "linekey.1.type = 61\n"; //Move Directory to linekey
				$output .= "linekey.1.label = Directory\n";
				$output .= "programablekey.2.type = 5\n"; //set Softkey 2 to DND
				$output .= "programablekey.3.type = 30\n"; //set Softkey 3 to Menu
			}
			else if (!$isDect && !$isAndroid)
				$output .= "programablekey.9.type = 30\n"; //set OK key to Menu
			else if ($isAndroid)
			{
				$imagedir = "SIPimages";
				$iconsfile = "icons_yealink.tar";
				if (file_exists("$imagedir/$iconsfile"))
					$output .= "dsskey.icon.url = $proto://".$webServerAddr."/prov/$imagedir/$iconsfile\n";
			}
			//Disable new v84/85 features
			$output .= "features.parked_call_monitor.blf_audio_enable = 0\n";
			$output .= "features.transfer_complete.prompt.enable = 0\n";

			//------------------------
			//set up one line per user
			//------------------------
			for ($i=0; $i < $maxlines;)
			{
				$i++;
				if (!array_key_exists("$i", $susers))
				{
					$output .= "account.$i.enable = 0\n";
					$output .= "account.$i.sip_server.1.address = %NULL%\n";
					$output .= "account.$i.label = %NULL%\n";
					$output .= "account.$i.display_name = %NULL%\n";
					$output .= "account.$i.user_name = %NULL%\n";
					$output .= "account.$i.auth_name = %NULL%\n";
					$output .= "account.$i.password = %NULL%\n";
					if ($supportDect)
						$output .= "handset.$i.name = %NULL%\n";
					continue;
				}
				$user = $susers["$i"];
				if ($user['isdefined'])
				{
					$user_cn              = $user['cn'][0];
					$user_telephoneNumber = $user['telephonenumber'][0];
					$user_loginAccessCode = $user['loginaccesscode'][0];
					$output .= "account.$i.enable = 1\n";
					$output .= "account.$i.sip_server.1.address = ".$serveraddr."\n";
					$output .= "account.$i.label = ".$user_telephoneNumber."\n";
					$output .= "account.$i.display_name = ".$user_cn."\n";
					$output .= "account.$i.user_name = ".$user_telephoneNumber."\n";
					$output .= "account.$i.auth_name = ".$user_telephoneNumber."\n";
					$output .= "account.$i.password = ".$user_loginAccessCode."\n";
					if ($supportDect)
						$output .= "handset.$i.name = $user_cn\n";
				}
				else if ($sipLicence)
				{
					$output .= "account.$i.enable = 1\n";
					$output .= "account.$i.sip_server.1.address = ".$serveraddr."\n";
					$output .= "account.$i.label = offline\n";
					$output .= "account.$i.display_name = offline\n";
					$output .= "account.$i.user_name = OFFLINE".$i."-".$mac."\n";
					$output .= "account.$i.auth_name = OFFLINE".$i."-".$mac."\n";
					$output .= "account.$i.password = $mac\n";
					if ($supportDect)
						$output .= "handset.$i.name = offline\n";
				}
				else
				{
					$output .= "account.$i.enable = 0\n";
					$output .= "account.$i.sip_server.1.address = 0\n";
					$output .= "account.$i.label = noUser\n";
					$output .= "account.$i.display_name = noUser\n";
					$output .= "account.$i.user_name = noUser\n";
					$output .= "account.$i.auth_name = noUser\n";
					$output .= "account.$i.password = noUser\n";
					if ($supportDect)
						$output .= "handset.$i.name = noUser\n";
					continue;
				}
				if ($havelinekeys)
				{
					$output .= "account.$i.blf.blf_list_uri = SpeedDials\n";
					$output .= "account.$i.blf_list_retrieve_call_parked_code = **\n";
					$output .= "account.$i.number_of_linekey = 1\n";
				}

				if ($sipLicence)
				{
					$output .= "account.$i.direct_pickup_code = **\n";
					$output .= "account.$i.subscribe_mwi = 1\n";
					if ($LDAPCallLogging)
						$output .= "voice_mail.number.$i = %NULL%\n";
					else
						$output .= "voice_mail.number.$i = 1571\n";
				}

				// When W60B has more than 4 users, only narrow band codecs are supported.
				if ($fixW60B)
				{
					$output .= "account.$i.codec.g722.priority=3\n"; //work around configuration bug
					$output .= "account.$i.codec.pcma.priority=1\n";
					$output .= "account.$i.codec.pcmu.priority=2\n";
					$output .= "account.$i.codec.g722.enable=0\n";
					$output .= "account.$i.codec.g729.enable=0\n";
				}
				else
				{
					$output .= "account.$i.codec.1.priority = 3\n";
					$output .= "account.$i.codec.2.priority = 2\n";
				}
				$output .= "account.$i.alert_info_url_enable = 0\n";
				//$output .= "account.$i.shared_line_one_touch_bargein.enable = 1\n";
				$output .= "account.$i.dtmf.info_type = 1\n";
				$output .= "account.$i.ringtone.ring_type = Default\n";
				$output .= "account.$i.register_mac = 1\n";
				$output .= "account.$i.register_line = 1\n";

				if ($usestun == 1)
				{
					$output .= "account.$i.nat.nat_traversal = 1\n";
					$output .= "account.$i.sip_server.1.transport_type = 2\n"; //TLS
					$output .= "account.$i.sip_server.1.port = 5061\n";
					$output .= "account.$i.srtp_encryption = 1\n"; //SRTP mode (1 is optional, 2 is compulsory)
				}
				else
				{
					$output .= "account.$i.nat.nat_traversal = 0\n";
					$output .= "account.$i.sip_server.1.transport_type = 1\n"; //TCP=1, UDP=0
					$output .= "account.$i.sip_server.1.port = 5060\n";
					$output .= "account.$i.srtp_encryption = 0\n"; //NOT SRTP
				}
			}

			// Apply any customer supplied code
			if (isset($customParam))
				$output .= $customParam;

			//Add random string so phone does not ignore this because it thinks it's seen it before
			$output .="# ".time();

 			//print $output; //plain text version
			//exit;

			//Encrypt
			// System or AdminModule start up has generated the key files or we're in trouble
			$fplainkey = "/SpliceCom/Yealink/Aeskey.txt";
			$fenckey   = "yealink_Security.enc";
			if (!file_exists($fenckey) || !file_exists($fplainkey))
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}
			$bytes2write = strlen($output);
			$descriptorspec = array(
				0 => array("pipe", "r"), // stdin
				1 => array("pipe", "w"), // stdout
				2 => array("pipe", "a") // stderr
			);
			$process = proc_open("/SpliceCom/Yealink/yenc $fplainkey $bytes2write", $descriptorspec, $pipes);
			if (is_resource($process))
			{
				for ($written = 0; $written < $bytes2write; $written += $wrote)
				{
					$wrote = fwrite($pipes[0], substr($output, $written));
					if ($wrote === false)
					{
						header('HTTP/1.1 500 Internal Server Error');
						exit;
					}
				}
				fclose($pipes[0]);
				if (fpassthru($pipes[1]) === false)
				{
					header('HTTP/1.1 500 Internal Server Error');
					exit;
				}
				fclose($pipes[1]);
				fclose($pipes[2]);
				proc_close($process);
			}
			else
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}

			$ok = true;
		}
	}
	else if (strcasecmp($pnpvendor, "fanvil") == 0)
	{
		$ok = provisionFanvil($pnpmodel, $ldap, $serveraddr, $useHttps, $proto, $phone_guid, $phonepassword, $module_dn, $phone_dn, $usestun, $stunaddr, $stunport, $provKey,
								$sipLicence, $phone_rqdv, $phone_fw, $phone_version);
	}
	
	if (!$ok)
	{
		// unknown vendor/model
	    header('HTTP/1.1 404 Not Found');
	    exit;
	}

function provisionFanvil($pnpmodel, $ldap, $serveraddr, $useHttps, $proto, $phone_guid, $phonepassword, $module_dn, $phone_dn, $usestun, $stunaddr, $stunport, $provKey,
								$sipLicence, $phone_rqdv, $phone_fw, $phone_version)
{
	switch ($pnpmodel)
	{
		case "H5":
		case "H3":
			$model = $pnpmodel;
			break;
		default:
			return false;
	}

	//system data
	$result = ldap_get_entries($ldap, ldap_read($ldap, "cn=System", "(objectclass=*)", array('description'), 0, 1));
	if (!$result || count($result) < 1)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$systemDescription = $result[0]['description'][0];
	//module data
	$result = ldap_get_entries($ldap, ldap_read($ldap, $module_dn, "(objectclass=*)", array('description','snmpLocation'), 0, 1));
	if (!$result || count($result) < 1)
	{
		header('HTTP/1.1 500 Internal Server Error');
		exit;
	}
	$moduleDescription = $result[0]['description'][0];
	$moduleLocation = $result[0]['snmplocation'][0];
	//phone data
	$result = ldap_get_entries($ldap, ldap_read($ldap, $phone_dn, "(objectclass=*)", array('description','snmpLocation'), 0, 1));
	if (!$result || count($result) < 1)
	{
	    header('HTTP/1.1 500 Internal Server Error');
	    exit;
	}
	$phoneDescription = $result[0]['description'][0];
	$phoneLocation = $result[0]['snmplocation'][0];
	//Get user
	$users = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Users", "(initialPhone=".$phone_guid.")", array('guid','cn','telephonenumber','loginaccesscode', 'description', 'siplicense'), 0, 1));
	if (!$sipLicence && $users && $users['count'] > 0)
		$sipLicence = $users[0]['siplicense'][0];
	

	$output = "<<VOIP CONFIG FILE>>Version:SV1.3\n";

	// Read in any customer supplied code
	$webServerAddr = $serveraddr;
	$custom = "custom_fanvil.php";
	if (file_exists($custom))
	{
		include $custom;
		if ($useHttps)
		{
			if (isset($httpsPort))
				$webServerAddr .= ":$httpsPort";
		}
		else if (isset($httpPort))
			$webServerAddr .= ":$httpPort"; //Some customers hate opening port 80
	}

	//Send ID to DHCP server as a nicety
	$output .="<GLOBAL CONFIG MODULE>\n";
	$output .="Use Vendor Class ID:1\n";
	//Set time - only support UK to start
	$output .="Time Zone:0\n"; //GMT/UK etc
    $output .="Location:7\n"; //The UK
	$output .="Time Zone Name: UTC\n";
	//Set some stuff on the display
	$output .="Hotel Address:$systemDescription\n";
	$output .="Hotel Tel:$moduleDescription\n";
	$output .="Hotel First line:$moduleLocation\n";
	if ($users && $users['count'] > 0)
	{
		$userDescription = $users[0]['description'][0];
		$output .="Hotel Second line:$userDescription\n";
	}
	$output .="Hotel Third line:$phoneDescription\n";
	$output .="Hotel Four line:$phoneLocation\n";
	$output .="Push XML IP:$serveraddr\n";

	//Set UK ring tones
	$output .="<DSP CONFIG MODULE>\n";
	$output .="Signal Standard:13\n";
	$output .="Ring Type:1\n";
	if ($sipLicence)
	{
		//Set distinctive ringing selection
		$output .= "--Alert Info Ring--:\n";
		$output .= "Alert1 Text        :info=Internal\n";
		$output .= "Alert1 Ring Type   :2\n";
		$output .= "Alert2 Text        :info=External\n";
		$output .= "Alert2 Ring Type   :3\n";
		$output .= "Alert3 Text        :info=System\n";
		$output .= "Alert3 Ring Type   :8\n";
		$output .= "Alert4 Text        :info=RingTune3\n";
		$output .= "Alert4 Ring Type   :1\n";
		$output .= "Alert5 Text        :info=RingTune4\n";
		$output .= "Alert5 Ring Type   :4\n";
		$output .= "Alert6 Text        :info=RingTune5\n";
		$output .= "Alert6 Ring Type   :5\n";
		$output .= "Alert7 Text        :info=RingTune6\n";
		$output .= "Alert7 Ring Type   :6\n";
		$output .= "Alert8 Text        :info=RingTune7\n";
		$output .= "Alert8 Ring Type   :7\n";
		$output .= "Alert9 Text        :info=RingTune8\n";
		$output .= "Alert9 Ring Type   :8\n";
		$output .= "Alert10 Text       :info=RingTune9\n";
		$output .= "Alert10 Ring Type  :9\n";
	}
	
	//Set auto-provisioning parameters
	$output .="<AUTOUPDATE CONFIG MODULE>\n";
	$output .="Download Server IP :$proto://$webServerAddr/prov/\n";
	if ($useHttps)
		$output .="Download Protocol  :5\n";
	else
		$output .="Download Protocol  :4\n";
	$output .="Download Mode      :1\n";
	$output .="DHCP Option        :0\n";
	$output .="PNP Enable         :0\n";
	$output .="Download CommonConf:0\n";
	//load Splicecom CA - must have pem or crt extension and be in a specific sub-directory in a tar zip
	$splicecomCA  = "SpliceComCA.cer";
	$splicecomCAf = "trustCert/sips.pem";
	$etcTar = "FanvilEtc.tar.gz";
	if (!file_exists($etcTar) && file_exists($splicecomCA))
	{
		exec("tar --transform 's:$splicecomCA:$splicecomCAf:' -czf $etcTar $splicecomCA");
	}
	if (file_exists($etcTar))
	{
		$output .="Auto Etc Url:https://$serveraddr/prov/$etcTar\n";
		$output .="Trust Certification:3\n";
	}
	//load custom images/icons
	if (isset($customImages))
		$output .= $customImages;
	//install custom firmware
	if (isset($customCode))
		$output .= $customCode;
	else if ($sipLicence)
	{
		//Check for upgrade of phone firmware
		if (strlen($phone_rqdv)==0 || strlen($phone_fw)==0)
		{
			switch ($pnpmodel)
			{
				case "H5":
					$phone_rqdv = "2.10.1.6806";
					$phone_fw = "hotelh52.10.1.6806T20190730194829.z";
					break;
				case "H3":
					$phone_rqdv = "2.10.1.6806";
					$phone_fw = "hotelh32.10.1.6806T20190730194521.z";
					break;
			}
		}
		//See if we are already at the required level
		if (strlen($phone_version)==0 || strpos($phone_version,$phone_rqdv)===false)
		{
			//get upgrade URL
			$result = ldap_get_entries($ldap, @ldap_read($ldap, "cn=Fanvil, cn=System", "(objectclass=*)", array('url'), 0, 1));
			$fw_url = trim($result[0]['url'][0]);
			if (strlen($fw_url)==0)
				$fw_url = "http://max.splicecom.com/Fanvil/firmware/";
			else if (substr($fw_url, -1) != '/')
				$fw_url .= '/';
			$fw_url .= $phone_fw;
			//error_log("Using url $fw_url");
			$output .= "Auto Image Url:$fw_url\n";
		}
		else
			$output .= "Auto Image Url:\n";
	}

	$speedDials = array();
	$user_guid  = "";
	if ($users && $users['count'] > 0)
	{
		$user = $users[0];
		$user_guid            = $user['guid'][0];
		$user_cn              = $user['cn'][0];
		$user_telephoneNumber = $user['telephonenumber'][0];
		$user_loginAccessCode = $user['loginaccesscode'][0];

		$output .="<SIP CONFIG MODULE>\n";
		if ($usestun)
		{
			$output .= "STUN Server:$stunaddr\n";
			$output .= "STUN Port:$stunport\n";
		}
		$output .="--SIP Line List--  :\n"; //This line needed for provisioning to work
		$output .="SIP1 Phone Number  :$user_telephoneNumber\n";
		$output .="SIP1 Display Name  :$user_cn\n";
		$output .="SIP1 Register Addr :$serveraddr\n";
		$output .="SIP1 Register User :$user_telephoneNumber\n";
		$output .="SIP1 Register Pswd :$user_loginAccessCode\n";
		$output .="SIP1 Enable Reg    :1\n";
		$output .="SIP1 Proxy Addr    :$serveraddr\n";
		$output .="SIP1 Proxy User    :$user_telephoneNumber\n";
		$output .="SIP1 Proxy Pswd    :$user_loginAccessCode\n";
		$output .="SIP1 MWI Num       :1571\n";
		$output .="SIP1 VoiceCodecMap :G722,G711A,G711U\n";
		$output .="SIP1 Use VPN       :0\n";
		$output .="SIP1 Ena REG MAC   :1\n";
		if ($usestun)
		{
			$output .="SIP1 Register Port :5061\n";
			$output .="SIP1 Proxy Port :5061\n";
			$output .="SIP1 Media Crypto :1\n";
			$output .="SIP1 NAT Type :1\n";
			$output .="SIP1 Transport :3\n";
		}
		else
		{
			$output .="SIP1 Register Port :5060\n";
			$output .="SIP1 Proxy Port :5060\n";
			$output .="SIP1 Media Crypto :0\n";
			$output .="SIP1 NAT Type :0\n";
			$output .="SIP1 Transport :1\n";
		}

		if ($sipLicence)
			$speedDials = ldap_get_entries($ldap, @ldap_search($ldap, "GUID=$user_guid", "(objectclass=SpeedDial)", array('telephoneNumber','shortCode','description'), 0, 12));
	}

	$output .="<PHONE CONFIG MODULE>\n";
	//More window dressing
	$output .="LCD Title:Splicecom\n";
	//set speed dials if we can
	if ($speedDials && $speedDials['count'] > 0)
	{
		$output .= "--Function Key--   :\n";
		for($i=0; $i < $speedDials['count']; $i++)
		{
			$speedDial=$speedDials[$i];
			$shortcode = $speedDial['shortcode'][0];
			$number = $speedDial['telephonenumber'][0];
			$label = $speedDial['description'][0];
			//error_log("$i: $shortcode, $label, $number");
			if (strlen($shortcode) > 4)
			{
				$keyindex=substr($shortcode, 4);
				if ($keyindex > 0 && $keyindex < 7)
				{
					$output .= "Fkey$keyindex Value:$number@1/f\n";
					$output .= "Fkey$keyindex Title:$label\n";
				}
			}
		}
	}
	$output .= "--Soft Dss Key--   :\n";
	$output .= "SIP Notify XML:1\n";

	//Set passwords
	$output .= "<MMI CONFIG MODULE>\n";
	$output .= "--MMI Account--:\n";
	$output .= "Account1 Name:admin\n";
	$output .= "Account1 Password:$phonepassword\n";
	$output .= "Account1 Level:10\n";
	$output .= "Account2 Name:guest\n";
	$output .= "Account2 Password:$phonepassword\n";
	$output .= "Account2 Level:5\n";

	//Turn off # as send
	$output .= "<TELE CONFIG MODULE>\n";
	$output .= "Dial by Pound:0\n";

	//Add paging
	if ($sipLicence)
		$output .= fanvilLoadMulticastPaging($ldap, $phone_guid, $user_guid);

	// Apply any customer supplied code
	if (isset($customParam))
		$output .= $customParam;

	$output .= "<<END OF FILE>>\n";
	//for debug escape nasty characters that will mess up html when we are using a browser to check the output
	//print htmlentities($output);
	if (publicPhone())
	{
		//encrypt output
		$bytes2write = strlen($output);
		$descriptorspec = array(
			0 => array("pipe", "r"), // stdin
			1 => array("pipe", "w"), // stdout
			2 => array("pipe", "a") // stderr
		);
		$process = proc_open("/SpliceCom/Fanvil/dsc s '$provKey' $bytes2write", $descriptorspec, $pipes);
		if (is_resource($process))
		{
			for ($written = 0; $written < $bytes2write; $written += $wrote)
			{
				$wrote = fwrite($pipes[0], substr($output, $written));
				if ($wrote === false)
				{
					header('HTTP/1.1 500 Internal Server Error');
					exit;
				}
			}
			fclose($pipes[0]);
			if (fpassthru($pipes[1]) === false)
			{
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}
			fclose($pipes[1]);
			fclose($pipes[2]);
			proc_close($process);
		}
		else
		{
			header('HTTP/1.1 500 Internal Server Error');
			exit;
		}
	}
	else
		print $output;
	return(true);
}

function fanvilLoadMulticastPaging($ldap, $phoneGuid, $userGuid)
{
	//check for sanity and set up search string
	if (strlen($phoneGuid)==0)
		return "";
	$search = "(member=".$phoneGuid.")";
	if (strlen($userGuid)!=0)
		$search = "(|(member=".$userGuid.")".$search.")";

	$pchans = ldap_get_entries($ldap, @ldap_search($ldap, "cn=PagingChannels", "(objectclass=PagingChannel)", array('cn','distributionGroup','multicastAddress','multicastPort'), 0, 0));
	if (!$pchans)
	{
		return ""; //soft fail for systems with databases missing these fields.
	}
	
	$pageProv  = "<MCAST CFG MODULE>\n";
	$pageProv .= "--Mcast Addr--:\n";
	$index = 1;
	for ($i=0; $i<$pchans['count']; $i++)
	{
		$dist_group_guid = $pchans[$i]['distributiongroup'][0];
		if (strlen($dist_group_guid)==0)
			continue;
		$group = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Groups", "(guid=".$dist_group_guid.")", array('cn'),0,1));
		if ($group['count'] > 0)
		{
			$phone = ldap_get_entries($ldap, @ldap_search($ldap, $group[0]['dn'], $search, array('member'),0,1));
			if ($phone['count'] > 0)
			{
				$pageProv .= "MCAST".$index." Name:".$pchans[$i]['cn'][0]."\n";
				$pageProv .= "MCAST".$index." Host:".$pchans[$i]['multicastaddress'][0]."\n";
				$pageProv .= "MCAST".$index." Port:".$pchans[$i]['multicastport'][0]."\n";
				$index++;
				if ($index > 10)
				{
					break; //phones don't support more than 10 channels.
				}
			}
		}
	}
	return $pageProv;
}

function loadMulticastPaging($ldap, $phoneGuid, $userGuid)
{
	global $output;

	//check for sanity and set up search string
	if (strlen($phoneGuid)==0)
		return;
	$search = "(member=".$phoneGuid.")";
	if (strlen($userGuid)!=0)
		$search = "(|(member=".$userGuid.")".$search.")";
	//print "Looking for ".$search."\n";

	$pchans = ldap_get_entries($ldap, ldap_search($ldap, "cn=PagingChannels", "(objectclass=PagingChannel)", array('cn','distributionGroup','multicastAddress','multicastPort'), 0, 0));
	if (!$pchans)
	{
	    //header('HTTP/1.1 500 Internal Server Error');
	    //exit;
		return; //soft fail for systems with databases missing these fields.
	}
	//print_r($pchans);
	
	//Adjust error reporting to avoid those ldap partial search result warnings
	$errlvl=error_reporting();
	error_reporting($errlvl & ~E_WARNING);

	$index = 1;
	for ($i=0; $i<$pchans['count']; $i++)
	{
		$dist_group_guid = $pchans[$i]['distributiongroup'][0];
		//print_r($dist_group_guid);
		if (strlen($dist_group_guid)==0)
			continue;
		$group = ldap_get_entries($ldap, ldap_search($ldap, "cn=Groups", "(guid=".$dist_group_guid.")", array('cn'),0,1));
		if ($group['count'] > 0)
		{
			//print_r($group);
			//$phones = ldap_get_entries($ldap, ldap_search($ldap, $group[0]['dn'], "(id=*)", array('member'),0,0));
			//print_r($phones);
			$phone = ldap_get_entries($ldap, ldap_search($ldap, $group[0]['dn'], $search, array('member'),0,1));
			//print_r($phone);
			if ($phone['count'] > 0)
			{
				if ($index == 1)
				{
					//SpliceCom phones don't allow pages to interrupt calls or other pages
					//Do the same here
					$output .= "multicast.receive_priority.enable = 0\n";
					$output .= "multicast.receive_priority.priority = 0\n";
				}
				//print "Phone is a member of Paging Channel '".$pchans[$i]['cn'][0]."'\n";
				$output .= "multicast.listen_address.".$index.".label = ".$pchans[$i]['cn'][0]."\n";
				//Note to oneself - ldap_get_entries translates attribute names to lowercase!
				$output .= "multicast.listen_address.".$index.".ip_address = ".$pchans[$i]['multicastaddress'][0].":".$pchans[$i]['multicastport'][0]."\n";
				$index++;
				if ($index > 10)
				{
					break; //phones don't support more than 10 channels.
				}
			}
		}
	}
	error_reporting($errlvl);
}

function setLdapsServerKey($ldaps_server, $serveraddr)
{
	if (file_exists($ldaps_server))
		return;
	if (!touch($ldaps_server)) //create file asap to hold off other parties
		return;
	//attempt locking
	$fp = fopen($ldaps_server, "r+");
	if ($fp === false)
		return;
	if (flock($fp, LOCK_EX | LOCK_NB))
	{
		//Got lock - we are good to go
		// move away old files that might be in use
		rename("ldaps.key", "ldaps-old.key");
		rename("ldaps.cer", "ldaps-old.cer");
		// tidy up old public IP address locks - vary rare and any old files not in use
		foreach (glob("ldaps-*") as $filename)
		{
			if (strcmp($filename, $ldaps_server)!=0)
				unlink($filename);
		}
		// generate new certificate and key
		$rc=0;
		$outp;
		exec("openssl req -x509 -newkey rsa:4096 -keyout ldaps.key -out ldaps.cer -days 3650 -nodes -subj \"/C=UK/ST=Herts/L=Chorleywood/O=SpliceCom Ltd/OU=Org/CN=".$serveraddr."\"",$outp,$rc);
		flock($fp, LOCK_UN);
		fclose($fp);
		if ($rc != 0)
		{
			unlink($ldaps_server); //remove lock if we failed to generate key - give some-one else a go
		}
	}
	else
		fclose($fp);
}

function setFirmware($fullModel, $webServerAddr, $proto, $phone_version)
{
	global $output;

	$firmwareDir = "firmware";
	//Custom index takes precedence
	$files = array("customIndex.txt", "webIndex.txt", "index.txt");

	foreach ($files as $index)
	{
		if (file_exists("$firmwareDir/$index") && (($file = fopen("$firmwareDir/$index", "r")) !== FALSE))
		{
			//search file for model
			while (($data = fgetcsv($file, 500, ",")) !== FALSE)
			{
				if (count($data) > 1)
				{
					if (strcmp(trim($data[0]), $fullModel) == 0)
					{
						$filename=trim($data[1]);
						//Are we already at this version?
						if (strlen($phone_version) > 0)
						{
							$ver = strstr($phone_version, "."); //only want last 3 digit pairs, e.g. .84.180.5
							if (strpos($filename, $ver) !== FALSE)
								return;
						}
						if (count($data) > 2 && strncmp(ltrim($data[2]), "#", 1)!=0)
						{
							$url=trim($data[2]);
							$output .= "firmware.url = http://$url/$filename\n";
							fclose($file);
							return;
						}
						else if (file_exists("$firmwareDir/$filename"))
						{
							$output .= "firmware.url = $proto://$webServerAddr/prov/$firmwareDir/$filename\n";
							fclose($file);
							return;
						}
					}
				}
			}
			fclose($file);
		}
	}
}

function setTimeZone($timeZoneFile, $timeZones)
{
	global $output;

	if (file_exists($timeZones))
	{
		//find timezone
		//look it up in file
		//if it exists write out timeZoneFile instructions
		//move the csv file so we don't do this again.
		$ok = false;
		if (file_exists($timeZoneFile))
			unlink($timeZoneFile);

		$tz = exec("timedatectl | awk '/Time zone:/{print $3}'");
		if (strlen($tz)==0)
			$tz = exec("timedatectl | awk '/Timezone:/{print $2}'"); //Don't you just love people who change the output format
		if (strlen($tz)==0) //fallback to dodgy date method which can return ambiguous answers
			$tz = exec("date +%Z");
		if (strlen($tz)!=0)
		{
			if (($file = fopen("$timeZones", "r")) !== FALSE)
			{
				//search file for TZ
				while (($data = fgetcsv($file, 500, ",")) !== FALSE)
				{
					if (count($data) > 2)
					{
						if (strcmp(trim($data[0]), $tz) == 0)
						{
							$offset=trim($data[1]);
							$name=trim($data[2]);
							$tzOutput  = '$output .= "local_time.time_zone = '.$offset.'\n";'."\n";
							$tzOutput .= '$output .= "local_time.time_zone_name = '.$name.'\n";'."\n";
							$tzOutput .= '$output .= "local_time.summer_time = 2\n";'."\n";
							$wdata = "<?php\n".$tzOutput."?>\n";
							if (file_put_contents($timeZoneFile, $wdata, LOCK_EX) !== false)
							{
								include $timeZoneFile;
								$ok = true;
							}
							break;
						}
					}
				}
				fclose($file);
			}
		}
		rename($timeZones, $timeZones.".done");
		if ($ok)
			return;
	}

//**** The Old way ******
	//set time zone 
	// This is set in php.ini for php5 systems. (callserver is 4.3.10)
	// It is not adjusted from UTC when manager utilities sets the timezone
	//  therefore we must avoid php calls as they always return UTC
	//$tz = date("O");
	$tz = exec("date +%z");
	//$output .= "local_time.time_zone = ".substr($tz,0,3).":".substr($tz,3)."\n";
	// and handle phone foibles
	$output .= "local_time.time_zone = ";
	if ($tz === "+0000")
		$output .="0\n";
	else
	{
		$output .= substr($tz,0,1); //add sign
		if ($tz[1] == '0') //delete leading zero
			$output .= substr($tz,2,1);
		else
			$output .= substr($tz,1,2);
		$mins = substr($tz,3);
		if ($mins !== "00") //only add non zero minutes
			$output .= ":".$mins;
		$output .= "\n";
	}
	//Date gives the current GMT offset and takes daylight savings into account
	//The phone can do automatic DST but needs a valid country string in local_time.time_zone_name
	// for it to work and this would require a huge table of allowed strings against time zone
	//We'll turn it off for now
	$output .= "local_time.summer_time = 0\n";
}

function publicPhone()
{
	$phoneAddr = $_SERVER['REMOTE_ADDR'];
	if (filter_var($phoneAddr, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)===false)
		return false;
	else
		return true;
}

function LoadW80BMs($ldap, $mac)
{
	//Scan db for W80BM
	// if has no master mac or master mac matches, then add to this DM
	$out = "";
	$attrs = array('serialNumber','masterSerialNumber', 'pnpmodel');
	$bms = ldap_get_entries($ldap, @ldap_search($ldap, "cn=Modules", "(objectclass=SlavePhoneDevice)", $attrs, 0, 0));
	//error_log(print_r($bms, TRUE));
	if (count($bms) > 1)
	{
		$baseNum=1;
		foreach ($bms as $bm)
		{
			if (!isset($bm['pnpmodel']) || !isset($bm['serialnumber']) || strpos($bm['pnpmodel'][0], "W80BM") === FALSE)
				continue;
			if (!isset($bm['masterserialnumber']))
				$master = "";
			else
				$master = SanitiseMac($bm['masterserialnumber'][0]);
			if (strlen($master)==0 || strcasecmp($master, $mac) == 0)
			{
				$slave = SanitiseMac($bm['serialnumber'][0]);
				//error_log("Adding BM $slave to DM\n");
				$out .= "station.allowed.$baseNum.mac = $slave\n";
				$out .= "station.allowed.$baseNum.name = BM $slave\n";
				$baseNum++;
				if ($baseNum > 30)
				{
					error_log("Too many W80BMs for W80DM $mac in database\n");
					break;
				}
			}
		}
	}
	return $out;
}

function SanitiseMac($mac)
{
	// strip non hexadecimal from string
	return preg_replace('/[^0-9a-fA-F]/','',$mac);
}

function SortLines($users, $maxlines, $reqlines)
{
	// Sort users according to preferred DECT line
	// demote duplicates
	// add logged out users if reqlines exceed current logged in users
	// constrain to maxlines
	$susers = array();
	//Add logged in users
	if ($users && $users['count'] > 0)
	{
		//BUT if we only have one user allowed then skip all that stuff
		if ($maxlines == 1 && $users['count'] == 1)
		{
			$user = $users[0];
			$user['isdefined'] = TRUE;
			$susers["1"] = $user;
			return $susers;
		}

		//Sort it all out
		$floaters = array();
		foreach ($users as $user)
		{
			if (!isset($user['cn']))
				continue;
			$user['isdefined'] = TRUE;
			$line = $user['dectline'][0];
			if (!isset($line) || $line < 1 || $line > $maxlines || array_key_exists("$line", $susers))
				$floaters[] = $user;
			else
				$susers["$line"] = $user;
		}
		$line = 1;
		if (count($floaters) > 0)
		{
			foreach ($floaters as $user)
			{
				while (array_key_exists("$line", $susers))
					$line++;
				if ($line > $maxlines)
					break;
				$susers["$line"] = $user;
				$line++;
			}
		}
	}
	else
		$line = 1;

	//Add logged out users
	if (isset($reqlines) && $reqlines > count($susers))
	{
		// logged out users required
		$nobody['isdefined'] = FALSE;
		$numu = count($susers);
		while ($numu < $reqlines)
		{
			while (array_key_exists("$line", $susers))
				$line++;
			if ($line > $maxlines)
				break;
			$susers["$line"] = $nobody;
			$line++;
			$numu++;
		}
	}

	return $susers;
}

?>
