<?php
$page_size = 25;
$script = basename($_SERVER['SCRIPT_NAME']);

if (isset($_REQUEST['ddiplan']) && strlen($_REQUEST['ddiplan']) >= 1) {
	$ddiplan = $_REQUEST['ddiplan'];
} else {
	$ddiplan = NULL;
} 

$search = (isset($_REQUEST['search']) && strlen($_REQUEST['search']) >= 1) ? $_REQUEST['search'] : NULL;
$activeCompany 	= (isset($_REQUEST['activeCompany']) && strlen($_REQUEST['activeCompany']) >= 1) ? $_REQUEST['activeCompany'] : NULL;
$id = (isset($_REQUEST['id']) && strlen($_REQUEST['id']) >=1 && $_REQUEST['id'] > 0 ) ? $_REQUEST['id'] : '0';
$query = ($id > 0) ? "(id>=$id)" : '';
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>DDI Alternate Number Management</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="dr.css" rel="stylesheet" type="text/css">

<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/jquery-ui.min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="dr.js" type="text/javascript"></script>
</head>

<body>
<div id="toTop">^ Back to Top</div>

<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'/></a>
</div>

<div id="wrap">


<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
?>	
</div>
<!-- header ends -->


<!-- content begins -->
<div id="main">
<div class="wrapper">
<h3><span class="icon-list greyicon"></span> DDI Alternate Number Management</h3>

<div class='colLeft selection'>
<?php
	$width = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? 'wide' : 'ddiplan';
	$sr = @ldap_list($ds,"cn=Trunk2Trunk, cn=leastcostcallplans","(&(objectclass=*)(numbermatch=))",array('numbermatch'));
	$count = @ldap_count_entries($ds, $sr);
	$t2tset = true;
	
	if ($count === NULL || $count === 0) {
		echo "<script>t2tAlert();</script>";
		echo "<span><br><b>Warning.</B><br><br>This page requires a Trunk2Trunk LCPlan with a blank number match.<br>Please contact your reseller to have this functionality enabled.</span>";
		$t2tset = false;
	}


if ($t2tset) {
?>

		<form id="frm1" method="get" action="index.php">
		<div class='field <?php echo $width ?>'>
			<label for="givenname">Select DDI Plan & Company</label>
			<select name='ddiplan' id='ddiplan'>
			<option></option>
			<?php
			$sr=ldap_list($ds,"cn=DDICallPlans","(objectclass=DDICallPlan)");
			$info = ldap_get_entries($ds, $sr);
				for ($n=0; $n<$info['count']; $n++) {
					$selected = ($ddiplan == $info[$n]['cn'][0]) ? 'selected' : ''; 
					echo "<option value='".$info[$n]['cn'][0]."' $selected>" . $info[$n]['cn'][0] . "</option>";
				}
			?>
			</select>
			
<?php
	if ($adminCompany === '00000000-0000-0000-0000-000000000000') {
?>						
			<select id='activeCompany' name='activeCompany'>
			<option value='0'></option>
			<?php	
			$sr=ldap_list($ds,"cn=companies","(objectclass=company)");
			$info = ldap_get_entries($ds, $sr);
			for ($m=0; $m<$info['count']; $m++) {
				$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
				if ($cn === 'MyCompany') continue;
				$selected = ($guid === $activeCompany) ? 'selected' : '';
				echo "<option value='$guid' $selected>$cn</option>";	
			}
			?>
			</select>
	<?php
	} else {
		$activeCompany = $adminCompany;
	}  // admincompany
	?>
			&nbsp;&nbsp;<button type='submit' id='frmDDI' value='Select'>Select</button>
			<span class='information'>SELECT DDIPLAN AND COMPANY</span>
		</div>
		</form>

<?php		
	} //t2t
?>	
</div>

<div class='colFull'>
<?php
	if (isset($ddiplan)) {
		
	print "<h3>DDIPlan: $ddiplan</h3>";
		
	if ($activeCompany === '0') $activeCompany = '*';
	
	//array of numbermatches & total entry count
	$existingNumbermatches = array();
	$sr = ldap_list($ds,"cn=$ddiplan,cn=ddicallplans","(objectclass=ddientry)",array('numbermatch'));
	$info = ldap_get_entries($ds, $sr);
	for ($n=0; $n<$info['count']; $n++) {
		$existingNumbermatches[] = $info[$n]['numbermatch'][0]; 
	}
	$totalentrycount = ldap_count_entries($ds, $sr);
	$entryCounts = array_count_values($existingNumbermatches);
	
	//timeplan names
	$timeplans = array();
	$sr = ldap_list($ds,"cn=timeplans","(objectclass=timeplan)",array('cn','guid'));
 	$info = ldap_get_entries($ds, $sr); $timeplans = array();
    	for ($m=0; $m<$info['count']; $m++) {
	   		$timeplans[$info[$m]['guid'][0]] = $info[$m]['cn'][0];
		}
		
	
	if (isset($id) && $id === $totalentrycount) $query = "(id<=$totalentrycount)";
	
	if ($search) {
		$sr = ldap_list($ds,"cn=$ddiplan,cn=ddicallplans","(&(objectclass=ddientry)(company=$activeCompany)(|(numbermatch=*$search*)(translateto=*$search*)))",array('id'));
		$info = ldap_get_entries($ds,$sr); 
		if ($info['count'] >= 1) { 
			$searchId = $info[0]['id'][0];
		} else {
			$searchId = '0';
			echo "<script>searchAlert();</script>";
		}
		$query = "(id>=$searchId)";
	}
	
	// get all entries upto page size
	$att = array('id','numbermatch','translateto','guid', 'timeplan');
	$sr = @ldap_list($ds,"cn=$ddiplan,cn=ddicallplans","(&(objectclass=ddientry)(company=$activeCompany) $query)",$att,0,$page_size);
	$info = ldap_get_entries($ds,$sr);
		
	if ($info['count'] < 1) {
		echo "<span style='color:#770000; font-weight:800;'>No DDI Results Found</span>";
	} else {

	$first = $info[0]['id'][0];
	$last = $info[$info['count']-1]['id'][0];
	$next = ($last +1 < $totalentrycount) ? $last +1 : $last;
	$prev = (($first - $page_size) > 0) ? $first - $page_size : '0';
	$last = $totalentrycount - $page_size+1;	
	$link = "ddiplan=" . urlencode($ddiplan) . "&activeCompany=". urlencode($activeCompany);
?>

<div>
  <div style="float:left">
	<?php
	if ($totalentrycount > $page_size) {
		echo "<a href='$script?id=0&$link' title='First Page' alt='First Page' id='topFirst'><img src ='../assets/images/first.png' /></a>&nbsp;";
		echo "<a href='$script?id=$prev&$link' title='Previous Page' alt='Previous Page' id='topPrev'><img src ='../assets/images/prev.png' /></a>&nbsp;";
		echo "<a href='$script?id=$next&$link' title='Next Page' alt='Next Page' id='topNext'><img src ='../assets/images/next.png' /></a>&nbsp;";
		echo "<a href='$script?id=$last&$link' title='Last Page' alt='Last Page' id='topLast'><img src ='../assets/images/last.png' /></a>&nbsp;";
	}
	echo "<form id='searchFrm' method='post'><input type='text' name='search' id='search' placeholder='DDI Search' /><button name='searchSbmt' id='searchSbmt'>Search</button></form><br>";
	?>	

  </div>
  
  <div style="float:right; height: 70px;">
  	<button class='formBtn duplicateAll'><span>
	<input type="image" title="Duplicate First Alternate Number To All Alternate Numbers" alt="Duplicate First Alternate Number To All Alternate Numbers" src="../assets/images/copy.png" style="vertical-align: text-bottom;" />
	</span>Copy</button>&nbsp;&nbsp;
  
    <button class='formBtn toggleAll'><span>
	<input type="image" title="Toggle All Alternative Numbers" alt="Toggle All Alternative Numbers" src="../assets/images/select.png" style="vertical-align: text-bottom;" />
	</span>Toggle</button>&nbsp;&nbsp;
	
	<button class='formBtn clearAll'><span>
	<input type="image" title="Clear All Alternate Numbers" alt="Clear All Alternate Numbers" src="../assets/images/deletewav.png" style="vertical-align: text-bottom;" /><br>
	</span>Clear</button>&nbsp;&nbsp;
  </div>
</div>

<div style="float:left">
	Number Match fields highlighted with a yellow background indicate entries where duplicate number match values have been found.<br><br>
</div>

<div style="float:right">
	<br><button class='buttonSave'>Save Entries</button><br><br>
</div>


	<div class='statictable'>
	<table id='ddiRoutes'>		
		<form id="routes">

		<thead>

		<tr id='header'>
			<th width="120" align="center"><b>TimePlan</b></th>
			<th width="120" align="center"><b>Number Match</b></th>
			<th width="120" align="center"><b>Translate To</b></th>
			<th width="120" align="center"><b>Alternate Number</b></th>
			<th width="125" align="center"><b>Alternate Mode</b></th>
		</tr>
		</thead>
		
		<tbody id="results">
	<?php
	
		$db = new SQLite3('DDIRoutes.db3') or die('Unable to open database');
		
		for ($n=0;$n<$info['count'];$n++) {
			
			$id = trim($info[$n]['id'][0]); 
			$guid = trim($info[$n]['guid'][0]); 
			$numbermatch = trim($info[$n]['numbermatch'][0]);
			$translateto = trim($info[$n]['translateto'][0]);
			$timeplan = (array_key_exists($info[$n]['timeplan'][0], $timeplans)) ? $timeplans[$info[$n]['timeplan'][0]] : '';
			
			$checked = $drMode = $dbAltNumber = $warn = '' ;
			
			$connection = $db->query("SELECT * FROM routes WHERE ddiplan = '$ddiplan' AND guid = '$guid'");
			$res = $connection->fetchArray(1);
			
			if ($res) {
				$dbNumberMatch = $res['numbermatch'];
				$dbTranslateTo = $res['translateto'];
				$dbAltNumber = $res['alternatenumber'];
				$dbDrMode = $res['drmode'];
				
				if ($dbNumberMatch === 'Blank Number Match') $dbNumberMatch = '';
                
				if ($numbermatch != $dbNumberMatch || $translateto != $dbTranslateTo) {
					$warn = "class='warn' title='Warning: Highlighted Entries Are Different To The Saved Values\nSaved Number Match = $dbNumberMatch\nSaved Translate To = $dbTranslateTo\nSaved Alternate Number = $dbAltNumber'";
				}
				
				if ($dbDrMode == '1') {
					$checked = 'checked';
				}
				
			}
			
			$duplicate = ($entryCounts[$numbermatch] > 1) ? "class='duplicate' title='Duplicate Number Match Entry'" : '';
			
			echo "<tr id='$guid' data-id='$n' $warn>";
			echo "<input type ='hidden' name='guid[]' id='guid$n' value='$guid'/>";
			
			echo "<td><input type='text' name='timeplan[]' id='timeplan$n' value='$timeplan' size='20' readonly tabindex='-1' /></td>";
			
			echo "<td><input type='text' name='numbermatch[]' id='numbermatch$n' value='$numbermatch' size='20' $duplicate readonly tabindex='-1' /></td>";
			echo "<td><input type='text' name='translateto[]' id='translateto$n' value='$translateto' size='20' class='active' readonly tabindex='-1' /></td>";
			echo "<td><input name='alternateNumber[]' id='alternateNumber$n' value='$dbAltNumber' class='alternate' size='25' tabindex='0'/></td>";
			echo "<input type ='hidden' name='drMode[$n]' value='0' />";
			echo "<td><div class='checkbox'><label for='drMode$n'><div class='switch'><input type='checkbox' class='drEnable' name='drMode[$n]' id='drMode$n' value='1' $checked/><div class='slider'></div></div></label></div></td>"; 
			echo "</tr>";
			
		}
	?>
		
		</tbody>
		</form>
	</table>
	<br>
	</div>	
	
<div>
  <div style="float:left">
	<?php
	if ($totalentrycount > $page_size) {
		echo "<a href='$script?id=0&$link' title='First Page' alt='First Page' id='btmFirst'><img src ='../assets/images/first.png' /></a>&nbsp;";
		echo "<a href='$script?id=$prev&$link' title='Previous Page' alt='Previous Page' id='btmPrev'><img src ='../assets/images/prev.png' /></a>&nbsp;";
		echo "<a href='$script?id=$next&$link' title='Next Page' alt='Next Page' id='btmNext'><img src ='../assets/images/next.png' /></a>&nbsp;";
		echo "<a href='$script?id=$last&$link' title='Last Page' alt='Last Page' id='btmLast'><img src ='../assets/images/last.png' /></a>&nbsp;<br>";
	}
	?>	
  </div>
  
<div style="float:right; text-align: right;">

	<button class='formBtn duplicateAll'><span>
	<input type="image" title="Duplicate First Alternate Number To All Alternate Numbers" alt="Duplicate First Alternate Number To All Alternate Numbers" src="../assets/images/copy.png" style="vertical-align: text-bottom;" />
	</span>Copy</button>&nbsp;&nbsp;
  
    <button class='formBtn toggleAll'><span>
	<input type="image" title="Toggle All Alternative Numbers" alt="Toggle All Alternative Numbers" src="../assets/images/select.png" style="vertical-align: text-bottom;" />
	</span>Toggle</button>&nbsp;&nbsp;
	
	<button class='formBtn clearAll'><span>
	<input type="image" title="Clear All Alternate Numbers" alt="Clear All Alternate Numbers" src="../assets/images/deletewav.png" style="vertical-align: text-bottom;" /><br>
	</span>Clear</button>&nbsp;&nbsp;
	
	<br><br><button class='buttonSave'>Save Entries</button><br>
  </div>
</div>				
		
<?php
		}	//count check
	} //ddiplan
?>

</div>
</div>
	
</div>	

<!--content ends -->

<br/>
<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>
</div>
</body>
</html>