<?php

	require('../assets/inc/ldapConnect.php');
	$url = $_SERVER['SERVER_ADDR'];
	$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) >=1 ) ? $_REQUEST['mode'] : NULL; // search, add, delete, save
	$timestamp = (isset($_REQUEST['timestamp']) && strlen($_REQUEST['timestamp']) >=1 ) ? $_REQUEST['timestamp'] : NULL;
	
	
	
if ($mode === 'search') {
	$ddiplan = $_GET['ddiplan'];
	$company = ($_GET['company'] === '0') ? '*' : $_GET['company'];
	$query = strtolower($_GET['search']);
	
	$dn = "cn={$ddiplan}, cn=ddicallplans";
	$filter = ($query === ' ') ? "(&(objectclass=*)(numbermatch=))" : "(&(objectclass=*)(company=$company)(|(numbermatch=*$query*)(translateto=*$query*)(description=*$query*)))";
	$att = array('numbermatch','translateto','bc','timeplan','guid','description');
	$sr = @ldap_search($ds, $dn, $filter, $att,0,30,5);
	$info = @ldap_get_entries($ds, $sr);
	$rec_count = (isset($info["count"]) && $info["count"] >= 1) ? $info["count"] : '0';
	
	if ($rec_count > '0' && $query != '') {

	for ($i=0; $i<$info["count"]; $i++) {
		$guid[] = $info[$i]["guid"][0];
		$numbermatch[] = $info[$i]["numbermatch"][0];
		$translateto[] = $info[$i]["translateto"][0];
		$description[] = $info[$i]["description"][0];
	}
	
	array_multisort($guid, $numbermatch, $translateto, $description);
	
	foreach ($guid as $key => $value) {
	echo "<tr id=$guid[$key]>
			<td>$numbermatch[$key]</td>
			<td>$translateto[$key]</td>
			<td>$description[$key]</td>
	    </tr>";
		}
	} 
}


if ($mode === 'deleteDdi') {
	
	$ddiGuid = (isset($_REQUEST['ddiGuid']) && strlen($_REQUEST['ddiGuid']) >=1 ) ? $_REQUEST['ddiGuid'] : NULL;
	$ddiPlan = (isset($_REQUEST['ddiPlan']) && strlen($_REQUEST['ddiPlan']) >=1 ) ? $_REQUEST['ddiPlan'] : NULL;
	
	$sr = ldap_read($ds,"guid=$ddiGuid, cn=$ddiPlan, cn=DDICallPlans","objectclass=ddientry"); 
	$info = ldap_get_entries($ds,$sr); $id = $info[0]['id'][0]; $numbermatch = $info[0]['numbermatch'][0];
	ldap_delete($ds, "guid=$ddiGuid, cn=$ddiPlan, cn=DDICallPlans");
	audit ($timestamp, "[DDI] [Delete] $ddiPlan / $id / $numbermatch", "Deleted DDI $numbermatch from $ddiPlan");
	
}


if ($mode === 'saveDdi') {
	$ddiMode		= (isset($_REQUEST['ddiMode']) 			&& strlen($_REQUEST['ddiMode']) >=1 ) 			? $_REQUEST['ddiMode'] 			: NULL; // addDdi or editDdi
	$ddiPlan 		= (isset($_REQUEST['ddiPlan']) 			&& strlen($_REQUEST['ddiPlan']) >=1 ) 			? $_REQUEST['ddiPlan'] 			: NULL;
	$currentDDIGuid = (isset($_REQUEST['currentDDIGuid']) 	&& strlen($_REQUEST['currentDDIGuid']) >=1 ) 	? $_REQUEST['currentDDIGuid'] 	: NULL;
	
	$inboundrecordings 	= (isset($_REQUEST['inboundrecordings']) 	&& $_REQUEST['inboundrecordings'] === '1' ) 	? $_REQUEST['inboundrecordings'] 	: NULL; 
	$contactlookup 		= (isset($_REQUEST['contactlookup']) 		&& $_REQUEST['contactlookup'] === '1' ) 		? $_REQUEST['contactlookup'] 	 	: NULL; 
	$calleranonymity 	= (isset($_REQUEST['calleranonymity']) 		&& $_REQUEST['calleranonymity'] === '1' ) 		? $_REQUEST['calleranonymity'] 		: NULL; 
	$dditocli 			= (isset($_REQUEST['dditocli']) 			&& $_REQUEST['dditocli'] === '1' ) 				? $_REQUEST['dditocli'] 			: NULL; 
	$disablecompression = (isset($_REQUEST['disablecompression']) 	&& $_REQUEST['disablecompression'] === '1' ) 	? $_REQUEST['disablecompression'] 	: NULL; 
	$contactlookupname 	= (isset($_REQUEST['contactlookupname']) 	&& strlen($_REQUEST['contactlookupname']) >= '1' ) 	? $_REQUEST['contactlookupname'] 	: NULL; 
	
	if (isset($contactlookupname) && strlen($contactlookupname) >= 1) {
		$sr = ldap_read($ds,"guid=$contactlookupname, cn=companies","objectclass=company",array('cn')); 
		$info = ldap_get_entries($ds,$sr);	$contactlookupname = $info[0]['cn'][0];
	}
	
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($ddiMode) {
		$ddiCompany 		= $ent['ddiCompany'];
		$numbermatch 		= $ent['numbermatch'];
		$translatetoselect  = $ent['translatetoselect'];
		$translateto 		= $ent['translateto'];
		$description 		= $ent['description'];
		$timeplan 			= $ent['timeplan'];
		$ddiPlan 			= $ent['ddiPlan'];
		$ddiGuid 			= $currentDDIGuid;
		
		unset ($ent['mode']);	
		unset ($ent['match']);	
		unset ($ent['ddiPlan']);		
		unset ($ent['ddiMode']);
		unset ($ent['ddiName']);
		unset ($ent['ddiGuid']);
		unset ($ent['selectedDdi']);
		unset ($ent['currentDDIGuid']);
		unset ($ent['translatetoselect']);
		unset ($ent['inboundrecordings']);
		unset ($ent['contactlookup']);
		unset ($ent['contactlookupname']);
		unset ($ent['calleranonymity']);
		unset ($ent['dditocli']);
		unset ($ent['disablecompression']);
		unset ($ent['drEnable']);
		unset ($ent['drEnableTo']);
		unset ($ent['ddiCompany']);
		unset ($ent['timestamp']);
		
		$ent['company'] = $ddiCompany;
		
		if ($translatetoselect === 'autoattendant') {
			$aaOption = '';
			if (isset($ddiCompany) && strlen($ddiCompany) >1) {
				$sr = ldap_read($ds,"guid=$ddiCompany, cn=companies","objectclass=company",array('cn')); 
				$info = ldap_get_entries($ds,$sr);	$companyName = $info[0]['cn'][0];
		
				if ($ddiCompany === '00000000-0000-0000-0000-000000000000') {
					$aaOption = ($company === '00000000-0000-0000-0000-000000000000') ? '' : ":$companyName";
				} else {
					$aaOption = ":$companyName";
				}
			}
			$translateto = $ent['translateto'] = "!AA$aaOption";
			
		} else if ($translatetoselect === 'conference') {
			if ($translateto === 'Join') {
				$translateto = $ent['translateto'] = "!ConferenceJoin";	
			} else {
				$translateto = $ent['translateto'] = "!ConferenceJoin:$translateto";
			}
			
		} 
		

		$prefix = '';
		if ($contactlookup) {
		 if (isset($contactlookupname) && strlen($contactlookupname) >=1) {
			$prefix .= "[$contactlookupname]";
		 } else {
			$prefix .= "[]";	 
		 }
		}
		if ($disablecompression) $prefix .= "~";
		if ($dditocli) $prefix .= "-";
		if ($inboundrecordings) $prefix .= "=";
		if ($calleranonymity) $prefix .= "?";
		$translateto = $ent['translateto'] = $prefix.$translateto;
		
		
		
		if ($ddiMode === "addDdi") {
			$modifyRDN = ''; $ddiEntryID = array();
			$sr = ldap_list($ds,"cn=$ddiPlan,cn=ddicallplans","objectclass=ddientry",array('id')); 
			$info = ldap_get_entries($ds,$sr);
			for($n=0; $n<$info['count'];$n++) {
				$ddiEntryID[] = $info[$n]['id'][0];
			}
			
			if (count($ddiEntryID) >= 1) {
				$id = $ddiEntryID = max($ddiEntryID)+1;
			} else {
				$id = $ddiEntryID = '1';
			}
			

			$ent["objectclass"]= "ddientry";
			$dn = "id=$ddiEntryID, cn=$ddiPlan, cn=DDICallPlans";
			ldap_add($ds, $dn, $ent);
			
			$sr = ldap_read($ds,$dn,"objectclass=ddientry",array('guid')); 
			$info = ldap_get_entries($ds,$sr);	$ddiGuid = $info[0]['guid'][0];
			
			if ($modifyRDN == '1') {
				ldap_rename($ds, $dn,"id=$id", "cn=$ddiPlan, cn=DDICallPlans", true);
				$dn = "id=$id, cn=$ddiPlan, cn=DDICallPlans";
				audit ($timestamp, "[DDI] [Rename] $ddiPlan / $id", $dn);
			}
			 
		} else {
				unset ($ent['id']);
				ldap_modify($ds, "guid=$currentDDIGuid, cn=DDICallPlans", $ent);
		}
	
		echo "$ddiMode,$ddiGuid,$numbermatch,$translateto,$description";
		audit ($timestamp, "[DDI] [$ddiMode] $ddiPlan / $numbermatch", $ent);
	}
}

if ($mode === 'numberMatch') {
	
	$currentDDIPlan = (isset($_REQUEST['currentDDIPlan']) && strlen($_REQUEST['currentDDIPlan']) >=1 ) ? $_REQUEST['currentDDIPlan'] : NULL;
	$numbermatch = (isset($_REQUEST['numbermatch']) && strlen($_REQUEST['numbermatch']) >=1 ) ? $_REQUEST['numbermatch'] : NULL;
	
	$sr = ldap_list($ds,"cn=$currentDDIPlan,cn=ddicallplans","numbermatch=$numbermatch",array('id')); 
    echo ldap_count_entries($ds, $sr);

}


if ($mode === 'checkEntry') {
	
	$ddiPlan 		= (isset($_REQUEST['ddiPlan']) 		&& strlen($_REQUEST['ddiPlan']) >=1 ) 		? $_REQUEST['ddiPlan'] 		: NULL;
	$saveDDI 		= (isset($_REQUEST['saveDDI']) 		&& strlen($_REQUEST['saveDDI']) >=1 ) 		? $_REQUEST['saveDDI'] 		: NULL;
	$saveTrans 		= (isset($_REQUEST['saveTrans']) 	&& strlen($_REQUEST['saveTrans']) >=1 ) 	? $_REQUEST['saveTrans'] 	: NULL;
	$saveTimePlan 	= (isset($_REQUEST['saveTimePlan']) && strlen($_REQUEST['saveTimePlan']) >=1 )	? $_REQUEST['saveTimePlan'] : NULL;
	
	$sr = ldap_list($ds,"cn=$ddiPlan,cn=ddicallplans", "(&(timeplan=$saveTimePlan)(numbermatch=$saveDDI)(translateto=$saveTrans))", array('timeplan','numbermatch','translateto')); 
    echo ldap_count_entries($ds, $sr);
	
}

if ($mode === 'translateto') {
	
	
	$selected = (isset($_REQUEST['selected']) && strlen($_REQUEST['selected']) >=1 ) ? $_REQUEST['selected'] : NULL;
	$currentCompany = (isset($_REQUEST['currentCompany']) && strlen($_REQUEST['currentCompany']) >=2 ) ? $_REQUEST['currentCompany'] : '*';
	$values = '';
	
	if ($selected === 'users' || $selected === 'departments') {
		switch ($selected) {
		case 'users':
			$queryCn = "cn=users";
			$base = "(&(objectclass=user)(company=$currentCompany))";
			$filter = array('cn','telephonenumber');
			break;
		case 'departments':
			$queryCn = "cn=departments";
			$base = "(&(objectclass=department)(company=$currentCompany))";
			$filter = array('cn','telephonenumber');
			break;		
		}
		
		$sr=ldap_list($ds, $queryCn, $base, $filter);
		$info = ldap_get_entries($ds, $sr);	$selectedEntries = array();
		for ($m=0; $m<$info['count']; $m++) {				
			$values .= $info[$m]['telephonenumber'][0] . ":" . $info[$m]['cn'][0] . " (" . $info[$m]['telephonenumber'][0]. ")" . ",";
		}

		$values = rtrim($values, ',');
		echo $values;
			
	} else if ($selected === 'conference') {
		
		if (strlen($currentCompany) <= 1) {
			$sr=ldap_list($ds, "cn=meetmeconferences", "(objectclass=meetmeconference)", array('cn'));
			$info = ldap_get_entries($ds, $sr);	$selectedEntries = array();
			for ($m=0; $m<$info['count']; $m++) {				
				$values .= $info[$m]['cn'][0] . ":" . $info[$m]['cn'][0] . ",";
			}
		}
		
		if (strlen($currentCompany) <= 1) {
			$dn = "cn=companies";
			$base = "(objectclass=meetmeconference)";
			$filter = array('cn');
		} else {
			$dn = "guid=$currentCompany, cn=companies";
			$base = "(objectclass=meetmeconference)";
			$filter = array('cn');
		}
		
		$sr=ldap_search($ds, $dn, $base, $filter);
		$info = ldap_get_entries($ds, $sr);
			for ($m=0; $m<$info['count']; $m++) {				
				$values .= $info[$m]['cn'][0] . ":" . $info[$m]['cn'][0] . ",";
			}
		
		$values = rtrim($values, ',');
		echo $values;
		
	}
}


if ($mode === 'range') {
	$ddiplan = (isset($_REQUEST['ddiplan'])	&& strlen($_REQUEST['ddiplan']) >=1 ) ? $_REQUEST['ddiplan'] : NULL;
	$number = (isset($_REQUEST['number'])	&& strlen($_REQUEST['number']) >=1 ) ? $_REQUEST['number'] : NULL;
	$basenumber = (isset($_REQUEST['basenumber'])	&& strlen($_REQUEST['basenumber']) >=1 ) ? $_REQUEST['basenumber'] : NULL;
	$baseextn = (isset($_REQUEST['baseextn'])	&& strlen($_REQUEST['baseextn']) >=1 ) ? $_REQUEST['baseextn'] : NULL;
	$description = (isset($_REQUEST['description'])	&& strlen($_REQUEST['description']) >=1 ) ? $_REQUEST['description'] : NULL;
	$timeplan = (isset($_REQUEST['timeplan'])	&& strlen($_REQUEST['timeplan']) >=1 ) ? $_REQUEST['timeplan'] : NULL;
	$company = (isset($_REQUEST['company'])	&& strlen($_REQUEST['company']) >=1 ) ? $_REQUEST['company'] : NULL;
	
	$ddiEntryID = array();
	$sr = ldap_list($ds,"cn=$ddiplan,cn=ddicallplans","objectclass=ddientry", array('id')); 
	$info = ldap_get_entries($ds,$sr);
	for($n=0; $n<$info['count'];$n++) {
		$ddiEntryID[] = $info[$n]['id'][0];
	}
	
	if (count($ddiEntryID) >= 1) {
		$id = $ddiEntryID = max($ddiEntryID)+1;
	} else {
		$id = $ddiEntryID = '1';
	}
	
	for ($m=0; $m<$number; $m++) {
		$numbermatch = $basenumber+$m;
		$translateto = $baseextn+$m;
		
		$dn = "cn=$ddiplan, cn=ddicallplans";
		$filter = "(&(objectclass=*)(numbermatch=$numbermatch))";
		$att = array('numbermatch');
		$sr = ldap_search($ds, $dn, $filter, $att);
		$info = ldap_get_entries($ds, $sr);
		
		if ($info['count'] == 0) {
			echo "$numbermatch ->$translateto\n";
			$ent["objectclass"]= "ddientry";
			$ent["numbermatch"]= $numbermatch;
			$ent["translateto"]= $translateto;
			$ent["description"]= $description;
			$ent["timeplan"]= $timeplan;
			$ent["company"]= $company;
			
			$dn = "id=$id, cn=$ddiplan, cn=DDICallPlans";
			ldap_add($ds, $dn, $ent); $id++;
		}
	}
} 
?>