$(document).ready(function() {
	
	// load table //
	oTable = $('#departments').dataTable({
		"bJQueryUI": true, "sPaginationType": "full_numbers",
		"aLengthMenu": [[15, 25, 50, 100, 250, 500], [15, 25, 50, 100, 250, 500]]
	});
	
	$("body").on('change', '#distributionskiponnotargets', function(){
		if ($('#distributionskiponnotargets').is(":checked")) {
		  $('#alternatedistributiongroup, #alternatedistributionmode, #alternatedistributionskiponnotargets, #maxringbeforealternatedistributiontime2').prop('disabled',false);
			$('#alternatedistributiongroup').closest('div').nextAll(':has(.slider):first').find('.slider').removeAttr('style');
			if ($('#maxringbeforealternatedistributiontime2').length > 0 && $('#maxringbeforealternatedistributiontime2').val() > '0') $('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled',false);
		} else if ($('#distributionskiponnotargets').not(":checked") && $('#maxringbeforealternatedistributiontime').val() < 1) {
			$('#alternatedistributiongroup, #alternatedistributionmode, #alternatedistributionskiponnotargets, #maxringbeforealternatedistributiontime2').prop('disabled','disabled');
			$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled','disabled');
			$('#alternatedistributiongroup').closest('div').nextAll(':has(.slider):first').find('.slider').css('background-color', '#C9E4FF');
		} 
		});
	
	$("body").on('change', '#alternatedistributionskiponnotargets', function(){
		if ($('#alternatedistributionskiponnotargets').is(":checked")) {
		  	$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled',false);
		} else if ($('#alternatedistributionskiponnotargets').not(":checked") && $('#maxringbeforealternatedistributiontime2').val() < 1) {
			$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled','disabled');
		} 
		});
	
	$('body').on('change', '#new_dept input[name=maxringbeforealternatedistributiontime]', function(){
		if ($(this).length > 0 && $(this).val() > '0') {
			$('#alternatedistributiongroup, #alternatedistributionmode, #alternatedistributionskiponnotargets, #maxringbeforealternatedistributiontime2').prop('disabled',false);
			$('#alternatedistributiongroup').closest('div').nextAll(':has(.slider):first').find('.slider').removeAttr('style');
			if ($('#maxringbeforealternatedistributiontime2').length > 0 && $('#maxringbeforealternatedistributiontime2').val() > '0') $('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled',false);
		} else {
			$('#alternatedistributiongroup, #alternatedistributionmode, #alternatedistributionskiponnotargets, #maxringbeforealternatedistributiontime2').prop('disabled','disabled');
			$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled','disabled');
			$('#alternatedistributiongroup').closest('div').nextAll(':has(.slider):first').find('.slider').css('background-color', '#C9E4FF');
		} 
	});
	
	$('body').on('change', '#new_dept input[name=maxringbeforealternatedistributiontime2]', function(){
		if ($(this).length > 0 && $(this).val() > '0') {
			$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled',false);
		} else {
			$('#alternatedistributiongroup2, #alternatedistributionmode2').prop('disabled','disabled');
		} 
	});
	
	$("body").on('change', '#voicemailenabled', function() {
		if ($('#voicemailenabled').is(":checked")) {
			if (!$('#messageboxlicense').is(":checked"))
				var n = noty({ type: 'error', layout: 'center', text: 'Please Note:<br/>Routing calls to Voicemail requires a MessageBox Licence<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		}
	})
	
	// highlight table entries //
	$('#departments').on( 'click', 'tr', function () {
		//console.log ('clicked on row')
	if ( $(this).hasClass('odd') || $(this).hasClass('even') || $(this).hasClass('new') ) {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
			selectedGuid = selectedName = '';
        }
        else {
            oTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedGuid = $('#departments tr.selected').attr('id');
			selectedName = $('#departments tr.selected').find('td:first').text();
        }
		
		//console.log (selectedGuid + ' ' + selectedName);
	}
    });
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		//console.log ('tabs')
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");
	});
	
	
	// add new department //
	$("#btn_add").click(function() {
		selectedGuid = selectedName = '';
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'departmentForm.php?deptMode=addDept',
			loadCallback: function(){ 	    
				originalFormData = $('#new_dept').serialize();
				var isDisabled = $('#alternatedistributiongroup').prop('disabled');
				if (isDisabled) {
					$('#alternatedistributiongroup').closest('div').nextAll(':has(.slider):first').find('.slider').css('background-color', '#C9E4FF');
				}
			}
		}); 
	});
	
	
	// delete selected department //
	$("#btn_delete").click(function() {
		//console.log ('del')
		var selected = $('#departments tr.selected').attr('id');
		var timestamp = Math.floor(Date.now() / 1000); 
		if (typeof selected != "undefined" && selected.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Department: <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'departmentActions.php?mode=deleteDept&deptName=' + encodeURIComponent(selectedName) + '&deptguid=' + encodeURIComponent(selected) + '&timestamp=' + timestamp });
					oTable.fnDeleteRow( oTable.$('#' + selected)[0] );
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit selected user //
	$("#btn_edit").click(function(e) {
		selectedName = $('#departments tr.selected').find('td:first').text();
		//console.log (selectedName)
		speedDials = [];// set array //
		initialOption = '0'; // set / clear initial phone
		guid = $('#departments tr.selected').attr('id');
		if (typeof guid == "undefined" || guid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });					
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'departmentForm.php?deptMode=editDept&deptName=' + encodeURIComponent(selectedName) + '&deptguid=' + guid,
			loadCallback: function(){ 	    
				originalFormData = $('#new_dept').serialize();
				
				monitorvalues = [];
				
				if ($('#vmMonitors tr:not(".novm")').length > 0 ) {
					$('#vmMonitors tr').each(function(){
						var vmMonId = $(this).attr('id').replace('row', '');
						monitorvalues.push ('Existing;' + $('#monitorValue' + vmMonId).val());
					})
				}
				//console.log (monitorvalues)
			}
        });
	});
	
	
	
	// close Department //
	$("body").on('click', '#close', function(){
		var msg = (originalFormData !== $('#new_dept').serialize()) ? '<b>Changes haven\'t been saved.</b><br/>' : ''

		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close Department: <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	
	// save updates //
	$("body").on('click', '#save', function(){
	var saveDept = $('#cn').val();
	var saveTele = $('#telephonenumber').val();
	var timestamp = Math.floor(Date.now() / 1000); 
	
	if (saveDept.length < 1 || saveTele.length < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'Department Name and Telephone Number must be set<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
		var n = noty({
        type: 'information', layout: 'center', text: 'Save Department: <b>' + saveDept + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				//console.log ('save')
				var deptMode = $('#deptMode').attr('value');
				
				$.ajax({
					type: "POST", 
					cache: false,
					data: $('#new_dept').serializeArray(),
					url: "departmentActions.php?mode=saveDept&timestamp=" + timestamp, 	
				success: function(data) {
					res = data.split(":");
					var deptMode = res[0];
					guid = (deptMode == 'editDept') ? guid : res[1];
					var name = res[2]; var extn = res[3];  var desc = res[4];
					var ret = deptMode + ':' + guid + ':' + name + ':' + extn + ':' + desc;
					//console.log (ret)
					parent.UpdateCode(ret);
					
					
				// Update Voicemail Monitors
				if (typeof monitorvalues != "undefined" && monitorvalues.length > 0) {
					$.ajax({
						type: "POST", 
						cache: false,
						data: { monitorvaluesArray: monitorvalues },
						url: "departmentActions.php?mode=vmMonitor&deptGuid=" + encodeURIComponent(guid) + '&timestamp=' + timestamp , 	
						success: function(data) {
							//console.log (data)
						}
					});
				}
				// Update Voicemail Monitors
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});
	
	
	
	
	//  Department Form Checks //
		// name check //
	$('body').on('keyup', '#new_dept input[name=cn]', function(){
		var origName = (selectedName.length > 0) ? encodeURIComponent( $('#departments tr.selected').find('td:first').text() ) : '';
		var deptCN = $(this).val(); 

		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?dept=" + encodeURIComponent(deptCN),   
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(deptCN) === origName) return false;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#cn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			    $("#save").prop("disabled",true);

			 } else {
				$('#msg').html(''); 
				$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#cn").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	// Extension check //
	$('body').on('keyup', '#new_dept input[name=telephonenumber]', function(){
		var origExtn = encodeURIComponent( $('#departments tr.selected').find('td:nth-child(2)').text() );
		var deptExtn = $(this).val(); 

		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?dept_ext=" + encodeURIComponent(deptExtn),   
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(deptExtn) === origExtn) return false;
			 if ( (response.toLowerCase().indexOf("error") >= 0) || (!$.isNumeric(deptExtn)) ) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#telephonenumber").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#save").prop("disabled",true);
			 } else {
				$('#msg').html(''); 
				$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#telephonenumber").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	$('body').on('change', '#new_dept select[name=alternatedistributiongroup]', function(){
		selected = $(this).val();
		if ($(this).val().length > 1 && $('#alternatedistributiongroup2').val().length < 1)
			$("#alternatedistributiongroup2").val(selected);
			$("#alternatedistributionmode2").val('1');
	});
	
	// check for manual distribution
	$('body').on('change', '#new_dept select[name=distributionmode]', function(){
		selected = $(this).val();
		if ($(this).val() === '5') {
			$("#distributionskiponnotargets").prop('checked', false).prop('disabled', true);
		} else {
			$("#distributionskiponnotargets").prop('disabled', false);
		}
	});
	
	$('body').on('change', '#new_dept select[name=alternatedistributionmode]', function(){
		selected = $(this).val();
		if ($(this).val() === '5') {
			$("#alternatedistributionskiponnotargets").prop('checked', false).prop('disabled', true);
		} else {
			$("#alternatedistributionskiponnotargets").prop('disabled', false);
		}
	});
	
	// check voicemail access code
	$('body').on('keyup', '#new_dept input[name=voicemailaccesscode]', function(){
		var msg = '';
		var vmc = $('#voicemailaccesscode').val();
		var pwd = ['1234', '999', '0000', '0'];
		if ($('#telephonenumber').val().length >= 1) {
			pwd.push( $('#telephonenumber').val() );
			msg = 'or ' + $('#telephonenumber').val();
		}
		if (vmc.length >= 1 && (jQuery.inArray(vmc, pwd) !== -1 || !$.isNumeric(vmc))) {
			$('#msg').html('Invalid Voicemail Access Code'); 
			$('#msg_wrap, #voicemailaccesscode').addClass('error');
		    $("#save").prop("disabled",true);
			var n = noty({ type: 'error', layout: 'center', text: 'Invalid Voicemail Access Code<br/>The voicemail access code must be a number and should not be set to 1234, 999, 0000, 0 ' + msg + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		} else {
			$('#msg').html(''); 
			$('#msg_wrap, #voicemailaccesscode').removeClass('error');
			$("#save").prop("disabled",false);
		}
	});
	
	// Out of Hours Distribution Checkbox
	$('body').on('change', '#new_dept select[name=outofhoursdistributiongroup]', function(){
		selected = $(this).val();
		timeplan = $( "#timeplan option:selected" ).text();
		if (selected.length > 1) {
			$("#outofhoursmode").val('1');
			if (timeplan == "Standard") {
				msg = "For Out Of Hours mode to work a timeplan other than Standard needs to be selected";
			} else if (timeplan == '') {
				msg = "For Out Of Hours mode to work a timeplan needs to be set";
			}
			var n = noty({ type: 'error', layout: 'center', text: 'Please Note:<br/>' + msg + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		}
	});
	
	// changing timeplan
	$('body').on('change', '#new_dept select[name=timeplan]', function(){
		selected = $('#timeplan option:selected').text();
		ooh = $( "#outofhoursdistributiongroup option:selected" ).text();
		if (ooh.length > 1) {
			if (selected == "Standard") {
				msg = "For Out Of Hours mode to work a timeplan other than Standard needs to be selected";
			} else if (selected.length == 0) {
				msg = "For Out Of Hours mode to work a timeplan needs to be set";
			} else {
				return false;
			}
			var n = noty({ type: 'error', layout: 'center', text: 'Please Note:<br/>' + msg + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		}
	});
	
	// numeric values only
	$('body').on('keyup', '#new_dept input[name=maxringbeforeannouncementtime], [name=repeatannouncementtime], [name=maxringbeforealternatedistributiontime], [name=maxringbeforealternatedistributiontime2], [name=maxnumberofactivecallsbeforebusy], [name=wrapuptime], [name=noanswertime]', function(){
		thisVal = ( $(this).val() )
		if(thisVal.length >= 1 && !$.isNumeric(thisVal)) {
			$('#msg').html('Numeric Value Only'); 
			$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$(this).css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#save").prop("disabled",true);
		} else {
			$('#msg').html(''); 
			$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$(this).css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$("#save").prop("disabled",false);
		}				
	});
	
	// Voicemail - check licence and mailbox and numeric
	$('body').on('keyup', '#new_dept input[name=maxnoanswertimebeforevoicemail], [name=maxnoanswertimebeforevoicemailooh]', function(){
	timer = $(this).val();
	thisVal = ( $(this).val() )
		if(thisVal.length >= 1 && !$.isNumeric(thisVal)) {
			$('#msg').html('Numeric Value Only'); 
			$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$(this).css({ 'border': '2pt solid #D00', 'color': '#D00'});
			$("#save").prop("disabled",true);
			return false
		} else {
			$('#msg').html(''); 
			$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$(this).css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
			$("#save").prop("disabled",false);
		}				
	
		if (timer > '0') {
			if (!$('#messageboxlicense').is(":checked") || !$('#voicemailenabled').is(":checked"))
				var n = noty({ type: 'error', layout: 'center', text: 'Please Note:<br/>Routing calls to Voicemail requires a MessageBox Licence and Voicemail needs to be enabled<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		}
	});
	
$('body').on('click', '#addRow', function(e) {
		e.preventDefault();
		var rowCount = $('#vmMonitors tr:not(".novm")').length;
		var newRowID = parseInt(rowCount) + 1;
		var monitor = $('#addmonitor').find(":selected").val().split(';');
		var newEntry = monitor[1]  + " (" + monitor[2] + ")";
		var newGuid = monitor[0]
		var newRow = "<tr id='row" + newRowID + "'><td><input id='monitorRow" + newRowID + "' value='" + newEntry + "' disabled/><input type='hidden' id='monitorValue" + newRowID + "' value='" + newGuid + "' disabled /></td><td class='delete'><img src='../assets/images/delete.png' class='deleteRow' name='deleteRow' id='deleteRow" +  newRowID + "' title='Delete Row'/></td></tr>";
	
		if ($('.novm').length > 0) $('.novm').remove();
		
		if ( $('#vmMonitors :input[value="' + monitor[0] + '"]').length < 1) {
			$('#vmMonitors').append(newRow)
			$('.monitorcontainer').scrollTop($('.monitorcontainer')[0].scrollHeight);
			
			//monitorvalues[newGuid] = 'New';
			//monitorvalues.push ('New;' + newGuid);
			
			monitorvalues = monitorvalues.map(function(value) {
				if( value.indexOf(newGuid) > -1 ) {
					return (value.indexOf('New') === 0 ? 'New;' : 'Existing;') + newGuid;
				} return value;
			});
			if ( ($.inArray('New;' + newGuid, monitorvalues) == -1)  ) {
				monitorvalues.push('New;' + newGuid)
			}
			//console.log (monitorvalues)

		} else {
			rowID = ( $('#vmMonitors :input[value="' + monitor[0] + '"]').attr('id').replace('monitorValue','') )
			$('#monitorRow' + rowID).css("background-color", "#ffff8c");
			
			setTimeout(function() {
				$('#monitorRow' + rowID).css("background-color", "#e8e8e8");
			}, 1500);
		}
		
	})
	
	
		$('body').on('click', '#vmMonitors .deleteRow', function() {
			thisRow = $(this);
			//console.log (thisRow)
			rowID = ( $(thisRow).attr('id').replace('deleteRow','') )
			selected = $('#monitorRow' + rowID).val();
			selectedID = $('#monitorValue' + rowID).val();
		
			var n = noty({
			type: 'warning', layout: 'center', text: 'Delete Department Voicemail Monitor: <b>' + selected + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
			buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					
					//delete monitorvalues[selectedID];
					//monitorvalues[selectedID] = 'Delete'
					//monitorvalues.push ('Delete;' + selectedID);
					
					monitorvalues = monitorvalues.map(function(value) {
						if( value.indexOf(selectedID) > -1 ) {
							return (value.indexOf('New') === 0 ? 'New;' : 'Delete;') + selectedID;
						} return value;
					});
					if ( ($.inArray('Delete;' + selectedID, monitorvalues) == -1  && $.inArray('New;' + selectedID, monitorvalues) == -1)   ) {
						monitorvalues.push('Delete;' + selectedID)
					}
					//console.log (monitorvalues)
					//return false;
					
					
					$(thisRow).closest('tr').remove();
					if ( $('#vmMonitors .deleteRow').length < 1) $('#vmMonitors').append("<tr class='novm'><td>No Voicemail Monitors Set</td></tr>");
					//console.log (monitorvalues)
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
		
    });
	
	

	
	//  Department Form Checks //
});

	// save and/or edit return values to update table
	function UpdateCode(ret) {  
		var ret = ret.split(':');
		//console.log (ret)
		var deptMode = ret[0]; 	
		var guid = ret[1]; var name = ret[2];
		var extn = ret[3]; var desc = ret[4];
	
	if (ret[0] == 'editDept') {
		$('#departments').dataTable().fnUpdate([name] ,$('tr#' + guid)[0], 0, false );
		$('#departments').dataTable().fnUpdate([extn] ,$('tr#' + guid)[0], 1, false );
		$('#departments').dataTable().fnUpdate([desc] ,$('tr#' + guid)[0], 2, false );
	} else if (ret[0] == 'addDept') {
		var addRow = $('#departments').dataTable().fnAddData( [name, extn, desc ]);
		var newRow = $('#departments').dataTable().fnSettings().aoData[addRow[0]].nTr;
		$('#departments tr').removeClass("selected");
		newRow.setAttribute('id',guid);
		newRow.setAttribute('class','new selected');
		}
	}
