<?php
session_start();

$contacts = (isset($_REQUEST['contacts']) && $_REQUEST['contacts'] === 'go') ? $_REQUEST['contacts'] : NULL;
$companySelect = (isset($_REQUEST['companySelect']) && strlen($_REQUEST['companySelect']) >= 1) ? $_REQUEST['companySelect'] : NULL;
$import = (isset($_REQUEST['import']) && strlen($_REQUEST['import']) >= 1) ? $_REQUEST['import'] : NULL;
$export = (isset($_REQUEST['export']) && strlen($_REQUEST['export']) >= 1) ? $_REQUEST['export'] : NULL;
$delete = (isset($_REQUEST['delete']) && strlen($_REQUEST['delete']) >= 1) ? $_REQUEST['delete'] : NULL;

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Contacts</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/buttons.css" rel="stylesheet" type="text/css">
<link href="contacts.css" media="screen" rel="stylesheet" type="text/css" />
<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="contacts.js" type="text/javascript"></script>

</head>

<body>
<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'></img></a>
</div>

<div id="wrap">

<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
	if ($adminCompany != '00000000-0000-0000-0000-000000000000') {  header("Location: ../"); exit(); }
?>	
</div>
<!-- header ends -->

<div id="main">
<div class="wrapper">
<!-- content begins -->
<h3><span class="icon-file-text greyicon"></span> Import / Export Contacts</h3>
<div class='colFull'>

	<br>Importing will create new contacts.<br>
	Any potential duplicate will have its name changed by adding a count value to the name.<br><br>
	
	
<table border="1" cellpadding="4">
<tr>
	<td><div id='contacts'><label for='file'><b>Upload New Contacts</b></label></td>
	<td>
	<p id="f1_upload_process"></p>
	<form action="files.php" method="post" enctype="multipart/form-data" target="upload_target" onsubmit="startUpload();" >
		<p id="f1_upload_form" align="center"><br>
			<input name="myfile" id="myfile" type="file" size="30" />
			<input type='hidden' name='mode' value='uploadFile' />
			<input type='hidden' id='company' name='company' value='<?php echo $adminCompany ?>' />
            <input type="submit" name="submitBtn" class="save" value="Upload" />
		</p>
		<iframe id="upload_target" name="upload_target" src="#" style="width:0;height:0;border:0px solid #fff;"></iframe>
	</form>
	</div></td>
</tr>
<tr><td colspan='2' style='height:10px'></tr>


<form id='actions' action="index.php" method="post" >


<?php if (isset($adminCompany)	&& $adminCompany === '00000000-0000-0000-0000-000000000000') {
	echo "<tr><td colspan='2' style='height:10px'>";
	echo "<div class='adminCompany'>";
	echo "<div class='list'>
		<label for='companySelect'>Company: </label>
		<select id='companySelect' name='companySelect' method='post'><option value='00000000-0000-0000-0000-000000000000'></option>";
		
		$sr=ldap_list($ds,"cn=companies","(objectclass=company)");
		$info = ldap_get_entries($ds, $sr);
		for ($m=0; $m<$info['count']; $m++) {
			$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
			if ($cn === 'MyCompany') continue;
			echo "<option value='$guid'>$cn</option>";	
		}

		echo "</select>";
		echo "</div></div>";
		echo "<tr><td colspan='2' style='height:10px'></tr>";
	} 
	
?>



<tr>
	<td><input type="submit" name="import" id="import" value="Import" disabled="disabled"></td>
	<td>Import Contacts from, comma separated variable txt file.</td>
</tr>
<tr>
	<td><input type="submit" name="export" id="export" value="Export"></td>
	<td> Export all Contacts to a file, previous file contents will be lost.</td>
</tr>
<tr>
	<td><input type="submit" name="delete" id="del" value="Export & Delete"></td>
    <td>As export but all Contacts will be deleted from system.</td>
</tr>

<tr>
	<td colspan='2' style='height:10px; text-align:center;'><span id='contactsMsg' style='display:none'><img src='../assets/images/save_banner.gif' /></span></td>
</tr>
<input type='hidden' name='contacts' value='go'>

</form>	


<?php
if (isset($contacts)){

echo "<tr><td colspan='2'><div id='contactsOutput' style='background-color:#f8f8f8; border:solid 1px #000000; height:100px; width:540px; overflow-y:scroll;'>";

$timestamp = time();
if ($import === 'Import') {
	$mode = 'importContacts';
	audit ($timestamp, "[Contacts] [Add] Contacts","Imported contacts from contacts.txt");
} else if ($export === 'Export') {
	$mode = 'exportContacts';
	audit ($timestamp, "[Contacts] [Export] Contacts", "Exported Contacts to contacts.out.csv");
} else if ($delete === 'Export & Delete') {
	$mode = 'deleteContacts';
	audit ($timestamp, "[Contacts] [Export] Contacts", "Exported Contacts to contacts.out.csv");
	audit ($timestamp, "[Contacts] [Delete] Contacts", "Deleted Contacts");
}
	


$cmd = "/SpliceCom/WebManager/admin/importcontacts/contacts.php $mode $companySelect";
echo "$mode<br>";

$a = popen("/usr/bin/php $cmd", 'r');

while($b = fgets($a, 512)) {
	ob_flush();flush();
    echo "$b<br>";
    echo "<script>var objDiv = document.getElementById(\"contactsOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";
    ob_flush();flush();
}
echo "<br><br>";
pclose($a);


echo "</div></td></tr>";
	
}
?>






<?php 
	
	$downloadFile = "contacts.out.txt";
	if ($adminCompany != '00000000-0000-0000-0000-000000000000') {
		$sr = ldap_list($ds,"cn=companies","(&(objectclass=company)(guid=$adminCompany))",array('cn')); 
		$info = ldap_get_entries($ds,$sr); $companyName = $info[0]['cn'][0];
		$downloadFile = "contacts.out.$companyName.txt";
	}
	
	$showDownload = (file_exists("/SpliceCom/ftp/$downloadFile")) ? '' : 'display: none';
	echo "<tr id='contactDownload' style='line-height: 32px; $showDownload'>";
?>
	
<td><div id='contacts'><label for='file'><b>Download Contacts</b></label></td>
<td><a id='download' href='../assets/inc/download.php?download_file=<?php echo $downloadFile ?>'><span class='icon-download2'></span>Download</a></div></td>
</tr><tr><td colspan='2' style='height:10px'></tr>
	



</table>

<!--content ends -->
</div>
</div>	


<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>
</div>

</div>
</body>
</html>

<?php if (!isset($_SESSION['loaded'])) {?>
<script type="text/javascript">
	$(function() {
		var n = noty({
        type: 'error', layout: 'center', text: 'Importing Contacts can have an impact on system performance.<br>We recommend this is only done out of hours.', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				    $noty.close(); 
					$.ajax({ url : 'files.php?loaded=1' });
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					window.location.href = "../";
					return false;
					}
                }
            ]
        });
	});
</script>
<?php } 