<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Licence Status</title>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="../assets/css/styles.css" rel="stylesheet" type="text/css" media="screen" />
<link href="../assets/css/menu.css" media="screen" rel="stylesheet" type="text/css" />
<link href="../assets/css/bPopup.css" media="screen" rel="stylesheet" type="text/css" />
<link href="licences.css" rel="stylesheet" type="text/css" media="screen" />
<script src="../assets/js/jquery-min.js" type="text/javascript"></script>
<script src="../assets/js/bPopup.js" type="text/javascript"></script>
<script src="licences.js" type="text/javascript"></script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>

<div id="content">

<div class="logo">
<a href="#"><img src='../assets/images/logo.png'></img></a>
</div>

<div id="wrap">


<!-- header begins -->
<div class="menu-wrap">
<?php
	require('../assets/inc/header.php');
	if ($adminCompany != '00000000-0000-0000-0000-000000000000') {  header("Location: ../"); exit(); }
?>	
</div>
<!-- header ends -->



<div id="main">
<div class="wrapper">
<!-- content begins -->
<h3><span class="icon-key2 greyicon"></span> Licence Status</h3><br/>

<?php

// find master details as licence count stored there
$sr=ldap_search($ds,"cn=Modules","(&(objectclass=AdministrationModule)(administrationmode=1))");
$info=ldap_get_entries($ds,$sr);
$sa = explode(",",$info[0]['dn']);
$s = substr($sa[1],3);
$publicipaddress=$info[0]['publicipaddress'][0];
$dn="cn=$s,cn=Modules";
$sr=ldap_read($ds,$dn,"objectclass=*");
$info=ldap_get_entries($ds,$sr);
$ipaddress = $info[0]['ipaddress'][0];
$guid=$info[0]['guid'][0];
// find self
$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
$info = ldap_get_entries($ds,$sr);
$self = $info[0]['location'][0];
if ($guid == $self) {
   $dsm=$ds;
} else {
   if(!$publicipaddress) $ip=$ipaddress;
   else {
      $sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(guid=$self))");
      $info = ldap_get_entries($ds,$sr);
      $dn=$info[0]['dn'];
      $sr=ldap_search($ds,$dn,"(&(objectclass=IntraModuleTrunk)(ipaddress=$ipaddress))");
      $info = ldap_get_entries($ds,$sr);
      if ($info[0]['count']) $ip=$ipaddress;
      else $ip= $publicipaddress;
   }
   $dsm = @ldap_connect($ip,4000) or exit("<p>EXIT: Primary Call Server LDAP connect failure</p>");
   @ldap_bind($dsm,"INTERNAL","001122334455") or exit("<p>EXIT: Primary Call Server LDAP bind failure</p>");
}

$dummy = "A Dummy Licence - Please Ignore";
$dummyatt=array('objectclass'=>'License','qty'=>'0','License'=>$dummy);
ldap_add($ds,"key=$dummy, cn=System",$dummyatt); ldap_delete($ds,"key=$dummy, cn=System");

$sr=@ldap_list($dsm,"cn=System","objectclass=licenserecord");
$info=ldap_get_entries($dsm,$sr);

$licences = array();
for($n=0; $n<$info['count'];$n++) {
	$newdata = array (
		'qty' =>  $info[$n]['qty'][0],
		'used' =>  $info[$n]['used'][0],
	);
	
$licence = str_replace ('_', '', $info[$n]['license'][0]);
$licences[$licence] = $newdata;
}

$arraySort = [
'AnalogueUser',
'CompressionChannel',
'ConferenceControl',
'ESPSession',
'iPCS',
'IPVirtualUser',
'ManagedUser',
'MessageBox',
'OperatorConsole',
'POTS',
'SIPPhone',
'TeamsTrunk',
'IPUser',
'Trunk',
'VoicemailPort',
'5108Plus',
'NavigateOutlook',
'NavigateSFB',
'NavigateSoftphone',
'VisionAgent',
'VisionLive',
'VisionMedia',
'TotalControl',
'VisionMobility',
'VisionRecording',
'VisionReport',
'VisionSupervisor'
];

$sortedarray = [];
$sortedarray = array_merge(array_flip($arraySort), $licences);

$modules=$vision=$navigate=0;

print "<div class='tables'>";

print "<table border=1 id='tbl'><tr><th width='200px'>Licence Type</th><th width='100px'>Available</th><th width='100px'>Used *</th></tr>";
echo "<tr class='licencerow'><td colspan='3'>System Licences</td></tr>";
foreach($sortedarray as $n => $k) {
	
    $title=$n;
	
	if (strpos($title, 'Navigate') !== false && $navigate == 0) {
		echo "<tr class='licencerow'><td  colspan='3'>Navigate</td></tr>";
		$navigate = 1;
	}
	
	if (strpos($title, 'Vision') !== false && $vision == 0) {
		echo "<tr class='licencerow'><td  colspan='3'>Vision</td></tr>";
		$vision = 1;
	}
	
	if ((strpos($title, 'S7') !== false || strpos($title, 'S8') !== false || strpos($title, 'SV') !== false) && $modules == 0) {
		echo "<tr class='licencerow'><td  colspan='3'>Module Licences</td></tr>";
		$modules = 1;
	}
	
	if ( $title == "ManagedUser" || $title == "POTS" ) continue;
	if ($title=="TotalControl") continue;
	
	if (strtolower($title) == "ipuser") { 
		print "<tr class='licencetr'><td><img onClick=\"centeredPopup('licences_ipuser.php','IPUsers','550','700','yes');return false\" src='../assets/images/expand.gif' alt='User Licences' title='User Licences' border='0' />&nbsp;Total IP Users</td><td>".$sortedarray[$n]['qty']."</td><td>".$sortedarray[$n]['used']."</td></tr>";
	} else if (strtolower($title) == "voicemailport") { 
		print "<tr class='licencetr'><td><img onClick=\"centeredPopup('licences_vmport.php','VoicemailPort','550','700','yes');return false\" src='../assets/images/expand.gif' alt='VoicemailPort Licences' title='VoicemailPort Licences' border='0' />&nbsp;$title</td><td>".$sortedarray[$n]['qty']."</td><td>".$sortedarray[$n]['used']."</td></tr>";
	} else if (strtolower($title) == "sipphone") { 
		print "<tr class='licencetr'><td><img onClick=\"centeredPopup('licences_sipphone.php','SIPPhones','550','500','yes');return false\" src='../assets/images/expand.gif' alt='SIPPhone Licences' title='SIPPhone Licences' border='0' />&nbsp;$title</td><td>".$sortedarray[$n]['qty']."</td><td>".$sortedarray[$n]['used']."</td></tr>";
	}
	else {
		print "<tr class='licencetr'><td>$title</td><td>".$sortedarray[$n]['qty']."</td><td>";
		echo ($title == "ManagedUser" || $title == "VisionMobility" || $title == "VisionReport" ) ? "" : $sortedarray[$n]['used'];
		echo "</td></tr>";
		
	}
}

print "</table><p>* The Primary counts the licences used.<br/><br/>";
print "<b>Please note</b> that when calculating the number of IPUser licences that are in use you need to include all active POTS ports that are available on the following modules<br/><br/>
P308 Phone Modules<br/><br/>
Although these do not have an IPUser licence assigned to them they are included in the count and therefore will be added to the number of actual IPUser licences you have allocated to users with IP Phones.<br/><br/>
If you have Managed IPUser licences within your system these will add to the total number of IPUser Licences available but are not included in the count of licences in use.<br/>";
print "<br/>Note: This script added a dummy licence to trigger a recount.<br/>Your warnings will show : <b>$dummy</b> REJECTED</p><br/>";

// build array of nodes
$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0))");
$info=ldap_get_entries($ds,$sr);
//		print "Module count = ".$info['count']."<br/>";
$modules = array();
for($n=0; $n<$info['count'];$n++) {
    $n2 = @count($modules['cn']);
    if ($info[$n]['moduletype'][0]==1) $modules['type'][$n2]="PM 4100";
    if ($info[$n]['moduletype'][0]==1 and substr($info[$n]['serialnumber'][0],0,8)!="00-07-d9") $modules['type'][$n2]="XS";
    if ($info[$n]['moduletype'][0]==2) continue; //$modules['type'][$n2]="4200";
    if ($info[$n]['moduletype'][0]==3) $modules['type'][$n2]="PM 4315";
    if ($info[$n]['moduletype'][0]==4) $modules['type'][$n2]="PM 4330";
    if ($info[$n]['moduletype'][0]==7) continue; //$modules['type'][$n2]="VoIP";
    if ($info[$n]['moduletype'][0]==8) continue; //$modules['type'][$n2]="4400";
    if ($info[$n]['moduletype'][0]==10) $modules['type'][$n2]="CS 4140";
    if ($info[$n]['moduletype'][0]==11) $modules['type'][$n2]="CS 5100";
    if ($info[$n]['moduletype'][0]==12) $modules['type'][$n2]="CS 5108";
    if ($info[$n]['moduletype'][0]==13) $modules['type'][$n2]="PM 5330";
    if ($info[$n]['moduletype'][0]==14) $modules['type'][$n2]="PM 5315";
    if ($info[$n]['moduletype'][0]==17) $modules['type'][$n2]="SoftPBX";
    if ($info[$n]['moduletype'][0]==18) $modules['type'][$n2]="SoftPBX";
    if ($info[$n]['moduletype'][0]==19) $modules['type'][$n2]="NSG";
    if ($info[$n]['moduletype'][0]==20) continue; //$modules['type'][$n2]="Vision";
	if ($info[$n]['moduletype'][0]==22) $modules['type'][$n2]="PM P308";
    if (!isset($modules['type'][$n2])) $modules['type'][$n2] = $info[$n]['moduletype'][0];

    $modules['cn'][$n2] = $info[$n]['cn'][0];
    $modules['guid'][$n2] = $info[$n]['guid'][0];
    $modules['version'][$n2] = $info[$n]['productversion'][0];
	$modules['ipaddress'][$n2] = $info[$n]['ipaddress'][0];
    $days=floor((time()-$info[$n]['lastseen'][0])/(24*60*60))." days ago @ ";
    $days .=date(" H:i:s l, jS F Y",$info[$n]['lastseen'][0]);
    $modules['lastseen'][$n2] = $days;
}

print "<p>Modules affecting licence count in system:</p><table border=1 id='tbl2'><tr><th>#</th><th>IP Address</th><th>Name</th><th>Type</th><th>Version</th><th>Last Seen</th></tr>";
foreach ($modules['ipaddress'] as $key => $value) {
    print "<tr class='licencetr'><td>".($key+1)."</td><td>".$modules['ipaddress'][$key]."</td><td>".$modules['cn'][$key]."</td><td>".$modules['type'][$key]."</td><td>".$modules['version'][$key];
    print "</td><td>".$modules['lastseen'][$key]."</td></tr>";
}

print "</table>";

print "<br/><p>".date(" H:i:s l, jS F Y")."</p>";

print "</div>";
?>

<div id="element_to_pop_up">
</div>

<!--content ends -->
</div>
</div>	


<!--footer begins -->
<?php
	require('../assets/inc/footer.php');
?>
<!-- footer ends-->
</div>

</div>
</body>
</html>
