$(document).ready(function() {
	
	var emptyRow = "<tr id='empty'><td colspan='4' align='center'>Contacts results are shown as you search</td></tr>";
	$('#header').last().after(emptyRow);


	// highlight table entries //
	$('#contactResults').on( 'click', 'tr', function () {
		thisName = $(this).prop('id');
		if (thisName == 'empty') return false;
		
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        }
        else {
            $('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedContactGuid = $('#contactResults tr.selected').attr('id');
			selectedContactOrderId = $('#contactResults tr.selected').find('td:first').text();
			selectedContactNumber = $('#contactResults tr.selected').find('td:nth-child(1)').text();
        }
    });
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");
	});
	
	// firstname & lastname
	$('body').on('change', '#cn', function(){
		var str = $(this).val(); str = $.trim(str); 
		str = str.split(' '); var arr = []; 
		arr.push(str.shift()); arr.push(str.join(' '));
		$('#givenname').val(arr[0]);
		$('#sn').val(arr[1]);
	});
	
	
	// search contacts entries //
	$('body').on('keyup', '#text_content', function(){
		$('table#contactResults tr#empty').remove();
		var timestamp = Math.floor(Date.now() / 1000); 


		var search = $(this).val();
		if (search.length <=0) {
			$('#header').last().after(emptyRow);
		}
		
		company = ($("#company option:selected").text().length >0) ? $("#company option:selected").text() : $('#company').val();
		$.ajax({ type: "GET",   
		url: "contactsActions.php?mode=search&search=" + encodeURIComponent(search) + "&company=" + encodeURIComponent(company) + '&timestamp=' + timestamp,   
		async: true,
        success : function(text) {
            response = text;
			$('#output_div').html(response)
			var rowCount = $('#contactResults tr').not('#empty').length - 3; 
			$('#result_count').text(rowCount);
			}
		});	
	});	
	
	
		
	$('body').on('change', '#company', function(){
		$('#output_div').html('');
		if ($('#empty').length  < 1) $('#header').last().after(emptyRow);
		$('#result_count').text('0');
		$('#text_content').val('');
		
	})
	
	
	// add new contact //
	$("#btn_add").click(function() {
		selectedContactOrderId = selectedContactGuid = selectedContactNumber = closeContact = '';
		selectedCompany = ($("#company option:selected").text().length >0) ? encodeURIComponent($("#company option:selected").text()) : encodeURIComponent($('#company').val());
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'contactForm.php?contactMode=addContact&selectedCompany=' + selectedCompany,
			loadCallback: function(){ 	    
				originalFormData = $('#new_contact').serialize();
			}
		}); 
	});
	
	
	// delete selected contact //
	$("#btn_delete").click(function() {
		var timestamp = Math.floor(Date.now() / 1000); 
		if (typeof selectedContactGuid != "undefined" && selectedContactGuid.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Contact Entry: <b>' + selectedContactNumber + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'contactsActions.php?mode=deleteContact&contactGuid=' + encodeURIComponent(selectedContactGuid)  + '&selectedContactNumber=' + encodeURIComponent(selectedContactNumber) + '&timestamp=' + timestamp });
					$('#contactResults tr.selected').remove()
					res_count = parseInt($('#result_count').text());
					--res_count;
					$('#result_count').text(res_count);
					selectedContactOrderId = selectedContactGuid = selectedContactNumber = closeContact = '';
					$noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit selected contact //
	$("#btn_edit").click(function(e) {
		closeContact = $('#contactResults tr.selected').find('td:first').text();
		selectedCompany = ($("#company option:selected").text().length >0) ? encodeURIComponent($("#company option:selected").text()) : encodeURIComponent($('#company').val());
		
		if (typeof selectedContactGuid == "undefined" || selectedContactGuid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });					
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'contactForm.php?contactMode=editContact&contactGuid=' + encodeURIComponent(selectedContactGuid) + '&contactNumberMatch=' + encodeURIComponent(selectedContactNumber) + '&selectedCompany=' + selectedCompany,
			loadCallback: function(){ 	    
				originalFormData = $('#new_contact').serialize();
			}
        });
	});
	
	
	
	// close contact //
	$("body").on('click', '#close', function(){
		var msg = (originalFormData !== $('#new_contact').serialize()) ? '<b>Changes haven\'t been saved.</b><br>' : ''
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close Contact Entry: <b>' + closeContact + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	
	// save updates //
	$("body").on('click', '#save', function(){
	var saveContact = $('#cn').val();
	var saveCompany = $('#o').val();
	var saveTelephonenumber = $('#telephonenumber').val();
	var saveDescription = $('#description').val();
	var selectedCompany = $('#selectedCompany').val();
	var timestamp = Math.floor(Date.now() / 1000); 
	
	if (saveContact.length <1 || saveTelephonenumber.length <1) {
		var n = noty({ type: 'error', layout: 'center', text: 'Contact name and telephone number must be set.<br><br><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
			
	var n = noty({
        type: 'information', layout: 'center', text: 'Save Contact Entry: <b>' + saveContact + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				var contactMode = $('#contactMode').attr('value');
				var formData = $('#new_contact').serializeArray();
				$.ajax({
					type: "POST",  cache: false, data: formData,
					url: "contactsActions.php?mode=saveContact&currentContactGuid=" + encodeURIComponent(selectedContactGuid) + '&contactMode=' + encodeURIComponent(contactMode) + '&selectedCompany=' + encodeURIComponent(selectedCompany) + '&timestamp=' + timestamp, 		
				success: function(data) {
					res = data.split(",");
					var contactMode = res[0];
					guid = (contactMode == 'editContact') ? selectedContactGuid : res[1];
						
					var cn = res[2];  var o = res[3];  var telephonenumber = res[4]; var description = res[5];
					var ret = contactMode + ',' + guid + ',' + cn + ',' + o + ',' + telephonenumber + ',' + description;
					parent.UpdateCode(ret);
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});	

});

	// save and/or edit return values to update table
	function UpdateCode(ret) {

		var ret = ret.split(',');
		var contactMode = ret[0];
		var guid = ret[1]; 
		var cn = ret[2]; 
		var o = ret[3];
		var telephonenumber = ret[4];
		var description = ret[5];
		
        var new_row = '<tr id=' + guid + '><td>' + cn + '</td><td>' + o + '</td><td>' + telephonenumber + '</td><td>' + description + '</td></tr>';
		$('#contactResults tr').removeClass("selected");
	
	if (contactMode == 'editContact') {
		$('#' + guid).replaceWith(new_row);
	
	} else if (contactMode == 'addContact') {
		$('table tbody').append(new_row);
		res_count = parseInt($('#result_count').text());
		++res_count;
		$('#result_count').text(res_count);
		}
		
		selectedContactGuid = guid;
	}
	
	function drReadOnly() {
		$('input[type=checkbox], select').prop('disabled','true');
		$("input:not('#close')").prop('disabled', true);
	}
