$(document).ready(function() {
	
	// load table //
	 oTable = $('#meetmeconferences').dataTable({
		"bJQueryUI": true, "sPaginationType": "full_numbers",
		"aLengthMenu": [[15, 25, 50, 100, 250, 500], [15, 25, 50, 100, 250, 500]]
	});
	
	// highlight table entries //
	$('#meetmeconferences').on( 'click', 'tr', function () {
	if ( $(this).hasClass('odd') || $(this).hasClass('even') || $(this).hasClass('new') ) {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
			selectedGuid = selectedName = '';
        } else {
            oTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
			selectedGuid = $('#meetmeconferences tr.selected').attr('id');
			selectedName = $('#meetmeconferences tr.selected').find('td:first').text();
        }
	}
    });
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");
	});
	
	
	// date picker
	$("body").on('focus', '#date', function(){
		$( this ).datepicker({ dateFormat: "dd/mm/yy", minDate: 0, maxDate: "+1Y -1D"});		
	});
	
	// add new
	$("#btn_add").click(function() {

		var time = new Date();
		var day = time.getDate();
		var month = ("0" + (time.getMonth() +　1)).slice(-2);
		var year = time.getFullYear();
		var hour = time.getHours();
		time.setHours(time.getHours()+1);
		var plushour = time.getHours();
		starttime = hour + ':' + time.getMinutes();
		endtime = plushour + ':' + time.getMinutes();
		
		selectedName = '';
		$('#loadMode').val('add');
		$('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
			loadUrl: 'popupForm.php?loadMode=add',
			loadCallback: function(){ 
				$('#date').val(day + '/' + month + '/' + year);
				$("#starttime").replaceWith("<input type='text' class='timepicker' id='starttime' name='starttime' value=''>");
				$("#starttime").wickedpicker({twentyFour: true, now: starttime });
				$("#endtime").replaceWith("<input type='text' class='timepicker' id='endtime' name='endtime' value=''>");
				$("#endtime").wickedpicker({twentyFour: true, now: endtime });
				originalFormData = $('#popup').serialize();
			}
			
		}); 
	});
		
	// delete selected //
	$("#btn_delete").click(function() {
		var timestamp = Math.floor(Date.now() / 1000); 
		
		if (typeof selectedGuid != "undefined" && selectedGuid.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Meet Me Conference : <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'actions.php?actionMode=delete&selectedGuid=' + encodeURIComponent(selectedGuid) + '&selectedName=' + encodeURIComponent(selectedName) + '&timestamp=' + timestamp });
					oTable.fnDeleteRow( oTable.$('#' + selectedGuid)[0] );
					selectedGuid = selectedName = '';
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit //
	$("#btn_edit").click(function(e) {
		if (typeof selectedGuid == "undefined" || selectedGuid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });							
		selectedName = encodeURIComponent($('#meetmeconferences tr.selected').find('td:first').text());
		$('#loadMode').val('edit');
		$('#guid').val(selectedGuid);
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'popupForm.php?loadMode=edit&selectedName=' + selectedName,
			loadCallback: function(){ 
			starttime = $("#starttime").val();
			endtime = $("#endtime").val();
				$("#starttime").replaceWith("<input type='text' class='timepicker' id='starttime' name='starttime' value=''>");
				$("#starttime").wickedpicker({twentyFour: true, now: starttime});
				$("#endtime").replaceWith("<input type='text' class='timepicker' id='endtime' name='endtime' value=''>");
				$("#endtime").wickedpicker({twentyFour: true, now: endtime});
				originalFormData = $('#popup').serialize();
			}
        });
	});
	
	
	// close //
	$("body").on('click', '#close', function(){
		var msg = (originalFormData !== $('#popup').serialize()) ? '<b>Changes haven\'t been saved.</b><br/>' : ''
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close Meet Me Conference: <b>' + selectedName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
	});
	
	
	// save updates //
	$("body").on('click', '#save', function(){
	var saveMeetMeConfernece = $('#cn').val();
	var loadMode = $('#loadMode').val();
	var timestamp = Math.floor(Date.now() / 1000); 
	
	if (saveMeetMeConfernece < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'Meet Me Confernece Name must be set<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
	
	var stt = new Date("January 01, 2017 " + $('#starttime').val().replace(' : ',':'));
	stt = stt.getTime();
	var endt = new Date("January 01, 2017 " + $('#endtime').val().replace(' : ',':'));
	endt = endt.getTime();
	
	if (stt >= endt) {
		var n = noty({ type: 'error', layout: 'center', text: 'Start Time must be before End Time<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
	
	
		var n = noty({
        type: 'information', layout: 'center', text: 'Save meet Me Confernece: <b>' + saveMeetMeConfernece + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				data = $('#popup').serializeArray()
				data.push({name: 'timestamp', value : timestamp}); 
				
				$.ajax({
					type: "POST", 
					cache: false,
					data: data,
					url: "actions.php?actionMode=save", 	
				success: function(data) {
					console.log(data)
					res = data.split(":");
					var loadMode = res[0];
					guid = (loadMode == 'edit') ? selectedGuid : res[1];
					var name = res[2]; var organiser = res[3]; var date = res[4];
					var ret = loadMode + ':' + guid + ':' + name + ':' + organiser + ':' + date;
					parent.UpdateCode(ret);
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close();
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	});
	
	
	// name check //
	$('body').on('keyup', '#popup input[name=cn]', function(){
		var origName = (selectedName.length >0) ? encodeURIComponent( $('#meetmeconferences tr.selected').find('td:first').text() ) : '';
		var confCN = $(this).val(); 
		
		if(!$.isNumeric(confCN)) {
			$('#msg').html('Conference Number can only contain digits'); 
				$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#cn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			    $("#save").prop("disabled",true);
				return false;
		} 
		
		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?meetmeconference=" + encodeURIComponent(confCN),   
         cache:false,
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(confCN) === origName) return false;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				$("#cn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			    $("#save").prop("disabled",true);

			 } else {
				$('#msg').html(''); 
				$("#msg_wrap").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#cn").css({ 'border': '1pt solid #A0A0A0', 'color': '#222'});
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	// numeric values only
	$('body').on('keyup', '#popup input[name=pin], [name=listenid], [name=listenpin], [name=maxmembers]', function(){
		thisVal = ( $(this).val() )
		if(thisVal.length >= 1 && !$.isNumeric(thisVal)) {
			$(this).addClass('error');
			$('#msg').html('Numeric Value Only'); 
			$('#msg_wrap').addClass('error');
			$("#save").prop("disabled",true);
		} else {
			$('#msg').html(''); 
			$(this).removeClass('error');
			$('#msg_wrap').removeClass('error');
			$("#save").prop("disabled",false);
		}
	});

	
});

	// save and/or edit return values to update table
	function UpdateCode(ret) {  
		var ret = ret.split(':');
		var deptMode = ret[0]; 	
		var guid = ret[1]; var name = ret[2];
		var organiser = ret[3]; 
		var date = ret[4];
		date = date.replace(/(\d\d)(\d\d)(\d\d)/g, '$3/$2/20$1');
	
	if (ret[0] == 'edit') {
		$('#meetmeconferences').dataTable().fnUpdate([name] ,$('tr#' + guid)[0], 0, false );
		$('#meetmeconferences').dataTable().fnUpdate([organiser] ,$('tr#' + guid)[0], 1, false );
		$('#meetmeconferences').dataTable().fnUpdate([date] ,$('tr#' + guid)[0], 2, false );
	} else if (ret[0] == 'add') {
		var addRow = $('#meetmeconferences').dataTable().fnAddData( [name, organiser, date ]);
		var newRow = $('#meetmeconferences').dataTable().fnSettings().aoData[addRow[0]].nTr;
		$('#meetmeconferences tr').removeClass("selected");
		newRow.setAttribute('id',guid);
		newRow.setAttribute('class','new selected');
		}
	}
