<?php
// PJC 29JUN2020 added Teams & Encryption Support
// PJC 29JUN2020 Updated tIPicall to TalkTalk Notice
// PJC 17MAY2019 Added DTMF mode (RFC 2833 / SIP INFO). Updated RTP Range to 8899
// PJC added AllTrunks
// Container updates, LCRPlan Dial Record

$container = (isset($_REQUEST['container']) && strlen($_REQUEST['container']) >=1) ? $_REQUEST['container'] : NULL;
$recordingoff = (isset($_REQUEST['recordingoff']) && $_REQUEST['recordingoff'] === '1') ? '1' : '0';
$sip_dnsip = $sip_dnsip_user = '';

if ($container == "1") {
	$ds = ldap_connect("127.0.0.1",4000);
		if ( ! $ds) {
			echo "LDAP connect failure<br>";
		} else {
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			$r = ldap_bind($ds,"INTERNAL","0123456");
			if ( ! $r) {
				echo "LDAP bind failure<br>";
				$ds = false;
		}
	}
	
} else {
	require('../assets/inc/ldapConnect.php');
}

	foreach($_REQUEST as $key => $value){
		if (is_array($value)) break;
		if (strlen($value) >= '1') {
			$$key = $value;
		}
	}
	
$local = (isset($_REQUEST['local']) && count($_REQUEST['local']) > 1) ? $_REQUEST['local'] : '';
$digits = (isset($_REQUEST['digits']) && count($_REQUEST['digits']) > 1) ? $_REQUEST['digits'] : '';

$typeoftrunk = (isset($module_type) && strlen($module_type) > 0) ? $module_type : '3';
$teams_lcrplan_numbermatch = (isset($teams_lcrplan_numbermatch) && strlen($teams_lcrplan_numbermatch) > 0) ? $teams_lcrplan_numbermatch : '';
$teams_lcrplan_translateto = (isset($teams_lcrplan_translateto) && strlen($teams_lcrplan_translateto) > 0) ? $teams_lcrplan_translateto : '';
$msg = "done";
$q="??????????";

//Module
$att=array('objectclass'=>'Module','cn'=>$sip_name, 'description'=>$sip_desc,'moduleType'=>'7','ipaddress'=>$sip_dnsip,'location'=>$sip_cs,'lastseen'=>time());
ldap_add($ds,"cn=$sip_name,cn=Modules",$att);

//ExternalGatewayModule
$att=array('objectclass'=>'ExternalGatewayModule','cn'=>'1');
ldap_add($ds,"cn=1,cn=$sip_name,cn=Modules",$att);

//Virtual Trunk
$att=array('objectclass'=>'Trunk','cn'=>'Virtual', 'description'=>$sip_desc,'typeoftrunk'=>$typeoftrunk,'port'=>'5060','capacity'=>$sip_caps, 'presentationnumber'=>$sip_pres);
ldap_add($ds,"cn=Virtual,cn=$sip_name,cn=Modules",$att);

//SIP Trunk
$att=array('objectclass'=>'siptrunk','sourceport'=>'0','natport'=>'0');
ldap_add($ds,"cn=1,cn=Virtual,cn=$sip_name,cn=Modules",$att);

//Modify Virtual Trunk
$att=array('port'=>$sip_source,'location'=>$sip_cs);

if ( $typeoftrunk == '3' ) {
	$sr = ldap_read($ds,"cn=Standard,cn=DDICallPlans","(objectclass=ddicallplan)", array('guid')); $info = ldap_get_entries($ds,$sr); 
	$sip_ddiplan = $info[0]['guid'][0];
	$att['ddicallplan'] = $sip_ddiplan;
} else {
	$sr = ldap_read($ds,"cn=$teams_dialplan,cn=dialplans","(objectclass=dialplan)", array('guid')); $info = ldap_get_entries($ds,$sr); 
	$teamsdialplan = $info[0]['guid'][0];
	$att['dialplan'] = $teamsdialplan;
}
ldap_modify($ds,"cn=Virtual,cn=$sip_name,cn=Modules",$att);

//Modify SIP Trunk
if ($sip_nat_server == 'None') {
	$sip_nat_server = '';
} else if ($sip_nat_server == 'other') {
	$sip_nat_server = (isset($sipnatserver) && strlen($sipnatserver) > 1) ? $sipnatserver : '';
} else {
	$sip_nat_server;
}

$att = array('sourceport'=>$sip_rec_port,
			 'compressiontype'=>$sip_comp,
			 'dtmfmode'=>$sip_dtmf,
			 'natserver'=>$sip_nat_server,
			 'natport'=>$sip_nat_port,
			 'natmode'=>$sip_nat_mode,
			 'sourceport'=>$sip_rec_port,
			 'ptime'=>$sip_ptime,
			 'useencryption'=>$sip_encryption);
			 
if ($sip_type == '1') {
	$att['sipregaddress'] = $sip_dnsip_user;
	$att['sipregusername'] = $sip_username;
	$att['sipregpassword'] = $sip_password;
} 

$btsip = NULL;
$sr = ldap_list($ds,"cn=Virtual, cn=$sip_name, cn=Modules","(objectclass=*)", array('dnssrv')); 
$info = ldap_get_entries($ds,$sr); 
$btsip = ($info[0]['count'] > 0) ? '1' : NULL;

if (isset($dnssrv) && $dnssrv == '1' && isset($btsip)) {
	$att['dnssrv'] = $dnssrv;
	$att['sipregcontact'] = $sip_regcontact;
	$att['sipregdomain'] = $sip_regdomain;
}

ldap_modify($ds,"cn=1,cn=Virtual,cn=".$sip_name.",cn=Modules",$att);


//Trunk Group
$att=array('objectclass'=>'TrunkGroup','description'=>$sip_name . " TrunkGroup");
ldap_add($ds,"cn=".$sip_trunkgrp.",cn=TrunkGroups",$att);

//Find Trunk
$sr = ldap_list($ds,"cn=$sip_name, cn=Modules","objectclass=trunk"); $info = ldap_get_entries($ds,$sr);
$trunk_guid = $info[0]['guid'][0];

//Add Trunk to Trunk Group
$att=array('objectclass'=>'TrunkRef');
ldap_add($ds,"trunk=$trunk_guid,cn=$sip_trunkgrp,cn=TrunkGroups",$att);

//Add Trunk to AllTrunks Group
$att=array('objectclass'=>'TrunkRef');
ldap_add($ds,"trunk=$trunk_guid,cn=AllTrunks,cn=TrunkGroups",$att);

//Find Trunk Group Guid
$sr = ldap_list($ds,"cn=TrunkGroups","cn=$sip_trunkgrp"); $info = ldap_get_entries($ds,$sr);
$trunk_grp_guid = $info[0]['guid'][0];

//LCR Plan
$att=array('objectclass'=>'leastcostcallplan','description'=>$sip_name . " LCRPlan");
ldap_add($ds,"cn=$sip_lcrplan,cn=LeastCostCallPlans",$att);

//Find LCRPlan GUID
$sr = ldap_read($ds,"cn=$sip_lcrplan,cn=leastcostcallplans","objectclass=*"); $info = ldap_get_entries($ds,$sr); 
$lcr_guid = $info[0]['guid'][0];

//Standard TimePlan
$sr = ldap_read($ds,"cn=Standard, cn=timeplans","objectclass=timeplan"); $info = ldap_get_entries($ds,$sr);
$std_timeplan = $info[0]['guid'][0];


//Add Default 0?????????? entry Dial Record
if ( $typeoftrunk == '3' ) {
	$recordingactionprimary = ($recordingoff === '0') ? '61' : '1';
	if ( isset($sip_lcr_default) && strlen($sip_lcr_default) >=1 ) {
		$att=array('objectclass'=>'LCREntry','dialprimary'=>'%n','actionprimary'=>$recordingactionprimary, 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
		ldap_add($ds,"numbermatch=0?????????,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
	}
}  else {
	error_log ("*** $teams_lcrplan_numbermatch ***");
	if (isset($teams_lcrplan_numbermatch) && strlen($teams_lcrplan_numbermatch) >= 1 && isset($teams_lcrplan_translateto) && strlen($teams_lcrplan_translateto) >= 1) {
		$att=array('objectclass'=>'LCREntry','dialprimary'=>$teams_lcrplan_translateto,'actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
		ldap_add($ds,"numbermatch=$teams_lcrplan_numbermatch,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
	} else {
		$att=array('objectclass'=>'LCREntry','dialprimary'=>'%n','actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
		ldap_add($ds,"numbermatch=,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
	}
}

// Add New LCRPlan Entries
if ( (isset($sip_local) && $sip_local >=1) && (isset($sip_lcrstd) && strlen($sip_lcrstd) >=1) ) {
foreach ($digits as $k => $v) {
	$num_match = $local[$k].substr($q, 0, $v-1);
	$att=array('objectclass'=>'LCREntry','dialprimary'=>$sip_lcrstd.'%n','actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
	ldap_add($ds,"numbermatch=$num_match,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
	}
}


// Add Emergency LCRPlan Entries
if ( $typeoftrunk == '3' ) {
	if (!isset($sip_noemerg_lcrplan) || $sip_noemerg_lcrplan == "NULL" ) {
		$emerg_no = array("999", "911", "112", "101");
		foreach ($emerg_no as $emergency) {
			$att=array('objectclass'=>'LCREntry','dialprimary'=>$emergency,'actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
			ldap_add($ds,"numbermatch=$emergency,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
		}
	}


	// Add New Emergency LCRPlan Entry
	if (isset($sip_emerg_lcrplan) && strlen($sip_emerg_lcrplan) >= 1) {
		$att=array('objectclass'=>'LCREntry','dialprimary'=>$sip_emerg_lcrplan,'actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$trunk_grp_guid,'timeplan'=>$std_timeplan);
		ldap_add($ds,"numbermatch=$sip_emerg_lcrplan,cn=$sip_lcrplan,cn=leastcostcallplans",$att);
	}
}
if ( isset($sip_update_dialplan) && strlen($sip_update_dialplan) >=1 ) {
	error_log('update dialplan enabled');
	
//Find Blank / Emergency DialPlan Entry	
$sip_dialplan = ( isset($sip_dialplan) && strlen($sip_dialplan) >=1 ) ? $sip_dialplan : NULL;

if ( isset($sip_dialplan_blank) && strlen($sip_dialplan_blank) >=1 && isset($sip_dialplan) ) {
	$sr = ldap_search($ds,"cn=$sip_dialplan,cn=DialPlans","(&(objectclass=dpentry)(numbermatch=))"); 
	$info = ldap_get_entries($ds,$sr); $dp_guid=$info[0]['guid'][0];
	if (strlen($dp_guid) > 1) {
		//Update Blank DialPlan Entry
			$att=array('leastcostcallplan'=>$lcr_guid);
			ldap_modify($ds,"guid=$dp_guid,cn=$sip_dialplan,cn=Dialplans",$att);
		} else {
			$dp_error = "No BLANK DialPlan entry to update";
		}
}

//Update additional numbers
if (isset($sip_dialplan_additional) && strlen($sip_dialplan_additional) >= 1) {
	error_log("adding extra entries $sip_dialplan");
	$additional=array('9','141','112','999','1280','9141','9112','12809','1280141','1280112');

$sr = ldap_search($ds,"cn=$sip_dialplan,cn=DialPlans","(objectclass=dpentry)",array('numbermatch')); $info = ldap_get_entries($ds,$sr);
for ($m=0; $m<$info['count']; $m++) {
		if (in_array($info[$m]['numbermatch'][0],$additional)) {
			$adn = $info[$m]['dn']; $att=array('leastcostcallplan'=>$lcr_guid);
				echo "matches found:". $info[$m]['numbermatch'][0]."<br/>";
			ldap_modify($ds,$adn,$att);
			} else {
				echo "No number matches found.<br/>";
			}
		}
}

	//Add New DialPlan ShortCode
if (isset($sip_dialplan_code) && strlen($sip_dialplan_code) >= 1) {
	$att=array('leastcostcallplan'=>$lcr_guid,'timeplan'=>$std_timeplan,'numbermatch'=>$sip_dialplan_code,'action'=>'1','objectclass'=>'DPEntry','translateto'=>'%r');
	ldap_add($ds,"numbermatch=$sip_dialplan_code,cn=$sip_dialplan,cn=Dialplans",$att);
}

}


?>