	$(document).ready(function(){
		$('#wizard').smartWizard({transitionEffect:'slideleft',keyNavigation:false,onShowStep:getStepNum,onLeaveStep:leaveAStepCallback,onFinish:onFinishCallback,enableFinishButton:false});
				
		sipnameCheck();
		
		wanIP = '';
		wanIPURL = 'http://jsonip.com?callback=?';
		$.ajax({
			dataType: "json",
			timeout: 2000,
			url: wanIPURL,
			success : function(data) {
				wanIP = data.ip;
			}
		});
		
		// hide Teams entries by default
		$('.teamstrunk').hide()
		var dialplanwarning = 0
				
		$('#module_type').on('change', function() {
			module_type  = $(this).val()
			
			if ( module_type == 4 ){
				$('#step1desc, #step2desc, #step3desc, #step5desc, #step5small, #step1title, #step2title, #step3title, #step5title').text('Teams')
				
				$('#sip_name').val('Teams Trunk');
				$('#sip_desc').val('Teams Internal Trunk');
				$('#sip_dnsip').val('').attr('placeholder','sbc.splicecom.com');
				$('.siptrunk').hide();
				$('.teamstrunk').show();
				
				if ( $('#sip_encryption').val() == 1 ) {
					$('#sip_source').val('5062')
				} else {
					$('#sip_source').val('5060')
				}
				
				
			} else {
				$('#step1desc, #step2desc, #step3desc, #step5desc, #step5small, #step1title, #step2title, #step3title, #step5title').text('SIP')
				$('#sip_name').val('TalkTalkSIP');
				$('#sip_desc').val('TalkTalk SIP Trunk');
				$('#sip_dnsip').val('91.146.112.10').attr('placeholder','');
				$('.siptrunk').show();
				$('.teamstrunk').hide();
				
				if ( $('#sip_encryption').val() == 1 ) {
					$('#sip_source').val('5061')
				} else {
					$('#sip_source').val('5060')
				}
			}
			
			sipnameCheck()
			trimname = $('#sip_name').val().replace(' ','')
			$('#sip_trunkgrp').val(trimname + 'TrkGrp')
			$('#sip_lcrplan').val(trimname + 'LCRPlan')
		})
		
		$('#sip_encryption').on('change', function() {
			encryption_type = $(this).val()
			if ( encryption_type == 1 ) {
				$('#sip_source').val('5062');
				$('#sip_nat_port').val('5061');
				$('#sip_rec_port').val('5061');
				
				if ( $('#module_type').val() == 4 ) {
					$('#sip_source').val('5062')
				} else {
					$('#sip_source').val('5061')
				}
				
			} else {
				$('#sip_source, #sip_nat_port,#sip_rec_port').val('5060');
			}
		})
			
			
		
		
		function alert(type, layout, text) {
			var n = noty({
				type: type, layout: layout, text: text + '<br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true,
			});
		}	
		
		function getStepNum() {
			stepNum = $('#wizard').smartWizard('currentStep');
			//console.log (stepNum)
			
			if (stepNum > 1) {
				$('.buttonSkip').remove();	
			} else {
				showSkip();
			}
		
			if (stepNum == '4') {
				sipRegDNSIP = $('#sip_dnsip').val();
				summaryTrunk = $('#sip_name').val();
				summaryTrunkDesc = $('#sip_desc').val();
				summaryAuthentication = $('#sip_type').val();
				summaryRegDNSIP = ($('#sip_dnsip').val().length >1) ? $('#sip_dnsip').val() : 'Not Set';
				summaryCapacity = $('#sip_caps').val();
				summaryPresentation = $('#sip_pres').val();
				summaryCompression = $('#sip_comp').val();
				summaryDTMF = $('#sip_dtmf').val();
				summaryNATServer = $('#sip_nat_server').val();
				summaryNATMode = $('#sip_nat_mode').val();
				summaryNATPort = $('#sip_nat_port').val();
				summaryTrunkGroup = $('#sip_trunkgrp').val();
				//summaryDDIPlan = $('#sip_ddiplan option:selected').text();
				summaryLCRPlan = $('#sip_lcrplan').val();
				summaryEncryption = ( $('#sip_encryption').val() == 0) ? 'Disabled' : 'Enabled'
								
				if ($('#dnssrv').length && $('#sip_regcontact').length && $('#sip_regdomain').length) {
					summaryDNSSRV = $('#dnssrv').is(':checked') ? 'Enabled' : 'Disabled';
					summaryRegContact = ($('#sip_regcontact').val().length >0) ? $('#sip_regcontact').val() : 'Not Set';
					summaryRegDomain = ($('#sip_regdomain').val().length >0) ? $('#sip_regdomain').val() : 'Not Set';
				}
				
				summaryDTMF = (summaryDTMF == 0) ? 'RFC 2833' : 'SIP INFO';
				
				switch (summaryAuthentication) {
					case '0':
						summaryAuthentication = "None";
						break;
					case '1':
						summaryAuthentication = "Username & Password";
						break;
					case '2':
						summaryAuthentication = "IP Authentication";
					break;
				}
					
				switch (summaryCompression) {
					case '0':
						summaryCompression = "None";
						break;
					case '11':
						summaryCompression = "G729a 8k";
						break;
					case '12':
						summaryCompression = "G711 (Relay)";
					break;
				}
				
				switch (summaryNATMode) {
					case '0':
						summaryNATMode = "None";
						break;
					case '1':
						summaryNATMode = "Static";
						break;
					case '2':
						summaryNATMode = "STUN";
					break;
				}
				
				$('#summaryDNSIP').html(sipRegDNSIP);
				$('#summaryTrunk').html(summaryTrunk);
				$('#summaryTrunkDesc').html(summaryTrunkDesc);
				$('#summaryAuthentication').html(summaryAuthentication);
				$('#summaryRegDNSIP').html(summaryRegDNSIP);
				$('#summaryCapacity').html(summaryCapacity);
				$('#summaryPresentation').html(summaryPresentation);
				$('#summaryCompression').html(summaryCompression);
				$('#summaryDTMF').html(summaryDTMF);
				$('#summaryNATServer').html(summaryNATServer);
				$('#summaryNATMode').html(summaryNATMode);
				$('#summaryNATPort').html(summaryNATPort);
				$('#summaryTrunkGroup').html(summaryTrunkGroup);
				//$('#summaryDDIPlan').html(summaryDDIPlan);
				$('#summaryLCRPlan').html(summaryLCRPlan);
				$('#summaryEncryption').html(summaryEncryption);
				
				if ($('#dnssrv').length && $('#sip_regcontact').length && $('#sip_regdomain').length) {
					$('#summaryDNSSRV').html(summaryDNSSRV);
					$('#summaryRegContact').html(summaryRegContact);
					$('#summaryRegDomain').html(summaryRegDomain);
				}
				
			}
			
			if ( stepNum == '5') {
				summaryTeamsDDIPlan = $('#teams_dialplan option:selected').text();
				summaryTeamsLCRNumberMatch = $('#teams_lcrplan_numbermatch').val();
				summaryTeamsLCRTranslateTo = $('#teams_lcrplan_translateto').val();
				$('#summaryTeamsDDIPlan').html(summaryTeamsDDIPlan);
				
				if (summaryTeamsLCRNumberMatch.length >=1 && summaryTeamsLCRTranslateTo.length >=1) {
					$('#summaryTeamsLCRNumberMatch').html(summaryTeamsLCRNumberMatch);
					$('#summaryTeamsLCRTranslateTo').html(summaryTeamsLCRTranslateTo);
					$('.teamslcrplan').show();
				} else {
					$('.teamslcrplan').hide();
				}
				
				
				
			}
		}
		
		// user authentication
		$('#sip_type').change(function(){
				$('#sip_dnsip_user').val('').prop('readonly', true);
				$('#sip_username').val('').prop('readonly', true);
				$('#sip_password').val('').prop('readonly', true);
			if  ($(this).val() == '0') {	
				alert('warning', 'center', '<b>Authentication Type</b><br/><br/>No Authentication type has been set<br/>');
			} else if ($(this).val() == '1') {	
				$('#sip_dnsip_user').prop('readonly', false);
				$('#sip_username').prop('readonly', false);
				$('#sip_password').prop('readonly', false);
			}
		});
		
		$('#dnssrv').change(function() {
			if ( $('#dnssrv').is(':checked') ) {
				$('#sip_regcontact, #sip_regdomain').prop('disabled', '');
			} else {
				$('#sip_regcontact, #sip_regdomain').prop('disabled', 'disabled');
			}
		})
	
		//Gamma ptime
		$('#sip_dnsip').blur(function() {
			$('#wizard').smartWizard('hideMessage');
			sip_dnsip = $('#sip_dnsip').val();
			if (/gamma|88.215/i.test(sip_dnsip)) {
				$('#sip_ptime').val('20');
			}
			if ($('#sip_dnsip').val() == "91.146.112.10" || $('#sip_dnsip').val() == "91.146.114.10") {
			alert('warning', 'center', '<b>SIP Presentaion Number</b><br/><br/>TalkTalk require a presentation number to be set<br/>');
			}
		});
		
		
		$('#sip_nat_mode').change(function(){
			$('#natDiv').css("height","38px");
		if ($(this).val()=="0") {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" value="None">');
			$('#sip_nat_port').val('0'); $('#sipnatserver').hide().val('');
			$('#sip_nat_server').attr('disabled', 'disabled');  
			$('#sip_nat_port').attr('disabled', 'disabled');
		}
		if ($(this).val()=="1") {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" value="' + wanIP + '">');
			$('#sip_nat_port').val('5060'); 
			$('#sipnatserver').hide().val('');
			$('#sip_nat_server').removeAttr('disabled'); 
			$('#sip_nat_port').removeAttr('disabled');
		}
		if ($(this).val()=="2") {
			$('#sip_nat_server').replaceWith('<select name="sip_nat_server" id="sip_nat_server"><option value="stunserver.org">stunserver.org</option><option value="stun.l.google.com">stun.l.google.com</option><option value="stun.sipgate.net">stun.sipgate.net</option><option value="stun.stunprotocol.org">stun.stunprotocol.org</option><option value="other">Other...</option></select>');
			$('#sip_nat_port').val('3478');
			$('#sip_nat_server').removeAttr('disabled'); 
			$('#sip_nat_port').removeAttr('disabled');
		}
		});
	
		$('form').on('change', 'select[name="sip_nat_server"]', function (event) {
			$('#natDiv').css("height","38px");
		if ($(this).val()=="stun.l.google.com") {
			$('#sip_nat_port').val('19203'); 
			$('#sipnatserver').hide().val('');
		}
		else if ($(this).val()=="stun.sipgate.net") {
			$('#sip_nat_port').val('10000'); 
			$('#sipnatserver').hide().val('');
		}
		else if ($(this).val()=="other") {
			$('#natDiv').css("height","67px");
			$('#sipnatserver').show(); 
			$('#sip_nat_port').val('3478');
		}
		else {
			$('#sip_nat_port').val('3478');  
			$('#sipnatserver').hide().val('');
			}
		});
	
		//NAT Server Address
		$('input[id="sip_nat_server"]').blur(function () {
			var sip_nat = $(this).val();
			var sip_nat_octets = sip_nat.split('.');
			var sip_first_octet = sip_nat_octets[0];
			if (sip_first_octet == '10' || sip_first_octet == '172' || sip_first_octet == '192') {
				alert('error', 'center', '<b>SIP NAT Server</b><br/>The IP Address entered appears to be a Local Network IP Address.<br/>Please confirn this is correct.<br/>');
			}
		});
		
		//SIP Compression
		$('#sip_comp').on('change', function() {
			if ($(this).val()=='0') {
				alert('warning', 'center', '<b>Compression Type: None</b><br/><br/>The only time you should use this compression type on a trunk, is if the trunk is going to connect to a device on the same network or LAN<br/>');
			}
		});
	
		//SIP Description, TrunkGroup & LCRPlan names
		$('#sip_name').on('keyup', function() {
		sipName = $(this).val();
			
		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?sip=" + encodeURIComponent(sipName),   
         async: true,
         success : function(text) {
             response = text;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#wizard').smartWizard('showMessage','Invalid or Duplicate Entry'); 
				$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				sipNameError = 1
			 } else {
				$('#wizard').smartWizard('hideMessage'); 
				$("#sip_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				$('#sip_desc').val(sipName + ' SIP Trunk')
				$('#sip_trunkgrp').val(sipName + 'TrkGrp')
				$('#sip_lcrplan').val(sipName + 'LCRPlan')
				sipNameError = 0
			 }
         }
		});
		});
		
	
	// validation
	function leaveAStepCallback(obj){
		var step_num= obj.attr('rel');
        return validateSteps(step_num);
	}
      
	function validateAllSteps(){
		var isStepValid = true;
       
		if(validateStep1() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:1,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:1,iserror:false});
		}
       
		if(validateStep3() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:false});
		}
       
       if(!isStepValid){
          $('#wizard').smartWizard('showMessage','Please correct the errors in the steps and continue');
       }
              
       return isStepValid;
    } 	
		
		
	function validateSteps(step){
		var isStepValid = true;
			
		// validate step 1
		if (step == 1){
			if (validateStep1() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
		
		
		// validate step2
		if (step == 2){
			if (validateStep2() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
      
		// validate step3
		if (step == 3){
			if (validateStep3() == false ){
			isStepValid = false; 
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
      
		return isStepValid;
    }
		
	function validateStep1(){
		var isValid = true; 
		var trunkName = $('#sip_name').val();
		var dnsip = $('#sip_dnsip').val();
		var sipcaps = $('#sip_caps').val();
		var presenationNumber = $('#sip_pres').val();
		
		var sipType = $('#sip_type').val();
		if (sipType == '1') {
			sipDNSIPUser = $('#sip_dnsip_user').val();
			sipUsername =  $('#sip_username').val();
			sipPassword = $('#sip_password').val();
			
			if (!sipDNSIPUser && sipDNSIPUser.length <= 0) {			
				$('#wizard').smartWizard('showMessage','Registrar DNS/IP Address must be set');
				$("#sip_dnsip_user").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_dnsip_user").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			if (!sipUsername && sipUsername.length <= 0) {			
				$('#wizard').smartWizard('showMessage','Username must be set');
				$("#sip_username").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_username").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			if (!sipPassword && sipPassword.length <= 0) {			
				$('#wizard').smartWizard('showMessage','Password must be set');
				$("#sip_password").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				isValid = false; return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#sip_password").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
		}
		
		if (sipNameError == '1') {
			$('#wizard').smartWizard('showMessage','Invalid or Duplicate Entry'); 
			$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;
			return false;
		}
		
		if (!trunkName && trunkName.length <= 0) {
			$('#wizard').smartWizard('showMessage','Trunk Name must be set.');
			$("#sip_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		if (!dnsip && dnsip.length <= 0) {
			$('#wizard').smartWizard('showMessage','DNS / IP Address must be set.');
			$("#sip_dnsip").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_dnsip").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		if (!sipcaps && sipcaps.length <= 0 || !$.isNumeric(sipcaps)) {
			$('#wizard').smartWizard('showMessage','Capacity Name must be set (numeric value)');
			$("#sip_caps").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_caps").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		
		if (!presenationNumber && presenationNumber.length <= 0 || !$.isNumeric(presenationNumber)) {
			$('#wizard').smartWizard('showMessage','SIP Presentation Number must be set (numeric value)');
			$("#sip_pres").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_pres").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
			
		return isValid;
	}
	
	
	function validateStep2(){
		var isValid = true; 
		var sip_nat_server = $('#sip_nat_server').val();
				
		if (!sip_nat_server && sip_nat_server.length <= 0) {
			$('#wizard').smartWizard('showMessage','SIP NAT Server must be set.');
			$("#sip_nat_server").css({ 'border': '2pt solid #D00', 'color': '#D00'});
			isValid = false;    
			return false;
		} else {
			$('#wizard').smartWizard('hideMessage');
			$("#sip_nat_server").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
		}
		
		return isValid;
	}
    
	function validateStep3(){
		var isValid = true;  
		return isValid;
	}
	
	// finish
    function onFinishCallback(){
		if (validateAllSteps()){
		var sipName = $('#sip_name').val();
		var n = noty({
        type: 'warning', layout: 'center', text: 'Create SIPTrunk <b>' + sipName + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
			$noty.close();
				
				$.ajax({
					type: "POST", 
					cache: false,
					async: true,
					data: $('#SIPTrunk').serializeArray(),
					url: "saveSIP.php", 	
					success: function(data) {
						console.log (data)
						n.close();
						$('#newTrunk').html(summaryTrunk);
						$('#newTrunkGroup').html(summaryTrunkGroup);
						$('#newLCRPlan').html(summaryLCRPlan);
						$('#colFull').replaceWith($('#sipDone').html());
						$(".buttonFinish").addClass('buttonDisabled');
						$(".buttonPrevious").addClass('buttonDisabled');
						if ( $('#referrer').val().indexOf('welcome') === 0 ) {
							$('.actionBar').prepend('<a href="#" data-loc="admin" class="buttonPortal">Portal</a>');
						} else {
							$('.actionBar').prepend('<a href="#" data-loc="manager" class="buttonPortal">Manager</a>');
						}
						$('.buttonPortal').click(function() {
							loc = ( $(this).data('loc') )
							$("body").fadeOut(500,function() {
								if ( loc == 'admin' ) {
									$(location).attr('href','/manager/admin');
								} else {
									$(location).attr('href','/manager');
								}
									
							});
						});
						return false;
					},
					error: function(data) {
						n.close();
						return false;
					}
				});
			}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                }
            ]
        });
       }
      }
	  
	$('#sip_update_dialplan').change(function(e) {	    
		sip_update_dialplan = $('#sip_update_dialplan').is(':checked') ? 1 : 0;
		console.log ('DialPlan = ' + sip_update_dialplan)
		
		if (sip_update_dialplan === 1) {
			
			if ( $('#module_type').val() == '4' && dialplanwarning == 0 ) {
				alert('warning', 'center', 'Are you Sure ?.<br/>');
				$('#wizard').smartWizard('showMessage','Warning - Incorrect settings can kill routing');
				dialplanwarning = 1
			}
			
			$('#sip_dialplan, #sip_dialplan_blank, #sip_dialplan_additional, #sip_dialplan_code').prop('disabled', false);
			$('#summaryDialPlan').html('Yes');
		} else {
			$('#sip_dialplan, #sip_dialplan_blank, #sip_dialplan_additional, #sip_dialplan_code').prop('disabled', true);			
			$('#sip_dialplan_blank, #sip_dialplan_additional').prop('checked', false);
			$('#summaryDialPlan').html('No');
			$('#wizard').smartWizard('hideMessage');
		}
	});
	
	$('#sip_lcr_default').change(function(e) {	    
		sip_lcr_default = $(this).val();
		console.log ('SIPLCR = ' + sip_lcr_default)
		if (sip_lcr_default === '1') {
			$('#sip_local').prop('disabled', false);
		} else {
			$('#sip_local').prop('disabled', true);			
		}
	});
	
	$('#sip_local').change(function(e) {	    
		sip_local = $(this).val();
		if (sip_local === '1') {
			$('#sip_lcrstd, #local, #digits, #addRow').prop('disabled', false);
			$('#addRow').css("color", "#000000");
		} else {
			$('#sip_lcrstd, #local, #digits, #addRow').prop('disabled', true);
			$('#addRow').css("color", "#A0A0A0");
		}
	});
	
	
 	$("#sip_noemerg_lcrplan").click( function(){
		if( $(this).is(':checked') ) alert('error', 'center', '<b>Emergency Services</b><br/>Removing these entries may result in you not being able to call emergency services.<br/>');
	});	

    $('#addRow').click(function(e) {
		console.log('add')
		e.preventDefault();
        var $newRow = $('#TemplateRow').clone(true).removeAttr('id').append("<td class='delete'><img src='../assets/images/delete.png' class='deleteRow' name='deleteRow' title='Delete Row'/></td>");
		$('#cloneTable tr:last').after($newRow);
		$(".stepContainer").scrollTop($(".stepContainer")[0].scrollHeight);
        return false;
    });
    
    $('#cloneTable').delegate('.deleteRow:not(#TemplateRow .deleteRow)', 'click', function() {
            $(this).closest('tr').remove();
    });

	  
	  
	  function showSkip() {
		console.log ( $('#referrer').val().indexOf('welcome') )
	  if ( $('#referrer').val().indexOf('welcome') === -1 ) 	return
		  
	  if ($(".actionBar").find(".buttonSkip").length < 1) { 
		$('.actionBar').append('<a href="#" class="buttonSkip">Skip Wizard</a>');
		$('.buttonSkip').click(function() {
		var n = noty({ type: 'warning', layout: 'center', text: 'Leave SIP Wizard ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$noty.close();
				$("body").fadeOut(500,function(){
					$(location).attr('href','/manager/admin');
				});
			} },
				{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                } ]
			});
		});
	  }
	  }
	  
	 function sipnameCheck() {
		sipName = $('#sip_name').val();
		//console.log ('SIP Name : ' + sipName)
		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?sip=" + encodeURIComponent(sipName),   
         async: true,
         success : function(text) {
			 //console.log ('SIP Name Check: ' + text)
             response = text;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				sipNameError = 1
			 } else {
				sipNameError = 0
			 }
         }
		});
		};
	
});