<?php 
	require('../assets/inc/ldapConnect.php');
	$actionMode = (isset($_REQUEST['actionMode']) && strlen($_REQUEST['actionMode']) >=1 ) ? $_REQUEST['actionMode'] : NULL;
	$timestamp = (isset($_REQUEST['timestamp']) && strlen($_REQUEST['timestamp']) >=1 ) ? $_REQUEST['timestamp'] : NULL;
	
if ($actionMode === 'save') {
	$loadMode = (isset($_REQUEST['loadMode']) && strlen($_REQUEST['loadMode']) >=1 ) ? $_REQUEST['loadMode'] : NULL; // add or edit
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($loadMode) {
		
		$cn 				= $ent['cn'];
		$description 		= $ent['description'];
		$mode 				= $ent['mode'];
		$selectedName 		= $ent['selectedName'];
		$timeplanguid		= $ent['guid'];
		
		unset ($ent['actionMode']);	
		unset ($ent['loadMode']);			
		unset ($ent['selectedName']);
		unset ($ent['guid']);		
		unset ($ent['timestamp']);		
	
		$ent['company'] = (isset($_REQUEST['company'])) ? $_REQUEST['company'] : $adminCompany;
	
		if ($loadMode === "add") {
			$ent['objectclass']	= 'timeplan';
			ldap_add($ds,"cn=$cn,cn=timeplans",$ent); 
			$sr = ldap_read($ds,"cn=$cn,cn=timeplans","objectclass=timeplan",array('guid')); 
			$info = ldap_get_entries($ds,$sr);	$timeplanguid = $info[0]['guid'][0];
			 
		} else {
			unset ($ent['cn']);
			ldap_modify($ds, "cn=$selectedName, cn=timeplans", $ent);
			if ($selectedName != $cn)
				ldap_rename($ds,"cn=$selectedName,cn=timeplans","cn=$cn","cn=timeplans",true);
		}
	
		echo "$loadMode:$timeplanguid:$cn:$description:$mode";
		audit ($timestamp, "[TimePlans] [$loadMode] $cn", $ent);
	}
}


if ($actionMode === 'delete') {
	$selectedName = (isset($_REQUEST['selectedName']) && strlen($_REQUEST['selectedName']) >=1 ) ? $_REQUEST['selectedName'] : NULL;
	ldap_delete($ds, "cn=$selectedName, cn=timeplans");
	audit ($timestamp, "[TimePlans] [Delete] $selectedName", "Deleted TimePlan $selectedName");
}


if ($actionMode === 'entries') {
	
	$selectedGuid = (isset($_REQUEST['selectedGuid']) && strlen($_REQUEST['selectedGuid']) >=1 ) ? $_REQUEST['selectedGuid'] : NULL;
	$timeBands = (isset($_REQUEST['timeBands']) && count($_REQUEST['timeBands']) >=1 ) ? $_REQUEST['timeBands'] : NULL;
	$dateExceptions = (isset($_REQUEST['dateExceptions']) && count($_REQUEST['dateExceptions']) >=1 ) ? $_REQUEST['dateExceptions'] : NULL;
	
	if ($selectedGuid && $timeBands) {
		foreach ($timeBands as $k => $v) {
			$sections = explode(":",$v);
			$action = $sections[0];
			$startday = $sections[2];
			$starttime = $sections[3];
			$endday = $sections[4];
			$endtime = $sections[5];
			
			$ent = array();
			$ent["startTime"] = $starttime;
			$ent["endDayofWeek"] = $endday;
			$ent["endTime"] = $endtime;
			
			if ($action === 'add') {
				if (strlen($starttime) < 1 || strlen($endtime) < 1) continue;
				$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
				$sr = ldap_read($ds,"guid=$guid,cn=timeplans","objectclass=timeplan",array('cn')); 
				$info = ldap_get_entries($ds,$sr);	$cn = $info[0]['cn'][0];
				
				$ent["objectclass"] = "timeband";
				$dn = "startDayofWeek=$startday,cn=$cn, cn=timeplans";
				ldap_add($ds, $dn, $ent);
				
			} else if ($action === 'edit') {
				$ent["startDayofWeek"] = $startday;
				$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
				$dn = "guid=$guid, cn=timeplans";
				ldap_modify($ds, $dn, $ent);
				
			} else if ($action === 'del') {
				$guid = $sections[1];
     			$dn = "guid=$guid, cn=timeplans";
				@ldap_delete($ds, "$dn");
			}
			
			
		}
	}
	
	if ($selectedGuid && $dateExceptions) {
		foreach ($dateExceptions as $k => $v) {
			$sections = explode(":",$v);
			$action = $sections[0];
			$dayofmonth = $sections[2];
			$month = $sections[3];

			$ent = array();
			$ent["dayofMonth"] = $dayofmonth;
						
			if ($action === 'add') {
				if (strlen($dayofmonth) < 1 || strlen($month) < 1) continue;
				$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
				$sr = ldap_read($ds,"guid=$guid,cn=timeplans","objectclass=timeplan",array('cn')); 
				$info = ldap_get_entries($ds,$sr);	$cn = $info[0]['cn'][0];

				$ent["objectclass"] = "dateException"; 
				$dn = "month=$month,cn=$cn, cn=timeplans";
				ldap_add($ds, $dn, $ent);
				
			} else if ($action === 'edit') {
				$guid = (strlen($sections[1]) < 36) ?  $selectedGuid : $sections[1];
				$ent["month"] = $month;
				$dn = "guid=$guid, cn=timeplans";
				ldap_modify($ds, $dn, $ent);
				
			} else if ($action === 'del') {
				$guid = $sections[1];
     			$dn = "guid=$guid, cn=timeplans";
				@ldap_delete($ds, "$dn");
			}
			
		}
	}
}

if ($actionMode === 'timebandSummary') {

$arrayData = json_decode($_POST['arrayData']);		
$days = [ 1 => 'Mon', 2 => 'Tue', 3 => 'Wed', 4 => 'Thur', 5 => 'Fri', 6 => 'Sat', 0 => 'Sun' ];

	// build array
	// 0 = start, 1 = end, 2 = start time. 3 = endtime
	$array = array();
	foreach ($arrayData[0] as $dk => $dv) {
		
		for ($m=$dv; $m<=$arrayData[1][$dk]; $m++) {
			
			$st = str_replace(' ', '', $arrayData[2][$dk]); 
			$en = str_replace(' ', '', $arrayData[3][$dk]);
			
			$time = strtotime($en);
			$en = date("H:i", strtotime('+1 minutes', $time));
				
		$array[] = array('day' => $m == 0 ? 7 : $m, 
                        'stime' => $st,
                        'etime' => $en
                        );
		}
	}	
	
// sort by day & start time	
array_multisort(array_column($array, 'day'), SORT_ASC, SORT_NUMERIC,
                array_column($array, 'stime'), SORT_ASC, SORT_NUMERIC, 
                $array);
	
	
// remove overlapping entries and show closed.
$closed = 0;
$result = array_reduce($array, function($_arr, $item) {
global $closed;	
$day = $item['day'];
	if (!key_exists($day, $_arr)) {
		$_arr[$day] = $item;
	} else {
		
		if (floatval(str_replace(':', '.', $_arr[$day]['etime'])) < floatval(str_replace(':', '.', $item['stime']))) {
			$_arr[$day]['closed'] = $_arr[$day]['etime'] . " - " . $item['stime'] ."<br/>";
			$closed++;
		} else {
			$_arr[$day]['closed'] = '';
		}
			
		
		if (floatval(str_replace(':', '.', $_arr[$day]['stime'])) > floatval(str_replace(':', '.', $item['stime']))) {
			$_arr[$day]['stime'] = $item['stime'];
		}
		if (floatval(str_replace(':', '.', $_arr[$day]['etime'])) < floatval(str_replace(':', '.', $item['etime']))) {
			$_arr[$day]['etime'] = $item['etime'];
		}
	}
return $_arr;
}, []);


// ensure sorting is dome after rebuild
array_multisort(array_column($result, 'day'), SORT_ASC, SORT_NUMERIC,
                array_column($result, 'stime'), SORT_ASC, SORT_NUMERIC, 
                $result);

//print_r($result);
echo "<table border=1><th colspan='2'>TimeBands Active</th>";
if ( $closed > 0 ) echo "<th style='background-color: #FFF'></th><th>Inactive</th>";
foreach ($result as $k => $v) {
		echo "<tr><td><b>{$days[ $v['day'] ]}</b></td><td>{$v['stime']} - {$v['etime']}</td>";
		if ( $closed > 0 ) echo "<td  style='background-color: #FFF'></td><td>{$v['closed']}</td></tr>";
}
echo "</table>";}

?>