$(document).ready(function() {
	
	
	// highlight table entries //
	$('#makemember').on( 'click', 'tr', function () {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        }
        else {
            $('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });
	
	
	$("#makemember").on("click","img.parent",function(e) {
		e.preventDefault();
		id = $(this).closest("tr").attr('class').replace(/[^\d.-]/g,'');
		id = id.substring(0, id.indexOf('.'));
		
		$('[class^="parent' + id + '"]').find('img').toggle();
		$('[class^="child' + id + '"]').toggle();
		
		if (!$('[class^="child' + id + '"]').is(':visible')) {
			$('[id^="user' + id + '"]').hide();
			$('[id^="unassigned' + id + '"]').hide();
		
		} else {

			$('*[class^="child' + id + '"]').each(function(i, obj) {
				selectedId = $(this).closest("tr").attr('class').replace(/[^\d.-]/g,'').replace('.','\\.');
				childMode = $(this).find(".option").val().split(':')
				
				if (childMode[0] === '2') {
					$("#user" + selectedId).show();
				} else if (childMode[0] === '3') {
					$("#unassigned" + selectedId).show();
				}
			});
		}
	});
	
	// show errors on load //
	var numError = $('.error').not('#msg_wrap').length;
	if (numError > 0){
		$('#msg').html('Duplicate or Invalid Entries Found'); 
		$("#msg_wrap").addClass("error")
		$("#submit").prop("disabled",true);
	}
	
	// shows options //
	$('.option').change(function(){
		var opt = $(this).val();
		var id = $(this).closest("tr").attr('class').replace(/[^\d.-]/g,'').replace('.','\\.');
		
		if(opt[0]=="2") {
			$('#user'+ id).show();
			$('#unassigned'+ id).hide();
		} else if(opt[0]=="3") {
			$('#unassigned'+ id).show();
			$('#user'+ id).hide();
		} else {
			$('#user'+ id).hide();
			$('#unassigned'+ id).hide();
		}
	});
	
	// update number for extension //
	$('#frm1').on('change', 'select[name="sel"]', function (event) {	
		var data = $(this).val(); 
        var id = $(this).attr('id').replace('.','\\.');
		var newselId = $(this).attr('id').replace('sel','new_sel').replace('.','\\.');
		$('[id^="new_sel"]').each(function() { 
			if ($(this).val() === data) { 
				$('#' + id + ',#' + newselId).addClass("error");
			    $("#submit").prop("disabled",true);
				return false
			} else {
				$('#' + id + ',#' + newselId).removeClass("error");
			    $("#submit").prop("disabled",false);
			}
		});

		
		
		
		$('#new_' + id).val(data);      
        $("input[name^='new_sel']").css('background-color', '#FFFFFF'); 
    });
	

	// submit //
	$("body").on('click', '#submit', function(){
		
		if ($('.option :selected').text().length === 0) {
			var n = noty({ type: 'error', layout: 'center', text: 'Warning<br>No Phones Selected', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500, });
			return false		
		}
		
		var selectDevices = (($(".option :selected").not(':empty').length));
		console.log ('Total Selected Devices: ' + selectDevices)
		
		uniqueDevices = [];
		$(".option :selected").not(':empty').each( function (key, value) {
			//console.log ($(this))
						
			var $row = $(this).closest("tr");
			var tds = $row.find("td");
			uniqueDevices.push ($(tds[1]).text())
		});
		unique = uniqueDevices.filter((item, i, ar) => ar.indexOf(item) === i);
		console.log ('Unique Devices: ' + unique.length)
		selectDevices = unique.length
		
		
		
		
		$(".option :selected").not(':empty').each(function(index){
			var phoneModel = $(this).val().split(':');
			if (phoneModel[2] != '3') selectDevices--;
		});
		console.log ('Selected SIP Devices: ' + selectDevices)

		
		$.ajax({ type: "GET",   
		url: "actions.php?mode=SIPlicenceCount",   
		async: true,
		success : function(text) {
			console.log('Available SIP Licences: ' + text)

			if ( selectDevices > '0' && text <= '0' ) {
				var n = noty({ type: 'error', layout: 'center', text: 'SIP Phone Licence<br/>No SIP Phone licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, });
				return false;
			} else if ( selectDevices > '0' && selectDevices > text) {
				var n = noty({ type: 'warning', layout: 'center', text: 'SIP Phone Licence<br/>Insufficient licences available<br/><br/>You require <b>' + selectDevices + '</b> licences only <b>' + text + '</b> are available.<br/>No Devices have been assigned.<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, });
				return false;
			} else {
				submitDevices();
			}
		}	
		});

	});
	
	// submit function
	function submitDevices() {
		var msg = 'Import Selected Phones ?';
		var mode = 'information';
		var STUNSTART = '0';
		var stunSet = '0';
		
		$("input[name^='stun']:checked").each(function(){
			if ($(this).val() === '1') stunSet++;
		});
		
		if (stunSet > 0) {
			
			$.ajax({
				type: "POST", 
		        async: false,
				cache: false,
				url: "actions.php?mode=stunCheck", 	
				success: function(data) {
					res = data.split(':');
					dontvalidate = res[0];
					publicip = res[1];
				}
			});
			
			if (dontvalidate === '0' || publicip === '0') {			
				var msg = 'As STUN is enabled the SoftPBX needs to be restarted. Once the Phones are imported you have the option to restart the SoftPBX.<br><br><span style="color:#000000; font-weight:bold !important; ">Please Note:</span> When the SoftPBX is restarted live calls will be disconnected and phones logged out.<br><br>Do you want to continue importing the phones ?';
				var mode = 'error';
				var STUNSTART = '1';
			}
		} 

		
		var n = noty({
        type: mode, layout: 'center', text: msg, dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				var tmp  = JSON.stringify($('#frm1').serializeArray());
				var timestamp = Math.floor(Date.now() / 1000); 
				
				$.ajax({
					type: "POST", 
			        async: true,
					cache: false,
					data: {myData : tmp},
					url: "actions.php?mode=makemember&STUNSTART=" + STUNSTART + "&timestamp=" + timestamp, 	
				success: function(data) {
					$("#statictable").html(data);
					$('#btn_delete, #msg_wrap, #submit').hide();
				}
				});
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	}
	
	
	// delete selected //
	$("#btn_delete").click(function() {
		var selected = $('#makemember tr.selected').find('input[name^=address]').val();
		var timestamp = Math.floor(Date.now() / 1000); 
		
		if (typeof selected != "undefined" && selected.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete Unassigned Phone: ' + selected + ' ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({
					type: "POST", 
					cache: false,
					url: "actions.php?mode=deleteunassigned&address=" + selected + "&timestamp=" + timestamp, 	
				success: function(data) {
					$('#makemember tr.selected').remove();
					$noty.close(); 
				}
				});
			}
            },
            {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                $noty.close(); }
                }
            ]
        });	
	});
	
	
	// restart AdminModule
	$("body").on('click', '#restart', function(){
		var timestamp = Math.floor(Date.now() / 1000); 
		var n = noty({
        type: 'error', layout: 'center', text: 'Restarting the SoftPBX will disconnect live calls and log out phones<br><br>Do you want to continue ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({
					type: "POST", 
					cache: false,
					url: "actions.php?mode=restartModule&timestamp=" + timestamp, 	
				success: function(data) {
					$('#restart').remove();
					if (data === '0') {
						$('#restartMsg').html('<b>SoftPBX Restarted</b>');
					} else {
						$('#restartMsg').html('An error occured restarting the SoftPBX');
					}
					
					$noty.close(); 
				}
				});
			}
            },
            {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                $noty.close(); }
                }
            ]
        });	
	});
	
	
	// name check //
	$('body').on('keyup', 'input[name^=usr_name]', function(){
		var userCN = $(this).val(); 
		var userID = this.id.replace('.','\\.'); 
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?user=" + encodeURIComponent(userCN),   
         async: true,
         success : function(data) {
			var nameList = $('input[name^="name"]');
			var names = new Array();
			nameList.not('#' + userID).each(function () {
				names.push($(this).val().toLowerCase());
			});
				
			 if (data.toLowerCase().indexOf("error") >= 0 || $.inArray(userCN.toLowerCase(), names) !== -1) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap, #" + userID).addClass("error");
			    $("#submit").prop("disabled",true);
			 } else {
 				$('#' + userID).removeClass('error');
				var numError = $('.error').not('#msg_wrap').length
				if (numError <= '0') {
					$('#msg').html(''); 
					$('#msg_wrap').removeClass('error');
					$("#submit").prop("disabled",false);
				}
			}
        }
		});
	});

	// Extension check //
	$('body').on('keyup', 'input[name^=usr_extn]', function(){
		var extn = $(this).val(); 
		var extnID = this.id.replace('.','\\.'); 
		
		var id = (this.id).replace('usr_extn','');
		$('#usr_loginaccesscode' + id).val(this.value);

		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?user_ext=" + encodeURIComponent(extn),   
         async: true,
         success : function(data) {
			var extnList = $('input[name^="usr_extn"]');
			var extns = new Array();
			extnList.not('#' + extnID).each(function () {
				extns.push($(this).val().toLowerCase());
			});
						
			 if (data.toLowerCase().indexOf("error") >= 0 || $.inArray(extn.toLowerCase(), extns) !== -1) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$("#msg_wrap, #" + extnID).addClass("error");
			    $("#submit").prop("disabled",true);
			} else {
				$('#' + extnID).removeClass('error');
				var numError = $('.error').not('#msg_wrap').length
				if (numError <= '0') {
					$('#msg').html(''); 
					$('#msg_wrap').removeClass('error');
					$("#submit").prop("disabled",false);
				}
			}
        }
		});
	});
	
	
	$('body').on('keyup', 'input[name^=loginaccesscode]', function(){
		var id = this.id.replace('.','\\.'); 

		if ($(this).val() === '1234') {
			$('#msg').html('Invalid Login Access Code'); 
			$('#msg_wrap, #' + id).addClass('error');
		    $("#save").prop("disabled",true);
			var n = noty({ type: 'error', layout: 'center', text: 'Invalid Login Access Code<br/>The login access code should not be set to 1234', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		} else {
			$('#msg').html(''); 
			$('#msg_wrap, #' + id).removeClass('error');
			$("#save").prop("disabled",false);
		}
	})
		
	
});

	