<?php 
	require('../assets/inc/ldapConnect.php');
	$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) >=1 ) ? $_REQUEST['mode'] : NULL; // saveUser, speedDials, deleteUser, moduleList
	$timestamp = (isset($_REQUEST['timestamp']) && strlen($_REQUEST['timestamp']) >=1 ) ? $_REQUEST['timestamp'] : NULL;
	
if ($mode === 'saveUser') {
	$userMode = (isset($_REQUEST['userMode']) && strlen($_REQUEST['userMode']) >=1 ) ? $_REQUEST['userMode'] : NULL; // addUser or editUser
	$ent = array();
	
	foreach($_REQUEST as $key => $value){
		if (strpos($key, '_') === false) $ent[$key] = $value;
	}
	
	if ($userMode) {
		
		$cn 				= $ent['cn'];
		$telephonenumber 	= $ent['telephonenumber'];
		$description 		= $ent['description'];
		$userName 			= $ent['userName'];
		$initialphonemodule = $ent['initialphonemodule'];
		$userguid 			= (isset($ent['userGuid']) && strlen($ent['userGuid']) > 1) ? $ent['userGuid'] : "";		
		
		unset ($ent['timestamp']);	
		unset ($ent['mode']);					
		unset ($ent['cn']);	
		unset ($ent['userMode']);
		unset ($ent['userName']);
		unset ($ent['guid']);
		unset ($ent['userGuid']);
		unset ($ent['initialphonemodule']);
		unset ($ent['initialphonedevice']);
		unset ($ent['followmetoselect']);
		unset ($ent['forwardonbusytoselect']);
		unset ($ent['forwardonnoanswertoselect']);
		
		if (!isset($_REQUEST['restrictgroups'])) 			$ent['restrictgroups'] = '0';
		if (!isset($_REQUEST['navigatesoftphonelicense'])) 	$ent['navigatesoftphonelicense'] = '0';
		if (!isset($_REQUEST['navigatesfblicense'])) 		$ent['navigatesfblicense'] = '0';
		if (!isset($_REQUEST['totalcontrollicense'])) 		$ent['totalcontrollicense'] = '0';
		if (!isset($_REQUEST['ipcslicense'])) 	$ent['ipcslicense'] = '0';
		if (!isset($_REQUEST['siplicense'])) 	$ent['siplicense'] = '0';
		if (!isset($_REQUEST['disabled'])) 		$ent['disabled'] = '0';
		if (!isset($_REQUEST['exdirectory'])) 	$ent['exdirectory'] = '0';
		if (!isset($_REQUEST['donotdisturb'])) 	$ent['donotdisturb'] = '0';
		if (!isset($_REQUEST['messageboxlicense'])) $ent['messageboxlicense'] = '0';
		if (!isset($_REQUEST['voicemailenabled'])) 	$ent['voicemailenabled'] = '0';
		
		$ent['allowmultiplephones'] = (!isset($_REQUEST['callselect'])) ? '0' : '1';
		unset ($ent['callselect']);
		
		$ent['company'] = (isset($_REQUEST['company'])) ? $_REQUEST['company'] : $adminCompany;

		
		// unassigned phone ?
		$initialphone = (isset($ent["initialphone"]) && strlen($ent["initialphone"])>1) ? trim($ent["initialphone"]) : NULL;    
		$currenthome = (isset($ent["currenthome"]) && strlen($ent["currenthome"])>1) ? trim($ent["currenthome"]) : NULL;  
  
		$sr=ldap_list($ds,"cn=unassignedphones","(&(objectclass=unassignedphone)(guid={$initialphone}))", array('serialnumber','location','pnpmodel'));
		$info = ldap_get_entries($ds, $sr);  $unassigned = $info['count']; $serial = '';
		for ($n=0; $n<$info['count']; $n++) {				
			$serial = $info[$n]['serialnumber'][0];
			$location = $info[$n]['location'][0];
			$pnpmodel = $info[$n]['pnpmodel'][0];
		}
  
		var_dump($ent);
  
		if ($unassigned == '1') {  
		// Delete unassigned
			$dn = "serialnumber=$serial, cn=unassignedphones";
			ldap_delete($ds, $dn);
					
		// Create Phone Object
			$att=array('objectclass'=>'Phone','typeOfPhone'=>'2','description'=>'Proactive Communication Station','location'=>$currenthome);
			$dn = "cn=PCS $serial,guid=$location, cn=modules";
			ldap_add($ds, $dn,$att);
		
		// Add cn=1 to phone object
			$att=array('objectclass'=>'SplicePhone','serialnumber'=>$serial, 'pnpmodel'=>$pnpmodel);
			$dn = "cn=1,cn=PCS $serial,guid=$location, cn=modules";
			ldap_add($ds, $dn,$att);
			
		// find phones GUID.
			$sr = ldap_read($ds,"cn=PCS $serial, guid=$location,cn=modules","objectclass=Phone"); $info = ldap_get_entries($ds,$sr);
			$ent['initialphone'] = $info[0]['guid'][0];
		}
					
		if ($userMode === "addUser") {
			$ent['objectclass']	= 'user'; // set objectclass
			ldap_add($ds,"cn=$cn,cn=users",$ent);
			audit ($timestamp, "[User] [$userMode] $cn", $ent);			
			
			$sr = ldap_search($ds,"cn=users","(&(objectclass=user)(telephonenumber=$telephonenumber))",array('guid','disabled')); 
			$info = ldap_get_entries($ds,$sr);	$userguid = $info[0]['guid'][0];  
			$disabledState = (isset($info[0]['disabled'][0])) ? $info[0]['disabled'][0] : '0';
	
		} else {
			
			if ($initialphonemodule === "clear") $ent['initialphone'] = "00000000-0000-0000-0000-000000000000";
			ldap_modify($ds, "guid=$userguid, cn=users", $ent);
			audit ($timestamp, "[User] [$userMode] $cn", $ent);

			if ($userName != $cn) {
				ldap_rename($ds,"guid=$userguid,cn=users","cn=$cn","cn=users",true);
				audit ($timestamp, "[User] [RenameUser] $cn", $userguid);
			}
			
			// check disabled status	
			$sr = ldap_read($ds,"guid=$userguid,cn=users","objectclass=user"); $info = ldap_get_entries($ds,$sr); 
			$disabledState = (isset($info[0]['disabled'][0])) ? $info[0]['disabled'][0] : '0';
		}
		
		$pnpmodel = '';
		if (isset($ent['initialphone']) && strlen($ent['initialphone']) >1) {
			$initPhone = $ent['initialphone'];
			@$sr = ldap_read($ds,"cn=1, guid=$initPhone","objectclass=*"); 
			@$info = ldap_get_entries($ds,$sr); 
			if (isset($info[0]['pnpmodel'][0])) $pnpmodel = str_replace('SIP-', '', $info[0]['pnpmodel'][0]);
			$pnpmodel = (file_exists("../assets/images/phones/$pnpmodel.jpg")) ? $pnpmodel.".jpg" : $pnpmodel;
		}
		
		echo "$userMode,$userguid,$cn,$telephonenumber,$description,$disabledState,$pnpmodel";
	}
}

if ($mode === 'speedDials') {
	$speedDials = (isset($_REQUEST['speedDials']) && count($_REQUEST['speedDials']) >=1 ) ? $_REQUEST['speedDials'] : NULL; // set speedDials Array
	$speedGroupHeaders = (isset($_REQUEST['speedGroupHeaders']) && count($_REQUEST['speedGroupHeaders']) >=1 ) ? $_REQUEST['speedGroupHeaders'] : NULL; // set speedGroupHeaders Array
	$userName = (isset($_REQUEST['userName']) && strlen($_REQUEST['userName']) >=1 ) ? $_REQUEST['userName'] : NULL; // get Username

	echo "USER<br/>";
	print_r($userName);
	
	echo "<br/>SpeedDials<br/>";
	print_r($speedDials);
	
	echo "<br/>GroupHeaders<br/>";
	print_r($speedGroupHeaders);
	
	if ( $speedGroupHeaders ) {
	foreach ($speedGroupHeaders as $k => $v) {
		$hdrSections = explode(",",$v);
		$hdrMode = $hdrSections[0];
		$hdrGuid = $hdrSections[1];
		$hdrShortcode = str_replace('-',',',$hdrSections[2]);
		$hdrDescription = $hdrSections[3];
					
		if ($hdrMode === 'add') {
			echo "add header..";
			if ($hdrShortcode == '0' && $description == '0') continue;
			$ent["objectclass"] = "speeddial";
			$ent["shortcode"] = $hdrShortcode;
			$dn = "description=$hdrDescription,cn=$userName, cn=Users";
			@ldap_add($ds, $dn, $ent);
			audit ($timestamp, "[User] [SpeedDial Group] [Add] $hdrDescription", $ent);
			
		} else if ($hdrMode === 'edit') {
			echo "edit";
			$ent["shortcode"] = $hdrShortcode;
			$ent["description"] = $hdrDescription;
			$dn = "guid=$hdrGuid, cn=Users";
			@ldap_modify($ds, $dn, $ent);
			audit ($timestamp, "[User] [SpeedDial Group] [Edit] $hdrDescription", $ent);
			
		} else if ($hdrMode === 'del') {
			echo "delete..";
			$dn = "guid=$hdrGuid, cn=$userName, cn=Users";
			@ldap_delete($ds, "$dn");
			audit ($timestamp, "[User] [SpeedDial Group] [Delete] $hdrShortcode", "$userName deleted folder $hdrShortcode");
		}
	}
	}
	
	if ( $speedDials ) {
	foreach ($speedDials as $k => $v) {
		echo "add speeddial..";
		$sections = explode(",",$v);
		$action = $sections[0];
		$guid = $sections[1];
		$telephonenumber = $sections[2];
		$description = $sections[3];
		$shortcode = (isset($sections[4])) ? str_replace('-',',',$sections[4]) : '';
		$shortcode = (strpos($shortcode, 'G:996699') !== false) ? str_replace('G:996699,', 'PRI:', $shortcode) : $shortcode;
		
		$ent["description"] = $description;
		$ent["shortcode"] = $shortcode;
		
		if ($action === 'add') {
			if ($telephonenumber == '0' && $description == '0') continue;
			$ent["objectclass"] = "speeddial";
			$dn = "telephonenumber=$telephonenumber,cn=$userName, cn=Users";
			echo $dn;
			@ldap_add($ds, $dn, $ent);
			audit ($timestamp, "[User] [SpeedDial] [Add] $telephonenumber", $ent);
			
		} else if ($action === 'edit') {
			$ent["telephonenumber"] = $telephonenumber;
			$dn = "guid=$guid, cn=Users";
			echo $dn;
			@ldap_modify($ds, $dn, $ent);
			audit ($timestamp, "[User] [SpeedDial] [Edit] $telephonenumber", $ent);
			
		} else if ($action === 'del') {
     		$dn = "guid=$guid, cn=$userName, cn=Users";
			echo $dn;
			@ldap_delete($ds, "$dn");
			audit ($timestamp, "[User] [SpeedDial] [Delete] $telephonenumber", "$userName deleted $telephonenumber");
		}
	}
	}
}

if ($mode === 'deleteUser') {
	$userName = (isset($_REQUEST['userName']) && strlen($_REQUEST['userName']) >=1 ) ? $_REQUEST['userName'] : NULL;
	$userGuid = (isset($_REQUEST['userGuid']) && strlen($_REQUEST['userGuid']) >=1 ) ? $_REQUEST['userGuid'] : NULL;
	ldap_delete($ds, "guid=$userGuid, cn=Users");
	audit ($timestamp, "[User] [Delete] $userName", $userGuid);
}


if ($mode === 'moduleList') {
	
	if (isset($_REQUEST['module']) && strlen($_REQUEST['module']) >1) {
	
	$module	= $_REQUEST['module'];
	$initialOption = $_REQUEST['initialOption'];
	
	$sr=ldap_list($ds,"cn=users","(&(objectclass=user)(!(initialphone=00000000-0000-0000-0000-000000000000)))", array('initialphone'));
	$info = ldap_get_entries($ds, $sr);	$setinitialphones = array();
	for ($m=0; $m<$info['count']; $m++) {				
		$setinitialphones[] = $info[$m]['initialphone'][0];
	}
	$tmp = array_count_values($setinitialphones);
	
	$sr=ldap_list($ds,"guid=$module,cn=modules","(&(objectclass=phone)(typeofphone<=3))", array('cn','guid'));
	$info = ldap_get_entries($ds, $sr);  $modules ='';
	for ($m=0; $m<$info['count']; $m++) {				
		$guid = $info[$m]['guid'][0]; 
		
		$sr2 = ldap_read($ds,"cn=1,guid=$guid","objectclass=*",array('guid','pnpmodel')); 
		$info2 = ldap_get_entries($ds,$sr2);	
		$pnpmodel = (isset($info2[0]['pnpmodel'][0])) ? $info2[0]['pnpmodel'][0] : '';

		if (($guid == $initialOption) || (stripos($pnpmodel, 'W5') !== false) || (stripos($pnpmodel, 'W6') !== false) || (stripos($pnpmodel, 'T53') !== false) || (stripos($pnpmodel, 'T54') !== false)  || (stripos($pnpmodel, 'T57') !== false)  || (stripos($pnpmodel, 'VP59') !== false) || !in_array($guid, $setinitialphones)) {
			
			if (in_array($guid, $setinitialphones)) {
				if ((stripos($pnpmodel, 'W5') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'W6') !== false && $tmp[$guid] >=8) || (stripos($pnpmodel, 'T53') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'T54') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'T57') !== false && $tmp[$guid] >=5) || (stripos($pnpmodel, 'VP59') !== false && $tmp[$guid] >=5)) continue;
			}
			
			$cn =  (substr($info[$m]['cn'][0],0,4)=='port') ?  chunk_split(ucfirst($info[$m]['cn'][0]), 4, ' ') : $info[$m]['cn'][0];
			$modules .= $cn."::".$guid.",";	
		}
		
	}
    //echo $modules;    
	$sr=ldap_list($ds, "cn=UnassignedPhones", "(&(&(objectclass=UnassignedPhone)(typeofphone=2)(location=$module)))", array("cn","guid","typeOfPhone","location"));
	$info2 = ldap_get_entries($ds, $sr); $devices =''; $guid = '';
	
	for ($n=0; $n<$info2['count']; $n++) {				
		$guid = $info2[$n]['guid'][0]; 
		$cn = $info2[$n]['cn'][0];
		$devices .= $cn."::".$guid.",";	
	}
	$devices = rtrim($devices, ',');
              
    if (strlen($devices) >= 1) $modules .= "Unassigned,";
    echo $modules;    
	if (strlen($devices) >= 1) echo $devices; 
	
	}  
}



if ($mode === 'licenceCount') {
	$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_IPUser))",array('qty','used')); 
	$info = ldap_get_entries($ds,$sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$qty = $info[$m]['qty'][0];
		$used = $info[$m]['used'][0];
	}
	
	echo trim($qty - $used);
}


if ($mode === 'callselect') {
	$telephonenumber = (isset($_REQUEST['telephonenumber']) && strlen($_REQUEST['telephonenumber']) >= 1) ? $_REQUEST['telephonenumber'] : NULL;
	$sr = ldap_list($ds,"cn=Users","(&(objectclass=*)(telephonenumber=$telephonenumber))",array('telephonenumber','agentlicense'));
		$info = ldap_get_entries($ds, $sr);
		echo $info[0]['agentlicense'][0];
}


if ($mode === 'licenceCheck') {
	$licenceCheck = (isset($_REQUEST['licence']) && strlen($_REQUEST['licence']) >= 1) ? $_REQUEST['licence'] : NULL;
	$qty = $used = '';
	
	
	if (stripos($licenceCheck, 'license') !== false) $licenceCheck = str_replace('license','', $licenceCheck);
	
	if ($licenceCheck === 'sip') $licenceCheck = 'SIPPhone';
	if ($licenceCheck === 'IP') $licenceCheck = 'IPUser';
	if ($licenceCheck === 'iPCS') $licenceCheck = 'iPCS';
	if ($licenceCheck === 'Analogue')$licenceCheck = 'AnalogueUser';
	if ($licenceCheck === 'Virtual') $licenceCheck = 'IPVirtualUser';
	if ($licenceCheck === 'totalcontrol') $licenceCheck = 'VisionMobility';

	if ($licenceCheck) {
		$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_$licenceCheck))",array('qty','used')); 
		$info = ldap_get_entries($ds,$sr);
		for ($m=0; $m<$info['count']; $m++) {				
			$qty = $info[$m]['qty'][0];
			$used = $info[$m]['used'][0];
		}
	
	echo trim($qty - $used);
	}	
}

if ($mode === 'forwarding') {
	$selected = (isset($_REQUEST['selected']) && strlen($_REQUEST['selected']) >=1 ) ? $_REQUEST['selected'] : NULL;
	$currentTele = (isset($_REQUEST['currentTele']) && strlen($_REQUEST['currentTele']) >=1 ) ? $_REQUEST['currentTele'] : NULL;
	$values = '';
	
	if ($selected) {
		switch ($selected) {
		case 'users':
			$queryCn = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? "cn=Users" : "cn=Users, cn=$adminCompany, cn=Companies";

			$objectclass = "user";
			$filter = array('cn','telephonenumber');
			break;
		case 'departments':
			$queryCn = ($adminCompany === '00000000-0000-0000-0000-000000000000') ? "cn=departments" : "cn=departments, cn=$adminCompany, cn=Companies";
			$objectclass = "department";
			$filter = array('cn','telephonenumber');
			break;		
		}
		
		$sr=ldap_list($ds, $queryCn,"(objectclass=$objectclass)", $filter);
		$info = ldap_get_entries($ds, $sr);	$selectedEntries = array();
		for ($m=0; $m<$info['count']; $m++) {				
			
			if ($info[$m]['telephonenumber'][0] === $currentTele || $info[$m]['cn'][0] === "InboundRecordings" || $info[$m]['cn'][0] === "OutboundRecordings") continue;
			
			if ($selected === 'conference') {
				$values .= $info[$m]['cn'][0] . ":" . $info[$m]['cn'][0] . ",";
			} else {
				$values .= $info[$m]['telephonenumber'][0] . ":" . $info[$m]['cn'][0] . " (" . $info[$m]['telephonenumber'][0]. ")" . ",";
			}
		}
			$values = rtrim($values, ',');
			echo $values;
	}
}

ldap_close($ds);
?>
