$(document).ready(function() {
	
	// load table //
	 oTable = $('#users').dataTable({
		"bJQueryUI": true, "sPaginationType": "full_numbers",
		"aLengthMenu": [[15, 25, 50, 100, 250, 500], [15, 25, 50, 100, 250, 500]]
	});
	
	// highlight table entries //
	$('#users').on( 'click', 'tr', function () {
	if ( $(this).hasClass('odd') || $(this).hasClass('even') || $(this).hasClass('new') ) {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        }
        else {
            oTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
	}
    });
	
	// change tabs //
	$("body").on('click', '#element_to_pop_up ul#tabs li', function(){
		$("ul#tabs li").removeClass("active");
		$(this).addClass("active");
	
		var i = $(this).index();
		$("ul#tab li.active").removeClass("active");
		$("ul#tab li").eq(i).addClass("active");
	});
	

		
	// add new user //
	var newUser = 0;
	$("#btn_add").click(function() {
		newUser = 1;
		$.ajax({ type: "GET",   
         url: "userActions.php?mode=licenceCount",   
         async: true,
 		 cache: false,
         success : function(text) {
			 console.log (text)
			 if (text < 1) {
				var n = noty({ type: 'error', layout: 'center', text: 'No user licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, timeout: 1500 });
				return false;
			 }
			 
			speedDials = [];// set array //
			speedGroupHeaders = [];// set array //
			initialOption = '0'; // set / clear initial phone
			origExtn = undefined;
			$('#element_to_pop_up').bPopup({
				escClose: false, modalClose: false,
				loadUrl: 'userForm.php?userMode=addUser',
				loadCallback: function(){ 	    
				originalFormData = $('#new_user').serialize();
				}
			}); 
			}
		});
	});
	
	
	// delete selected user //
	$("#btn_delete").click(function() {
		//console.log ('del')
		var timestamp = Math.floor(Date.now() / 1000); 
		var selected = $('#users tr.selected').attr('id');
		console.log (selected)
		var deleteUser = $('#users tr.selected').find('td:first').text();
		if (typeof selected != "undefined" && selected.length > 3)
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete User: <b>' + deleteUser + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				$.ajax({ url : 'userActions.php?mode=deleteUser&userGuid=' + encodeURIComponent(selected) + '&userName=' + encodeURIComponent(deleteUser) + '&timestamp=' + timestamp });
					oTable.fnDeleteRow( oTable.$('#' + selected)[0] );
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
	});

	
	// edit selected user //
	$("#btn_edit").click(function(e) {
		speedDials = [];
		speedGroupHeaders = [];
		initialOption = '0';
		guid = $('#users tr.selected').attr('id');
		var userName = encodeURIComponent( $('#users tr.selected').find('td:first').text() );
		origExtn = encodeURIComponent( $('#users tr.selected').find('td:nth-child(2)').text() );
		if (typeof guid == "undefined" || guid.length < 1 ) return false;
		$.ajaxSetup({ cache: false });					
		
        $('#element_to_pop_up').bPopup({
			escClose: false, modalClose: false,
            loadUrl: 'userForm.php?userMode=editUser&userName=' + userName + '&userGuid=' + guid,
			loadCallback: function(){ 	    
				originalFormData = $('#new_user').serialize();
				
				usertypelicense = $('#usertype').val();
				messageboxlicense = $("#messageboxlicense").prop("checked") ? '1' : '';
				siplicense = $("#siplicense").prop("checked") ? '1' : '';
				ipcslicense = $("#ipcslicense").prop("checked") ? '1' : '';
				totalcontrollicense = $("#totalcontrollicense").prop("checked") ? '1' : '';
				navigatesoftphonelicense = $("#navigatesoftphonelicense").prop("checked") ? '1' : '';
				navigatesfblicense = $("#navigatesfblicense").prop("checked") ? '1' : '';
				navigateoutlooklicense = $('#navigateoutlooklicense').val();
				operatorconsolelicense = $('#operatorconsolelicense').val();
				
				selectediniitalmodule = $('#initialphonemodule').val();
				selectedinitialdevice = $('#initialphone').val()
				
				$("#speedDialFrm").tableDnD({
					onDrop: grouping,
					scrollAmount: '100',
					hierarchyLevel: '1'
				});
				
				var spanText = $(this).find("#msg").text();
				if (spanText.indexOf("Disabled") >= 0) {
					$('#msg_wrap').addClass('error');
				}
			
				// order headers //
				var $table=$('#speedDialFrm');
				var rows = $table.find('tr.group_heading').get();
				rows.sort(function(a, b) {
					var keyA = $(a).attr('data-order');
					var keyB = $(b).attr('data-order');
					if (!keyA || !keyB) return -1;
					if (keyA > keyB) return 1;
					if (keyA < keyB) return -1;
					return 0;
				});
				
				$.each(rows, function(index, row) {
					$table.children('tbody').append(row);
				})
				
				$.each(rows, function(index, row) {
					$(this).attr("data-order", index+1);
					var rowID = $(this).attr('id');
					$('#orderPriority' + rowID).html(index+1)
				});
				// order headers //

				
				var tr = $table.find('tr.toggler_row').get();
				tr.sort(function(a, b) {
					var keyA = $(a).attr('data-speeddial');
					var keyB = $(b).attr('data-speeddial');
					keyA = pad(keyA,3);
					keyB = pad(keyB,3);
					if (!keyA || !keyB) return -1;
					if (keyA < keyB) return 1;
					if (keyA > keyB) return -1;
					return 0;
				});

				$(tr).each(function(index, row) {
					if ( $(this).attr('data-order') === '') { 
						var site_id = $(this).attr('data-speeddial').replace('G:','')
						if (!$.isNumeric(site_id)) site_id = '';						
						var OrderArray = [];
						console.log(site_id)
					$('*[data-speeddial=G\\:' + site_id + ']').each(function() {
						OrderArray.push( $(this).attr('data-order') ) 
					}); 
					OrderId = (OrderArray.length >=1) ? Math.max.apply(Math,OrderArray) +1 : '1';
					$(this).attr('data-order', OrderId);
					}
				});

				tr.sort(function(a, b) {
					var keyA = $(a).attr('data-order');
					var keyB = $(b).attr('data-order');
					keyA = pad(keyA,3);
					keyB = pad(keyB,3);
					if (!keyA || !keyB) return -1;
					if (keyA < keyB) return 1;
					if (keyA > keyB) return -1;
					return 0;
				});

				$(tr).each(function(index, row) {
					var id = $(this).attr('id');
					var arr = $(this).attr('data-speeddial').replace('G:','')
					if (!$.isNumeric(arr)) arr = '';
					$('#' + id).insertAfter('[data-header=GH\\:' + arr + ']');
				});
			}
        });
	});
	
	// close user //
	$("body").on('click', '#close', function(){
		var closeUser = (newUser != 1) ? $('#users tr.selected').find('td:first').text() : '';
		var msg = (originalFormData !== $('#new_user').serialize()) ? '<b>Changes haven\'t been saved.</b><br/>' : ''
		var n = noty({
        type: 'warning', layout: 'center', text: msg + 'Close User <b>' + closeUser + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
                    $noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });
		newUser = 0;
	});
	
	// save updates //
	$("body").on('click', '#save', function() {
		$('#msg_wrap').text('')
		
		if ( $('#callselect').is(':checked') ) {
			var saveTele = $('#telephonenumber').val();
			$.ajax({ type: "GET",   
				url: "userActions.php?mode=callselect&telephonenumber=" + encodeURIComponent(saveTele),   
				async: true,
				success : function(data) {
					if (data > '0') {
						var n = noty({ type: 'error', layout: 'center', text: '<br/>Call Select can not be enabled when the user has a Vision Agent Licence<br/>Please contact your system administrator.<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
						$('#msg_wrap').text('Vision Agent licences can only be disabled by the administrator')
						return false;
					} else {
						saveuser()
					}
				}	
			})
		} else {
			saveuser()
		}
		
		
	})
	
	function saveuser() {
		
	var timestamp = Math.floor(Date.now() / 1000); 
	var saveUserType = $('#usertype :selected').val();
	var saveUser = $('#cn').val();
	var saveTele = $('#telephonenumber').val();
	if (saveUser.length < 1 || saveTele.length < 1 || saveUserType.length < 1) {
		var n = noty({ type: 'error', layout: 'center', text: 'User Name, Telephone Number and User Type must be set<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 })
		return false;
	}
	
	//check Voicemail Access Code
		var msg = '';
		var vmc = $('#voicemailaccesscode').val();
		var pwd = ['1234', '999', '0000', '0'];
		if ($('#telephonenumber').val().length >= 1) {
			pwd.push( $('#telephonenumber').val() );
			msg = 'or ' + $('#telephonenumber').val();
		}
			
		if (vmc.length >= 1 && (jQuery.inArray(vmc, pwd) !== -1 || !$.isNumeric(vmc))) {
			$('#msg').html('Invalid Voicemail Access Code'); 
			$('#msg_wrap, #voicemailaccesscode').addClass('error');
		    $("#save").prop("disabled",true);
			var n = noty({ type: 'error', layout: 'center', text: 'Invalid Voicemail Access Code<br/>The voicemail access code must be a number and should not be set to 1234, 999, 0000, 0 ' + msg + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
			return false;
		} else {
			$('#msg').html(''); 
			$('#msg_wrap, #voicemailaccesscode').removeClass('error');
			$("#save").prop("disabled",false);
		}
	
	
		var n = noty({
        type: 'information', layout: 'center', text: 'Save User <b>' + saveUser + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				//console.log ('save')
				var userMode = $('#userMode').attr('value');
				data = $('#new_user').serializeArray()
				data.push({name: 'timestamp', value : timestamp}); 
				
				$.ajax({
					type: "POST", cache: false,
					data: data,
					url: "userActions.php?mode=saveUser", 	
				success: function(data) {
					console.log(data)
					res = data.split(",");
					var userMode = res[0];
					guid = (userMode == 'editUser') ? guid : res[1];
					var name = res[2]; var extn = res[3];  var desc = res[4]; var disabledState = res[5]; var pnpmodel = res[6];
					console.log(res)
					var ret = userMode + ',' + guid + ',' + name + ',' + extn + ',' + pnpmodel + ',' + desc + ',' + disabledState;
					parent.UpdateCode(ret);
				//speedDials//
				$.ajax({
					type: "POST", cache: false,
					data: {
						speedDials: speedDials, 
						speedGroupHeaders: speedGroupHeaders,
						timestamp: timestamp
					},
					url: "userActions.php?mode=speedDials&userName=" + encodeURIComponent(name), 	
					success: function(data) {
						console.log (data)
					}
				});
				//speedDials//
				}
				});

				parent.$("#element_to_pop_up").html('').bPopup().close(); // clear and close bpopup
				$noty.close();
				return false; 
			}
            },
			{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); }
			}
            ]
        });
	}
	
	
	// SpeedDials //
	// add speeddial //
	$("body").on('click', '#addBtn', function(){
		console.log ('addSP')
        var epoch = (new Date).getTime(); 
		var rowCount = $('#speedDialFrm tr').length +1;
		
		var groupOrderArray = [];
		$('[data-speeddial=G\\:996699]').each(function() {
			groupOrderArray.push( $(this).attr('data-order') ) 
		}); 
		newOrderId = (groupOrderArray.length >=1) ? Math.max.apply(Math,groupOrderArray) +1 : '1';

		$('#speedDialFrm > tbody:last-child').append("<tr id='" +  rowCount + "' data-speeddial='G:996699' data-order='" + newOrderId + "' class='toggler_row' ><td><input name='sp_id[]' id='spguid" + rowCount + "' type='hidden' value='" + epoch + "'/><input name='sp_number[]' id='spnumber" + rowCount + "' type='text' class='smallFields' value='' placeholder='telephonenumber'/></td><td><input name='sp_description[]' id='spdescription" + rowCount + "' type='text' class='smallFields' value='' placeholder='description'/></td><td class='center'><img src='../assets/images/delete.png' name='deleteRow' class='delete deleteRow cursor' title='Delete Row'/>&nbsp;<img src='../assets/images/move.png' name='moveRow' class='deleteRow move' title='Move Row'/>&nbsp;<img class='move' style='cursor:pointer' title='Move to Group' alt='Move to Group' src='../assets/images/moverow.png' /></td></tr>");
		speedDials.push('add,'+ epoch + ',0,0,G:996699-' + newOrderId)
		$("#speedDialFrm").tableDnD({
			onDrop: grouping,
			scrollAmount: '100',
			hierarchyLevel: '1'
		});
		
		$('#spnumber' + rowCount).focus();
		$(".scroller").scrollTop($(".scroller")[0].scrollHeight);
		console.log (speedDials)
        return false;
    });
	
	// delete speeddial //
	$("body").on('click', '.delete', function(){
		console.log ('delSP')
		var id = $(this).closest('tr').find('input[name="sp_id[]"]').val();
		var telenum = ($(this).closest('tr').find('input[name="sp_number[]"]').val().length > 0) ? $(this).closest('tr').find('input[name="sp_number[]"]').val() : '0';
		var description = ($(this).closest('tr').find('input[name="sp_description[]"]').val().length > 0) ? $(this).closest('tr').find('input[name="sp_description[]"]').val() : '0';
		var res = ',' + id + ',' + telenum + ',' + description;
		
		speedDials = $.map(speedDials, function(value) {
		if( value.indexOf(id) > -1 ) {
			return undefined;
		} return value;
		});
		
		if (id.length != 13) 
			speedDials.push('del,' + id + ',' + telenum + ',0');
		$(this).closest('tr').remove();
		console.log ('del' + speedDials)
    });
	
	// edit speedials //
	$('body').on('change', '#speedDialFrm input:not(.group_header)', function(){
		//var id = $(this).closest('tr').attr('id')
		var group = $(this).closest('tr').attr('data-speeddial');
		var order = $(this).closest('tr').attr('data-order');
		var guid = $(this).closest('tr').find('input[name="sp_id[]"]').val()
		var telenum = $(this).closest('tr').find('input[name="sp_number[]"]').val()
		var description = $(this).closest('tr').find('input[name="sp_description[]"]').val()
		var res = ',' + guid + ',' + telenum + ',' + description + ',' + group + '-' + order;

		speedDials = speedDials.map(function(value) {
		if( value.indexOf(guid) > -1 ) {
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		} return value;
		});
		if ( ($.inArray('edit' + res, speedDials) == -1  && $.inArray('add' + res, speedDials) == -1)   ) {
			speedDials.push('edit' + res)
		}
		console.log (speedDials)
		return false;
	});
	
	// speeddials add group header //
	$("body").on('click', '#addGrp', function(){
        var epoch = (new Date).getTime(); 
		var newHeaderId ='0';
		var groupCountArray = [];
		var groupOrderArray = [];
		
		$('.group_heading:not(.nopriority)').each(function() {
			var groupCount = $(this).attr('data-header').split(':');
			groupCountArray.push(groupCount[1]) 
		}); 
		newHeaderId = (groupCountArray.length >=1) ? Math.max.apply(Math,groupCountArray) +1 : '1';
		$('.group_heading:not(.nopriority)').each(function() {
			groupOrderArray.push( $(this).attr('data-order') ) 
		}); 
		newOrderId = (groupOrderArray.length >=1) ? Math.max.apply(Math,groupOrderArray) +1 : '1';
		
		var rowCount = $('#speedDialFrm tr').length +1;
		$('#speedDialFrm tr.nopriority').before("<tr id='" + rowCount + "' data-header='GH:" + newHeaderId + "' data-order='" + newOrderId + "' data-guid='" +  epoch + "' class='group_heading nodrag'><td><img src='../assets/images/folder-icon.png' /><input type='text' maxlength='16' id='group" + rowCount + "' value='Folder" + newHeaderId + "' class='group_header'></td><td>Order: <span id='orderPriority" + rowCount + "'>" + newOrderId + "</span></td><td><img class='cursor' id='moveDown' src='../assets/images/down.png' /> <img class='cursor' id='moveUp' src='../assets/images/up.png' /> <img class='cursor' id='headerDelete' src='../assets/images/delete.png' />&nbsp;<img src='../assets/images/move.png' name='moveRow' class='deleteRow move' title='Move Row'/></td></tr>");
		speedGroupHeaders.push('add,' + epoch + ',GH:' + newHeaderId + '-' + newOrderId + ',Group' + newHeaderId)
		$("#speedDialFrm").tableDnD({
			onDrop: grouping,
			scrollAmount: '100',
			hierarchyLevel: '1'
		});
		console.log (speedGroupHeaders);
        return false;
    });
	
	// speeddials edit group header // 
	$('body').on('change', '#speedDialFrm input.group_header', function(){
		//var headerId = $(this).closest('tr').attr('id');
		var headerGuid = $(this).closest('tr').data('guid');
		var headerData = $(this).closest('tr').data('header');
		var headerOrder = $(this).closest('tr').data('order');
		var header = headerData + '-' + headerOrder;
		var headerName = $(this).val();
		var res = ',' + headerGuid + ',' + header + ',' + headerName;
        
		speedGroupHeaders = speedGroupHeaders.map(function(value) {
		if( value.indexOf(headerGuid) > -1 ) {
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		} return value;
		});
		if ( ($.inArray('edit' + res, speedGroupHeaders) == -1  && $.inArray('add' + res, speedGroupHeaders) == -1)   ) {
			speedGroupHeaders.push('edit' + res)
		}
		console.log (speedGroupHeaders)
		return false;
	});
	

	// speeddial group headers moveUp and moveDown
	$("body").on('click', '#moveUp, #moveDown', function() {
		var mode = ( $(this).attr('id') );
		var top = $(".group_heading:first").attr('id');
		
		var oldID = $(this).closest('tr').attr('id');
		var oldGroupHeader = $(this).closest('tr').attr('data-header');
		var oldPriority = $(this).closest('tr').attr('data-order');
		
		if (mode === 'moveUp') {
			if (oldID === top || newID === top) return false;
			var newID = $(this).closest("tr").prevAll(".group_heading").attr("id");
			var newGroupHeader = $(this).closest("tr").prevAll(".group_heading").attr("data-header");
			var newPriority = $(this).closest("tr").prevAll(".group_heading").attr("data-order");			
		} else if (mode === 'moveDown') {
			var newID = $(this).closest("tr").nextAll(".group_heading").attr("id");
			if (oldID === '996699' || newID === '996699') return false;
			var newGroupHeader = $(this).closest("tr").nextAll(".group_heading").attr("data-header");
			var newPriority = $(this).closest("tr").nextAll(".group_heading").attr("data-order");			
		}
		
		var oldHeading = $('#group' + oldID).val();
		var oldHeadingGuid = $('#' + oldID).attr('data-guid');
		var newHeading = $('#group' + newID).val();
		var newHeadingGuid = $('#' + newID).attr("data-guid");
		
		
		if (mode === 'moveDown') { 
			$('#' + oldID).insertAfter('#' + newID);
		} else if (mode === 'moveUp') { 
			$('#' + oldID).insertBefore('#' + newID);
		}
		
		
		$('#orderPriority' + oldID).html(newPriority)
		$('#orderPriority' + newID).html(oldPriority)
		$('#' + oldID).attr('data-order',newPriority);     
		$('#' + newID).attr('data-order',oldPriority);
	
		
		// push group header changes to speedGroupHeaders array	
		var res = ',' + oldHeadingGuid + ',' + oldGroupHeader + '-' + newPriority + ',' + oldHeading;
		speedGroupHeaders = speedGroupHeaders.map(function(value) {
			if( value.indexOf(oldHeadingGuid) > -1 ) {
				return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
			} return value;
		});
		if ( ($.inArray('edit' + res, speedGroupHeaders) == -1  && $.inArray('add' + res, speedGroupHeaders) == -1)   ) {
			speedGroupHeaders.push('edit' + res)
		}	

		var res = ',' + newHeadingGuid + ',' + newGroupHeader + '-' + oldPriority + ',' + newHeading;
		speedGroupHeaders = speedGroupHeaders.map(function(value) {
			if( value.indexOf(newHeadingGuid) > -1 ) {
				return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
			} return value;
		});
		if ( ($.inArray('edit' + res, speedGroupHeaders) == -1  && $.inArray('add' + res, speedGroupHeaders) == -1)   ) {
			speedGroupHeaders.push('edit' + res)
		}
		console.log (mode + ' -> group headers')
		console.log (speedGroupHeaders)		

		// update speedDials //
		$("tr.toggler_row").each(function() {
			var id = $(this).prop('id');
			var group = $(this).attr('data-speeddial');
			var arr = group.split(':');
			if (arr[1]) {
				$('#' + id).insertAfter('[data-header=GH\\:' + arr[1] + ']');
				//
			} else {
				$('#' + id).insertAfter('[data-header=GH\\:996699');
			}
		});
		return false;
	});
	
	
	
	$('body').on('click', '#headerDelete', function(){
		var headerName = $(this).closest('tr').find('.group_header').val();
		var groupRowId = $(this).closest('tr').attr('id');
		var HeaderId = $(this).closest('tr').attr('data-header').replace('GH:','');;
		var headerGuid = $(this).closest('tr').attr('data-guid');
		
		var n = noty({
        type: 'warning', layout: 'center', text: 'Delete SpeedDial Group: <b>' + headerName + '</b> ?<br/>All entries will be moved to the not grouped section', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [
            {addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
				
				$('#' + groupRowId).remove();
				speedGroupHeaders = $.map(speedGroupHeaders, function(value) {
				if( value.indexOf(headerGuid) > -1 ) {
					return undefined;
				} return value;
				});
				
				if (headerGuid.length != 13)
					speedGroupHeaders.push('del,' + headerGuid + ',' + headerName + ',0');
				
				$('[data-speeddial=G\\:'+ HeaderId + ']').each(function() {
					var id = $(this).closest('tr').attr('id')
					var guid = $(this).closest('tr').find('input[name="sp_id[]"]').val()
					var telenum = $(this).closest('tr').find('input[name="sp_number[]"]').val()
					var description = $(this).closest('tr').find('input[name="sp_description[]"]').val()
					var lastRowID = $('tr:last').attr('id');
					$('#' + id).insertAfter('#' + lastRowID);
					$('#' + id).attr('data-speeddial', 'G:996699');
					
					
				// push changes to speedDials array //
				var res = ',' + guid + ',' + telenum + ',' + description + ',';
				speedDials = speedDials.map(function(value) {
					if( value.indexOf(guid) > -1 ) {
						return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
					} return value;
				});
				if ( ($.inArray('edit' + res, speedDials) == -1  && $.inArray('add' + res, speedDials) == -1)   ) {
					speedDials.push('edit' + res)
				}
				console.log (' -> updateDEL')
				console.log (speedDials)
				});	
				
				
				console.log (speedGroupHeaders)
				$noty.close(); 
				}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); }
                }
            ]
        });	
		return false;
	});
	// SpeedDials //
	
	//  User Form Checks //
	
	// firstname & lastname
	$('body').on('change', '#new_user input[name=cn]', function(){
		var str = $(this).val(); str = $.trim(str); str = str.split(' '); var arr = []; 
		arr.push(str.shift()); arr.push(str.join(' '));
		$('#givenname').val(arr[0]);
		$('#sn').val(arr[1]);
	});
	
	// name check //
	$('body').on('keyup', '#new_user input[name=cn]', function(){
		var origName = (newUser === 0) ? encodeURIComponent( $('#users tr.selected').find('td:first').text() ) : '';
		var userCN = $(this).val(); 

		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?user=" + encodeURIComponent(userCN),   
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(userCN) === origName) return false;
			 if (response.toLowerCase().indexOf("error") >= 0) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$('#msg_wrap, #cn').addClass('error');
			    $("#save").prop("disabled",true);

			 } else {
				$('#msg').html(''); 
				$('#msg_wrap, #cn').removeClass('error');
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	// DECT Line
	$('body').on('keyup', '#dectline', function(){
		dectline =  $(this).val()
		if ( !$.isNumeric(dectline) )  {
				$('#msg').html('Only Numeric Values Supported'); 
				$('#msg_wrap, #dectline').addClass('error');
				$("#save").prop("disabled",true);
			 } else {
				$('#msg').html(''); 
				$('#msg_wrap, #dectline').removeClass('error');
				$("#save").prop("disabled",false);
			 }
	})
	
	
	
	// Extension check //
	$('body').on('keyup', '#new_user input[name=telephonenumber], #new_user input[name=hometelephonenumber], #new_user input[name=mobiletelephonenumber]', function() {
		fieldId = this.id;
		var userExtn = $(this).val(); 
		
		if (fieldId === 'hometelephonenumber' && $('#followmetoselect').val() === 'home')
			$('#followmeto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);
		if (fieldId === 'hometelephonenumber' && $('#forwardonbusytoselect').val() === 'home')
			$('#forwardonbusyto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);
		if (fieldId === 'hometelephonenumber' && $('#forwardonnoanswertoselect').val() === 'home')
			$('#forwardonnoanswerto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);
		
		if (fieldId === 'mobiletelephonenumber' && $('#followmetoselect').val() === 'mobile')
			$('#followmeto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);
		if (fieldId === 'mobiletelephonenumber' && $('#forwardonbusytoselect').val() === 'mobile')
			$('#forwardonbusyto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);
		if (fieldId === 'mobiletelephonenumber' && $('#forwardonnoanswertoselect').val() === 'mobile')
			$('#forwardonnoanswerto').val(userExtn).removeClass('error').attr('readonly',true).attr('disabled', false);

		var response = '';
		$.ajax({ type: "GET",   
         url: "../assets/inc/names.php?user_ext=" + encodeURIComponent(userExtn),   
         async: true,
         success : function(text) {
             response = text;
			 if (encodeURIComponent(userExtn) === origExtn) return false;
			 if (userExtn.length < 1) {
				$('#msg').html(''); 
				$('#msg_wrap, #' + fieldId).removeClass('error');
				$("#save").prop("disabled",false);
				return false;
			 }
			 if ( (response.toLowerCase().indexOf("error") >= 0) || (!$.isNumeric(userExtn)) ) {
				$('#msg').html('Invalid or Duplicate Entry'); 
				$('#msg_wrap, #' + fieldId).addClass('error');
				$("#save").prop("disabled",true);
			 } else {
				$('#msg').html(''); 
				$('#msg_wrap, #' + fieldId).removeClass('error');
				$("#save").prop("disabled",false);
			 }
         }
		});
	});
	
	// Email Address check //
	$('body').on('keyup', '#new_user input[name=mail]', function(){
		var email = $('#mail').val();
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		if (!regex.test(email)) {
			$('#msg').html('Invalid or Duplicate Entry'); 
				$('#msg_wrap, #mail').addClass('error');
				$("#save").prop("disabled",true);
			 } else {
				$('#msg').html(''); 
				$('#msg_wrap, #mail').removeClass('error');
				$("#save").prop("disabled",false);
			}
	});
	
	// check voicemail access code
	$('body').on('keyup', '#new_user input[name=voicemailaccesscode]', function(){
		var msg = '';
		var vmc = $('#voicemailaccesscode').val();
		var pwd = ['1234', '999', '0000', '0'];
		if ($('#telephonenumber').val().length >= 1) {
			pwd.push( $('#telephonenumber').val() );
			msg = 'or ' + $('#telephonenumber').val();
		}
			
		if (vmc.length >= 1 && (jQuery.inArray(vmc, pwd) !== -1 || !$.isNumeric(vmc))) {
			$('#msg').html('Invalid Voicemail Access Code'); 
			$('#msg_wrap, #voicemailaccesscode').addClass('error');
		    $("#save").prop("disabled",true);
			var n = noty({ type: 'error', layout: 'center', text: 'Invalid Voicemail Access Code<br/>The voicemail access code must be a number and should not be set to 1234, 999, 0000, 0 ' + msg + '<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		} else {
			$('#msg').html(''); 
			$('#msg_wrap, #voicemailaccesscode').removeClass('error');
			$("#save").prop("disabled",false);
		}
	});

	
	// Change Module, Show phones
	$("body").on('change', '#initialphonemodule', function(){
		if (initialOption <= 1) initialOption = $('#new_user option[class=initialOption]').val()
		module = $(this).val();
		if (module == "clear") {
			$("#initialphone").empty().append($("<option></option>").attr("value", '').text('no devices available')).attr("disabled", true);
			return false
		}

		$.ajax({ url: 'userActions.php?mode=moduleList&module=' + encodeURIComponent(module) + '&initialOption=' + encodeURIComponent(initialOption),
       	success: function(data, textStatus, xhr) {
			console.log(data)
        	var devices = data.split(',');
        	var $el = $("#initialphone"); $el.empty();
			if (devices[0] === "") { $el.append($("<option></option>").attr("value", '').text('no devices available')).attr("disabled", true); return false	}

			$.each(devices, function(value,key) {
				if (key === 'Unassigned') { 
					$("<option></option>").attr("value", '').appendTo($el);
					$('<optGroup/>').attr('label', 'Unassigned Phones').appendTo($el); 
					return;	
				}
				var device = key.split('::');
				if (key != "") $el.append($("<option></option>").attr("value", device[1]).text(device[0])).prop("disabled", false)
				if (device[1] === initialOption) $('#initialphone option[value="' + device[1] + '"]').addClass('initialOption');
			});
		   } 
		});
	});
	
	// check loginaccess code
	$('body').on('keyup', '#new_user input[name=loginaccesscode]', function(){
		var lac = $(this).val();
		if (lac.length >= 1 && (lac === '1234' || !$.isNumeric(lac))) {
			$('#msg').html('Invalid Login Access Code'); 
			$('#msg_wrap, #loginaccesscode').addClass('error');
		    $("#save").prop("disabled",true);
			var n = noty({ type: 'error', layout: 'center', text: 'Invalid Login Access Code<br/>The login access code must be a number and should not be set to 1234<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
		} else {
			$('#msg').html(''); 
			$('#msg_wrap, #loginaccesscode').removeClass('error');
			$("#save").prop("disabled",false);
		}
	});
	
	$("body").on('change', '#disabled', function() {
		if (!this.checked && $('#exdirectory').is(':checked')) {
			console.log ("uncheck ?")
			var n = noty({
			type: 'warning', layout: 'center', text: 'Ex Directory is currently enabled.<br> Do you wish to disable this mode ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
				buttons     : [
					{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					$('#exdirectory').attr('checked', false);
					$noty.close(); 
					}
				},
				{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
					$noty.close(); }
				}
				]
			});	
		}
	});
	
	$("body").on('change', '#disabled', function() {
		if (!this.checked && $('#callselect').is(':checked')) {
			console.log ("uncheck ?")
			var n = noty({
			type: 'warning', layout: 'center', text: 'Call Select is currently enabled.<br> Do you wish to disable this mode ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
				buttons     : [
					{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
					$('#callselect').attr('checked', false);
					$noty.close(); 
					}
				},
				{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
					$noty.close(); }
				}
				]
			});	
		}
	});
	
	
	// call select check
		$("body").on('change', '#callselect', function() {
		var licenceCheck = $(this).attr('id')
		var telephonenumber = $('#telephonenumber').val()
		
		if (document.getElementById(licenceCheck).checked) {
			$.ajax({ type: "GET",   
			url: "userActions.php?mode=callselect&telephonenumber=" + encodeURIComponent(telephonenumber),   
			async: true,
			success : function(data) {
				if (data > '0') {
					var n = noty({ type: 'error', layout: 'center', text: '<br/>Call Select can not be enabled when the user has a Vision Agent Licence<br/>Please contact your system administrator.<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
					$('#' + licenceCheck).prop('checked', false);
				}
			}	
			});
		}
	});
	// call select check
	
	// check licensing
	$("body").on('change', '#messageboxlicense, #ipcslicense, #navigatesoftphonelicense, #navigatesfblicense, #siplicense, #totalcontrollicense', function() {
		var licenceCheck = $(this).attr('id')
		
		
		if (licenceCheck == 'messageboxlicense') {
			if (this.checked && !$('#voicemailenabled').is(':checked')) {
				var n = noty({ type: 'warning', layout: 'center', text: '<br/>Voicemail Box Not Enabled.<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
				$('#msg_wrap').text('Warning. Voicemail Box Not Enabled')
			} else {
				$('#msg_wrap').text('')
			}
		}
						
		if ( window[licenceCheck] > 0 ) {
			console.log (' licence was already set ');
			return false;
		}
				
		var licenceArray = {'messageboxlicense': 'MessageBox', 'ipcslicense': 'iPCS', 'navigatesoftphonelicense': 'Navigate SoftPhone', 'navigatesfblicense' : 'Navigate Skype for Business Licence', 'siplicense': 'SIP Phone', 'totalcontrollicense': 'Web Portal'};
		if (document.getElementById(licenceCheck).checked) {
			$.ajax({ type: "GET",   
			url: "userActions.php?mode=licenceCheck&licence=" + encodeURIComponent(licenceCheck),   
			async: true,
			success : function(text) {
				console.log(text)
				if (text <= '0') {
					var n = noty({ type: 'error', layout: 'center', text: licenceArray[licenceCheck] + '<br/>Insufficient licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
					$('#' + licenceCheck).prop('checked', false);
				}
			}	
			});
		}
		
	});
	
	$("body").on('change', '#usertype', function() {
		var usertype = $('#usertype :selected').text();
		var usertypevalue = $('#usertype').val();
		
			// if virtual user clear module and device, set options disabled
		if ( usertypevalue == 1 ) {
			
			$('#initialphonemodule').val('clear');
			$("#initialphonemodule > option").each(function() {
				if (this.value != 'clear') $(this).attr('disabled', true);
			});
			$('#initialphone').val('');
			$("#initialphone > option").each(function() {
				$(this).attr('disabled', true);
			});
			
		} else {
			// if not virtual reset module and device, set options enabled
			$('#initialphonemodule, #initialphone').attr('disabled', false);
			
				if (selectediniitalmodule != 'clear') {
					$('#initialphonemodule').val(selectediniitalmodule)
					$('#initialphone').val(selectedinitialdevice)
				}
				
				$("#initialphonemodule > option").each(function() {
					$(this).attr('disabled', false);
				});
				
				$("#initialphone > option").each(function() {
					$(this).attr('disabled', false);
				});
			
		}
		
		
		if ( usertypevalue == usertypelicense ) {
			console.log (' licence was already set ');
			return false;
		}
		
		var licenceArray = {'IP': 'IP User', 'Analogue': 'Analogue User', 'Virtual': 'Virtual User'};
			$.ajax({ type: "GET",   
			url: "userActions.php?mode=licenceCheck&licence=" + encodeURIComponent(usertype),   
			async: true,
			success : function(text) {
				console.log (text)
				if (text <= '0') {
					var n = noty({ type: 'error', layout: 'center', text: licenceArray[usertype] + '<br/>Insufficient licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
					//$('#usertype option[value=0]').prop('selected', 'selected').change();
				}
			}	
			});
	});
	
	
	
	
	
	
	// check licensing
	$("body").on('change', '#navigateoutlooklicense, #operatorconsolelicense', function() {
		var licenceCheck = $(this).attr('id')
		thislicence = $(this).find('option:selected').val();
	
		if ( window[licenceCheck] == thislicence ) {
			console.log (' licence was already set ');
			return false;
		}
		
		var licenceMode = $(this).val()
		var licenceArray = {'navigateoutlooklicense': 'Navigate Outlook', 'operatorconsolelicense': 'Operator Console'};
		if (licenceMode != '0') {
			$.ajax({ type: "GET",   
			url: "userActions.php?mode=licenceCheck&licence=" + encodeURIComponent(licenceCheck),   
			async: true,
			success : function(text) {
				console.log (text)
				if (text <= '0') {
					var n = noty({ type: 'error', layout: 'center', text: licenceArray[licenceCheck] + '<br/>Insufficient licences available<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
					$('#' + licenceCheck).val('0');
				}
			}	
			});
		}
	})
	
	//forwarding
	$('body').on('change', '#followme, #forwardonbusy, #forwardonnoanswer', function() {
		var thisId = $(this).attr('id');
		var thisSelect = thisId + 'toselect';
        var thisTo = thisId + 'to';
		if  ($(this).val() == '0') {	
			$('#' + thisTo).replaceWith('<input name="' + thisTo + '" id="' + thisTo + '" class="smallFields" readonly>');
			$('#' + thisSelect).attr('disabled', true).val($("#" + thisSelect + " option:first").val());
			$('#msg').html(''); 
			$('#msg_wrap').removeClass('error');
		} else {
			$('#' + thisTo).attr('readonly', false);
			$('#' + thisSelect).attr('disabled', false);
		}
	});
	
	// FollowMeTo Select //
	$("body").on('change', '#followmetoselect, #forwardonbusytoselect, #forwardonnoanswertoselect', function(){
		var thisSelect = $(this).attr('id');
        var thisTo = thisSelect.replace('select', '');

		var selected = $(this).val();
		console.log (thisSelect)
		console.log (thisTo)
		
		$('#msg').html(''); 
		$('#msg_wrap').removeClass('error');
		$("#save").prop("disabled",false);
		
		if (selected === '') {
			$('#' + thisTo).replaceWith('<input name="' + thisTo + '" id="' + thisTo + '" class="smallFields" readonly>');
			return false;
		}
	
		if (selected === 'mobile'){
			mobiletelephonenumber = $('#mobiletelephonenumber').val();
			$('#' + thisTo).replaceWith('<input name="' + thisTo + '" id="' + thisTo + '" class="smallFields" value="" readonly>');
			
			if (mobiletelephonenumber.length >= 1) {
				mobiletelephonenumber = mobiletelephonenumber;
				$('#' + thisTo).val(mobiletelephonenumber).attr('disabled', false);
			} else {
				mobiletelephonenumber = "Number not set in user details";
				$('#' + thisTo).attr('readonly', false).addClass('error').val(mobiletelephonenumber).attr('disabled', true);
				$('#msg').html('Mobile Number not set in user details'); 
				$('#msg_wrap').addClass('error');
				$("#save").prop("disabled",true);
			} 
			return false;
		
		} else if (selected === 'home') {
			hometelephonenumber = $('#hometelephonenumber').val();
			$('#' + thisTo).replaceWith('<input name="' + thisTo + '" id="' + thisTo + '" class="smallFields" value="" readonly>');
			
			if (hometelephonenumber.length >= 1) {
				hometelephonenumber = hometelephonenumber;
				$('#' + thisTo).val(hometelephonenumber).attr('disabled', false);
			} else {
				hometelephonenumber = "Number not set in user details";
				$('#' + thisTo).attr('readonly', false).addClass('error').val(hometelephonenumber).attr('disabled', true);
				$('#msg').html('Home Number not set in user details'); 
				$('#msg_wrap').addClass('error');
				$("#save").prop("disabled",true);
			} 
			return false;
			
		} else if (selected === 'other') {
			$('#' + thisTo).replaceWith('<input name="' + thisTo + '" id="' + thisTo + '" class="smallFields" value="" >');
			return false;
			
		} else {
			var currentTele = $('#telephonenumber').val();
			console.log (currentTele)
			$('#' + thisTo).replaceWith("<select id='" + thisTo + "' name='" + thisTo + "'><option></option></select>");
			$.ajax({
				type: "POST", cache: false,
				url: "userActions.php?mode=forwarding&currentTele=" + encodeURIComponent(currentTele) + "&selected=" + encodeURIComponent(selected), 	
				success: function(data) {
					var $el = $("#" + thisTo); $el.empty();
					var values = data.split(',');
					$.each(values, function(key, value) {
						var select = value.split(':')
						$el.append($("<option></option>").attr("value", select[0]).text(select[1]) );
					});
				}
			});
		}
	});
	
	//  User Form Checks //
	
	$("body").on('click', '.closemovegroup', function(evt){
		var rowid = $('#moveRow').val();
		$('#' + rowid).css('background-color','');
		$('#message').hide();
	});
	
	// MOVE ROW speeddial //
	$("body").on('click', '.move', function(evt) {
		moveRowId = $(this).closest('tr').attr('id');
		$('#moveRow').val(moveRowId);
		$('.toggler_row').css('background-color','');
		$('#message').hide();
		
		groupHeadingCount = $('.group_header').length;
	
	if (groupHeadingCount >1) {
		row = $(this).parents("tr:first");
		$(row).css('background-color','#CDE6FF');
		
		$('#SelectGroup').empty();
		$('#SelectGroup').append("<option value=''></option>")

		$('.group_header').each(function(){
			groupHeaderValue = this.value;
			groupHeaderId  = $(this).closest('tr').attr('id');
			$('#SelectGroup').append("<option value='" + groupHeaderId + "'>" + groupHeaderValue + "</option>")
		});
		
		 $("#message").css({
			top: evt.pageY + -5,
			left: evt.pageX + 10
		}).toggle();
	}
        return false;
    });
	
	$("body").on('change', '#SelectGroup', function(e){
		moveRowAfter = this.value		
		console.log ('moveRowAfter = ' + moveRowAfter)	
    
		$('#' + moveRowAfter).after(row)
		grouping(0,row)
		
		$('#message').hide()
		setTimeout(
		function() {
			$(row).removeAttr('style');
		}, 1000);
	})	
	
	// check if vmlicence is applied if vm is enabled
	$("body").on('change', '#voicemailenabled', function() {
		if (this.checked && !$('#messageboxlicense').is(':checked')) {
			var n = noty({ type: 'warning', layout: 'center', text: '<br/>Voicemail is being enabled, but no voicemail box licence is applied.<br/><br/><i>click to close</i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1 });
			$('#msg_wrap').text('Warning. No Voicemail Box Licence Applied')
		} else {
			$('#msg_wrap').text('')
		}
	})
	
});

	function pad (str, max) {
		str = str.toString();
		return str.length < max ? pad("0" + str, max) : str;
	}


	// save and/or edit return values to update table
	function UpdateCode(ret) {  

		var ret = ret.split(',');
		var userMode = ret[0]; 	
		var guid = ret[1]; 
		var name = ret[2];
		var extn = ret[3]; 
		var pnpmodel = ret[4]; 
		var desc = ret[5];
		var disabledState = ret[6]
		var pnptext = pnpmodel.replace('.jpg','');
		
		var state = (disabledState === '0') ? '<img src="../assets/images/success.png">' : '<img src="../assets/images/fail.png">' ;
		var pnpRow = (pnpmodel.indexOf('jpg') >= 0) ?  "<a href='#' class='model'><div class='hover-img'><span><img src='../assets/images/phones/" + pnpmodel + "' alt='image' height='100' /></span></div>" + pnptext + "</a>" : "<a href='#' class='model'>" + pnptext + "</a>";
		
		//var pnpRow = (pnpmodel.length > 0) ?  "<a href='#' class='model'><div class='hover-img'><span><img src='../assets/images/phones/" + pnpmodel + ".jpg' alt='image' height='100' /></span></div>" + pnpmodel + "</a>" : "<a href='#' class='model'>" + pnpmodel + "</a>";

	
	if (ret[0] == 'editUser') {
		$('#users').dataTable().fnUpdate([name] ,$('tr#' + guid)[0], 0, false );
		$('#users').dataTable().fnUpdate([extn] ,$('tr#' + guid)[0], 1, false );
		$('#users').dataTable().fnUpdate([pnpRow] ,$('tr#' + guid)[0], 2, false );
		$('#users').dataTable().fnUpdate([desc] ,$('tr#' + guid)[0], 3, false );
		$('#users').dataTable().fnUpdate([state] ,$('tr#' + guid)[0], 4, false );
	} else if (ret[0] == 'addUser') {
		var addRow = $('#users').dataTable().fnAddData( [name, extn, pnpRow, desc, state ]);
		var newRow = $('#users').dataTable().fnSettings().aoData[addRow[0]].nTr;
		$('#users tr').removeClass("selected");
		newRow.setAttribute('id',guid);
		newRow.setAttribute('class','new selected');
		}
	}
	
	function grouping(table, row) {
		console.log ('moved')
		var row_id = $(row).prop('id');
		var heading = $('#' + row_id).prevAll('.group_heading').eq(0);
		var group_id = heading.attr('data-header').replace('H','');
		var oldGroupId = $('#' + row_id).attr('data-speeddial').replace('G:','');
		if (!$.isNumeric(oldGroupId)) oldGroupId = '';
		var groupId = group_id.replace('G:','');
		if (!$.isNumeric(groupId)) groupId = '';
		$('#' + row_id).attr('data-speeddial',group_id); // update rows data-speeddial group value
		
		var rows = $('tr[data-speeddial=G\\:' + groupId + ']').get();
		var oldRows = $('tr[data-speeddial=G\\:' + oldGroupId + ']').get();
		//current Rows		
		var orderIDs = [];
        for (var i=0; i<rows.length; i++) {
			orderIDs.push(rows[i].id)
        }
	    $.each(orderIDs, function(index, id) {
		var index = index +1;
		$('#' + id).attr('data-order', index)
		var guid = $('#spguid' + id).val();
		var telenum = $('#spnumber' + id).val();
		var description = $('#spdescription' + id).val();
		var orderVal = $('#' + id).attr('data-speeddial') + '-' +$('#' + id).attr('data-order');
		var res = ',' + guid + ',' + telenum + ',' + description + ',' + orderVal;
		console.log ('newrow ' + res)
		speedDials = speedDials.map(function(value) {
		if( value.indexOf(guid) > -1 ) {
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		} return value;
		});
		if ( ($.inArray('edit' + res, speedDials) == -1  && $.inArray('add' + res, speedDials) == -1)   ) {
				speedDials.push('edit' + res)
		}
		})
		//oldRows
		var orderIDs = [];
        for (var i=0; i<oldRows.length; i++) {
			orderIDs.push(oldRows[i].id)
        }
	    $.each(orderIDs, function(index, id) {
		var index = index +1;
		$('#' + id).attr('data-order', index)
		var guid = $('#spguid' + id).val();
		var telenum = $('#spnumber' + id).val();
		var description = $('#spdescription' + id).val();
		var orderVal = $('#' + id).attr('data-speeddial') + '-' +$('#' + id).attr('data-order');
		var res = ',' + guid + ',' + telenum + ',' + description + ',' + orderVal;
		console.log ('oldrow ' + res)
		
		speedDials = speedDials.map(function(value) {
		if( value.indexOf(guid) > -1 ) {
			return (value.indexOf('add') === 0 ? 'add' : 'edit') + res;
		} return value;
		});
		if ( ($.inArray('edit' + res, speedDials) == -1  && $.inArray('add' + res, speedDials) == -1)   ) {
				speedDials.push('edit' + res)
		}
		})
		
		console.log (speedDials)
	}
	
