<?php
session_start();

// v1.10
//PJC 28-AUG-2014 - Initial release
$page_id = "001";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}

$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); 
$info = ldap_get_entries($ds,$sr); 
$self = $info[0]['location'][0];

$sr = ldap_read($ds,"cn=$self,cn=Modules","objectclass=module"); 
$info = ldap_get_entries($ds,$sr); 
$productversion = $info[0]['productversion'][0];


if (strpos($productversion, 'SV') === false) {
	header("Location: /manager/assist");
	exit;
}

	
	$sr = @ldap_search($ds,"cn=Modules","(&(objectclass=module)(moduletype=20))",array('type', 'ipaddress'));
	$count = @ldap_count_entries($ds, $sr); 
	$info = ldap_get_entries($ds,$sr);
	$vision = $visionIp = false;
	
	if ($count != NULL || $count > 0) {
		$vision = true;
		$visionIp = $info[0]['ipaddress'][0];
	}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Bulk Create Departments <?php if ($vision) echo " / Queues" ?></title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="css/jquery-ui.css" rel="stylesheet" type="text/css">
<link href="css/wiz/bulk_departments.css" rel="stylesheet" type="text/css">
<link href="css/colorbox.css" rel="stylesheet"/>
<link href="css/buttons.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">

<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/jquery-ui.min.js" type="text/javascript"></script>
<script src="js/wiz/bulkdepts.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="js/wiz/jq-ajax-progress.min.js"></script>
<script src="js/jquery.colorbox-min.js"></script>


<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_bulk_depts.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Create Bulk Departments <?php if ($vision) echo " / Queues" ?></h2>
This page provides a simple way to create multiple departments <?php if ($vision) echo " / Queues" ?> with the same base settings.<br>
It only allows you to create Vision Queues if it detects a Vision Server in the local module list.<br><br>
A database backup is automatically performed before the departments/queues are created - this can be disabled if required.<br><br>

<table width="80%" align="center">
  <form method="POST" id='bulk'>
	<tr>
	<td width="31%"><b>Select Mode</b></td>
    <td width="69%">
	<select name="mode" id="mode">
		<option value='1'>Department</option>
		<?php
			if ($vision) echo "<option value='2'>Vision Queue</option>";
		?>
	</select>	
	</tr>
	<tr><td style='height:20px;'><hr width='75%'></td></tr>
	
	<tr><td class='modename'><b>Number of Departments:</b></td><td><div id="dept_no"></div></td></tr>
  
  	<tr>
    <td class='modename' width="31%"><b>Department Base Name:</b></td>
    <td width="69%"><input type="text" name="dept_name" id="dept_name" size="20"><span class='modename' style="font-size: 12px"><i> (departments will be named 'Name_001', 'Name_002' )</i></span></td>
  	</tr>
	
    <tr>
    <td class='modename' width="31%"><b>Department Base Number:</b></td>
    <td width="69%"><input type="text" name="dept_number" id="dept_number" size="20"><span class='modename' style="font-size: 12px"><i> (departments will be numbered '??1', '??2' )</i></span></td>
  	</tr>
	
    <tr>
    <td class='modename' width="31%"><b>Department Description:</b></td>
    <td width="69%"><input type="text" name="dept_desc" id="dept_desc" size="20"><span class='modename' style="font-size: 12px"><i> (the same description will be applied to all departments )</i></span></td>
  	</tr>
	</form>
	
	<tr><td colspan='2'><a id='bulknames' class='bulknames'><img src='images/edit.gif'/><span class='modename'> CUSTOMISE DEPARTMENT NAMES AND EXTENSIONS</span></a></td></tr>
	</table>
	
	<form method="POST" id='bulkCustom'>
	<table class='custom header'>
		<thead>
			<th width='150px'>Name</th><th width='150px'>Number</th><th width='150px'>Description</th>
		</thead>
	</table>
	<div class='custom'>
	
	<table width='555px' id='custom'>
			<tbody id='customTb'></tbody>
	</table>
	</div>
	</form>
	
	<form method="POST" id='bulkConfig'>
	<table width="80%" align="center">
	<tr><td><hr width='75%'></td></tr>
	
	<tr>
    <td width="31%"><b>In Hours Time Plan:</b></td>
    <td width="69%"><select name="dept_timeplan" >
    <?php
    $dn = "cn=TimePlans";
	$filter="(objectclass=Timeplan)";
	$sr=ldap_list($ds, $dn, $filter);
    $info = ldap_get_entries($ds, $sr);
	for ($n=0; $n<$info['count']; $n++) {				
		$cn = $info[$n]['cn'][0];$guid = $info[$n]['guid'][0];
		$selected = ($cn == "Standard") ? "selected" : "";
		echo "<option value='$guid' $selected>$cn</option>";	
	}
	?>
	</select><span style="font-size: 12px"> <i>(STANDARD is the default Timeplan)</i></span></td>
  	</tr>
	
  	<tr>
    <td width="31%"><b>Out Of Hours Timed Mode:</b></td>
    <td width="69%"><select name="dept_mode" >
    <option selected value='0'>Not Used</option>
    <option value='1'>Timed</option>
    <option value='2'>Out Of Hours</option>
    <option value='3'>In Hours</option>
    </select>
    </td>
  	</tr>
	
  	<tr>
    <td width="31%"><b>Current Home:</b></td>
    <td width="69%"><select name="dept_home" >
    <?php
    $sr=ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0)(|(moduletype=1)(moduletype=2)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))");
        $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";	
	}
	?>
	</select></td></tr>
	
  	<tr><td><hr width='75%'></td></tr>
	
    <tr>
    <td width="31%"><b>Distribution Group:</b></td>
    <td width="69%"><select name="dept_dist_group" id="dept_dist_group">
    <option value="0"></option>
    <?php
    $sr=ldap_list($ds,"cn=Groups","(objectclass=group)");
        $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";	
	}
	?>
	</select></td></tr>
  	
	<tr>
    <td width="31%"><b>Distribution Mode:</b></td>
    <td width="69%"><select name="dept_dist_mode" id='dept_dist_mode' >
    <option value="0"></option>
	<option value="1">All</option>
	<option value="2">Rotary</option>
	<option value="3">Sequential</option>
	<option value="5" disabled>Manual</option>
    </select></td>
    </tr>
	
	<tr class='queue'>
    <td width="31%"><b>Manual Distribution Mode:</b></td>
    <td width="69%">
	<select name="queue_distributionMode" >
		<option value="0">Longest Idle</option>
		<option value="1">Least Busy</option>
	</select>
	</td>
	
	<tr>
    <td width="31%"><b>Distribution Skip On No Targets:</b></td>
    <td width="69%">
	<input type='checkbox' id='distributionSkipOnNoTargets' name='distributionSkipOnNoTargets'>
	</td>
    
	
	
	<tr><td><hr width='75%'></td></tr>
    	
	<tr><td colspan='2' class="toggler"><img id='showhide' src='images/show.gif'/><img id='showhide' src='images/hide.gif' style='display:none'/> SHOW ALTERNATE ROUTING</td></tr>
	
	<tr class="alt" style="display:none">
  	<td width="31%"><b>Max Ring Time Before Alternate Distribution:</b></td>
    <td width="69%"><input type="text" name="dept_maxalt" size="20" value="0"></td>
  	</tr>
	
    <tr class="alt" style="display:none">
    <td width="31%"><b>Alt Distribution Group:</b></td>
    <td width="69%"><select name="dept_altdist_group" id="dept_altdist_group" >
    <option value="0"></option>
    <?php
    $sr=ldap_list($ds,"cn=Groups","(objectclass=group)");
        $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";	
	}
	?>
	</select></td></tr>

	<tr class="alt" style="display:none">
    <td width="31%"><b>Alt Distribution Mode:</b></td>
    <td width="69%"><select name="dept_altdist_mode" id="dept_altdist_mode" >
	<option value="0"></option>
	<option value="1">All</option>
	<option value="2">Rotary</option>
	<option value="3">Sequential</option>
	<option value="5" disabled>Manual</option>
    </select></td>
    </tr>
	
	<tr class="alt" id='altPri' style="display:none">
  	<td width="31%"><b>Alternate Distribution Priority:</b></td>
    <td width="69%"><input type="text" name="altPri" size="20" value="0"></td>
  	</tr>
	
	<tr class='alt' style="display:none" id='tralternateDistributionSkipOnNoTargets'>
    <td width="31%"><b>Alt Distribution Skip On No Targets:</b></td>
    <td width="69%">
	<input type='checkbox' id='alternateDistributionSkipOnNoTargets' name='alternateDistributionSkipOnNoTargets'>
	</td>
	    
    <tr class="alt" style="display:none"><td><hr width='75%'></td></tr>
	
	<tr class="alt" style="display:none">
    <td width="31%"><b>Max Ring Time Before Alternate Distribution 2:</b></td>
    <td width="69%"><input type="text" name="dept_maxalt2" size="20" value="0"></td>
  	</tr>
	
	<tr class="alt" style="display:none">
    <td width="31%"><b>Alt Distribution Group 2:</b></td>
    <td width="69%"><select name="dept_altdist_group_two"  id="dept_altdist_group_two" >
    <option value="0"></option>
    <?php
    $sr=ldap_list($ds,"cn=Groups","(objectclass=group)");
        $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";	
	}
	?>
	</select></td></tr>
	
	<tr class="alt" style="display:none">
    <td width="31%"><b>Alt Distribution Mode 2:</b></td>
    <td width="69%"><select name="dept_altdist_mode_two" id="dept_altdist_mode_two" >
	<option value="0"></option>
	<option value="1">All</option>
	<option value="2">Rotary</option>
	<option value="3">Sequential</option>
	<option value="5" disabled>Manual</option>
    </select></td>
    </tr>
	
	<tr class="alt" id='altPri2' style="display:none">
  	<td width="31%"><b>Alternate Distribution Priority 2:</b></td>
    <td width="69%"><input type="text" name="altPri2" size="20" value="0"></td>
  	</tr>

    <tr><td><hr width='75%'></td></tr>
	
	<tr class="alt" style="display:none">
    <td width="31%"><b>Out Of Hours Distribution Group:</b></td>
    <td width="69%"><select name="ooh_dist_group"  id="ooh_dist_group" >
    <option value="0"></option>
    <?php
    $sr=ldap_list($ds,"cn=Groups","(objectclass=group)");
        $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {				
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";	
	}
	?>
	</select></td></tr>
	
	<tr class="alt" style="display:none">
    <td width="31%"><b>Out Of Hours Distribution Mode :</b></td>
    <td width="69%"><select name="ooh_dist_mode" id="ooh_dist_mode" >
	<option value="0"></option>
	<option value="1">All</option>
	<option value="2">Rotary</option>
	<option value="3">Sequential</option>
	<option value="5" disabled>Manual</option>
    </select></td>
    </tr>
	
    <tr class="alt" style="display:none"><td><hr width='75%'></td></tr>

	
	
	<tr class='queue'>
    <td width="31%"><b>Announcement Mode:</b></td>
    <td width="69%">
	<select name="queue_announcementmode" id="queue_announcementmode" >
		<option value="0">Normal</option>
		<option value="1">Estimated Time To Answer</option>
		<option value="2">Position in Queue</option>
	</select>
	
	<select name="queue_announcementMedia" id="queue_announcementMedia" style='display: none;width:179px' >
		<option value="0">Text-To-Speech</option>
		<option value="1">Pre-recorded Announcement</option>
	</select>
	</td>
  	</tr>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Default Call Priority:</b></td>
    <td width="69%"><input type="text" name="queue_default_callpriority" size="20" value="0"></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Escalate Priority By:</b></td>
    <td width="69%"><input type="text" name="queue_escalate_priorityby" size="20" value="0"></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Escalate Priority Every:</b></td>
    <td width="69%"><input type="text" name="queue_escalate_priorityevery" size="20" value="0"></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Blacklist On Not Answered Count:</b></td>
    <td width="69%"><input type="text" name="queue_blacklist" size="20" value="0"></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Auto Feed Mode:</b></td>
    <td width="69%">
	<select name="queue_autofeedmode">
		<option value="0">Off</option>
		<option value="1">On</option>
	</select>
	</td>
  	</tr>
	
	<tr class='queue'><td><hr width='75%'></td></tr>
	
  	<tr>
    <td width="31%"><b>Max Ring Time Before Announcement:</b></td>
    <td width="69%"><input type="text" name="dept_maxannounce" size="20" value="0"></td>
  	</tr>
	
  	<tr>
    <td width="31%"><b>Repeat Announcement Time:</b></td>
    <td width="69%"><input type="text" name="dept_repeatannounce" size="20" value="0"></td>
  	</tr>
	
  	<tr class='department'>
    <td width="31%"><b>Max Number Of Active Calls Before Busy:</b></td>
    <td width="69%"><input type="text" name="dept_busy" size="20" value="0"></td>
  	</tr>
	
  	<tr>
    <td width="31%"><b>Wrap Up Time:</b></td>
    <td width="69%"><input type="text" name="dept_wrapup" size="20" value="10"></td>
  	</tr>
	
    <tr>
    <td width="31%"><b>No Answer Time:</b></td>
    <td width="69%"><input type="text" name="dept_noanswer" size="20" value="60"></td>
  	</tr>
	
    <tr><td><hr width='75%'></td></tr>
	<tr><td colspan='2' class="vmtoggler"><img id='vmshowhide' src='images/show.gif'/><img id='vmshowhide' src='images/hide.gif' style='display:none'/> SHOW VOICEMAIL CONFIGURATION</td></tr>
    	
    <tr class="vmail" style="display:none">
    <td width="31%"><b>Max No Answer Time Before Voicemail:</b></td>
    <td width="69%"><input type="text" name="dept_noanswervm" size="20" value="0"></td>
  	</tr>
	
    <tr class="vmail" style="display:none">
    <td width="31%"><b>Out Of Hours Max No Answer Time Before Voicemail:</b></td>
    <td width="69%"><input type="text" name="dept_oohanswervm" size="20" value="0"></td>
  	</tr>
	
	<tr class="vmail" style="display:none">
    <td width="31%"><b>Voicemail Enabled:</b></td>
    <td width="69%"><input type="checkbox" name="dept_vmenabled" id="dept_vmenabled"> <span style="font-size: 12px"><i>(Enable Voicemail - voicemail access code will be set to extension number)</i></span></td>
  	</tr>
	
    <tr class="vmail" style="display:none">
    <td width="31%"><b>Message Box License:</b></td>
    <td width="69%"><input type="checkbox" name="dept_vmbox" id="dept_vmbox"> <span style="font-size: 12px"><i>(Allocate Voicemail Box Licence)</i></span></td>
  	</tr>
  	
	<tr><td><hr width='75%'></td></tr>
	
    <tr class='department'>
    <td width="31%"><b>Call Waiting:</b></td>
    <td width="69%"><select name="dept_callwaiting" >
	<option selected value="0">Disable</option>
	<option  value="1">Enable</option>
	<option  value="2">Phone Tools</option>
	<option  value="3">No Beep</option>
    </select></td>
    </tr>
	
	<tr class='department'><td><hr width='75%'></td></tr>
	
	<?php 
		$lastHost = file_exists('/SpliceCom/Web/download/vision_host') ? file_get_contents('/SpliceCom/Web/download/vision_host') : NULL;	
		$newHost = $_SERVER['SERVER_ADDR'];
	
		if (file_exists('/SpliceCom/Web/download/vision_host') && ($lastHost == $newHost)) {	
	?>
	<tr class='queue'>
    <td colspan ='2'><i>The default MySQL credentials have been set. Please change these if required</i></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server IP Address:</b></td>
    <td width="69%"><input type="text" name="queue_mysqlip" id="queue_mysqlip" <?php if ($vision) echo "value='$visionIp'" ?> size="20"></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server Username:</b></td>
    <td width="69%"><input type="text" name="queue_mysqlusename" size="20" value='tc'></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server Password:</b></td>
    <td width="69%"><input type="password" name="queue_mysqlpassword" value='tc17ps00' size="20"></td>
  	</tr>
	
	<?php } else { ?> 
	
	<tr class='queue'>
    <td width="31%"><b>Vision Server IP Address:</b></td>
    <td width="69%"><input type="text" name="queue_visionip" id="queue_visionip" <?php if ($vision) echo "value='$visionIp'" ?> size="20"></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Vision Server Root Username:</b></td>
    <td width="69%"><input type="text" name="queue_visionusername" size="20" value='splicecom'></td>
  	</tr>
	
	<tr class='queue'>
    <td width="31%"><b>Vision Server Root Password:</b></td>
    <td width="69%"><input type="password" name="queue_visionpassword" size="20"></td>
  	</tr>	
	
	<tr class='queue'>
    <td colspan ='2'><i>The default MySQL credentials have been set. Please change these if required</i></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server IP Address:</b></td>
    <td width="69%"><input type="text" name="queue_mysqlip" id="queue_mysqlip" <?php if ($vision) echo "value='$visionIp'" ?> size="20"></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server Root Username:</b></td>
    <td width="69%"><input type="text" name="queue_mysqlusename" size="20" value='root'></td>
  	</tr>	
	
	<tr class='queue'>
    <td width="31%"><b>Vision MySQL Server Root Password:</b></td>
    <td width="69%"><input type="password" name="queue_mysqlpassword" value='r00t0940' size="20"></td>
  	</tr>
		
	<?php
		}
	?>
	
	<tr class='queue'><td><hr width='75%'></td></tr>

  	<tr>
    <td width="31%"><b><span class='red'>Create System Backup:</span></b></td>
    <td width="69%"><input type="checkbox" name="backup" id="backup" checked> <span style="font-size: 12px"><i>(Untick To Disable System Backup)</i></span></td>
  	</tr>
	
	<input  TYPE="hidden" NAME="update" value="update">
	</table>
	<p align="center"><input type="button" id="create" value="Create Departments"></p></form>

</div>   
</body>  
</html>  


<div class="overlay" id="overlay" style="display:none;">
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            Applying multiple departments or queues to the PBX uses additional resources and could cause system instability.<br><br>
           	We suggest this is only done out of hours or during quiet periods.<br><br>
			Please ensure you <span style="color:#aa0000; font-weight:bold";>backup your Vision MySQL Database</span> before using this script to create queues.<br><br>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
		</div>
</div>

<?php if (!isset($_SESSION['bulk_updates'])) { ?>
<script type="text/javascript">
$(function() {
	$('#overlay').fadeIn('fast',function(){
          $('#alert').animate({'top':'100px'},500);
      });
      $('#alertclose').click(function(){
         	$('#alert').animate({'top':'-600px'},500,function(){
          $('#overlay').fadeOut('fast');
          document.location.href='assist.php';
      	});
      });
      $('#alertOK').click(function(){
      	$.ajax({ url : 'log/reset.php?bulk_updates=1' });
      	$('#alert').animate({'top':'-600px'},500,function(){
      	$('#overlay').fadeOut('fast');
         	});
      });
});
</script>
<?php   } ?>