<?php

	include("includes/JSON.php");
	$mode = (isset($_REQUEST['mode']) && strlen($_REQUEST['mode'] > '0')) ? $_REQUEST['mode'] : exit();
	
	if( !function_exists('json_encode') ) {
		function json_encode($data) {
			$json = new Services_JSON();
			return( $json->encode($data) );
		}
	}
	// Future-friendly json_decode
	if( !function_exists('json_decode') ) {
		function json_decode($data) {
			$json = new Services_JSON();
			return( $json->decode($data) );
		}
	}
	
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		die ("Error: LDAP connect failure");
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			die("Error: LDAP bind failure");
			$ds = false;
		}
	}

if (isset($_REQUEST['update']) && $_REQUEST['update'] === 'update') {
	
	// LDAP BACKUP
	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
		$backup = "Backup ".date('d.m.y His')." - PreBulkDepartmentsAdd.txt";
		$ent["dobackupto"][0] = $backup;
		ldap_modify($ds,"cn=Commands", $ent);
		ldap_modify($ds,"cn=Commands", $ent); $ent='';
		sleep (5);
	}
	
	$custom_name = $custom_number = $custom_desc = array();
	$mode = 						(isset($_REQUEST['mode']) && strlen($_REQUEST['mode']) > 0) 									? $_REQUEST['mode'] 					: NULL;
	$dept_no = 						(isset($_REQUEST["dept_no"]) && strlen($_REQUEST["dept_no"]) > 0) 								? $_REQUEST["dept_no"] 					: NULL;
	$custom_name =					(isset($_REQUEST["custom_name"]) && count($_REQUEST["custom_name"]) > 0) 						? $_REQUEST["custom_name"] 				: NULL;
	$custom_number = 				(isset($_REQUEST["custom_num"]) && count($_REQUEST["custom_num"]) > 0) 							? $_REQUEST["custom_num"] 			: NULL;
	$custom_desc = 					(isset($_REQUEST["custom_desc"]) && count($_REQUEST["custom_desc"]) > 0) 						? $_REQUEST["custom_desc"]				: NULL;
	$dept_home = 					(isset($_REQUEST["dept_home"]) && strlen($_REQUEST["dept_home"]) > 0)							? $_REQUEST["dept_home"]				: NULL;
	$dept_dist_group = 				(isset($_REQUEST["dept_dist_group"]) && strlen($_REQUEST["dept_dist_group"]) > 0) 				? $_REQUEST["dept_dist_group"] 			: NULL; 
	$dept_dist_mode = 				(isset($_REQUEST["dept_dist_mode"]) && strlen($_REQUEST["dept_dist_mode"]) > 0)					? $_REQUEST["dept_dist_mode"]			: NULL;
	$dept_altdist_group = 			(isset($_REQUEST["dept_altdist_group"]) && strlen($_REQUEST["dept_altdist_group"]) > 0)			? $_REQUEST["dept_altdist_group"]		: NULL;
	$dept_altdist_mode = 			(isset($_REQUEST["dept_altdist_mode"]) && strlen($_REQUEST["dept_altdist_mode"]) > 0)			? $_REQUEST["dept_altdist_mode"]		: NULL;
	$dept_altdist_group_two = 		(isset($_REQUEST["dept_altdist_group_two"]) && strlen($_REQUEST["dept_altdist_group_two"]) > 0)	? $_REQUEST["dept_altdist_group_two"]	: NULL;
	$dept_altdist_mode_two = 		(isset($_REQUEST["dept_altdist_mode_two"]) && strlen($_REQUEST["dept_altdist_mode_two"]) > 0)	? $_REQUEST["dept_altdist_mode_two"]	: NULL;
	$dept_maxalt = 					(isset($_REQUEST["dept_maxalt"]) && strlen($_REQUEST["dept_maxalt"]) > 0)						? $_REQUEST["dept_maxalt"]				: NULL;
	$dept_maxalt2 = 				(isset($_REQUEST["dept_maxalt2"]) && strlen($_REQUEST["dept_maxalt2"]) > 0)						? $_REQUEST["dept_maxalt2"]				: NULL;
	$dept_wrapup = 					(isset($_REQUEST["dept_wrapup"]) && strlen($_REQUEST["dept_wrapup"]) > 0)						? $_REQUEST["dept_wrapup"]				: NULL;
	$dept_noanswer = 				(isset($_REQUEST["dept_noanswer"]) && strlen($_REQUEST["dept_noanswer"]) > 0)					? $_REQUEST["dept_noanswer"]			: NULL;
	$dept_noanswervm = 				(isset($_REQUEST["dept_noanswervm"]) && strlen($_REQUEST["dept_noanswervm"]) > 0)				? $_REQUEST["dept_noanswervm"]			: NULL;
	$dept_oohanswervm = 			(isset($_REQUEST["dept_oohanswervm"]) && strlen($_REQUEST["dept_oohanswervm"]) > 0)				? $_REQUEST["dept_oohanswervm"]			: NULL;
	$dept_vmenabled = 				(isset($_REQUEST["dept_vmenabled"]) && $_REQUEST["dept_vmenabled"] == 'on')						? '1'									: '0';
	$dept_vmbox = 					(isset($_REQUEST["dept_vmbox"]) && $_REQUEST["dept_vmbox"] === 'on')							? '1'									: '0';
	$altPri = 						(isset($_REQUEST["altPri"]) && strlen($_REQUEST["altPri"]) > 0)									? $_REQUEST["altPri"]					: NULL;
	$altPri2 = 						(isset($_REQUEST["altPri2"]) && strlen($_REQUEST["altPri2"]) > 0)								? $_REQUEST["altPri2"]					: NULL;
	$ooh_dist_group = 				(isset($_REQUEST["ooh_dist_group"]) && strlen($_REQUEST["ooh_dist_group"]) > 0)					? $_REQUEST["ooh_dist_group"]			: NULL;
	$ooh_dist_mode = 				(isset($_REQUEST["ooh_dist_mode"]) && strlen($_REQUEST["ooh_dist_mode"]) > 0)					? $_REQUEST["ooh_dist_mode"]			: NULL;
	
	$distributionSkipOnNoTargets =  (isset($_REQUEST["distributionSkipOnNoTargets"]) && $_REQUEST["distributionSkipOnNoTargets"] == 'on')	? '1' : '0';
	$alternateDistributionSkipOnNoTargets =  (isset($_REQUEST["alternateDistributionSkipOnNoTargets"]) && $_REQUEST["alternateDistributionSkipOnNoTargets"] == 'on')	? '1' : '0';

	
if ($mode === '1') { //department                                                                                                                                           
	$dept_mode = 					(isset($_REQUEST["dept_mode"]) && strlen($_REQUEST["dept_mode"]) > 0)							? $_REQUEST["dept_mode"]				: NULL;
	$dept_timeplan = 				(isset($_REQUEST["dept_timeplan"]) && strlen($_REQUEST["dept_timeplan"]) > 0)					? $_REQUEST["dept_timeplan"]			: NULL;
	$dept_maxannounce = 			(isset($_REQUEST["dept_maxannounce"]) && strlen($_REQUEST["dept_maxannounce"]) > 0)				? $_REQUEST["dept_maxannounce"]			: NULL;
	$dept_repeatannounce = 			(isset($_REQUEST["dept_repeatannounce"]) && strlen($_REQUEST["dept_repeatannounce"]) > 0)		? $_REQUEST["dept_repeatannounce"]		: NULL;
	$dept_busy = 					(isset($_REQUEST["dept_busy"]) && strlen($_REQUEST["dept_busy"]) > 0)							? $_REQUEST["dept_busy"]				: NULL;
	$dept_callwaiting = 			(isset($_REQUEST["dept_callwaiting"]) && strlen($_REQUEST["dept_callwaiting"]) > 0)				? $_REQUEST["dept_callwaiting"]			: NULL;

	//for($i=1; $i<=$dept_no; $i=$i+1) {
	foreach ($custom_name as $k => $v) {
		//$num = sprintf('%03d', $i-1);
		$number = $custom_number[$k]; 
		$cn = $v;
		$random_vmCode = mt_rand(100000, 999999);

	
        $att=array('objectclass'=>'Department', 'GUID'=>'00000000-0000-0000-0000-000000000000', 'cn'=>$cn, 'telephonenumber'=>$number, 'description'=>$custom_desc[$k], 'outofhoursmode'=>$dept_mode, 
		'distributiongroup'=>$dept_dist_group, 'distributionmode'=>$dept_dist_mode, 'alternatedistributiongroup'=>$dept_altdist_group, 'alternatedistributionmode'=>$dept_altdist_mode, 
		'alternatedistributiongroup2'=>$dept_altdist_group_two, 'alternatedistributionmode2'=>$dept_altdist_mode_two, 'timeplan'=>$dept_timeplan, 'currenthome'=>$dept_home, 'maxRingBeforeAnnouncementTime'=>$dept_maxannounce, 
		'repeatAnnouncementTime'=>$dept_repeatannounce, 'maxRingBeforeAlternateDistributionTime'=>$dept_maxalt, 'maxRingBeforeAlternateDistributionTime2'=>$dept_maxalt2, 'maxNumberOfActiveCallsBeforeBusy'=>$dept_busy, 
		'wrapUpTime'=>$dept_wrapup, 'noAnswerTime'=>$dept_noanswer, 'maxNoAnswerTimeBeforeVoicemail'=>$dept_noanswervm, 'maxNoAnswerTimeBeforeVoicemailOOH'=>$dept_oohanswervm, 'callWaiting'=>$dept_callwaiting, 
		'voicemailEnabled'=>$dept_vmenabled, 'voicemailAccessCode'=>$random_vmCode, 'messageBoxLicense'=>$dept_vmbox, 'outOfHoursDistributionGroup'=>$ooh_dist_group, 'outOfHoursDistributionMode'=>$ooh_dist_mode, 
		'distributionSkipOnNoTargets'=>$distributionSkipOnNoTargets, 'alternateDistributionSkipOnNoTargets'=>$alternateDistributionSkipOnNoTargets);
      		  
        ldap_add($ds,"cn=$cn,cn=Departments",$att);
		ob_flush(); flush();
		echo "$cn";
		ob_flush(); flush();
		usleep(50000);
  	}
	ldap_close($ds);
	echo "<br><br><i>(Click to Close Window)</i><br><br>";
}

if ($mode === '2') { // queue
	include('includes/Net/SSH2.php');

	//CHECK IF HOST HAS BEEN ADDED
	$lastHost = file_exists('/SpliceCom/Web/download/vision_host') ? file_get_contents('/SpliceCom/Web/download/vision_host') : NULL;	
	$newHost = $_SERVER['SERVER_ADDR'];
	
	if (!file_exists('/SpliceCom/Web/download/vision_host') || $lastHost != $newHost) {	
	
	$queue_visionip = 		(isset($_REQUEST["queue_visionip"]) && strlen($_REQUEST["queue_visionip"]) > 0)				? $_REQUEST["queue_visionip"]		: NULL;
	$queue_visionusername = (isset($_REQUEST["queue_visionusername"]) && strlen($_REQUEST["queue_visionusername"]) > 0)	? $_REQUEST["queue_visionusername"]	: NULL;
	$queue_visionpassword = (isset($_REQUEST["queue_visionpassword"]) && strlen($_REQUEST["queue_visionpassword"]) > 0)	? $_REQUEST["queue_visionpassword"]	: NULL;
	
	//SSH CONNECTION
	$ssh = new Net_SSH2($queue_visionip);
	if (!$ssh->login($queue_visionusername, $queue_visionpassword)) {
			die('Error: SSH Connection Failure<br>Please check your Vision Server Root username and password');
	} else {
			echo "Successfully Connected to Vision<br>";
	}	
	
	//CHECK VISION IS RUNNING
	$visionPid = $ssh->exec('pidof visiond');
	if ($visionPid < 1 ) die('Error: Vision Not Running<br>Please ensure Vision is running before using this script');
	
	$queue_mysqlusename = 	(isset($_REQUEST["queue_mysqlusename"]) && strlen($_REQUEST["queue_mysqlusename"]) > 0)		? $_REQUEST["queue_mysqlusename"]	: NULL;
	$queue_mysqlpassword = 	(isset($_REQUEST["queue_mysqlpassword"]) && strlen($_REQUEST["queue_mysqlpassword"]) > 0)	? $_REQUEST["queue_mysqlpassword"]	: NULL;	
		
	echo "Running MySQL Host Update<br>";
		
		//ADD TO  MYSQL HOST
		$hostRes =  $ssh->exec('mysql -u '. $queue_mysqlusename .' -p'. $queue_mysqlpassword .' TC_splicecom  -e "grant all privileges on TC_splicecom.* to \'tc\'@\''.$newHost.'\' identified by \'tc17ps00\';"');		
		
		if(preg_match("/(ERROR|fail|denied)/i", $hostRes)){
			die('<br>Error: MySQL Host Update failed<br>Please check your MySQL access credentials');
		}

		
		$fh = fopen('/SpliceCom/Web/download/vision_host', 'w+') or die("Error: Can't open file<br>vision hostfile found, but unable to open");
		fwrite($fh, $newHost);
		chmod('/SpliceCom/Web/download/vision_host', 0777);
		fclose($fh);
		
		//SSH DISCONNECT
		$ssh->disconnect();	
	}	
	
	
	
	
	//MAKE CONNECTION TO DATABASE
	//SERVER & MYSQL
	$queue_mysqlip = (isset($_REQUEST["queue_mysqlip"]) && strlen($_REQUEST["queue_mysqlip"]) > 0)	? $_REQUEST["queue_mysqlip"]: NULL;
	
	if ($queue_mysqlip) {
		$db = new mysqli($queue_mysqlip, 'tc', 'tc17ps00', 'TC_splicecom');
		if($db->connect_errno > 0){
			die('Error: Unable to connect to MySQL database [' . $db->connect_error . ']');
		}
		
		//QUEUE VALUES
		$queue_default_callpriority =	(isset($_REQUEST["queue_default_callpriority"]) && strlen($_REQUEST["queue_default_callpriority"]) > 0)		? $_REQUEST["queue_default_callpriority"]		: NULL;
		$queue_escalate_priorityby = 	(isset($_REQUEST["queue_escalate_priorityby"]) && strlen($_REQUEST["queue_escalate_priorityby"]) > 0)		? $_REQUEST["queue_escalate_priorityby"]		: NULL;
		$queue_escalate_priorityevery = (isset($_REQUEST["queue_escalate_priorityevery"]) && strlen($_REQUEST["queue_escalate_priorityevery"]) > 0)	? $_REQUEST["queue_escalate_priorityevery"]		: NULL;
		$queue_blacklist = 				(isset($_REQUEST["queue_blacklist"]) && strlen($_REQUEST["queue_blacklist"]) > 0)							? $_REQUEST["queue_blacklist"]					: NULL;
		$queue_announcementmode =		(isset($_REQUEST["queue_announcementmode"]) && strlen($_REQUEST["queue_announcementmode"]) > 0)				? $_REQUEST["queue_announcementmode"]			: NULL;
		$queue_announcementMedia = 		(isset($_REQUEST["queue_announcementMedia"]) && strlen($_REQUEST["queue_announcementMedia"]) > 0)			? $_REQUEST["queue_announcementMedia"]			: NULL;
		$queue_autofeedmode = 			(isset($_REQUEST["queue_autofeedmode"]) && strlen($_REQUEST["queue_autofeedmode"]) > 0)						? $_REQUEST["queue_autofeedmode"]				: NULL;
		$queue_distributionMode = 		(isset($_REQUEST["queue_distributionMode"]) && strlen($_REQUEST["queue_distributionMode"]) > 0)				? $_REQUEST["queue_distributionMode"]			: NULL;
		
		
		//START LOOP
		//for($i=1; $i<=$dept_no; $i=$i+1) {
		foreach ($custom_name as $k => $v) {
		//um = sprintf('%03d', $i-1);
		$number = $custom_number[$k]; 
		$cn = $v;
		$random_vmCode = mt_rand(100000, 999999);

		
			$att=array('objectclass'=>'Department', 'GUID'=>'00000000-0000-0000-0000-000000000000', 'cn'=>$cn, 'telephonenumber'=>$number, 'description'=>$custom_desc[$k], 'distributiongroup'=>$dept_dist_group, 
			'distributionmode'=>$dept_dist_mode, 'alternatedistributiongroup'=>$dept_altdist_group, 'alternatedistributionmode'=>$dept_altdist_mode, 'alternatedistributiongroup2'=>$dept_altdist_group_two, 
			'alternatedistributionmode2'=>$dept_altdist_mode_two, 'maxRingBeforeAlternateDistributionTime'=>$dept_maxalt, 'maxRingBeforeAlternateDistributionTime2'=>$dept_maxalt2, 'currenthome'=>$dept_home, 
			'wrapUpTime'=>$dept_wrapup, 'noAnswerTime'=>$dept_noanswer, 'maxNoAnswerTimeBeforeVoicemail'=>$dept_noanswervm, 'maxNoAnswerTimeBeforeVoicemailOOH'=>$dept_oohanswervm,	'voicemailEnabled'=>$dept_vmenabled, 
			'voicemailAccessCode'=>$random_vmCode, 'messageBoxLicense'=>$dept_vmbox);      		  
			
			//LDAP ADD DEPARTMENT
			ldap_add($ds,"cn=$cn,cn=Departments",$att);
			$sr = ldap_read($ds,"cn=$cn,cn=Departments","objectclass=department"); $info = ldap_get_entries($ds,$sr); $deptGuid = $info[0]['guid'][0];
		
			$sql = "INSERT INTO CallCentreQueue ( id, customerId, queueName, queueNumber, queueGuid, priority, escalatePriority, escalatePeriod, announcementMode, announcementMedia, autoFeedMode, distributionMode, averageAnswerTime, alternatePriority, alternatePriority2, blacklistMaxNotAnswered )" .  
				"VALUES (NULL, '1', '$cn', '$number', '$deptGuid', '$queue_default_callpriority', '$queue_escalate_priorityby', '$queue_escalate_priorityevery', '$queue_announcementmode', '$queue_announcementMedia', '$queue_autofeedmode', '$queue_distributionMode', '0', '$altPri', '$altPri2', '$queue_blacklist' );";
			
			// UPDATE MYSQL
			if(!$result = $db->query($sql)){
				die('Error: There was an error running the MySQL query [' . $db->error . ']');
			} else {
				if ($db->sqlstate === '00000') {
					ob_flush(); flush();
					echo "$cn";
					ob_flush(); flush();
					usleep(100000);
				}
			}
		}
		
		//UPDATE QUEUES
		$sql  = "INSERT INTO CallCentreCommand SET customerId=1, command='UPDATEQUEUES'";
		if(!$result = $db->query($sql)){
			die('Error: There was an error running the UpdateQueues MySQL query [' . $db->error . ']');
		}
		ldap_close($ds);
		$db->close();

	} else {
		die('Error: MySQL Server IP Address not set');
	}

}

} //update


if ($mode === 'existingmembers') { // get all cn
	$existing = array();
	
	$sr=ldap_list($ds,"cn=users","(objectclass=user)", array('cn','telephonenumber'));
		$info = ldap_get_entries($ds, $sr);
		for ($m=0; $m<$info['count']; $m++) {
		$existing[] = strtolower($info[$m]['cn'][0]); 
		$existing[] = $info[$m]['telephonenumber'][0];
	}
	
	$sr=ldap_list($ds,"cn=departments","(objectclass=department)", array('cn','telephonenumber'));
		$info = ldap_get_entries($ds, $sr);
		for ($m=0; $m<$info['count']; $m++) {
		$existing[] = strtolower($info[$m]['cn'][0]); 
		$existing[] = $info[$m]['telephonenumber'][0];
	}
	
	$results = array_keys(array_flip($existing)); 
	echo json_encode($results);
}
?>
