<?php
// PJC 15-APR-2019 SoftPBX Wording
// PJC 06-DEC-2018 Route SuSE15, updated softPBX PHP Version check
// PJC 24-SEP-2018 Updated 5100/SoftPBX
// PJC 01-MAY-2018 Updated how subnet mask is read
// PJC 24-JAN-2017 remove unused $url
// PJC 20-FEB-2015 - Default Gateway Update - Add new classes for button status
include "tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);

?>
<html>
<head>
<title>Connectivity</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(document).ready(function() {
	
	var dnsTick = function() {
		$('#dnsStatus').html('DNS Connection Timeout');
        $("#testDns").css('backgroundColor', '#FF0000'); 
        $('#dnsImg').hide();
    }
	
	$("#testDns").click(function () {
		if ($('#dnsserver').val().length <1) {
			$("#testDns").css('backgroundColor', '#FF0000');
			$("#dnsStatus").html("<span style='color:red'>No DNS Servers Configured</span>");
			return false;
		}
		$('#dnsImg').show();
        var loadTimeout = setTimeout(dnsTick, 10100);
		var dns = ( $("#dnsaddress").val().length > 1 ) ? $("#dnsaddress").val() : 'bbc.co.uk';
		var link = 'connect.php?dns='+ dns +'&server=' + $("#dnsserver").val();
		$.ajax({
	    	url: link,
	    	timeout: 10000,
        	success: function(data, textStatus, xhr) {
			var dnsStatus = (data == '1') ? 'DNS resolution successful' : data;
			$('#dnsStatus').html(dnsStatus); 
			var dnsBtnStatus = (data == '1') ? 'valid' : 'fail';
		    $('#testDns').addClass(dnsBtnStatus);
			clearTimeout(loadTimeout); $('#dnsImg').hide(); } });
	});
	
	$("#emailserver").on('change', function() {
		var mode = $(this).val().split(';'); // 0 = voicemailport 1 =  module
		var link = (mode[0] == '0') ? 'connect.php?vmemail='+ mode[1] : 'connect.php?csemail='+ mode[1];
		
		 if(typeof mode[1] === 'undefined'){
			$('#sourcename').html('');
			$('#sourceaddress').html('');
			$('#hostaddress').html('');
			return false;
		}
		
		$.ajax({
	    	url: link,
        	success: function(data, textStatus, xhr) {
			var vmvalues = data.split(';');
			$('#sourcename').html(vmvalues[2]);
			$('#sourceaddress').html(vmvalues[1]);
			$('#hostaddress').html(vmvalues[0]);  } });
		
	});
	
	$("#testEmail").click(function () {
		if ( $("#emailserver").val().length < 1 ) { alert('Please select a valid email server'); return false; }
		if ( $("#emailaddress").val().length < 5 ) { alert('Please enter a valid email address'); return false; }
		$('#emailImg').show(); 
		
		var mode = $("#emailserver").val().split(';'); // 0 = voicemailport 1 =   module
		var link = (mode[0] == '0') ? 'connect.php?email=' + $("#emailaddress").val() + '&server=' + mode[1] + '&type=0' : 'connect.php?email=' + $("#emailaddress").val() + '&server=' + mode[1] + '&type=1';
		$.ajax({
	    	url: link,
        	success: function(data, textStatus, xhr) {
				console.log (data)
	        if (data == "1") {
				$('#emailStatus').html('Email to: <b>' + $("#emailaddress").val() + '</b> successfully sent');
				$("#testEmail").addClass('valid');
	        } else {
		        $("#testEmail").addClass('fail');
		        $('#emailStatus').html(data);
	        } 	$('#emailImg').hide(); } });
	});
	
	$("#testFtp").click(function () {
		$('#ftpImg').show();  
		var link = 'connect.php?ftp='+ $("#ftpserver").val() + '&username=' + $("#ftpusername").val() + '&password=' + $("#ftppassword").val();
		$.ajax({
	    	url: link,
        	success: function(data, textStatus, xhr) {
			var ftpPasswd = $("#ftppassword").val();
			data = data.replace("PASS "+ftpPasswd, 'PASS ******');
			$('#ftpStatus').html(data); 
			var ftpBtnStatus = ( data.indexOf('230') !== -1 ) ? 'valid' : 'fail';
			$("#testFtp").addClass(ftpBtnStatus);
			$('#ftpImg').hide(); } });
	});
	
	$("#testkeepAlive").click(function () {
		$('#keepAliveImg').show();  
		var link = 'connect.php?keepalive='+ $("#keepAliveServer").val();
		$.ajax({
	    	url: link,
        	success: function(data, textStatus, xhr) {
			var keepAliveStatus = (data == '1') ? 'Keep Alive Connection Successful' : data;
			$('#keepAliveStatus').html(keepAliveStatus); 
			var keepAliveBtnStatus = (data == '1') ? 'valid' : 'fail';
			$("#testkeepAlive").addClass(keepAliveBtnStatus);
			$('#keepAliveImg').hide(); } });
	});
});	
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_connectivity.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<?php

$lines = file('/etc/resolv.conf'); $dns='';
foreach ($lines as $line_num => $line) {
	if(strstr($line,'nameserver')) $dns .=str_replace("nameserver","",$line);
} 
$dns = trim($dns);
$dns = explode(" ",$dns);
$dnsPrimary = isset($dns[0]) ? trim($dns[0]) : 'Not Set';
$dnsSecondary = isset($dns[1]) ? trim($dns[1]) : NULL;

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");

		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	$modules = array('','CallServer 4100','Trunk Module','Phone Module 4315','Phone Module 4330','','','VoIP','4400','','CallServer 4140','CallServer 5100','CallServer 5108','Phone Module 5330','Phone Module 5315','','','SoftPBX Linux','SoftPBX Apple','Network Services Gateway','Vision');
	$sr=ldap_read($ds, "cn=System", "(objectclass=*)", array('description','administrationdomain','supplier'));
    $info = ldap_get_entries($ds, $sr);
    	for ($n=0; $n<$info['count']; $n++) {
			$desc = $info[$n]['description'][0]; $admin = $info[$n]['administrationdomain'][0]; $supp = $info[$n]['supplier'][0];
		}

	$sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $loc = $info[0]['location'][0];
    $sr = ldap_list($ds,"cn=Modules","(&(objectclass=*)(guid=".$loc."))",array('ipaddress','moduletype','productversion','serialnumber','location')); 
    $info = ldap_get_entries($ds,$sr); $dn = $info[0]['dn']; $ip = $info[0]['ipaddress'][0]; $mod = $info[0]['moduletype'][0]; $serial = $info[0]['serialnumber'][0]; $ver = $info[0]['productversion'][0];
    
    $sr = ldap_read($ds,"cn=1,{$dn}","(objectclass=*)",array('cn'));
    $info = ldap_get_entries($ds,$sr);
    for ($n=0; $n<$info['count']; $n++) {
		$cn[] = $info[$n]['cn'][0]; 
	}
	
	
	
	if (file_exists('/SpliceCom/model')) {
		$sr = ldap_read($ds,"cn=1,{$dn}","(objectclass=*)",array('cn','dhcpBaseMask'));
		$info = ldap_get_entries($ds,$sr);
		for ($n=0; $n<$info['count']; $n++) {
			$cn[] = $info[$n]['cn'][0]; 
			$dhcpBasemask = $info[$n]['dhcpbasemask'][0]; 
		}
	} else {	
		$cmd = "ip route | awk 'NR==2{print $1}'";
		exec($cmd, $dfBase);
		$dfBaseParts = explode('/',$dfBase[0]);
		$dhcpBasemask = createNetmaskAddr($dfBaseParts[1]) . "  <i>($dfBaseParts[1])</i>";
	}
	
	$cmd = "ip route get 8.8.8.8 | awk '/via/ {f=NR} f&&NR-1==f' RS=' '";
	exec($cmd, $dfGateway);

	if (isset($dfGateway) && count($dfGateway) >=1) {
		if (count($dfGateway) == "1") {
			$dfGateway = $dfGateway[0];
		}
		elseif (array_is_unique($dfGateway)) {
			$dfGateway = "<span class='red'>Multiple Different Default Addresses Set</span>";
		} else {
			$dfGateway = $dfGateway[0];
		}	
	} else {
		$dfGateway = "No Default Gateway Set";
	}

    $sr=ldap_search($ds,"cn=voicemailports","(&(objectclass=voicemailport)(location=$loc))",array('emailsmarthost','cn','guid'));
   	$info2 = ldap_get_entries($ds, $sr);
	for ($n=0; $n<$info2['count']; $n++) {
		$cn[] = $info2[$n]['cn'][0]; 
		$guid[] = $info2[$n]['guid'][0];
		$emailsmarthost[] = $info2[$n]['emailsmarthost'][0];
	}

	$sr=ldap_search($ds,$dn,"(objectclass=administrationmodule)",array('smtpserver','dn','guid'));
   	$info3 = ldap_get_entries($ds, $sr);
	for ($n=0; $n<$info3['count']; $n++) {
		$smtpdn = $info3[$n]['dn']; 
		$smtp = explode(",",$smtpdn);
		$smtpcn[] = str_replace("cn=","",$smtp[1]);
		$smtpguid[] = $info3[$n]['guid'][0];
		$smtpserver[] = $info3[$n]['smtpserver'][0];
	}
	
	function array_is_unique($array) {
   		return array_unique($array) == $array;
	}
	
	
	function createNetmaskAddr ($cidr_mask) {
	
		$bin = ''; 
		for($i=1;$i<=32;$i++) { 
			$bin .= $cidr_mask >= $i ? '1' : '0'; 
		} 
		$netmask = bindec($bin); 
		return long2ip($netmask);
	}
?>
<div id="contain">
	<h2><img src='images/ok.png' style="vertical-align:middle;">&nbsp;Connectivity</h2>
	
	<fieldset style="border: 1px dashed" id="system"><legend style="color: #A0A0A0"><b>System :</b></legend>
	<table style="text-align: left;" border='0'>
	<tr><td width='150px'><b>System</b></td><td><?php echo $admin ?></td></tr>
	<tr><td width='150px'><b>Description</b></td><td><?php echo $desc ?></td></tr>
	<tr><td width='150px'><b>Supplier</b></td><td><?php echo $supp ?></td></tr>
	<tr><td width='150px'><b>Module</b></td><td><?php echo "{$modules[$mod]} ({$serial}) - {$ver}"; ?></td></tr>
	</table></fieldset></br>
	
	<fieldset style="border: 1px dashed" id="network"><legend style="color: #A0A0A0"><b>Network :</b></legend>
	<table style="text-align: left;" border='0'>
	
	<tr><td width='150px'><b>IP Address</b></td><td width="300px"><?php echo $ip ?></td>
	<td width='150px'><b>DNS Primary</b></td><td><?php echo $dnsPrimary; ?></td></tr>
	
	<tr><td width='150px'><b>Subnet Mask</b></td width="300px"><td><?php echo $dhcpBasemask ?></td>
	<td width='150px'><b>DNS Secondary</b></td><td><?php echo $dnsSecondary; ?></td></tr>
	
	<tr><td width='150px'><b>Default Gateway</b></td><td width="300px"><?php echo $dfGateway ?></td>
	<td width='150px'><b>DNS Resolution</b></td><td id='dns' name='dns'><input type='text' id='dnsaddress' value='bbc.co.uk'>
	<select name='dnsserver' id='dnsserver'>
	<?php if (isset($dnsPrimary)) echo "<option value='$dnsPrimary'>$dnsPrimary</option>"; ?>
	<?php if (isset($dnsSecondary)) echo "<option value='$dnsSecondary'>$dnsSecondary</option>"; ?>
	</select>
	<input type='submit' value='Test DNS' id='testDns'><span id='dnsImg' style='display: none;'><img src='images/ajax-loader.gif'/></span></td></tr>
	
	</table><div id='dnsStatus'></div></fieldset></br>
	
	
	<?php 
		$keepAliveCheck = (substr(phpversion(),0,1) >= "5") ? '' : 'disabled';
	?> 
	
	<fieldset style="border: 1px dashed" id="keepAlive"><legend style="color: #A0A0A0"><b>KeepAlive :</b></legend>
	<table style="text-align: left;" border='0'>
	<tr>
	<td width='150px'><b>Server</b></td>
	<td width='300px'><input type='text' id='keepAliveServer' name='keepAliveServer' value='https://validate.splicecom.com' size='30' <?php echo $keepAliveCheck ?> /></td>
	</tr>
	<tr>
	<td width='150px'></td><td width="300px"><input type='submit' value='Test KeepAlive' id='testkeepAlive' <?php echo $keepAliveCheck ?> ><span id='keepAliveImg' style='display: none;'><img src='images/ajax-loader.gif'/></span></td>
	</tr>
	</table>
	<div id='keepAliveStatus'></div>
	</fieldset></br>
	
	
	<fieldset style="border: 1px dashed" id="network"><legend style="color: #A0A0A0"><b>Email :</b></legend>
	<table style="text-align: left;" border='0'>
	<tr><td width='150px'><b>Email Server</b></td>

	<?php

	echo "<td width='300px'><select id='emailserver' name='emailserver'><option></option><optgroup label='Voicemail Ports'>";
			foreach ($emailsmarthost as $key => $value){
   		   	if (strlen($value)>1) echo "<option value='0;$guid[$key]'>$cn[$key] ($value)</option>";
			}
	echo "<option></option><optgroup label='Modules'>";
			foreach ($smtpserver as $smtpkey => $smtpvalue){
   		   	if (strlen($smtpvalue)>1) echo "<option value='1;$smtpguid[$smtpkey]'>$smtpcn[$smtpkey] - ($smtpvalue)</option>";
			}
	echo "</select></td>";
	?>	
		
	<td width='150px'><b>Source Name</b></td><td id='sourcename'></td>
	</tr>
	
	<tr>
	<td width='150px'></td><td width="300px"></td>
	<td width='150px'><b>Source Address</b></td><td id='sourceaddress'></td>
	</tr>
	
	<tr>
	<td width='150px'><b>Test Address</b></td><td id='email' name='email'><input type='text' id='emailaddress'><input type='submit' value='Test Email' id='testEmail'><span id='emailImg' style='display: none;'><img src='images/ajax-loader.gif'/></span></td>
	<td width='150px'><b>Smart Host Address</b></td><td width="300px" id='hostaddress'></td>
	</tr>
	</table><div id='emailStatus'></div></fieldset></br>

	<fieldset style="border: 1px dashed" id="ftp"><legend style="color: #A0A0A0"><b>FTP :</b></legend>
	<table style="text-align: left;" border='0'>
	<tr>
	<td width='150px'><b>FTP Server</b></td>
	<td width='300px'><input type='text' id='ftpserver' name='ftpserver'/></td>
	<td width='150px'><b>Username</b></td><td><input type='text' id='ftpusername'></td>	
	</tr>
	<tr>
	<td width='150px'><b>Password</b></td><td><input type='password' id='ftppassword'></td>
	<td width='150px'></td><td width="300px"><input type='submit' value='Test FTP' id='testFtp'><span id='ftpImg' style='display: none;'><img src='images/ajax-loader.gif'/></span></td>
	</tr>
	</table>
	<div id='ftpStatus'></div>
	</fieldset></br>
</div>	
</body></html>
