<!--
//PJC SEPT2013
//PJC 04-OCT-2018 - Hide on VMAP
-->
<?php

if ( file_exists('/SpliceCom/install/assets/vmap' ) ) {
	header("Location: /manager/assist"); exit();	
}

$page_id = "046";
include ".access.php";
include "tzone.php"; // include timezone

// find linux version
	exec ('cat /proc/version', $version);
	$version = $version[0];
	include "tzone.php"; // include timezone
?>
<html>
<head>
<title>Disk Space - Disk Usage Analysis</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validate.js" type="text/javascript"></script>
<script src="js/wiz/extra.js" type="text/javascript"></script>

<style>
tr:hover td { background-color: #404040; }
</style>
<script type="text/javascript">
$(function() {
     $(window).scroll(function() {
          if($(this).scrollTop() != 0) {
               $('#toTop').fadeIn();
          } else {
               $('#toTop').fadeOut();
          }
     });
     $('#toTop').click(function() {
          $('body,html').animate({scrollTop:0},800);
     });
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>

<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = 'du.php'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_diskspace.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id="contain">
<h2><img src='images/ok.png' style="vertical-align:middle;">&nbsp;Disk Space - Disk Usage Analysis</h2>
This script allows you to see the usage of disk being used by specific directories.<br/>
Clicking on the directory name should allow you to drill into that directory.<br/>
For further help and advice click <a href='#' class="show_hide">HERE</a>

<div class="slidingDiv" hidden>
<strong>Clearing Disk Space</strong><br/>
This script shows the amount of space being used by directories on the CallServer / S8000. Clicking on a directory name allows you to drill into that directory.<br/><br/>
<strong>Example: /SpliceCom</strong><br/>
<pre>
 . (Disk Root)
 .. (Up One Level)
 17.36 MB 	 /SpliceCom/Wavs
 24.00 kb 	 /SpliceCom/OpenVXI
 12.00 kb 	 /SpliceCom/kernel
 552.00 kb 	 /SpliceCom/loader
 8.00 kb 	 /SpliceCom/sessions
 60.88 MB (Directory Accumulative Total)	 /SpliceCom (Current Directory)
</pre>
The total size of all files in /SpliceCom/Wavs and all sub directories is <b>17.36 MB</b>.<br/>The Directory Accumulative Total <b>60.88 MB</b> is calculated from the accumulative total of all directories and files in /SpliceCom.<br/><br/>
Once you have found which directories are using the disk space you will need to use telnet/SSH to login and manually clear any offending files.<br/><br/>
<strong>Useful Commands</strong>
<pre>
ls : Used for listing files, several ways of doing this.
ls		Lists files in alphabetical order
ls -l		List files as above but shows attributes
ls -lrth	List files as above but in date order and human readable form
</pre>
<pre>
rm : VERY DANGEROUS! Used to remove files from the system.
rm *.log	(Removes all files with the .log extension
rm /ftp/*.wav	will remove wav files from the /ftp directory
</pre>
<pre>
cd : Used to move around the systems directories.
cd /SpliceCom	Change to /SpliceCom
cd /ftp/tftp	Change to /ftp/tftp

However if you want to get to a sub directory then you do not have to use /
IE: If you are in /ftp and want to change to /ftp/tftp just type cd tftp
</pre>
Further information on Linux Commands can be found <a href='commands.php' target='_blank'>HERE</a>
<div align="right"><a href="#" class="show_hide">HIDE</a></div>
</div>

<br/><br/><b>KEY</b><br/>
<span style='color:#000000'>BLACK -  Files under 100MB</span><br/>
<span style='font-weight:bold;color:#C0C000'>GOLD - Files size between 100MB & 250MB</span><br/>
<span style='font-weight:bold;color:#FF00FF'>PURPLE - Files size between 250MB & 500MB</span><br/>
<span style='font-weight:bold;color:#FF0000'>RED -    Files over 500MB</span><br/><br/>

<?php
$out = array();
if (isset($_REQUEST['path'])) {
	$path = (isset($_REQUEST['path']) && strlen($_REQUEST['path'])>=1) ? $_REQUEST['path'] : "/";
 	$sub="1";

 	if (stri4pos($version,'centos') !== false) {
		exec ('du --max-depth=1 '.$path.' 2>&1', $out);
	} else {
		exec ('du -d1 '.$path.' 2>&1', $out);
	}
		} else {
	$path="/"; $sub="0";
	exec ('du -s /* 2>&1', $out);
}

$a = explode("/",$path); $dircount = count($a)-1;
$b = $a[$dircount]; $url = (strlen(str_replace("/".$b,"",$path))) ? "?path=".str_replace("/".$b,"",$path) : "" ;

echo "<h2>Current Path: $path</h2>";
echo "<table border='1'>";

if($sub=="1"){
echo "<tr><td colspan='2'><a href='du.php'><b>.</b></a> (Disk Root)</td></tr>";
echo "<tr><td colspan='2'><a href='du.php$url'><b>..</b></a> (Up One Level)</td></tr>";
}

foreach ($out as $line) {
	if (preg_match('~\b(denied|cannot)\b~i',$line)) continue;
		$part = preg_split('/\s+/', $line);
		$sz[] = $part[0];
		$dir[] = $part[1];
	}

//array_multisort($sz, SORT_NUMERIC, SORT_ASC, $dir);

foreach ($sz as $key => $value)    {
		$color="#000000";
	echo "<tr>";
		if ($value > 102400 && $value < 256000) $color = "#C0C000;font-weight: bold;";
		if ($value > 256000 && $value < 512000) $color = "#FF00FF;font-weight: bold;";
		if ($value > 500000) $color = "#FF0000;font-weight: bold;";

	$size = (formatRawSize($value)>0) ? formatRawSize($value) : "0.00";

	if ($dir[$key]==$path) {
		echo "<td>&nbsp;<span style='color:$color'>{$size}</span>&nbsp;<span style='font-size:8pt;font-style:italic'>(Directory Accumulative Total)</span></td>";
		echo "<td>&nbsp;<b>$dir[$key]</b>&nbsp;<span style='font-size:8pt;font-style:italic'>(Current Directory)</span></td>";
	} else {
		echo "<td>&nbsp;<span style='color:$color'>{$size}</span>&nbsp;</td>";
		echo "<td>&nbsp;<a href='du.php?path=$dir[$key]'>".$dir[$key]."</a>&nbsp;</td>";
	}
	echo "</tr>";
}
echo "</table>";

function formatRawSize($bytes) {
        if(!empty($bytes)) {
        $s = array('kb', 'MB', 'GB', 'TB', 'PB');
        $e = floor(log($bytes)/log(1024));
        @$output = sprintf('%.2f '.$s[$e], ($bytes/pow(1024, floor($e))));
        return $output;
        }
}

function stri4pos($haystack, $needle){
    return strpos($haystack, stristr( $haystack, $needle ));
}
?>
</div>
</body>
</html>
