<?php
// v2.81
//PJC 08-AUG-2019 - Updated for PHP7
//PJC 30-SEP-2016 - Add array check for user_capability
//PJC 05-AUG-2016 - Add pause to capability duplication
//PJC 14-JAN-2016 - Updated LCRPLAN
//PJC 08-May-2014 - added duplicate capabilites
//PJC 16Jan2013
$page_id = "070";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$action = (isset ($_REQUEST['action'] )) ? $_REQUEST['action'] : "0";

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
?>
<html>
<head>
<title>Duplicate - Various System Settings</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link rel="stylesheet" type="text/css" href="css/wiz/jquery.validate.css" />
<link rel="stylesheet" type="text/css" href="css/Styles.css" />
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/extra.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validate.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validation.functions.js" type="text/javascript"></script>
<script type="text/javascript">
	function formSubmit()
		{
		document.getElementById("frm1").submit();
		}
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_duplicate.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='images/wizards.png' style="vertical-align:middle;">&nbsp;Duplicate - Various System Settings</h2>
This script allows you to duplicate the base settings of a User, Department, Group, TimePlan, DialPlan and LCRPlan.<br/><br/>
<b>User</b> Voicemail Access, Login Access and Remote Working Codes can be duplicated or set to a random 4 digit number.<br/>
<b>Department</b> Voicemail Access codes can be duplicated or set to a random 4 digit number.<br/><br/>

<b>PLEASE NOTE</b> :<br/>
Duplicating system entries will use additional system resources and could cause slow downs or issues with Vision Call Centre.<br/>
We recommend this is only done out of hours or during 'quiet' periods.<br/><br/>
Select what would you would like to duplicate.<br/>
<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">
<select onchange="formSubmit()" name="action">
<option value=""> </option>
<option value="1" <?php if ($action == '1') echo 'selected'; ?> >User</option>
<option value="2" <?php if ($action == '2') echo 'selected'; ?> >Department</option>
<option value="3" <?php if ($action == '3') echo 'selected'; ?> >Group</option>
<option value="4" <?php if ($action == '4') echo 'selected'; ?> >TimePlan</option>
<option value="5" <?php if ($action == '5') echo 'selected'; ?> >DialPlan</option>
<option value="6" <?php if ($action == '6') echo 'selected'; ?> >LCRPlan</option>
<option value="7" <?php if ($action == '7') echo 'selected'; ?> >Capabilities</option>
</select></form>
<?php
If (isset($_REQUEST['action'])) {

	if ($_REQUEST['action'] =='1') {
?>
<h2>Duplicate User</h2>
This script allows you to Duplicate a user.<br/>
Select the existing user, then enter the new extension name and number.<br/><br/>
<b>Please Note :</b> This script does not check your licences and doesn't include the users initial phone.<br/><br/><br/>
<form method="post" id="form1" action="<?php echo $script;?>?action=1">
<?php
 	   $sr=ldap_list($ds, "cn=users", "(objectclass=user)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing User : </b></label><select name='existing_user' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The User To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New Username :</b></label><input type='text' name='user_name' id='user_name' size='30' maxlength='16' onkeyup=\"user(this.value)\" autocomplete='off' tabindex='2' /><a href='#' class='tooltip' title='The Name To Be Applied To This New User. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='user'></span></div>";
		    echo "<div class='block'><label><b>New Extension Number :</b></label><input type='text' name='user_ext' id='user_ext' size='30' maxlength='16' onkeyup=\"userext(this.value)\" autocomplete='off' tabindex='3' /><a href='#' class='tooltip' title='The Extension Number To Be Applied To This New User. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='userext'></span></div><br/>";
		    echo "<div class='block'><label><b>Duplicate Capabilities:</b></label><input type='checkbox' name='user_caps' id='user_caps' value='yes' checked='checked' tabindex='4'><a href='#' class='tooltip' title='Duplicate User Capabilities'><img src='images/tooltip.jpg'></a></div>";
		    echo "<div class='block'><label><b>Duplicate Speed Dials:</b></label><input type='checkbox' name='user_speeddials' id='user_speeddials' value='yes' checked='checked' tabindex='5'><a href='#' class='tooltip' title='Duplicate User Speed Dials'><img src='images/tooltip.jpg'></a></div>";
		    echo "<div class='block'><label><b>Duplicate Voicemail Contacts:</b></label><input type='checkbox' name='user_vmcontacts' id='user_vmcontacts' value='yes' checked='checked' tabindex='6'><a href='#' class='tooltip' title='Duplicate User Voicemail Contacts'><img src='images/tooltip.jpg'></a></div><br/>";
			echo "<div class='block'><label><b>Create New Codes:</b></label><input type='checkbox' name='user_codes' id='user_codes' value='yes' checked='checked' tabindex='7'><a href='#' class='tooltip' title='Create New Randomised Voicemail Access, Login Access And Remote Working Codes'><img src='images/tooltip.jpg'></a></div>";
			echo "<div class='block'><label><b>Exclude Email Settings:</b></label><input type='checkbox' name='user_email' id='user_email' value='yes' checked='checked' tabindex='8'><a href='#' class='tooltip' title=\"Don't Duplicate Users Email Login Details\"><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate User' onClick=\"return confirm('Are you sure you want to duplicate this user ?')\">";
			echo "<input type='hidden' name='dup' value='dup_user'>";
			echo "</form>";

	} //end 1

if ($_REQUEST['action'] =='2') {
?>
<h2>Duplicate Department</h2>
This script allows you to Duplicate a Department.<br/>
Select the existing department, then enter the new department name and number.<br/><br/>
<b>Please Note :</b> This script does not check your licences..<br/><br/><br/>
<form method="post" action="<?php echo $script;?>?action=2">
<?php
 	   $sr=ldap_list($ds, "cn=departments", "(objectclass=department)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing Department : </b></label><select name='existing_dept' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The Department To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New Department Name :</b></label><input type='text' name='dept_name' id='dept_name' size='30' maxlength='16' onkeyup=\"deptname(this.value)\" autocomplete='off' tabindex='2'/><a href='#' class='tooltip' title='The Name To Be Applied To This New Department. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='deptname'></span></div>";
		    echo "<div class='block'><label><b>New Department Number :</b></label><input type='text' name='dept_ext' id='dept_ext' size='30' maxlength='16' onkeyup=\"deptext(this.value)\" autocomplete='off' tabindex='3'/><a href='#' class='tooltip' title='The Extension Number To Be Applied To This New Department. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='deptext'></span></div><br/>";
		    echo "<div class='block'><label><b>Duplicate Voicemail Contacts:</b></label><input type='checkbox' name='dept_vmcontacts' id='dept_vmcontacts' value='yes' checked='checked' tabindex='4'><a href='#' class='tooltip' title='Duplicate Department Voicemail Contacts'><img src='images/tooltip.jpg'></a></div>";
		    echo "<div class='block'><label><b>Create New Code:</b></label><input type='checkbox' name='dept_code' id='dept_code' value='yes' checked='checked' tabindex='5'><a href='#' class='tooltip' title='Create New Randomised Voicemail Access Code'><img src='images/tooltip.jpg'></a></div>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate Department' onClick=\"return confirm('Are you sure you want to duplicate this department ?')\">";
			echo "<input type='hidden' name='dup' value='dup_dept'>";
			echo "</form>";

	} //end 2


if ($_REQUEST['action'] =='3') {
?>
<h2>Duplicate Group</h2>
This script allows you to Duplicate a Group.<br/>
Select the existing group, then enter the new group name.<br/><br/>
<b>Please Note :</b> This script does not check your licences or if a group with this name exists.<br/><br/><br/>
<form method="post" action="<?php echo $script;?>?action=3">
<?php
 	   $sr=ldap_list($ds, "cn=groups", "(objectclass=group)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing Group : </b></label><select name='existing_group' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The Group To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New Group Name :</b></label><input type='text' name='group_name' id='group_name' size='30' maxlength='16' onkeyup=\"groupname(this.value)\" autocomplete='off' tabindex='2'/><a href='#' class='tooltip' title='The Name To Be Applied To This New Group. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='groupname'></span></div>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate Group' onClick=\"return confirm('Are you sure you want to duplicate this group ?')\">";
			echo "<input type='hidden' name='dup' value='dup_group'>";
			echo "</form>";

	} //end 3


if ($_REQUEST['action'] =='4') {
?>
<h2>Duplicate TimePlan</h2>
This script allows you to Duplicate a TimePlan.<br/>
Select the existing timeplan, then enter the new timeplan name.<br/><br/>
<b>Please Note :</b> This script does not check your licences or if a timeplan with this name exists.<br/><br/><br/>
<form method="post" action="<?php echo $script;?>?action=4">
<?php
 	   $sr=ldap_list($ds, "cn=timeplans", "(objectclass=timeplan)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing TimePlan : </b></label><select name='existing_timeplan' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The Timeplan To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New TimePlan Name :</b></label><input type='text' name='timeplan_name' id='timeplan_name' size='30' maxlength='16' onkeyup=\"timeplanname(this.value)\" autocomplete='off' tabindex='2'/><a href='#' class='tooltip' title='The Name To Be Applied To This New Timeplan. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='timeplanname'></span></div>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate TimePlan' onClick=\"return confirm('Are you sure you want to duplicate this timeplan ?')\">";
			echo "<input type='hidden' name='dup' value='dup_timeplan'>";
			echo "</form>";

	} //end 4

if ($_REQUEST['action'] =='5') {
?>
<h2>Duplicate DialPlan</h2>
This script allows you to Duplicate a DialPlan.<br/>
Select the existing dialplan, then enter the new dialplan name.<br/><br/>
<b>Please Note :</b> This script does not check your licences or if a dialplan with this name exists.<br/><br/><br/>
<form method="post" action="<?php echo $script;?>?action=5">
<?php
 	   $sr=ldap_list($ds, "cn=dialplans", "(objectclass=dialplan)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing DialPlan : </b></label><select name='existing_dialplan' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The Dialplan To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New DialPlan Name :</b></label><input type='text' name='dialplan_name' id='dialplan_name' size='30' maxlength='16' onkeyup=\"dialplanname(this.value)\" autocomplete='off' tabindex='2'/><a href='#' class='tooltip' title='The Name To Be Applied To This New Dialplan. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='dialplanname'></span></div>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate DialPlan' onClick=\"return confirm('Are you sure you want to duplicate this dialplan ?')\">";
			echo "<input type='hidden' name='dup' value='dup_dialplan'>";
			echo "</form>";

	} //end 5


if ($_REQUEST['action'] =='6') {
?>
<h2>Duplicate LCRPlan</h2>
This script allows you to Duplicate a LCRPlan.<br/>
Select the existing lcrplan, then enter the new lcrplan name.<br/><br/>
<b>Please Note :</b> This script does not check your licences or if a lcrplan with this name exists.<br/><br/><br/>
<form method="post" action="<?php echo $script;?>?action=6">
<?php
 	   $sr=ldap_list($ds, "cn=leastcostcallplans", "(objectclass=leastcostcallplan)", array("cn","guid"));
 	   $info = ldap_get_entries($ds, $sr);
	   echo "<div class='block'><label><b>Select Existing LCRPlan : </b></label><select name='existing_lcrplan' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 echo "<option value='$cn'>$cn</option>";
			}
			echo "</select><a href='#' class='tooltip' title='Select The Lcrplan To Be Duplicated'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<div class='block'><label><b>New LCRPlan Name :</b></label><input type='text' name='lcrplan_name' id='lcrplan_name' size='30' maxlength='16' onkeyup=\"lcrplanname(this.value)\" autocomplete='off' tabindex='2'/><a href='#' class='tooltip' title='The Name To Be Applied To This New Lcrplan. max 16 chars'><img src='images/tooltip.jpg'></a>&nbsp;<span id='lcrplanname'></span></div>";
		    echo "<br/><input type='submit' id='submit' value='Duplicate LCRPlan' onClick=\"return confirm('Are you sure you want to duplicate this lcrplan ?')\">";
			echo "<input type='hidden' name='dup' value='dup_lcrplan'>";
			echo "</form>";

	} //end 6
	
	
if ($_REQUEST['action'] =='7'){
	echo "<h2>Duplicate Capabilities</h2>";
	echo "This script allows you to Duplicate a users capabilities.<br/>";
	echo "Select the existing user you want to copy capabilities from and click select. When the page refreshes tick each capability you want to copy to the user range.<br/><br/>";
	echo "In the 'Extension Range' field enter the extension numbers where the speed dials are to be applied. Enter either a comma between<br/>";
	echo "each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br/><br/>";
	?>
	   <form method="post" action="<?php echo $script;?>?action=7">
	   <?php
  		$sr=ldap_list($ds, "cn=users", "(objectclass=user)", array("cn","guid"));
 	   	$info = ldap_get_entries($ds, $sr);
 
	   echo "<div class='block'><label><b>Select Existing User : </b></label><select name='existing_user' tabindex='1'>";

 	         for ($n=0; $n<$info['count']; $n++) {
			 $cn = $info[$n]['cn'][0];
			 $selected = (isset($_REQUEST['existing_user']) && $_REQUEST['existing_user'] == $cn) ? "selected" : "";
			 echo "<option value='$cn' $selected>$cn</option>";
			}
			echo "</select><input type='submit' id='submit' value='Select'><a href='#' class='tooltip' title='Select The User To Copy Capabilites From'><img src='images/tooltip.jpg'></a></div><br/>";
		    echo "<input type='hidden' name='dup' value='show_caps'>";
			echo "</form>";
		}
	
		

	

} //end action

if (isset($_REQUEST['dup'])) {
	$find      = array('(',')','@');
	$replace   = array('\(','\)','\@');
	
// USERS
if ($_REQUEST['dup'] == "dup_user") {
	$existing_user = $_REQUEST['existing_user'];
	$user_name = $_REQUEST['user_name'];
	$user_ext = $_REQUEST['user_ext'];
	$user_exclude = array('objectclass','cn','initialPhone');
	$existing_user = str_replace($find, $replace, $existing_user);

	if (isset($_REQUEST['user_email']) && $_REQUEST['user_email']=="yes") {
		array_push($user_exclude, 'emailUsername');
		array_push($user_exclude, 'emailPassword');
	}
	
	$sr=ldap_list($ds, "cn=users", "(&(objectclass=user)(cn=$existing_user))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);

	for ($i=0; $i < $attrs["count"]; $i++) {
		if (in_array($attrs[$i],$user_exclude)) continue;
	   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
	   		if ($attrs[$i]=="voicemailAccessCode") $vmc = $attrs[$attrs[$i]][0];
	   		if ($attrs[$i]=="loginAccessCode") $lac = $attrs[$attrs[$i]][0];
	   		if ($attrs[$i]=="remoteWorkingCode") $rwc = $attrs[$attrs[$i]][0];
    	}

		if (isset($_REQUEST['user_codes']) && $_REQUEST['user_codes']=="yes") {
			$vmc = $lac = $rwc = $new['voicemailaccesscode'] = $new['loginaccesscode'] = $new['remoteworkingcode'] = mt_rand(1345, 9999);
		}
    	$new['objectclass'] = "user"; 
		$new['telephonenumber'] = $user_ext;
    	ldap_add($ds,"cn=$user_name,cn=users",$new); $new=array();
		
	$existing_user = stripslashes($existing_user);
 	if (isset($_REQUEST['user_caps']) && $_REQUEST['user_caps']=="yes") {
		@$sr=ldap_list($ds, "cn=$existing_user,cn=users", "(objectclass=capability)");
		@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$capability = $new['capability'] = $info[$e]['capability'][0]; 
			$new['capabilitypercent'] = $info[$e]['capabilitypercent'][0]; 
			$new['objectclass'] = "Capability";
			ldap_add($ds,"capability=$capability,cn=$user_name,cn=users",$new); $new=array();
		}
	}

	if (isset($_REQUEST['user_speeddials']) && $_REQUEST['user_speeddials']=="yes") {
	@$sr=ldap_list($ds, "cn=$existing_user,cn=users", "(objectclass=speeddial)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$telephone = $new['telephonenumber'] = $info[$e]['telephonenumber'][0]; 
			$desc=$new['description'] = $info[$e]['description'][0]; 
			$new['objectclass'] = "SpeedDial"; 
			$new['shortCode'] = $info[$e]['shortcode'][0];
			ldap_add($ds,"description=$desc,cn=$user_name,cn=users",$new); $new=array();
		}
	}

	if (isset($_REQUEST['user_vmcontacts']) && $_REQUEST['user_vmcontacts']=="yes") {
	@$sr=ldap_list($ds, "cn=$existing_user,cn=users", "(objectclass=VoicemailContact)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$new['telephonenumber'] = $info[$e]['telephonenumber'][0]; 
			$new['type'] = $info[$e]['type'][0]; 
			$new['objectclass'] = "VoicemailContact"; 
			$method = $new['method'] = $info[$e]['method'][0];
			ldap_add($ds,"method=$method,cn=$user_name,cn=users",$new); $new=array();
		}
	}

	$sr = ldap_read($ds,"cn=$user_name,cn=users","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$guid=$info[0]['guid'][0];
    echo "<h3>New User Created</h3>";
    echo "New User : <b><a href='/manager/manager.cgi?pagename=user&index=$guid' target='_blank'> ".$user_name."</a> </b>( ".$user_ext." )<br/><br/>";
    echo "Duplicated from exisiting User : <b>".$existing_user."</b><br/><br/>";
    echo "Login Access Code : <b>". $lac."</b><br/>";
    echo "Remote Working Code : <b>". $rwc."</b><br/>";
    echo "Voicemail Access Code : <b>". $vmc."</b><br/>";
    echo "Email Settings Duplicated : <b>"; echo ($_REQUEST['user_email']=="yes") ? "<img src='images/error.jpg'>" : "<img src='images/ok.jpg'>"; echo "</b><br/>";

}
// USERS
// DEPARTMENTS
if ($_REQUEST['dup'] == "dup_dept") {
	$existing_dept = $_REQUEST['existing_dept'];
	$dept_name = $_REQUEST['dept_name'];
	$dept_ext = $_REQUEST['dept_ext'];
	$existing_dept = str_replace($find, $replace, $existing_dept);
	
	$sr=ldap_list($ds, "cn=departments", "(&(objectclass=*)(cn=$existing_dept))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);
		for ($i=0; $i < $attrs["count"]; $i++) {
	   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
	   		if ($attrs[$i]=="voicemailAccessCode") $vmc = $attrs[$attrs[$i]][0];
    	}
		
		if (isset($_REQUEST['dept_code']) && $_REQUEST['dept_code']=="yes") { 
			$vmc = $new['voicemailaccesscode'] = mt_rand(1345, 9999);
		}
    	$new['telephonenumber'] = $dept_ext;
		ldap_add($ds,"cn=$dept_name,cn=departments",$new);  $new=array();
		
	$existing_dept = stripslashes($existing_dept);
	if (isset($_REQUEST['dept_vmcontacts']) && $_REQUEST['dept_vmcontacts']=="yes") {
	@$sr=ldap_list($ds, "cn=$existing_dept,cn=departments", "(objectclass=voicemailcontact)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$new['telephonenumber'] = $info[$e]['telephonenumber'][0]; 
			$new['type'] = $info[$e]['type'][0]; 
			$new['objectclass'] = "VoicemailContact";
			$method=$new['method'] = $info[$e]['method'][0];
			ldap_add($ds,"method=$method,cn=$dept_name,cn=departments",$new);
		}
	}
   		$sr = ldap_read($ds,"cn=$dept_name,cn=departments","objectclass=*"); 
		$info = ldap_get_entries($ds,$sr); 
		$guid=$info[0]['guid'][0];
		echo "<h3>New Department Created</h3>";
    	echo "New Department : <b><a href='/manager/manager.cgi?pagename=dept&index=$guid' target='_blank'> ".$dept_name."</a> </b>( ".$dept_ext." )<br/><br/>";
    	echo "Duplicated from exisiting Department : <b>".$existing_dept."</b><br/><br/>";
    	echo "Voicemail Access Code : <b>". $vmc."</b><br/>";

}
// DEPARTMENTS
//// GROUPS
if ($_REQUEST['dup'] == "dup_group") {
		$existing_group = $_REQUEST['existing_group'];
		$group_name = $_REQUEST['group_name'];
		$existing_group = str_replace($find, $replace, $existing_group);

	$sr=ldap_list($ds, "cn=groups", "(&(objectclass=*)(cn=$existing_group))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);
		for ($i=0; $i < $attrs["count"]; $i++) {
	   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
    	}
		ldap_add($ds,"cn=$group_name,cn=groups",$new); $new = array();
		$existing_group = stripslashes($existing_group);
	@$sr=ldap_list($ds, "cn=$existing_group,cn=groups", "(objectclass=member)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$new['priority'] = $info[$e]['priority'][0]; 
			$new['member'] = $info[$e]['member'][0]; 
			$new['objectclass'] = "Member";
			$id=$new['id'] = $info[$e]['id'][0];
			ldap_add($ds,"id=$id,cn=$group_name,cn=groups",$new);
		}

	$sr = ldap_read($ds,"cn=$group_name,cn=groups","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$guid = $info[0]['guid'][0];
		echo "<h3>New Group Created</h3>";
    	echo "New Group : <b><a href='/manager/manager.cgi?pagename=group&index=$guid' target='_blank'> ".$group_name."</a></b><br/><br/>";
    	echo "Duplicated from exisiting Group : <b>".$existing_group."</b><br/><br/>";
}
//// GROUPS

//// TIMEPLANS
if ($_REQUEST['dup'] == "dup_timeplan") {
		$existing_timeplan = $_REQUEST['existing_timeplan'];
		$timeplan_name = $_REQUEST['timeplan_name'];
		$existing_timeplan = str_replace($find, $replace, $existing_timeplan);
	$sr=ldap_list($ds, "cn=timeplans", "(&(objectclass=*)(cn=$existing_timeplan))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);
			for ($i=0; $i < $attrs["count"]; $i++) {
		   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
	    	}
			ldap_add($ds,"cn=$timeplan_name,cn=timeplans",$new); $new=array();
	$existing_timeplan = stripslashes($existing_timeplan);
	@$sr=ldap_list($ds, "cn=$existing_timeplan,cn=TimePlans", "(objectclass=timeband)");
	@$info = ldap_get_entries($ds, $sr);
	   		for ($e=0; $e<$info['count']; $e++) {
			   	$new['starttime'] = $info[$e]['starttime'][0]; 
				$new['endtime'] = $info[$e]['endtime'][0]; 
				$new['objectclass'] = "TimeBand";
				$start = $new['startdayofweek'] = $info[$e]['startdayofweek'][0]; 
				$new['enddayofweek'] = $info[$e]['enddayofweek'][0];
			ldap_add($ds,"startdayofweek=$start,cn=$timeplan_name,cn=timeplans",$new); $new = array();
			}
	@$sr=ldap_list($ds, "cn=$existing_timeplan,cn=TimePlans", "(objectclass=dateexception)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$dayofmonth = $info[$e]['dayofmonth'][0]; 
			$new['month'] = $info[$e]['month'][0]; 
			$new['objectclass'] = "dateexception";
			ldap_add($ds,"dayofmonth=".$dayofmonth.",cn=$timeplan_name,cn=timeplans",$new);
		}

	$sr = ldap_read($ds,"cn=$timeplan_name,cn=timeplans","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$guid=$info[0]['guid'][0];
		echo "<h3>New TimePlan Created</h3>";
    	echo "New TimePlan : <b><a href='/manager/manager.cgi?pagename=timeplan&index=$guid' target='_blank'> ".$timeplan_name."</a></b><br/><br/>";
    	echo "Duplicated from exisiting TimePlan : <b>".$existing_timeplan."</b><br/><br/>";
}
//// TIMEPLANS

// DIALPLANS
if ($_REQUEST['dup'] == "dup_dialplan") {
		$existing_dialplan = $_REQUEST['existing_dialplan'];
		$dialplan_name = $_REQUEST['dialplan_name'];
		$existing_dialplan = str_replace($find, $replace, $existing_dialplan);
	$sr=ldap_list($ds, "cn=dialplans", "(&(objectclass=*)(cn=$existing_dialplan))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);
			for ($i=0; $i < $attrs["count"]; $i++) {
		   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
	    	}
			ldap_add($ds,"cn=$dialplan_name,cn=dialplans",$new); $new=array();
	$existing_dialplan = stripslashes($existing_dialplan);
	@$sr=ldap_list($ds, "cn=$existing_dialplan,cn=dialplans", "(objectclass=DPEntry)");
	@$info = ldap_get_entries($ds, $sr);
	   		for ($e=0; $e<$info['count']; $e++) {
			   	$new['numbermatch'] = $info[$e]['numbermatch'][0]; 
				$new['objectclass'] = "DPEntry";
			   	$action = $new['action'] = $info[$e]['action'][0]; 
				$new['location'] = $info[$e]['location'][0];
				$new['leastcostcallplan'] = $info[$e]['leastcostcallplan'][0]; 
				$new['translateto'] = $info[$e]['translateto'][0];
				$new['translateclito'] = $info[$e]['translateclito'][0]; 
				$new['timeplan'] = $info[$e]['timeplan'][0];
				ldap_add($ds,"action=$action,cn=$dialplan_name,cn=dialplans",$new);
			}
	$sr = ldap_read($ds,"cn=$dialplan_name,cn=dialplans","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$guid = $info[0]['guid'][0];
		echo "<h3>New DialPlan Created</h3>";
    	echo "New DialPlan : <b><a href='/manager/manager.cgi?pagename=dialplan&index=$guid' target='_blank'> ".$dialplan_name."</a></b><br/><br/>";
    	echo "Duplicated from exisiting DialPlan : <b>".$existing_dialplan."</b><br/><br/>";
		}
//// DIALPLANS

// LCRPLAN
if ($_REQUEST['dup'] == "dup_lcrplan") {
		$existing_lcrplan = $_REQUEST['existing_lcrplan'];
		$lcrplan_name = $_REQUEST['lcrplan_name'];
		$existing_lcrplan = str_replace($find, $replace, $existing_lcrplan);
		
	$sr=ldap_list($ds, "cn=leastcostcallplans", "(&(objectclass=*)(cn=$existing_lcrplan))");
	$info = ldap_get_entries($ds, $sr); 
	$entry = ldap_first_entry($ds, $sr); 
	$attrs = ldap_get_attributes($ds, $entry);
		for ($i=0; $i < $attrs["count"]; $i++) {
	   		$new[$attrs[$i]] = $attrs[$attrs[$i]][0];
    	}
		ldap_add($ds,"cn=$lcrplan_name,cn=leastcostcallplans",$new); $new=array();
		
	$existing_lcrplan = stripslashes($existing_lcrplan);
	@$sr=ldap_list($ds, "cn=$existing_lcrplan,cn=leastcostcallplans", "(objectclass=LCREntry)");
	@$info = ldap_get_entries($ds, $sr);
   		for ($e=0; $e<$info['count']; $e++) {
		   	$action=$new['actionprimary'] = $info[$e]['actionprimary'][0]; 
			$new['objectclass'] = "LCREntry";
		   	$new['actionsecondary'] = $info[$e]['actionsecondary'][0]; 
			$new['dialprimary'] = $info[$e]['dialprimary'][0];
			$new['dialsecondary'] = $info[$e]['dialsecondary'][0]; 
			$new['dtmfprimary'] = $info[$e]['dtmfprimary'][0];
			$new['dtmfsecondary'] = $info[$e]['dtmfsecondary'][0]; 
			$new['numbermatch'] = $info[$e]['numbermatch'][0]; 
			$new['timeplan'] = $info[$e]['timeplan'][0];
			$new['trunkgroupprimary'] = $info[$e]['trunkgroupprimary'][0]; 
			$new['trunkgroupsecondary'] = $info[$e]['trunkgroupsecondary'][0]; 
			$new['timeout'] = $info[$e]['timeout'][0];
			ldap_add($ds,"actionprimary=$action,cn=$lcrplan_name,cn=leastcostcallplans",$new);
		}
	$sr = ldap_read($ds,"cn=$lcrplan_name,cn=leastcostcallplans","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$guid=$info[0]['guid'][0];
		echo "<h3>New LCRPlan Created</h3>";
    	echo "New LCRPlan : <b><a href='/manager/manager.cgi?pagename=lcrplan&index=$guid' target='_blank'> ".$lcrplan_name."</a></b><br/><br/>";
    	echo "Duplicated from exisiting LCRPlan : <b>".$existing_lcrplan."</b><br/><br/>";
	}
// LCRPLAN


// SELECT CAPABILITIES
if ($_REQUEST['dup'] == "show_caps") {
	echo "Copy Capabilites From User : <b>". $_REQUEST['existing_user']."</b><br/>";
	echo "<form id='frm1' method='post' action='duplicate.php'>";
	echo "Create System Backup : <input type='checkbox' name='backup' id='backup' checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.jpg'></a><br/><br/>";
	
		echo "Select Assigned Capabilities :<br/><br/>";
		$sr = ldap_search($ds,"cn={$_REQUEST['existing_user']}, cn=Users","(objectclass=capability)",array('capability','capabilitypercent'));
		$info = ldap_get_entries($ds, $sr); 
   			for ($m=0; $m<$info['count']; $m++) {
   			echo "<input type='checkbox' name='dupcaps[]' value='{$info[$m]['capability'][0]}:{$info[$m]['capabilitypercent'][0]}'> {$info[$m]['capability'][0]} ({$info[$m]['capabilitypercent'][0]}) <br/>";
   			}
   			   						
   			if ($info['count']>0) {
			echo "<br/><br/><b>Extension Range To Apply Capabilities :</b><br/><input type='text' name='extn_range' id='extn_range' size='60' />&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range For Capabilities To Be Applied To'><img src='images/tooltip.jpg'></a></br></br>";

   			echo "<input type='hidden' name='action' value='7'>";
			echo "<input type='hidden' name='dup' value='dup_caps'>";
   			echo "<input type='hidden' name='existing_user' value='{$_REQUEST['existing_user']}'>";
	   		echo "<br/><input type='submit' name='Send' value='Copy Cababilites' onClick=\"return confirm('Are you sure you want to duplicate these capabilities ?')\"></form>";
   		} else {
	   		echo "<b><font color='red'>No Capabilities Assigned To This User.</font></b><br/>";
   		}
}
// SELECT CAPABILITIES

// Duplicate Capabilities
if ($_REQUEST['dup'] == "dup_caps") {
	$capabilities = $_REQUEST['dupcaps'];
	$range = num_range($_REQUEST['extn_range']);
	
	if ( count($capabilities) <1 ) {
		echo "No Capability Selected<br/>";
		exit;
	}
	
	if( count( array_filter( $range)) == 0) {
    	echo "No Extension Range Specified<br/>";
    	exit;
	}
		
	if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
		$backup = "Backup ".date('d.m.y His')." - DuplicateCapabilities.txt";
		$ent["dobackupto"][0] = $backup;
		ldap_modify($ds,"cn=Commands", $ent);
		ldap_modify($ds,"cn=Commands", $ent); $ent = array();
	}
	
	// create list of users
	$sr=ldap_list($ds,"cn=users","(objectclass=*)",array('cn','telephonenumber'));
    $usr = ldap_get_entries($ds, $sr);
       	for ($s=0; $s<$usr['count']; $s++) {
           $users[$usr[$s]['telephonenumber'][0]]=$usr[$s]['cn'][0];
       	}
       	
	// check if numbers from range are users
	foreach ($users as $k => $v) {
		if (in_array($k, $range)) $updateusers[$k] = $v;
	}

	echo "<h2>Adding Capabilities</h2>";
	
	$userTimeout = 0;
	foreach ($updateusers as $uk => $uv) {  //$uv = name $uk = number
		if ($userTimeout == '25') sleep(2);
		echo "<br/>Extension : <b>$uv</b> ($uk)<br/>";
		
		// current users capabilities
		unset($user_capability);
		$sr=ldap_list($ds,"cn=$uv, cn=Users","(objectclass=capability)");
 	   		$info = ldap_get_entries($ds, $sr);
       			for ($n=0; $n<$info['count']; $n++) {
				$user_capability[] = $info[$n]['capability'][0];
				}
			if (count($user_capability) >= 1)
				$user_capability = array_unique($user_capability);
		
		$capsTimeout = 0;
		foreach ($capabilities as $ck => $cv) {	
		if ($capsTimeout == '25') sleep(2);
			$parts = explode(":",$cv);
			$capname = $parts[0]; $capvalue = $parts[1];
			
			if (count($user_capability) <= 0 || !in_array($capname,$user_capability)) {
				$ent = array(); 
				$ent["capabilitypercent"] = $capvalue; 
				$ent["objectclass"] = "capability";
				$dn = "capability=".$capname.",cn=$uv, cn=Users";
				ldap_add($ds, $dn, $ent);
				echo "Added: $capname - value: $capvalue<br/>";
			} else {
				echo "Capability <b>$capname</b> already assigned to user - skipped.<br/>";
			}
			$capsTimeout++;
		}
		$userTimeout++;
	}
}

}// end
function num_range($s) {
$tmp = explode(',', $s);
$nums = array();
foreach ($tmp as $el)
{
    $a = explode('-', $el);
    if (count($a) == 1)
    {
        $nums[] = (int)$a[0];
    }
    else
    {
        for ($i = $a[0]; $i <= $a[1]; ++$i)
        {
            $nums[] = (int)$i;
        }
    }
}
$nums = array_unique($nums);
return $nums;
}

?>
</div>
</body>
</html>
