<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<title>Help - Codes Check</title>
<head>
<script type="text/javascript">
	var state = {};
	var title = 'Help';
	var url   = '/manager/assist/help';
	history.pushState(state, title, url);
</script>
<link href="/manager/assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="/manager/assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div id="contain">
<h2><img src='/manager/assist/images/help.png' style="vertical-align:middle;">&nbsp;Help - Codes Check</h2>
<b>Codes Check</b><br/>
This page provides a simple way to view, edit and check how codes are configured against a user, agent, department, port or phone. Each option presents a table of code information.<br/><br/>
The results are searchable, sortable and can be edited live. Double clicking on a cell will allow you to edit it.<br/><br/>
Once your changes have been made you must press ENTER for them to be saved. All edits are written live back to the System Database.<br/><br/>
You need to refresh this page to check the results.<br/><br/>

<b>User Codes</b><br/>
This table displays all codes assigned to a user and will check for any common or simple  voicemail access codes that may pose a security risk.<br/><br/>
There are several options available once the table has loaded:-<br/><br/>
The table can be sorted into a different order by clicking on any of the column headings, clicking the same column heading will change the order from ascending to descending.<br/><br/>
The search box allows you to enter either a username or extension number with the number of entries in the table reducing as the name or number becomes unique. There is also an option to display more entries in the table than the default of 10<br/><br/>
The username, in blue, will link to the user in Manager if clicked. The Login Access Code, Remote Working Code, Voicemail Access and Partner Login Codes can all be edited within the displayed table by double clicking in the appropriate box and entering a new value and hitting return to submit a live change to the system configuration. All other values have to be changed via Manager.<br/><br/>
When loaded or refreshed this table also checks if any voicemail access codes match commonly used values and then highlights the users row depending on the results returned.<br/><br/>

<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:90%' ><legend><b>Key :</b></legend>
<span style='font-weight:bold;color:YELLOW'>Yellow - Voicemail Access Code Matches Common Value.</span><br/>
<span style='font-weight:bold;color:#A9F6FF'>Cyan - Voicemail Access Code Matches Extension Number.</span><br/>
<span style='font-weight:bold;color:#BC65FF'>Violet - Voicemail Enabled But No Code Set.</span></fieldset><br/><br/>

<b>Ports and Phones Codes</b><br/>
This table shows all codes assigned to a Port or Phone.<br/><br/>
The Name is a link to the relevant device in Manager. Where applicable you can live edit the Partner Login Codes.<br/><br/>

<b>Agent Codes</b><br/>
This table shows all codes assigned to an Agent and checks for common configuration errors.<br/><br/>
The username is a link to the user in Manager. You can live edit the Login Access Code, Remote Working Code, Voicemail Access and Partner Login Codes.<br/><br/>
If a user is configured as an Agent they <b>MUST</b> have their Remote Working Code, Voicemail Access Code and Partner Login Code set.<br/><br/>
The Agents <b>Remote Working Code MUST</b> match their <b>Partner Login Code</b> any mismatches will be highlighted in yellow.<br/><br/>
Once you have updated the agents codes, you will need to refresh this page to check the results.<br/><br/>
When loaded or refreshed this table checks if the agents codes are configured correctly and then highlights the agents row depeneding on the results returned.<br/><br/>

<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:90%' ><legend><b>Key :</b></legend>
<span style='font-weight:bold;color:YELLOW'>Yellow - Remote Working Code and Partner Login Code don't match.</span><br/>
<span style='font-weight:bold;color:#A9F6FF'>Cyan - No Initial Phone Set. You must check the Remote Working Code matches the Partner Login Code of any Port or Device they may log into.</span><br/>
<span style='font-weight:bold;color:#BC65FF'>Violet - A required code has not been set.</span></fieldset><br/><br/>

<b>Department Codes</b><br/>
This table shows the voicemail access codes assigned to a department and checks for commonly used codes.<br/><br/>
The name is a link to the Department in Manager. You can live edit the Voicemail Access Code.<br/><br/>
When loaded or refreshed this table checks if any voicemail access codes match commonly used values and then highlights the department row depeneding on the results returned.<br/><br/>

<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:90%' ><legend><b>Key :</b></legend>
<span style='font-weight:bold;color:YELLOW'>Yellow - Voicemail Access Code Matches Common Value.</span><br/>
<span style='font-weight:bold;color:#A9F6FF'>Cyan - Voicemail Access Code Matches Extension Number.</span><br/>
<span style='font-weight:bold;color:#BC65FF'>Violet - Voicemail Enabled But No Code Set.</span></fieldset><br/><br/>

<b>Registrations</b><br/>
This table shows all codes assigned to a user where their device is registered to this call server and checks for common configuration errors.<br/><br/>
The username is a link to the user in Manager. You can live edit the Login Access Code, Remote Working Code, Voicemail Access and Partner Login Codes.<br/><br/>
If a user is configured as an Agent they <b>MUST</b> have their Remote Working Code, Voicemail Access Code and Partner Login Code set.<br/><br/>
The Agents <b>Remote Working Code MUST</b> match their <b>Partner Login Code</b> any mismatches will be highlighted in yellow.<br/><br/>
Once you have updated the agents codes, you will need to refresh this page to check the results.<br/><br/>
When loaded or refreshed this table checks if the agents codes are configured correctly and then highlights the agents row depeneding on the results returned.<br/><br/>

<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:90%' ><legend><b>Key :</b></legend>
<span style='font-weight:bold;color:YELLOW'>Yellow - Remote Working Code and Partner Login Code don't match.</span><br/>
<span style='font-weight:bold;color:#A9F6FF'>Cyan - No Initial Phone Set. You must check the Remote Working Code matches the Partner Login Code of any Port or Device they may log into.</span><br/>
<span style='font-weight:bold;color:#BC65FF'>Violet - A required code has not been set.</span></fieldset><br/><br/>

<b>Partner Login Codes</b><br/>
This table shows all partner login codes assigned to a Port or Phone.<br/><br/>
The Name is a link to the relevant device in Manager. Where applicable you can live edit the Partner Login Codes.<br/><br/>
This page also allows you to bulk update partner login codes on mulitple ports or devices. Using the check boxes select the required entries. In the Partner Login Code field enter the code to be applied to your selected entries. Click 'Update', you will be asked to confirm the update.<br/><br/>

<b>Other Details</b><br/>
This explains how you can update voicemail access codes from the command line. A link is also provided to a web version of this page.<br/><br/>
</div>
</body>
</html>
