<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<title>Help - Add Voicemail Contacts</title>
<head>
<script type="text/javascript">
	var state = {};
	var title = 'Help';
	var url   = '/manager/assist/help';
	history.pushState(state, title, url);
</script>
<link href="/manager/assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="/manager/assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div id="contain">
<h2><img src='/manager/assist/images/help.png' style="vertical-align:middle;">&nbsp;Help - Add Voicemail Contacts</h2>
<b>Add Voicemail Contacts</b><br/>This page allows you to add bulk voicemail contacts to a department in a far easier way than adding each contact one at a time through the standard Manager pages. It can also be used to remove existing voicemail contacts from a department.<br/><br/>
When loaded the page checks if an SMTP Server has been configured correctly against your CallServer. This is required for the voicemail contact type: 'Missed Call Email'<br/><br/>
Create System Backup is enabled by default. This will create a backup of your database prior to making any changes.<br/><br/>
<b>Individual Department:</b><br/>
Select the Department to add the contact to, then enter the contact details in the form.<br/><br/>
<b>Mutliple Departments:</b><br/>
To select multiple Departments, press and hold CTRL and then click on each Department. (If using a MAC press and hold Command)<br/>
To select all Departments, select the first, press and hold SHIFT, then select the last Department.<br/>
Then enter the contact details in the form.<br/><br/>
<b>Add Voicemail Contacts</b><br/>
To add voicemail contacts to a Department:<br/><br/>
<b>1.</b> Select the required Department from the 'Select Department' drop down list.<br/>
<b>2.</b> In the contact form enter the required telephone number, email address or value in the Telephone Number Field.<br/>
<b>3.</b> Select the required contact type from the Type drop down list.<br/>
<b>4.</b> Select the required contact method from the Method drop down list.<br/><br/>
To add additional contacts click the 'Add Row' button to add a new row to the contact form. Complete this row following 1 - 4 above.<br/><br/>
<b>example:</b><br/>
New voicemail contact to allow a user who is not a member of this department access to voicemail.<br/><br/>
<b>1.</b> Select the required Department from the 'Select Department' drop down list.<br/>
<b>2.</b> In the contact form enter the required telephone number in the Telephone Number Field. eg: 2001<br/>
<b>3.</b> Select Telephon from the Type drop down list.<br/>
<b>4.</b> Select Access from the Method drop down list.<br/>
<b>5.</b> Click Submit.<br/><br/>
<b>Delete Voicemail Contacts</b><br/>
<b>1.</b> Select the required Department from the 'Select Department' drop down list.<br/>
<b>2.</b> Ensure the 'Delete all exisiting voicemail contacts from department' tick box is ticked.<br/>
<b>3.</b> Click Submit.<br/>
All voicemail contacts on your selected department will have been deleted.<br/><br/><br/>

<b>Telephone number</b><br/>
The Telephone Number field supports 64 characters.<br/><br/>
When used with Telephone Contact Type and the Access Contact Method  the telephone number
to match against the incoming CLI to allow the User to access voicemail remotely without having to
enter the Access Code.<br/><br/>
When used with Telephone Contact Type, the Deliver and Deliver New Contact Method  the
telephone number dialed by the system to allow voicemail to deliver a new message.<br/><br/>
When used with Telephone Contact Type and the Prompt Contact Method  the Users extension
number.<br/><br/>
When used with the Email Contact Type  the email address where email messages informing the
User of a new message will be sent.<br/><br/>
When used with SMS Contact Type  the email address where SMS alerts informing the User of a
new voicemail message will be sent.<br/><br/>
When used with the Lamp Contact Type  the extension number of the Index handset across the
DPNSS link<br/><br/>
When used with the Archive Contact Type this field is ignored, however, there must be at least a
single character entered.<br/><br/>
When used with Archive Email Contact Type  the email address where the new call recording will be
sent.<br/><br/>

<b>Type</b><br/>
<b>Telephone</b><br/>
<b>1</b>  When accessing voicemail remotely if the incoming CLI matches the entry in the
Telephone Number field the User will not need to enter their Access Code. The
Contact Method field must be set to Access<br/><br/>

<b>2</b>  Voicemail will ring the number entered in the Telephone Number field to attempt
to deliver a new message. The Contact Method field must be set to Deliver or
Deliver New.<br/><br/>

<b>Email</b>   An email message will be sent to the email address specified in the Telephone
Number field when a new message is received<br/><br/>

<b>SMS</b>   An SMS alert will be sent to the email address specified in the Telephone Number field
when a new voicemail message is received<br/><br/>

<b>Lamp</b>  Used over a DPNSS link to an Index to light the message-waiting lamp on the Index
handset.<br/><br/>

<b>Archive</b>  Enables an external application  such as Vision  to collect call recordings,
made manually and/or automatically, from this Users voicemail box. VM Contact
Method should be set to Deliver and Delete or Deliver. The former is strongly
recommended as it minimises the hard disc space consumed by call recording.<br/><br/>

<b>ArchiveEmail</b>  A new call recording will be sent to the email address specified in the Telephone<br/><br/>

<b>SMS Web</b>  To enable SMS notification via a web page<br/><br/>

<b>Custom Email</b>  This option is used to send a customised email message to the address entered in the Telephone Number field rather than the default email message. This requires modification of the genmail  that can be found in /SpliceCom, the method MUST be set to Deliver Link<br/><br/>


<b>Method</b><br/>
<b>None</b>  Used in conjunction with Email Contact Type. The User can manually select to
forward a voicemail message to the email address entered in the Telephone
Number field.<br/><br/>

<b>Alert</b>
<b>1</b>  When used in conjunction with the Email Contact Type the User will be
automatically sent an email message to the email address entered in the
Telephone Number field to inform them that they have received a new
voicemail message<br/><br/>

<b>2</b>  When used in conjunction with the SMS Contact Type the SMS alert will be
sent to the email address specified in the Telephone Number field<br/><br/>

<b>3</b>  When used in conjunction with the Lamp Contact Type the message waiting
lamp will be lit on the extension number entered in the Telephone Number
field<br/><br/>

<b>Deliver</b><br/>
<b>1</b>  When used in conjunction with the Email and ArchiveEmail Contact Type a
new voicemail message will be automatically sent to the email address
entered in the Telephone Number field. The message will be marked as old
on the voicemail server and deleted after 7 days.<br/><br/>

<b>2</b>  When used in conjunction with the Telephone Contact Type voicemail will
attempt to deliver a new voicemail message to the number entered in the
Telephone Number field<br/><br/>

<b>Copy</b>   Used in conjunction with the Email Contact Type. A new voicemail message will
be automatically sent to the email address entered in the Telephone Number
field. The message will still be considered a new message on the voicemail
server<br/><br/>

<b>Access</b>   Used in conjunction with the Telephone Contact Type to allow Users to access
their voicemail remotely without entering the Access Code.<br/><br/>

<b>Prompt</b>  Used in conjunction with the Telephone Contact Type to prompt a User for their
Access Code when accessing voicemail via a Dial Plan entry.<br/><br/>

<b>Deliver and Delete</b>   Used in conjunction with the Email and ArchiveEmail Contact Type. A new
voicemail message will be automatically sent to the email address entered in the
Telephone Number field. The message will be immediately deleted from the
voicemail server.<br/><br/>

<b>Deliver New</b>  Used in conjunction with the Telephone Contact Type. Voicemail will attempt to
deliver a new voicemail message to the number entered in the Telephone
Number field however the message will not be preceded by the usual statement
indicating the number of new messages received.<br/><br/>

<b>Deliver Link</b>  Used in conjunction with the Email Contact Type. A new voicemail message will
be automatically sent to the email address entered in the Telephone Number
field and link to the voicemail server will be provided. The recipient will be
requested to enter the relevant extension number and voicemail access code
when using this link and messages will be played via the media player on the
recipients PC.<br/><br/><br/>

<b>Users - Voicemail to Email</b><br/>
This script will allow you to create a voicemail contact against each users who has an existing email address configured.<br/><br/>
In the extension range field, enter the extension numbers to be used.<br/>
From the Type dropdown select the Contact Type.<br/>
From the Method dropdown select the Method Type.<br/><br/>
Clicking submit will create a new voicemail contact for each extension that has an email address configured.<br/><br/>


</div>
</body>
</html>
