$(function(){
	
	$('#select').on('change', function() {
		
		preview = $(this).val();
		if (preview.length > 1) {
			
			$('#myfile').attr('disabled',true).css( 'cursor', 'not-allowed' );
			$('#uploadBtn').attr('disabled',true).css( 'cursor', 'not-allowed' );
			$('#submitcreate').attr('disabled',false).css( 'cursor', 'pointer' );
			
			
			width = $(this).find(':selected').data('width')
			height = $(this).find(':selected').data('height')
	
			$('#imagepreview').show();
			$('#imagepreviewdiv').css("background", "url('/prov/SIPimages/" + preview + "') center / contain no-repeat");
			$('#imgres').html('<b>Selected Image</b> : ' + width + '(w) * ' + height + '(h)');
			
			$('#f1_upload_process').html('<b>' + preview + '</b> selected<br>');
			$('#f1_upload_process').append('Please select phones and create Custom File.<br><br><i>To upload a file clear the selected file<i>');
		} else {
			$('#myfile').attr('disabled',false).css( 'cursor', 'pointer' );
			$('#uploadBtn').attr('disabled',false).css( 'cursor', 'pointer' );
			$('#submitcreate').attr('disabled',true).css( 'cursor', 'not-allowed' )
			
			$('#imagepreviewdiv').css("background", "url('') center / contain no-repeat");
			$('#imgres').html('');
			$('#f1_upload_process').html('');
		}
			
	});	
	
	var _URL = window.URL || window.webkitURL;
	$('body').on('change', '#myfile', function(){
		var file = $(this)[0].files[0];
		var filename = $('input[type=file]').val().split('\\').pop();

		if (filename.length >1) {
			$('#select').attr('disabled',true).css( 'cursor', 'not-allowed' );
			$('#submitcreate').attr('disabled',false).css( 'cursor', 'pointer' )
				
			img = new Image();
			img.src = _URL.createObjectURL(file);
			
			img.onload = function() {
				imgwidth = this.width;
				imgheight = this.height;	
				$('#imagepreview').show();
				$('#imagepreviewdiv').css("background", "url('" + img.src + "') center / contain no-repeat");
				$('#imgres').html('<b>Selected Image</b> : ' + imgwidth + '(w) * ' + imgheight + '(h)');
				
				$('#f1_upload_process').html('<b>' + filename + '</b> selected<br>');
				$('#f1_upload_process').append('Please click Upload Wallpaper.<br><br><i>To select a file from the list, clear this file first<i>');
			}
		} else {
			$('#select').attr('disabled',false).css( 'cursor', 'pointer' );
			$('#submitcreate').attr('disabled',true).css( 'cursor', 'not-allowed' )
			$('#imagepreviewdiv').css("background", "url('') center / contain no-repeat");
			$('#imgres').html('');
			$('#f1_upload_process').html('');
		}
	});
	
	
	$('body').on('click','#submitcreate', function() {
				
		select = ($('#select').val() != null && $('#select').val().length > 0) ? $('#select').val() : '';
		myfile = ($('#myfile').val() != null && $('#myfile').val().length > 0) ? $('#myfile').prop("files")[0]['name'] : '';
		phones = ($('#phones').val() != null && $('#phones').val().length > 0) ? $('#phones').val() : '';
		
		
		if (select.length > 1) {
			wallpaper = select;
		} else if (myfile.length > 1) {
			wallpaper = myfile;	
		} else {
			wallpaper = '';
		}
		
		if (phones.length < 1) {
			var n = noty({ type: 'error', layout: 'center', text: 'Error: No Phones Selected<br><br><i>Click to Close</i>', dismissQueue: true, theme: 'relax', modal: true,  maxVisible: 1 });
			return false
		}
		
		var n = noty({
			type: 'warning', layout: 'center', text: 'Create Custom Yealink File For Selected Devices With Wallpaper File <b>' + wallpaper + '</b> ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
			buttons : [ { 
				addClass: 'btn btn-primary', text: 'Create File', onClick: function ($noty) {
					
					$.ajax({ 
						type: "POST", 
						cache: false,
							url : "wallpaper_do.php?mode=create&wallpaper=" + wallpaper + '&phones=' + phones, 
							success: function(data) { 
								console.log(data)
								if (data.toLowerCase().indexOf("error") >= 0) {
									var n = noty({ type: 'error', layout: 'center', text: 'Error: An Error Has Occured Please Contact Support<br><br><i>Click to Close</i>', dismissQueue: true, theme: 'relax', modal: true,  maxVisible: 1 });
								} else {
									var n = noty({ type: 'success', layout: 'center', text: 'Success: custom_yealink.php created<br><br><i>Click to Close</i>', dismissQueue: true, theme: 'relax', modal: true,  maxVisible: 1 });
									$('#myfile').val('');
									$('#select').attr('disabled',false).css( 'cursor', 'pointer' );
									$('#uploadBtn').attr('disabled',true).css( 'cursor', 'not-allowed' );
									$('#submitcreate').attr('disabled',true).css( 'cursor', 'not-allowed' )
									setTimeout(function () {
										$('#f1_upload_process').html('custom_yealink.php created.<br><br>Click <b><a href="../manager/assist/download.php?download=/SpliceCom/Web/prov/custom_yealink.php">HERE</a></b> to download the file.');
									}, 1000);
								}
							}
					});
				
				$noty.close(); 
				}
			},{ 
				addClass: 'btn btn-warning', text: 'Cancel', onClick: function ($noty) {
				$noty.close(); 
				}
			}] 
		});
	});
	
});

function startUpload(){
    document.getElementById('f1_upload_process').innerHTML = "Uploading...&nbsp;<img src='assets/images/save_banner.gif' /><br/>";
    return true;
}
function stopUpload(success,filename) {
	console.log (success,filename)
	var result = '';
	var filename = filename;
	if (success == 1){
		document.getElementById('f1_upload_process').innerHTML = "<b>" + filename + "</b> uploaded<br>";
		$('#f1_upload_process').append('Please select phones and create Custom File.');
	} else {
		document.getElementById('f1_upload_process').innerHTML = "<p class='f1_error'>File Upload Error</p>";
	}
	return true;   
}