
$(document).ready(function(){
	
	pbxtype = $('#model').val();
	
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});
	
	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
	
	$('#poweroff').change(function(){
		if($(this).val()=="2"){
			$.ajax({ url : 'log/reset.php?patchRBF=1' });
			alert ('Reboot When Free Selected');
		}
	});	
	
	$('body').on( 'click', '#reset', function (e) {
		var reset = confirm ('Reset Form...\nDo You Want To Continue ?');
		
		if (reset == true) {
			$('.ver').val('');
			$('input:checkbox').removeAttr('checked');
			$('#server').val('max.splicecom.com::max');
			$("#vers").val("latest");
		
			frmware('latest');
		} else {
			return false;
		}
	});
	
	
	$('#vers').change(function() {
		ver = $(this).val();
		frmware(ver);
		
		if(ver == "beta"){
			$(function() {
				$('#overlay').fadeIn('fast',function(){
				$('#alert').animate({'top':'100px'},500);
			});
			$('#alertclose').click(function(){
				$('#alert').animate({'top':'-600px'},500,function(){
				$('#overlay').fadeOut('fast');
				$("#vers").val("recommended");
				frmware('latest');
				});
			});
			$('#alertOK').click(function(){
				$.ajax({ url : 'log/reset.php?patch=1' });
				$('#alert').animate({'top':'-600px'},500,function(){
				$('#overlay').fadeOut('fast');
				});
			});
			});
		}
	});
	
	load = ($("#vers").val());
	if (load=="beta") {
		$(function() {
			$('#overlay').fadeIn('fast',function(){
			$('#alert').animate({'top':'100px'},500);
		});
        $('#alertclose').click(function(){
            $('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            $("#vers").val("recommended");
			frmware('latest');
            });
          });
        $('#alertOK').click(function(){
	        $.ajax({ url : 'log/reset.php?patch=1' });
            $('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            });
          });
        })
	}
	

	$('body').on( 'click', '#go', function (e) {
		e.preventDefault();
		
		if ($("input:checked").length <1) {
			alert ('No Firmware Selected');
			$('#go').hide();
			return false;
		}
		
		admin = $('#adminp').val();
		if (typeof(admin) != "undefined" && admin !== null) {
			if (pbxtype == 'SV1000' && (admin[0] == '3' || admin[0] == '4')) {
				warning = 'Detected system is an SV1000.\nAre you sure you want to download this version of firmware (' + admin + ') ?'
			} else if (pbxtype == 'CallServer' && admin[0] == '1') {
				warning = 'Detected system is an CallServer.\nAre you sure you want to download this version of firmware (' + admin + ') ?'
			} else if (pbxtype == 'softPBX' && admin[0] == '1') {
				warning = 'Detected system is an softPBX.\nAre you sure you want to download this version of firmware (' + admin + ') ?'
			} else {
				warning = '';
			}
			
			if (warning.length >1) {
				var warningCheck = confirm(warning);
				if (warningCheck == false) {
					$('#go').hide();
					return false
				}
			}
		}
		var msg = '';
		$("input:checked").each(function() {
			type = $(this).closest('tr').find(".type").text();
			ver = $(this).closest('tr').find(".ver").val();
			placeholder = ($(this).closest('tr').find(".ver").attr('placeholder').length > 1) ? $.trim($(this).closest('tr').find(".ver").attr('placeholder')) : 'NOT SET - Will be reset';
			
			if (placeholder == "NOT SET - Will be reset" ) $(this).attr('checked', false);
			
			version = (ver && ver.length > 1) ? ver : placeholder
			msg += type + " - " +  version + "\n";
		});

		var res = confirm ('Download firmware:\n\n' + msg + '\nDo You Want To Continue ?');
		console.log (res)
		if (res == true) {
			if ($("input:checked").length >= 1) {
				$('<input />').attr('type', 'hidden').attr('name', 'go').attr('value', 'go').appendTo('#firmwareform');
				$('<input />').attr('type', 'hidden').attr('name', 'update').attr('value', '0').appendTo('#firmwareform');
				$('#firmwareform').submit();
			}
			
		} else {
			$('#go').hide();
			return false;
		}
	})
	
	$('body').on( 'focusout', '.ver', function (e) {
		verval = $(this).val().toLowerCase();
		
		n = verval.indexOf("(");
		char = verval[n-1];
				
		rpl = (char == '.') ? '' : '.';
		verval = verval.replace('(',rpl);
		verval = verval.replace(')','');
		verval = verval.replace('..','.');
		verval = verval.replace('sv','');
		
		$(this).val(verval);
		$('#go').hide();
	})
	
	
	$('body').on( 'change', '.enable', function (e) {
		$('#go').hide();
	})
	
});	
	
	function frmware(str) {
		
		var sv = '';
		$('.ver').each(function(i, obj) {
			$(this).attr('placeholder', '')
		})

		str = (str.length > 1) ? str : 'latest'
		$.ajax({ url : 'webpatch_do.php?ver=' + str,
			success : function(text) {
				console.log(text)
				$.get('../../download/firmware.' + str, function(data) {
					data = data.replace(/ /g, '');
					data = data.split('\n');
					$.each(data, function (index, value) {
						firmware = value.split('=');
												
						
						if (pbxtype == 'SV1000') {
							
							if (firmware[0] == 'SV1000') sv = firmware[1];
						}
						
						if (firmware[0] == 'voicemail') firmware[0] = 'vm'
						if (firmware[0] != '#') $('#' + firmware[0] + 'p').attr('placeholder', firmware[1]);
					});	
					
					if (pbxtype == 'SV1000') $('#adminp').attr('placeholder', sv.replace('SV',''));
				});
			}
		});	
	}