<?php
session_start();
// v2.32 - added PHP5+ detection
// v2.31 - fix issue with range for import.
// v2.30 - Updated Import and Add
// v2.27 - slow down deletion of speeddials, show delete and add output on screen
// v2.26 - slow down adding of speeddials
//PJC 28JAN2016 - Fixed issue with export warning about no extension range.
//PJC 29DEC2015 - Update alert for no extension range - flash field and set focus	
//PJC 16June2014 - wording update
//PJC 16Jan2013
ini_set('max_execution_time', '0');
set_time_limit(0);

$page_id = "016";
include ".access.php";
include "tzone.php"; // include timezone
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : NULL;
if (isset($_GET['download'])) {
	$filename=$_GET['file'];
	$fn = "/SpliceCom/Web/download/".$filename;
	if(is_readable($fn)) {
		$filesize = filesize($fn);
		$filetime =date("r",filemtime($fn));
		$fp=@fopen($fn,"r");
		if($fp)
		{
			header("Accept-Ranges: bytes");
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=$filename; size=$filesize; modification-date=\"$filetime\"");
       		while (!feof($fp)) {
        		echo(fread($fp, 4096));
    	    }
   	    	fclose ($fp);
   	    	unlink ($fn);
			exit;
	    }
	}
	header("HTTP/1.0 404 Not Found");
	exit;
}

$script=$_SERVER['SCRIPT_NAME'];

function num_range($s) {
$tmp = explode(',', $s);
$nums = array();
foreach ($tmp as $el)
{
    $a = explode('-', $el);
    if (count($a) == 1)
    {
        $nums[] = (int)$a[0];
    }
    else
    {
        for ($i = $a[0]; $i <= $a[1]; ++$i)
        {
            $nums[] = (int)$i;
        }
    }
}
$nums = array_unique($nums);
return $nums;
}


	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	$backup = "Backup ".date('d.m.y His')." - PreBulkSpeeddialUpdate.txt";
?>

<html>
<head>
<title>Speed Dials - Add, Import, Export And Update</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="css/buttons.css" rel="stylesheet" type="text/css">
<link href="css/speeddials.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/speeddials.js" type="text/javascript"></script>
</head>
<body>

<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_speeddials.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div style="position:absolute; top:30px; right:8px" >
<?php link_check("029","<a href='extension_list.php' target='_blank'>Extension List</a>", $ma_acl); ?>
</div>
<div id="contain">
<h2><img src='images/settings.png' style="vertical-align:middle;">&nbsp;Speed Dials - Add, Import, Export And Update</h2>
This script allows you to bulk Add new speed dials to an individual or range of extensions, Bulk update existing speed dials<br>
and import or export speed dials from selected users.<br><br>
<b>PLEASE NOTE :</b><br>
The maximum number of users speeddials can be applied to is 100 and the maximum number of speeddials that can be imported is 50.<br>
Adding or Updating speed dials will use additional system resources and could cause slow downs.<br>We recommend this is only done out of hours or during 'quiet' periods.<br><br>
Select what action you would like to perform.<br>
<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">
<select onchange="formSubmit()" name="action">
<option value="" > </option>
<option value="1" <?php if ($action == '1') echo 'selected'; ?> >Add New Speed Dials</option>
<option value="2" <?php if ($action == '2') echo 'selected'; ?> >Update Existing Speed Dials</option>
<option value="3" <?php if ($action == '3') echo 'selected'; ?> >Remove Existing Speed Dials</option>
<option value="4" <?php if ($action == '4') echo 'selected'; ?> >Import Speed Dials</option>
<option value="5" <?php if ($action == '5') echo 'selected'; ?> >Export Speed Dials</option>
</select>&nbsp;<a href='#' class='tooltip' title='Select The Action To Perform'><img src='images/tooltip.gif'></a></form>

<?php
If (isset($_REQUEST['action'])) {

if ($_REQUEST['action'] =='2') {
?>
<div><h2>Update Existing Speed Dials</h2>
Enter the Telephone number of the speed dial you would like to update. Using this form you can change the number, shortcode and description.<br>
The only values that must be completed are the Old and New telephone numbers.<br><br>
In the 'Extension Range' field enter the extension numbers where the speed dials are to be applied. Enter either a comma between<br>
each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br><br>
Clicking 'Add Row' adds additional speed dial rows.<br>
Clicking 'Remove row' removes the last speed dial row added.<br>
Clicking 'Update Speed Dials' will update your selected speed dials.<br><br>
eg:<br>
Old Number: 2001, New Number: 2001, Description: John - would update all speed dials with the telephone number of 2001 to telephone number 2001 Description John.<br>
Old Number: 1234, New Number: 3200, Description: Mark - would update all speed dials with the telephone number of 1234 to telephone number 3200 Description Mark.<br><br>
<br><br><form method='post' name='update'>
<b>Extension Range :</b>  <input type="text" name="extn_range" id="extn_range_update" size="60" />&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></br></br>
Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br><br>
<table border="1" id="update">
  <tr>
    <th colspan="2">Old Number&nbsp;<a href='#' class='tooltip' title='Current Speeddial Number'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">New Number&nbsp;<a href='#' class='tooltip' title='New Speeddial Number'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Shortcode&nbsp;<a href='#' class='tooltip' title='Shortcode If Required'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Description&nbsp;<a href='#' class='tooltip' title='Speeddial Description'><img src='images/tooltip.gif'></a></th>
  </tr>
  <tr>
    <td>1</td>
    <td><input type="text" name="old[]" id="txtRow1" size="15" /></td>
    <td><input type="text" name="new[]" id="txtRow2" size="15" /></td>
    <td><input type="text" name="short[]" id="txtRow3" size="15" /></td>
    <td><input type="text" name="desc[]" id="txtRow4" size="15" /></td>
  </tr>
</table>
<p><input type="button" value="Add Row" onclick="addRowToTable('update');" />
<input type="button" value="Remove Row" onclick="removeRowFromTable('update');" /></p>
<input type="hidden" name="update" value="update">
<p><input type="submit" value="Update Speed Dials" /></p>
</form></div>

<?php
	}

if ($_REQUEST['action'] =='1') {
?>
<div><h2>Add New Speed Dials</h2>
In the 'Extension Range' field enter the extension numbers where the speed dials are to be applied. Enter either a comma between<br>
each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br><br>
Selecting 'Delete all exising speed dials from range' will delete ALL existing speed dials from the extension numbers entered prior to applying the new entries.<br><br>
Clicking 'Add Row' adds additional speed dial rows.<br>
Clicking 'Remove row' removes the last speed dial row added.<br>
Clicking 'Add Speed Dials' applies the new speed dials to your selected extension range.<br><br>
A database backup is automatically performed before the new speed dials are applied<br><br>
<form method='post' name='add'>
<br><b>Extension Range : </b><input type="text" name="extn_range" id="extn_range_add" size="60" />&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></br>
Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br><br>
Delete all exisiting speed dials from range : <input type="checkbox" name="delsp" id="delsp" />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Delete All Existing Speeddials From Your Range'><img src='images/tooltip.gif'></a><br><br>
<table border="1" id="add">
  <tr>
    <th colspan="2">New Number&nbsp;<a href='#' class='tooltip' title='New Speeddial Number'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Shortcode&nbsp;<a href='#' class='tooltip' title='Shortcode If Required'><img src='images/tooltip.gif'></a></th>
    <th colspan="1">Description&nbsp;<a href='#' class='tooltip' title='Speeddial Description'><img src='images/tooltip.gif'></a></th>
  </tr>
  <tr>
    <td>1</td>
    <td><input type="text" name="new[]" id="txtRow2" size="15" /></td>
    <td><input type="text" name="short[]" id="txtRow3" size="15" /></td>
    <td><input type="text" name="desc[]" id="txtRow4" size="15" /></td>
  </tr>
</table>
<p><input type="button" value="Add Row" onclick="addRowToTable('add');" />
<input type="button" value="Remove Row" onclick="removeRowFromTable('add');" /></p>
<input type="hidden" name="add" value="add">
<p><input type="submit" value="Add Speed Dials" /></p>
</form></div>

<?php
}

if ($_REQUEST['action'] =='3') {
?>
<div><h2>Remove Existing Speed Dials</h2>
Enter the Telephone number of the speed dial you would like to Remove.<br>
In the 'Extension Range' field enter the extension numbers where the speed dials are to be removed from. Enter either a comma between<br>
each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br><br>
Clicking 'Remove Speed Dials' will remove your selected speed dial from the extensions requested.<br><br>
<br><br><form method='post' name='remove'>
<b>Extension Range :</b>  <input type="text" name="extn_range" id="extn_range_remove" size="60" />&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></br></br>
Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br><br>
<table border="1" id="remove">
  <tr>
    <th colspan="1">Telephone Number&nbsp;<a href='#' class='tooltip' title='Speeddial Telephone Number'><img src='images/tooltip.gif'></a></th>
  </tr>
  <tr>
    <td><input type="text" name="tele" id="txtRow1" size="15" /></td>
  </tr>
</table>
<input type="hidden" name="remove" value="remove">
<p><input type="submit" value="Remove Speed Dials" /></p>
</form></div>

<?php
	}

if ($_REQUEST['action'] =='4') {
	$sprange = (isset($_REQUEST['sprange']) && strlen($_REQUEST['sprange'] >1)) ? urldecode($_REQUEST['sprange']) : NULL;
?>
<div><h2>Import Speed Dials</h2>
Import Speed Dials for selected users.<br><br>
Import file needs to be in the following format:<br>
telephone;shortcode;description<br>
2001;;Extn 2001<br>
2002;G:1;Extn 2002<br><br>
In the 'Extension Range' field enter the extension numbers where the speed dials are to be applied. Enter either a comma between<br>
each extension number or use a hyphen to indicate a range of extensions. For example: 2001,2003,2005,2009,2015,2020 etc or 2001-2050<br><br>
<b>Please Note:</b><br>
If you are importing bulk speeddials to multiple users, once the import is complete we recommend you either reboot the phones or log the users out and back in again.<br><br>

<form action="speeddialupload.php" method="post" enctype="multipart/form-data" target="upload_target" name='upfile' id='uploadform' onsubmit="startUpload();" >
<br><br><b>Extension Range :</b>  <input type="text" name="extn_range" id="extn_range_import" size="60" value="<?php echo $sprange ?>" />&nbsp;<a href='#' class='tooltip' title='Enter Extension Number Range'><img src='images/tooltip.gif'></a></br>
Create System Backup : <input type="checkbox" name="backup" id="backup" checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.gif'></a><br><br>
Delete all existing speed dials from range : <input type="checkbox" name="delsp" id="delsp" />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Delete ALL Existing Speeddials From Your Range'><img src='images/tooltip.gif'></a><br><br><br>

<div class='upload'>
<b>Import SpeedDials</b>
	
		<p id="f1_upload_form" align="center">
			<input name="myfile" id="myfile" type="file" size="30" />
			<input type='hidden' id='mode' name='mode' value='upload' />
			<input type='hidden' id='counter' name='counter' value='' />
            <input type="submit" name="submitBtn" id="uploadBtn" value="Upload CSV File" />
		</p>
		<iframe id="upload_target" name="upload_target" src="#" style="display:none"></iframe>
</form>

	<p id="f1_upload_process"></p>
</div>
</div>
<div class='applysp'>

	 <form action="speeddials.php" method="post" name='importspeeddials' id='importspeeddials' >
		<input type='submit' name='uploadprocess' id='uploadprocess' value='Apply SpeedDials' disabled='disabled'/>
		
		<input type='hidden' id='import' name='import' value='' />
		<input type='hidden' id='action' name='action' value='4' />
		<input type='hidden' id='sptime' name='sptime' value='' />
		<input type='hidden' id='sprange' name='sprange' value='' />
		<input type='hidden' id='spbackup' name='spbackup' value='' />
		<input type='hidden' id='spdelete' name='spdelete' value='' />
	</form>
</div>

<br><br>


<?php
	}

if ($_REQUEST['action'] =='5') {
?>
<div><h2>Export Speed Dials</h2>
Export Speed Dials for selected user.<br><br>
Exporting Speed Dials creates a download link for the speeddial.csv file<br>
A copy of this file is in the /Web/download directory and is automatically deleted when the file has been downloaded.<br>
Delete existing speed dials will delete the users current speed dials, once they have been exported.<br><br>
<form method="post" name='export'>
<br><b>Select User : </b><select name="user" id="extn_range_export"><option value=""></option>
<?php	   $sr=ldap_list($ds,"cn=Users", "(objectclass=*)", array('cn','telephonenumber'));
 	   $info = ldap_get_entries($ds, $sr);
       		for ($n=0; $n<$info['count']; $n++) {
				$cn = $info[$n]['cn'][0];$telephonenumber = $info[$n]['telephonenumber'][0];
				echo "<option value='$cn'>$cn  ($telephonenumber)</option>";
				}
?>
</select>&nbsp;<a href='#' class='tooltip' title='Select User From Who Speeddials Are To Be Exported'><img src='images/tooltip.gif'></a><br><br><b>Export SpeedDials</b><br>
Delete exisiting speed dials : <input type="checkbox" name="delsp" id="delsp" />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Delete ALL Existing Speeddials From User'><img src='images/tooltip.gif'></a>
<br><input type="submit"  style="font-size: 10pt; font-family: Tahoma" name="export" value="Export Speed Dials" /></form>
</div>
<?php
	}
  }
?>

</body>
</html>

<div id='res'>
<?php

// UPDATE //
if (!empty($_REQUEST['update'])=="update") {
echo "<h2>Update Existing Speed Dials</h2><br>";
$old = $_REQUEST['old']; 
$new = $_REQUEST['new']; 
$short = $_REQUEST['short'];
$desc = $_REQUEST['desc']; 
$range = num_range($_REQUEST['extn_range']);

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	backup($backup);
}

$sr=ldap_list($ds,"cn=users","(objectclass=*)",array('cn','telephonenumber'));
    $usr = ldap_get_entries($ds, $sr);
       	for ($s=0; $s<$usr['count']; $s++) {
           $users[$usr[$s]['telephonenumber'][0]]=$usr[$s]['cn'][0];
       	}

foreach ($users as $k => $v) {
		if (in_array($k, $range)) $updateusers[] = $v;
		}
foreach ($updateusers as $nk => $nv) {
foreach($old as $ok => $ov) {
	$sr = ldap_search($ds,"cn=".$nv.",cn=Users","(&(telephonenumber=".$ov.")(objectclass=speeddial))",array("dn"));
        $info = ldap_get_entries($ds, $sr);
		   for ($n=0; $n<$info["count"]; $n++) {

		$ent["telephonenumber"][0] = $new[$ok];
        $ent["description"][0] = $desc[$ok];
        $ent["shortcode"][0] = $short[$ok];
        $dn = $info[$n]["dn"];
        ldap_modify($ds, $dn, $ent);
    	}
	}
}

foreach ($old as $k => $n) {
echo "Old speed dials numbered <b>".$old[$k]."</b> Have been updated to <b>".$new[$k]. "</b> ( ".$desc[$k]." )<br>";
}

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") echo "<br><br>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update";
}
// UPDATE //


// ADD //
if (!empty($_REQUEST['add'])=="add") {
$delsp = isset($_REQUEST['delsp']) ? $_REQUEST['delsp'] : ''; 
$phone = $_REQUEST['new']; 
$short = $_REQUEST['short']; 
$desc = $_REQUEST['desc']; 
$range = num_range($_REQUEST['extn_range']);

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	backup($backup);
}
echo "<h2>Add New Speed Dials</h2><br><b>Extension number range : </b></br>"; echo $_REQUEST['extn_range']."</br>";
echo "</br><b>Speed Dials : </b></br>";
  for ($m=0; isset($phone[$m]) && isset($short[$m]) && isset($desc[$m]); $m++){
		echo $phone[$m] ." - ". $short[$m] ." - ". $desc[$m]."</br>";
		}

$sr=ldap_list($ds,"cn=users","(objectclass=*)",array('cn','telephonenumber'));
    $usr = ldap_get_entries($ds, $sr);
       	for ($s=0; $s<$usr['count']; $s++) {
           $users[$usr[$s]['telephonenumber'][0]]=$usr[$s]['cn'][0];
       	}

foreach ($users as $k => $v) {
		if (in_array($k, $range)) $updateusers[] = $v;
		}
foreach ($updateusers as $nk => $nv) {

	if ($delsp) {
		ob_flush();flush();
		echo "<b>Deleting Speed Dials</b> - Please wait .";
		ob_flush();flush();
	
        $sr=ldap_search($ds,"cn=".$nv.", cn=users","(objectclass=speeddial)",array('guid'));
			$sp = ldap_get_entries($ds, $sr);
            for ($d=0; $d<$sp['count']; $d++) {
	            $dn = "guid=".$sp[$d]['guid'][0].", cn=".$nv.", cn=Users";
				ldap_delete($ds, "$dn"); usleep(500000); //0.5 second per speedDial
				if ($d % 10 == 0) {
					ob_flush();flush();
					echo ".";
					ob_flush();flush();
					}
			}
		echo "<br>";
	}

	if (!empty($desc[0])) {
		for ($n=0; isset($phone[$n]) && isset($short[$n]) && isset($desc[$n]); $n++) {
			$ent = array(); $ent["shortcode"] = $short[$n]; $ent["description"] = $desc[$n]; $ent["objectclass"] = "speeddial";
			$dn = "telephonenumber=".$phone[$n].",cn=".$nv.", cn=Users";
			ldap_add($ds, $dn, $ent); usleep(500000); //0.5 second per speedDial
		}
	}
	sleep(1); // per user	
}
if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") echo "<br><br>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update";

}
// ADD //


// EXPORT //
if (isset($_REQUEST["export"])) {
if (strlen($_REQUEST['user'])<1) {
?>
<script type = 'text/javascript'>
//<!--
alert("No extension selected.");
//-->
</script>
<?php
exit;
}
$usr = isset($_REQUEST['user']) ? $_REQUEST['user'] : ''; $delsp = isset($_REQUEST['delsp']) ? $_REQUEST['delsp'] : '';
$file = preg_replace('/\s+/', '', $usr); $file = $file."-speeddials.csv";
$fh = fopen("/SpliceCom/Web/download/".$file, 'w') or die("can't open file");
$sr=ldap_list($ds,"cn=$usr, cn=Users", "(objectclass=speeddial)", array('telephonenumber','shortcode','description'));
 	   $info = ldap_get_entries($ds, $sr);
       		for ($n=0; $n<$info['count']; $n++) {
				$tele = $info[$n]['telephonenumber'][0]; $short = $info[$n]['shortcode'][0]; $desc = $info[$n]['description'][0];
				$sp = $tele.";".$short.";".$desc."\r\n";
				fwrite($fh, $sp);
				}
				fclose($fh);

		if ($delsp) {
			ob_flush();flush();
			echo "<b>Deleting Speed Dials</b> - Please wait .";
			ob_flush();flush();
		
            $sr=ldap_search($ds,"cn=$usr, cn=users","(objectclass=speeddial)",array('guid'));
				$sp = ldap_get_entries($ds, $sr);
                for ($d=0; $d<$sp['count']; $d++) {
	                $dn = "guid=".$sp[$d]['guid'][0].", cn=$usr, cn=Users";
					ldap_delete($ds, "$dn"); usleep(500000); //0.5 second per speedDial
					if ($d % 10 == 0) {
						ob_flush();flush();
						echo ".";
						ob_flush();flush();
						}
				}
				echo "<br>";
				sleep(2);
			}
		
	echo "<h2>Export Speed Dials</h2><br>";
	echo "Export speed dials from user <b>".$usr."</b><br><br>";
	echo "<a href='".$_SERVER['PHP_SELF']."?download=1&file=$file'><img src='images/down.png' alt='Download Speeddials' title='Download Speeddials' width='50' height='50'><br>Download</a>";

}
// EXPORT //


// REMOVE //
if (!empty($_REQUEST['remove'])=="remove") {
	if (empty($_REQUEST['tele'])) exit("No Telephone Number Entered");
	if (empty($_REQUEST['extn_range'])) exit("No Extension Number Entered");
echo "<h2>Remove Existing Speed Dials</h2><br>";
$tele = $_REQUEST['tele']; 
$range = num_range($_REQUEST['extn_range']);

if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") {
	backup($backup);
}

$sr=ldap_list($ds,"cn=users","(objectclass=*)",array('cn','telephonenumber'));
    $usr = ldap_get_entries($ds, $sr);
       	for ($s=0; $s<$usr['count']; $s++) {
           $users[$usr[$s]['telephonenumber'][0]]=$usr[$s]['cn'][0];
       	}
foreach ($users as $k => $v) {
		if (in_array($k, $range)) $userupdate[] = $v;
		}
foreach ($userupdate as $nk => $nv) {
	$sr = ldap_search($ds,"cn=".$nv.",cn=Users","(&(telephonenumber=".$tele.")(objectclass=speeddial))",array("dn"));
       $info = ldap_get_entries($ds, $sr);
	   	for ($n=0; $n<$info["count"]; $n++) {
        	$dn = $info[$n]["dn"];
        	ldap_delete($ds, $dn); usleep(500000); //0.5 second per speedDial
    	}
}

foreach ($userupdate as $k => $n) {
echo "Speed Dials numbered <b>".$tele."</b> Have been Removed from user : <b>".$n. "</b><br>";
}
if (isset($_REQUEST['backup']) && $_REQUEST['backup']==="on") echo "<br><br>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update";
}
// REMOVE //



// IMPORT //
if (isset($_REQUEST["import"])) {
	
	$deletetotaltime=$spcount='';
	
	$tzone =  (file_exists('/SpliceCom/timezone')) ? trim(file_get_contents('/SpliceCom/timezone')) : 'Europe/London';
	$tzone = (strlen($tzone)>1) ? $tzone : 'Europe/London';

	if ($tzone) {
	if(substr(phpversion(),0,1)>="5") {
			date_default_timezone_set("$tzone");
		} else {
			putenv ("TZ=$tzone");
		}	
	}

	echo "<br><div class='applysp'>SpeedDial Range: <b>$sprange</b><br>";
	echo "Backup : <b>".$_REQUEST['spbackup']."</b><br>";
	echo "Delete existing SpeedDials: <b>".$_REQUEST['spdelete']."</b><br><br></div>";


	$range = num_range($sprange);  
	$delsp = isset($_REQUEST['spdelete']) && $_REQUEST['spdelete'] === 'true' ? $_REQUEST['spdelete'] : '';
	
    $file_content = file_get_contents ( "/SpliceCom/Web/download/spupload.csv" );    
	$file_arr = preg_split ( '/\n/' , $file_content );
	$speedDialRows = count($file_arr);
	
	
	if (isset($_REQUEST['spbackup']) && $_REQUEST['spbackup'] === 'true') {
		backup($backup);
	}	

	$sr=ldap_list($ds,"cn=users","(objectclass=*)",array('cn','telephonenumber'));
		$usr = ldap_get_entries($ds, $sr);
			for ($s=0; $s<$usr['count']; $s++) {
				$users[$usr[$s]['telephonenumber'][0]]=$usr[$s]['cn'][0];
			}

	foreach ($users as $k => $v) {
		if (in_array($k, $range)) $updateusers[] = $v;
	}
	
	if ($delsp) {
		foreach ($updateusers as $nk => $nv) {
			$sr=ldap_list($ds,"cn=$nv, cn=users","(objectclass=speeddial)",array('telephonenumber'));
			$spcount +=  ldap_count_entries($ds, $sr);
		}
		
		$spusercount=count($updateusers);
		$deletetotaltime=$spcount*.05+$spusercount;
		$deletetotaltime = round($deletetotaltime);
	}
	
	$sptime = (isset($_REQUEST['sptime']) && strlen($_REQUEST['sptime'] >1)) ? round($_REQUEST['sptime']) : NULL;
	$sptime += $deletetotaltime;
	$complete= date('H:i',strtotime("+$sptime seconds",strtotime(date('H:i'))));

	echo "<div id='importtime' class='applysp'>Import Should Finish At Approx <b>$complete</b><br><br></div>";
 	echo "<div id='importOutput' class='importresults'>";
	
	foreach ($updateusers as $nk => $nv) {

		if ($delsp) {
		echo "<script>var objDiv = document.getElementById(\"importOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";			
		ob_flush();flush();
		echo "<b>$nv</b> Deleting Speed Dials - Please wait .";
		ob_flush();flush();
		
           $sr=ldap_search($ds,"cn=".$nv.", cn=users","(objectclass=speeddial)",array('guid'));
			$sp = ldap_get_entries($ds, $sr);
               for ($d=0; $d<$sp['count']; $d++) {
	               $dn = "guid=".$sp[$d]['guid'][0].", cn=".$nv.", cn=Users";
				ldap_delete($ds, "$dn"); usleep(500000); //0.5 second per speedDial
				if ($d % 5 == 0) {
					ob_flush();flush();
					echo ".";
					ob_flush();flush();
					}
			}
			echo "<br>";
			echo "<script>var objDiv = document.getElementById(\"importOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";
			sleep(2);
		}

    foreach ( $file_arr as $item ) {
	    $var = strlen($item);
	    if ($var > "3") {
		$data = explode ( ';' , trim($item) );
    		if (isset($data[3])) {
				echo "Wrong File Format.";
				exit;
    		}

    	$_tele = isset($data[0]) ? $_tele = $data[0] : $_tele=''; 
		$_code = isset($data[1]) ? $_code = $data[1] : $_code=''; 
		$_desc = isset($data[2]) ? $_desc = $data[2] : $_desc='';
		
		if ($_tele == "Column1" || $_code == "Column2" || $_desc == "Column3") continue;
		
    	$ent = array(); 
		$ent["shortcode"] = $_code; 
		$ent["description"] = $_desc; 
		$ent["objectclass"] = "speeddial";
		
		$dn = "telephonenumber=".$_tele.",cn=".$nv.", cn=Users";
		
		ldap_add($ds, $dn, $ent) or exit ("Wrong File Type");
		ob_flush();flush();
		echo "Added <b>$_tele</b> to <b>$nv</b><br>";
		ob_flush();flush();
		echo "<script>var objDiv = document.getElementById(\"importOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";
		}
		usleep(500000); // 0.5 seconds per SpeedDial
	}
		echo "<br>";
		echo "Done...<br><br>";
		echo "<script>var objDiv = document.getElementById(\"importOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";
		sleep(1); // per user
	}
	
	
	echo "Completed...";
	unlink('/SpliceCom/Web/download/spupload.csv');
	if (isset($_REQUEST['spbackup']) && $_REQUEST['spbackup'] === 'true') echo "<br><br>A Backup named <b>".$backup."</b> was created in /SpliceCom/ftp prior to this update";
	echo "<script>var objDiv = document.getElementById(\"importOutput\");objDiv.scrollTop = objDiv.scrollHeight;</script>";


echo "</div>";

}
// IMPORT //

function fmtMSS($s){
    return(($s-($s%60))/60).(9<$s?':':':0').$s%60;
};

function backup($backup){
	global $ds;
	$ent["dobackupto"][0] = $backup;
	ldap_modify($ds,"cn=Commands", $ent);
	ldap_modify($ds,"cn=Commands", $ent); $ent='';
	sleep(2);
}

ldap_close($ds);
?>
</div>
</div>



<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            Adding or Updating speed dials will use additional system resources and could cause slow downs.<br><br>
			We recommend this is only done out of hours or during 'quiet' periods.<br><br>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
</div>

<?php if (!isset($_SESSION['speeddials'])) {?>
<script type="text/javascript">
		$(function() {
			$('#overlay').fadeIn('fast',function(){
            $('#alert').animate({'top':'100px'},500);
        });
        $('#alertclose').click(function(){
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            document.location.href='assist.php';
        	});
        });
        $('#alertOK').click(function(){
	    	$.ajax({ url : 'log/reset.php?speeddials=1' });
        	$('#alert').animate({'top':'-600px'},500,function(){
        	$('#overlay').fadeOut('fast');
           	});
        });
		});
</script>
<?php } 
