<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta name="robots" content="noindex, nofollow">
	<meta name="googlebot" content="noindex, nofollow">
	<link rel="stylesheet" type="text/css" href="css/wallpaper.css">
	<link rel="stylesheet" type="text/css" href="css/buttons.css">
	<script type="text/javascript" src="js/wiz/jquery-1.8.0.js"></script>
	<script type="text/javascript" src="js/jquery.noty.packaged.js"></script>
	<script type="text/javascript" src="js/wallpaper.js"></script>
	<script language="javascript">
	var popupWindow = null;
	function centeredPopup(url,winName,w,h,scroll){
		LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
		TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
		settings =
		'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
		popupWindow = window.open(url,winName,settings)
	}
	</script>

<?php
	ini_set('max_execution_time', 600);
	
	$page_id = "093";
	include ".access.php";
	include "tzone.php"; // include timezone
	
	$script = $_SERVER['SCRIPT_NAME'];
	$model = (isset($_REQUEST['model'])) ? $_REQUEST['model'] : "";
	$ds = @ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
	@ldap_bind($ds,"INTERNAL","0123456") or exit("<p>EXIT: LDAP bind failure</p>");
	
	
	
	$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); 
	$info = ldap_get_entries($ds,$sr); 
	$self = $info[0]['location'][0];

	$sr = ldap_read($ds,"cn=$self,cn=Modules","objectclass=module"); 
	$info = ldap_get_entries($ds,$sr); 
	$productversion = $info[0]['productversion'][0];
	
	if (strpos($productversion, 'SV') === false) {
		header('location: assist.php');
	}
?>	
		
	<title>Yealink Wallpaper</title>
</head>

<body>

<div style="position:absolute; top:8px; right:8px" >
	<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
	<img onClick="centeredPopup('help/help_wallpaper.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
	<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
	<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

  <div id="wrap">
  <h2><img src='images/yealink.png' style="vertical-align:bottom;">&nbsp;Wallpaper Configuration</h2><br/>
  
  Either select the wallpaper to be applied from the list, or upload new wallpaper file.<br>
  Once the wallpaper has been chosen, select all phones this should be applied to phones.<br/><br/>
  
  <div class="row">
  <div class="column">
    <table border='1' cellpadding='1' class='table'>
	<tr class='header'><th>Phone Model</th><th>Image</th><th>Max Picture Size in Pixels</th></tr>
	
	<?php
	$model = $cn = array();
	$resolution = array('t29' => '480(w) * 272(h)', 't41' => '192(w) * 64(h)', 't42' => '192(w) * 64(h)', 't46' => '480(w) * 272(h)', 't48' => '800(w) * 480(h)', 't49' => '1280(w) * 800(h)', 
						't52' => '320(w) * 240(h)', 't54' => '480(w) * 272(h)', 't56' => '1024(w) * 600(h)', 't57' => '480(w) * 800(h)', 't58' => '1024(w) * 600(h)', 'cp960' => '720(w) * 1280(h)');
						
		$sr=ldap_search($ds,"cn=Modules","(&(objectclass=phone)(typeofphone=3))", array('cn', 'typeofphone'));
			$info = ldap_get_entries($ds, $sr);
			for ($m=0; $m<$info['count']; $m++) {
				$dn = $info[$m]['dn'];
				
				$sr2 = ldap_read($ds,"cn=1,$dn","objectclass=*",array('pnpmodel'));
				$info2 = ldap_get_entries($ds,$sr2);
				$pnpmodel = str_replace('SIP-','',strtoupper($info2[0]['pnpmodel'][0]));

				
				if (substr($pnpmodel, 0, 1) =='T' || substr($pnpmodel, 0, 1) =='C') {
					$cn[$m] = $info[$m]['cn'][0];
					$model[$m] = str_replace('SIP-','',strtoupper($pnpmodel));
				}
			}
			$uniquemodels = array_unique($model);
		
			foreach ($uniquemodels as $key => $value) {
					$image = (substr($value, 0, 1) =='T') ? substr(strtolower($value),0,3) : strtolower($value);
					$phone = strtoupper($image);
					$phoneImage = (file_exists("images/$image.jpg")) ? "$image.jpg" : "blank.png";
					echo "<tr class='center'><td>$phone</td><td><img src='images/$phoneImage'/></td><td>$resolution[$image]</td></tr>";
				}
		
	?>

	</table>
  </div>
  
  <div class="column">
  	<table border='1' cellpadding='1' class='table'>

	<tr class='smallrow'><td><b>Select Wallpaper</b></td>
	<td><select class='select' name="select" id="select">
	<option></option>
		<?php
		foreach (glob("/SpliceCom/Web/prov/SIPimages/*.{jpg,png}", GLOB_BRACE) as $filename) {
			$wallpaper = basename($filename);
			list($width, $height) = getimagesize($filename);
	
			echo "<option value='$wallpaper' data-width='$width' data-height='$height'>$wallpaper</option>"; 
		}
		?>
		</select>
	</td></tr>
	
	<tr class='upload'>
		<td><b>Upload Wallpaper</b></td>
		<td><form action="wallpaper_do.php" method="post" enctype="multipart/form-data" target="upload_target" onsubmit="startUpload();" >
				<div id="f1_upload_form" align="center">
				<input name="myfile" id="myfile" type="file" /><br>
				<input name="mode" id="mode" value="upload" type="hidden" /><br>
				<input type="submit" name="submitBtn" id="uploadBtn" value="Upload Wallpaper" />
			</div>
			<iframe id="upload_target" name="upload_target" src="#" style="display:none"></iframe>
		</form>
		</td>
	</tr>
	
	<tr>
		<td class='title' style="height:143px;"><b>Select<br>Yealink Phones</b></td>
		<td><select name="phones" id="phones" size='7' class='select' multiple>
	
		<?php
			foreach ($cn as $key => $value) {
				echo "<option value='$value'>$value ($model[$key])</option>"; 
			}
		?>
		</select>
	
		</td>
	</tr>
	
	<tr>
		<td class='title'><b>Status</b></td>
		<td><div class='status' id='f1_upload_process'></div></td>
	</tr>
	
	<tr class='smallrow'>
		<td class='title'><b>Create File</b></td>
		<td colspan='2' style='text-align: center'>
			<input type='submit' name='submitcreate' id='submitcreate' value='custom_yealink.php' disabled style='cursor: not-allowed'/>
		</td>
	</tr>
	</table>
  </div>
  
  <div class="column">
	<table border='1' cellpadding='1' class='table'>

	<tr>
		<td colspan='2' class='imagepreview' id='imagepreview'>
			<div class='imagepreviewdiv' id='imagepreviewdiv'>
			</div>
			<div id='imgres' class='imgres'>
			</div>
		</td>
	</tr>
	</table>
  </div>
  
</div> <!-- row -->

</div> <!-- wrap -->
</body>
</html>
