<?php
ini_set('memory_limit', '128M');
ini_set('max_execution_time',360);

// 	PJC v1.4
// 	import_contacts.php -  command line script			//
//														//
//	run as:												//
// 	import contacts, specify the file to import			//
//	eg: php import_contacts.php contacts.txt			//
//														//
//	export contacts to contacts.out.txt					//					
//	eg: php import_contacts.php export					//
//														//
//	delete contacts										//
//	eg: php import_contacts.php delete					//
//														//
//	refresh contacts. export, delete and import	file	//
//	eg: php import_contacts.php contacts.txt refresh	//


$file = (isset($argv[1])) ? $argv[1] : exit('No Import Contacts File Specified.');
$mode = (isset($argv[2])) ? $argv[2] : NULL; 

if (!isset($mode)) $mode = $argv[1];


$ds = ldap_connect("127.0.0.1",4000);	
if ( ! $ds) {
	echo "LDAP connect failure\n";
} else {
	$r = ldap_bind($ds,"INTERNAL","0112233445566");

	if ( ! $r) {
		echo "LDAP bind failure\n";
		$ds = false;
	}
}


if (isset($mode) && ($mode === 'export')) {
	export();
	ldap_close($ds);
	exit('Export Done');
}

if (isset($mode) && ($mode === 'refresh')) {
	export();
	delete();
	import();
	ldap_close($ds);
	exit('Refresh Done');
}

if (isset($mode) && ($mode === 'delete')) {
	delete();
	ldap_close($ds);
	exit('Delete Done');
}

import();
if (isset($file)) ldap_close($ds);


function import() {
	global $file, $ds;
	if ($file) { 
    $handle = fopen($file,"r"); 
    $n=1;
	
    do {  $n++;
        if (@$data[0]) { 
		
		$cn = $data[0];	
		if ($cn === 'name') continue;
		
		$cn = str_replace('"','',$cn);
		if (strlen($cn) < 1 && strlen($data[1]) >=1) $cn = $data[1];
		
		if (isset($cn) && strlen($cn) > 0) {
			$check = str_replace("(","\(",$cn); 
			$check = str_replace(")","\)",$check);
			
			$count = array();
			$result = @ldap_search($ds, "cn=contacts", "(cn=$check*)", array('cn'), 0, 0);
			$entry = @ldap_first_entry($ds, $result);
			if ($entry) {
				do {
					$count[] = @ldap_get_dn($ds, $entry);
				} while ($entry = @ldap_next_entry($ds, $entry)); 
			}
			$res = count($count);
			if ( $res >= 1 ) {
				$cn = $cn."(".$res.")";
			}
		}
		
		$contact = array (
        'objectclass' => 'Contact',
        'o' => $data[1],
        'cn' => $cn,
        'facsimiletelephonenumber' => ref_number($data[3]),
        'mobiletelephonenumber' => ref_number($data[4]),
        'hometelephonenumber' => ref_number($data[5]),
        'spare1telephonenumber' => ref_number($data[6]),
        'spare2telephonenumber' => ref_number($data[7]),
        'ambiguoustelephonenumber' => ref_number($data[8]),
        'mail' => $data[9],
        'givenname'=> $data[10],
        'sn' => $data[11],
        'description' => $data[12],
        'ou' => $data[13],
        'title' => $data[14],
        'street' => $data[15],
        'l' => $data[16],
        'st' => $data[17],
        'postalcode' => $data[18],
        'c' => $data[19],
        'ouraccount'=>$data[20],
        'theiraccount' => $data[21],
        'url' => $data[22],
        'autourl' => $data[23],
        'directrouteto' => $data[24]
		);
            
		$dn = "telephonenumber=".ref_number($data[2]).", cn=Contacts";
		   
		echo "$cn ADDED\n";
		ldap_add($ds,"$dn",$contact); 
        } 
    } while ($data = fgetcsv($handle,1000,",","'")); 
    	echo "Import Done\n";
	}
}

function ref_number($number) {
	$number = "zczc".str_replace(" ","",$number);
	$number = str_replace("+44(0","0",$number);
	$number = str_replace("0044(0","0",$number);
	$number = str_replace("44(0","0",$number);
	$number = str_replace("44(","0",$number);
	$number = str_replace("+","00",$number);
	$number = str_replace("zczc0044","zczc0",$number);
	$number = str_replace("(0)","",$number);
	$number = str_replace("(","",$number);
	$number = str_replace(")","",$number);
	$number = str_replace("-","",$number);
	$number = str_replace("zczc","",$number);
	return($number);
}
	
function export() {
	global $ds;
$fields = array ('cn' => 'name','o' => 'company','telephonenumber' => 'phone','facsimiletelephonenumber' => 'fax','mobiletelephonenumber' => 'mobile','hometelephonenumber' => 'home','spare1telephonenumber' => 'spare1','spare2telephonenumber' => 'spare2','ambiguoustelephonenumber' => 'ambiguous' ,'mail' => 'mail','givenname'=>'firstname','sn' => 'lastname','description' => 'description','ou' => 'department','title' => 'job','street' => 'street','l' => 'city','st' => 'county','postalcode' => 'postcode','c' => 'country','ouraccount'=>'ouraccount','theiraccount' => 'theiraccount','url' => 'url','autourl' => 'autourl','directrouteto' =>'directrouteto','priorityboost'=>'priorityboost','exdirectory'=>'exdirectory');
$file = 'contacts.out.txt';
		
$list = array();
$result = ldap_search($ds, "cn=contacts", "(cn=*)", array('cn'), 0, 0);
$entry = ldap_first_entry($ds, $result);
if ($entry) {
	do {
		$list[] = ldap_get_dn($ds, $entry);
	} while ($entry = ldap_next_entry($ds, $entry)); 
}

$fp = fopen ($file, "w");
if ($fp) {

	$titles = implode(",",$fields)."\n";
	fputs($fp,$titles);
	$n = 0;

	foreach ($list as $listKey => $listValue) {
		$sr=ldap_read($ds,$listValue,"objectclass=contact");
		$info=ldap_get_entries($ds,$sr); 
		for($n=0; $n<$info['count'];$n++) {           
			$contact = '"';
			foreach ($fields as $key => $value) {
				$row = $info[$n][$key][0];
				$contact = $contact.$row.'","';
			}
			$contact = $contact.'\n';
			$contact = str_replace(',"\n','',$contact);
			fputs($fp, "$contact\n");
			$cn = $info[$n]['cn'][0];
			echo "$cn EXPORTED\n";
		}
	}
	fclose($fp);
	}
}

function delete() {
	global $ds;
	$list = array();
	$result = ldap_search($ds, "cn=contacts", "(cn=*)", array('cn'), 0, 0);
	$entry = ldap_first_entry($ds, $result);
	
	if ($entry) {
		do {
			$dn = @ldap_get_dn($ds, $entry);
			@ldap_delete($ds,$dn);
			echo "$dn DELETED\n";
		} while ($entry = @ldap_next_entry($ds, $entry)); 
	}
}
?> 