<?php

$ip="127.0.0.1";
$user="INTERNAL";
$password="notneeded";

if( $argv[1] )
  $ip=$argv[1];
if( $argv[2] )
  $user=$argv[2];
if( $argv[3] )
  $password=$argv[3];

$s = ldap_connect($ip,4000);
ldap_bind($s,$user,$password);

$attr=Array("cn","GUID","objectclass","lastseen");
$sr=ldap_list($s,"cn=Modules","(objectclass=Module)",$attr);

$info=ldap_get_entries($s,$sr);

foreach( $info as $entry )
{
    $now = time();
    $ago =($now - $entry["lastseen"][0]);
    $warn="";
    
    if( !$entry["cn"][0] )
        continue;
    
    if( $ago < 60 )
    {
        $res = $ago . " seconds";
    }
    else if( $ago < 3600 )
    {
        $res = round($ago / 60,1 ) . " minutes";
    }
    else if( $ago < 86400 )
    {
        $res = round($ago / (60*60),1 ) . " hours";
    }
    else
    {
        $res = round($ago / (60*60*24),1 ) . " days";
        
        if( ($ago / (60*60*24) ) >= 30 )
            $warn = "*********";
    }
    
    print $entry["cn"][0] . " was last seen " . $res . " ago $warn\n";
//    print_r($entry);
}

?>
