<?php
// PJC 18/06/2020 v1.2 Updated Layout
// PJC 09/03/2020 - Licence Count Update
// PJC 09/01/2019 - Only count member modules
// PJC - 19-May-2016 v1.1 - added 17/18 SoftPBX
// PJC - 23-MAR-2016 v1.0
header('Content-type: text/html; charset=UTF-8') ;
$page_id = "041";
include "assist/.access.php";
include "assist/tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);
?>
<html>
<head>
<title>IP User Licences</title>
<head>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<style>body {  background-image: none;}</style>
<script type="text/javascript">
	var state = {};
	var title = 'IPUsers';
	var url   = '/manager/assist';
	history.pushState(state, title, url);
</script>
</head>
<body style="background-color:#F6F6F6";>
<div id="wrapper" style="text-align: center">    
<div id="yourdiv" style="display: inline-block;">
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	
	$licence_count = $callserver = $managedusers = 0;
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(|(license=IPUser)(license=POTS)(license=ManagedUser))(valid=1))",array('license','valid','qty'));
		$infolicences = ldap_get_entries($ds, $sr);
		
		foreach ($infolicences as $key => $val) {
			$license = $val['license'][0];
			if (strpos($license, 'ManagedUser') !== false) $managedusers = 1;
		}
	
	

	$modules_cn = array('3'=>'Phone Module 4315','4'=>'Phone Module 4330','10'=>'Remote CallServer 4140','11'=>'CallServer 5100','12'=>'CallServer 5108','13'=>'Phone Module 5330','14'=>'Phone Module 5315','17'=>'SoftPBX','18'=>'SoftPBX','19'=>'Network Service Gateway','21'=>'Intelligent Gateway Module P302','22'=>'Intelligent Gateway Module P308');
	$modules_ports = array('3'=>'15','4'=>'30','10'=>'8','11'=>'8','12'=>'8','13'=>'30','14'=>'15','17'=>'0','18'=>'0','19'=>'4','21'=>'2','22'=>'8');
	$sv = array('001'=>'0', 'SC'=>'0','MAPS'=>'5','VMAP'=>'0','NSG'=>'0','OFF01'=>'0');

	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(modulestatus=0)(|(moduletype=3)(moduletype=4)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=13)(moduletype=14)(moduletype=17)(moduletype=18)(moduletype=19)(moduletype=21)(moduletype=22)))",array('status','cn','guid','moduletype'));
		$info = ldap_get_entries($ds, $sr);  
		
	echo "<table border ='1' style='border-collapse: collapse; width: 450px';";
	echo "<thead><th>Name</th><th>Module</th></thead>";
	
		for ($m=0; $m<$info['count']; $m++) {
			$module_type = $modules_cn[$info[$m]['moduletype'][0]];
			$module_cn = $info[$m]['cn'][0];
			 echo "<tr><td>$module_cn</td><td><i>$module_type</i></td></tr>";
		}
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr></table>";
	
	
	$sr = ldap_list($ds,"cn=system","(&(objectclass=licenserecord)(license=_SV1000*))",array('license','qty'));
		$info2 = ldap_get_entries($ds, $sr); 
		
		for ($m=0; $m<$infolicences['count']; $m++) {
			if (isset($info2[$m]['license'][0])) $licence = str_replace('_','',$info2[$m]['license'][0]);
				if (strpos($licence, 'SV1000') !== false) {
					$type = explode('-', $licence);
					$quantity = $sv[$type[1]];
					$licence_count += $quantity;
					if ($quantity >0) echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
				}

		}
		echo "<br><table border ='1' style='border-collapse: collapse; width: 450px';";
		echo "<thead><th colspan='2'>Licence</th><th>Quantity</th></thead>";
		for ($m=0; $m<$infolicences['count']; $m++) {

			$licence = $infolicences[$m]['license'][0];
				
			if ($managedusers == 0) {			
				$quantity = $infolicences[$m]['qty'][0];
				$licence_count += $quantity;
				echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
			} else {
				if ($licence == 'ManagedUser' || $licence == 'POTS') {
					$quantity = $infolicences[$m]['qty'][0];
					$licence_count += $quantity;
					echo "<tr><td colspan='2'>$licence</td><td>$quantity</td></tr>";
				}
			}
			
		}
	echo "<tr><td colspan='2'>Total:</td><td><b>$licence_count</b></td></tr>";
	
	$total =  $licence_count;
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";
	echo "<tr><td colspan='2'>Total Licences:</td><td><b>$total</b></td></tr>";
	echo "</table>";			
?>
</div>
</div>
</body>
</html>