<?php
// PJC - 18-June-2020 v1.2 Update VMPort Output, Show VM Ports, location and capacity
// PJC - 19-May-2016 v1.1 - added 17/18 SoftPBX
// PJC - 16-MAY-2016 v1.0

header('Content-type: text/html; charset=UTF-8') ;
$page_id = "041";
include "assist/.access.php";
include "assist/tzone.php"; // include timezone
$script=basename($_SERVER['SCRIPT_NAME']);
?>
<html>
<head>
<title>Voicemail Port Licences</title>
<head>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<style>body {  background-image: none;}</style>
<script type="text/javascript">
	var state = {};
	var title = 'IPUsers';
	var url   = '/manager/assist';
	history.pushState(state, title, url);
</script>
<style>
.row { background-color: #fcfcfc; }
</style>
</head>
<body style="background-color:#F6F6F6";>
<div id="wrapper" style="text-align: center">    
<div id="yourdiv" style="display: inline-block;">
<?php
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}
	
	$port_count = $licence_count = $callserver = 0;
	$modules_cn = array('1'=>'CallServer 4100', '10'=>'Remote CallServer 4140','11'=>'CallServer 5100','12'=>'CallServer 5108','17'=>'SoftPBX','18'=>'SoftPBX','19'=>'Network Service Gateway');
	$SV1000 = array('001'=>240, 'SC'=>30, 'MAPS'=>15, 'VMAP'=>90, 'NSG'=>90, 'OFF01'=>90);

	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))",array('status','cn','guid','moduletype'));
		$info = ldap_get_entries($ds, $sr);  
		
	echo "<table border ='1' style='border-collapse: collapse; min-width: 450px;'>";
	echo "<thead><th>Name</th><th colspan='2'>Module</th></thead>";
	
		for ($m=0; $m<$info['count']; $m++) {
			$module_type = $modules_cn[$info[$m]['moduletype'][0]];
			$module_cn = $info[$m]['cn'][0];
			$module[ $info[$m]['guid'][0] ] = $info[$m]['cn'][0];
			echo "<tr><td>$module_cn</td><td colspan='2' style='text-align:right'><i>$module_type</i></td></tr>";
		}
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";
	
	
	echo "<thead><th colspan='2'>Licence</th><th>Quantity</th></thead>";
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=voicemailport))",array('key','valid','license','qty'));
		$info = ldap_get_entries($ds, $sr);  
		for ($m=0; $m<$info['count']; $m++) {
			$licence = $info[$m]['license'][0];
			$quantity = $info[$m]['qty'][0];
   		    $vmlicence_count += $quantity;
			echo "<tr><td colspan='2'>$licence</td><td style='text-align:right'>$quantity</td></tr>";
		}
		
	$total =  $vmlicence_count;		
	echo "<tr><td colspan='2'>Total:</td><td style='text-align:right'><b>$vmlicence_count</b></td></tr>";
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";
	
		$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=SV1000*))",array('valid','license','qty'));
		$info = ldap_get_entries($ds, $sr);  
		for ($m=0; $m<$info['count']; $m++) {
			if ( $info[$m]['valid'][0] == 1) {
				$licence = $info[$m]['license'][0];
				$quantity = $info[$m]['qty'][0];
				$SVType = $SV1000[ str_replace ('SV1000-','',$info[$m]['license'][0]) ];
				$SVvmportcount = $SVType * $quantity;
				$svlicence_count += $SVvmportcount;
				
				$extralicences = ($quantity >1) ? "<i>(x$quantity)</i>" : '';
			}
			echo "<tr><td colspan='2'>$licence $extralicences</td><td style='text-align:right'>$SVvmportcount</td></tr>";
		}
		
	$total =  $total + $svlicence_count;		
	echo "<tr><td colspan='2'>Total:</td><td style='text-align:right'><b>$svlicence_count</b></td></tr>";
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";	
	
	echo "<tr><td colspan='2'>Total Licences:</td><td style='text-align:right'><b>$total</b></td></tr>";
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";
	
	echo "<thead><th colspan='2'>Voicemail Port</th><th colspan='2'>Capacity</th></thead>";	
	$sr = ldap_list($ds,"cn=voicemailports","(objectclass=voicemailport)",array('cn','capacity','location'));
		$info = ldap_get_entries($ds, $sr);  
		for ($m=0; $m<$info['count']; $m++) {
				$cn = $info[$m]['cn'][0];
				$capacity = $info[$m]['capacity'][0];
				$location = $module[ $info[$m]['location'][0] ];
				$totalcapacity += $capacity;
			echo "<tr><td colspan='2'>$cn <i>($location)</i></td><td style='text-align:right'>$capacity</td></tr>";
		}
	echo "<tr class='licencerow'><td colspan='3'>&nbsp;</td></tr>";
	echo "<tr><td colspan='2'>Total:</td><td style='text-align:right'><b>$totalcapacity</b></td></tr>";
	echo "</table>";
?>
</div>
</div>
</body>
</html>