<?php

include "assist/tzone.php"; // include timezone

$ds = @ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
@ldap_bind($ds,"INTERNAL","0123456") or exit("<p>EXIT: LDAP bind failure</p>");

$phone = $ent = array();

$vals = (isset($_REQUEST['phone'])) ? $_REQUEST['phone'] : $_REQUEST['phone'];
$val =explode(":", $vals);

$title="Phone Home"; 

$srcModuleGuid = $val[0];
$dstModuleGuid = $val[1];
$dstModuleName = $val[2];
$phoneName = $val[3];
$phoneGuid = $val[4];


$sr = ldap_read($ds,"cn=$phoneName, guid=$srcModuleGuid, cn=modules","objectclass=*");  
$info = ldap_get_entries($ds,$sr); 
$att = array('cn','description','owner','productversion','snmplocation','typeofphone','objectclass');

foreach ($att as $v) {
	if (isset($info[0][$v][0])) $phone[$v] = $info[0][$v][0];
}
$phone['location'] = $dstModuleGuid;

$sr = ldap_read($ds,"cn=1, cn=$phoneName, guid=$srcModuleGuid, cn=modules","objectclass=*");  
$info = ldap_get_entries($ds,$sr); 
$att = array('cn','compressiontype','forcealerting','forcespeech','headsetworking','ipaddress','javalicense','ledbrightness','model','noprogress','objectclass','options','partnerlogincode','password','pnpmodel','pnpvendor','pnpversion','proxyserveraddress','proxyserverport','remoteidle','remotepstn','screenbrightness','screensavermode','screensaverparams','serialnumber','stunaddr','stunport','update','usestun','siplicense');

foreach ($att as $v) {
	if (isset($info[0][$v][0])) $ent[$v] = $info[0][$v][0];
}


// check if set as initial phone
$user_dn = NULL;
$sr = ldap_list($ds,"cn=Users","(&(objectclass=User)(initialphone=$phoneGuid))", array('dn'));  
$info = ldap_get_entries($ds,$sr);  

if ($info['count'] > 0) {
	$user_dn = $info[0]['dn'];
}

//delete old phone
ldap_delete($ds, "cn=$phoneName, guid=$srcModuleGuid, cn=modules");

// add phone
$dn = "cn=$phoneName,cn=$dstModuleName, cn=modules";
ldap_add($ds, $dn, $phone);

// add cn=1
$dn = "cn=1,cn=$phoneName,cn=$dstModuleName, cn=modules";
ldap_add($ds, "$dn", $ent);

if (isset($user_dn)) {
	
	//find new phones GUID
	$dn = "cn=$phoneName,cn=$dstModuleName, cn=modules";
	$sr = ldap_read($ds,$dn,"objectclass=Phone"); 
	$info = ldap_get_entries($ds,$sr);
	$phoneNewGuid = $info[0]['guid'][0];
	ldap_modify($ds, $user_dn, array('initialphone' => $phoneNewGuid));
	
}

echo "$phoneName<br><br>Moved To:<br>$dstModuleName";

?>