<?php
//PJC10JUN20 - Updated for SIP devices supporting multiple users
//PJC10JUN16 - Layout Update & Search
//PJC02JUN16 - Layout and error messages
//PJCSEPT2013
//4jul05 31jan07 10aug09 15mar12
$page_id = "067";
include "assist/.access.php";
header('Content-type: text/html; charset=UTF-8') ;
ini_set('max_execution_time',60); //increased to 60 4jul05
include "assist/tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$ds = @ldap_connect("127.0.0.1",4000) or exit("<p>EXIT: LDAP connect failure</p>");
@ldap_bind($ds,"INTERNAL","001122334455") or exit("<p>EXIT: LDAP bind failure</p>");

?>
<html>
<head>
<title>Sorted lists of User information</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link href="assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="assist/js/wiz/main.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});
	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
	
	$("#searchInput").keyup(function() {
		var rows = $(".fbody").find('tr:not(:has(th))').hide();
		var data = this.value.split("/");
		$.each(data, function(i, v) {
			rows.filter(":Contains('" + v + "')").show();
		});
	});

	$.expr[":"].Contains = jQuery.expr.createPseudo(function(arg) {
		return function(elem) {
			return $(elem).find('td').filter(function() {
				return $(this).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
			}).length;
		};
	});
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
<style>
th { background-color:#8a8a7b;font-size:14px; }
td { text-align:center;  vertical-align:middle; }
fieldset { width:60%; }
</style>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('assist/help/help_sorted.php','help','600','500','yes');return false" src="assist/images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='assist/images/backup.png' style="vertical-align:middle;">&nbsp;Sorted Lists</h2>

<?php
$name=$extension=$title=$phone=$phonename=array();

echo "<fieldset><legend>Counts:</legend>";

$att =array('cn', 'telephonenumber');
$sr = ldap_list($ds,"cn=Departments","objectclass=Department",$att);
$info=ldap_get_entries($ds,$sr);
print "Department count = ".$info['count']."<br>";
if ($info['count']>0) {
   for($n=0; $n<$info['count'];$n++) {
	   $name[]=$info[$n]['cn'][0];
	   $extension[]=$info[$n]['telephonenumber'][0];
	   $title[]=" [Department]";
	   $phone[]="";
	   $phonename[]="";
   }
}


$att =array('cn', 'telephonenumber');
$sr = ldap_list($ds,"cn=Groups","objectclass=Group",$att);
$info=ldap_get_entries($ds,$sr);
print "Group count = ".$info['count']."<br>";
if ($info['count']>0) {
	for($n=0; $n<$info['count'];$n++) {
		$name[]=$info[$n]['cn'][0];
		$extension[]="";
		$title[]=" [Group]";
		$phone[]="";
		$phonename[]="";
	}
}


$att =array('cn', 'telephonenumber','initialphone');
$sr = ldap_list($ds,"cn=Users","objectclass=User",$att);
$info=ldap_get_entries($ds,$sr);
print "User count = ".$info['count']."<br>";
if ($info['count']>0) {
	for($n=0; $n<$info['count'];$n++) {
		$name[]=$info[$n]['cn'][0];
		$extension[]=$info[$n]['telephonenumber'][0];
		$title[]="";
		$phone[]=$info[$n]['initialphone'][0];
		$phonename[]="";
	}
}

echo "</fieldset>";

echo"<br/><div id='error' style='display: none'><fieldset><legend>Errors:</legend><div id='errors'></div></fieldset></div>";

echo "<br/><fieldset><legend>Search:</legend><input class='filter' id='searchInput' size='28' placeholder='Type To Filter'></fieldset><br/>";

$phonespnp = array();
for($n=0; $n<count($name);$n++) {
	if ($title[$n]==" [Group]") continue;
	if ($title[$n]==" [Department]") continue;
	$dn ="guid=".$phone[$n];
	$sr = @ldap_read($ds,$dn,"objectclass=*");
	if ($sr){
		$info=ldap_get_entries($ds,$sr);
		$s = $phonesdn = $info[0]['dn'];
		$s=str_replace(",cn=Modules","",$s);
		$s=str_replace("cn=","",$s);
		$phonename[$n] = $s;
		
		$srdn = ldap_read($ds,"cn=1, $phonesdn","objectclass=GenericIPPhone", array('pnpmodel'));
		$infodn	= ldap_get_entries($ds,$srdn);
		$pnptype = (isset($infodn[0]['pnpmodel'][0])) ? $infodn[0]['pnpmodel'][0] : NULL;
		if (preg_match('(T53|T54|T57|VP59|W60|W56|W80)', $pnptype) === 1) {
			$phonespnp[] = $s;	
		} 
	}
}

array_multisort($name, $extension, $title, $phone, $phonename);
$old="";
$name_errors=0;

echo "<br/><fieldset><legend><h1>Sort by Name and check for duplicates</h1></legend>";
print "<table>";
print "<tbody class='fbody'><th width='250px'>Name</th><th width='250px'>Extension</th><th width='250px'>Port</th>";
for($n=0; $n<count($name);$n++) {
   $new =	$name[$n];
	print "<tr><td>".$name[$n].$title[$n]."</td><td>".$extension[$n]."</td><td>".$phonename[$n]."</td><td>";
	if ($old==$new) {
		print "*** duplicate ***";
		$name_errors++;
	}
	$old=$new;
	print "</td><tr>";
}
print "</tbody>";
print "</table>";
if ($name_errors>0) {
	print "<br/>Error count = $name_errors <br>";
	echo "<script type='text/javascript'>$('#error').show();$('#errors').append('Sort by Name Errors: " . $name_errors . "<br/>');</script>";
}
echo "</fieldset><br/>";


array_multisort($extension, SORT_NUMERIC, $title, $phone, $phonename, $name);
$old="rubbish";
$extn_errors=0;
echo "<br/><fieldset><legend><h1>Sort by Extension and check for duplicates</h1></legend>";
print "<table>";
print "<tbody class='fbody'><th width='250px'>Extension</th><th width='250px'>Number</th><th width='250px'>Port</th>";
for($n=0; $n<count($extension);$n++) {
	if ($title[$n]==" [Group]") continue;
	$new =	$extension[$n];
	print "<tr><td>";
	print $extension[$n]."</td><td>";
	print $name[$n].$title[$n]."</td><td>";
	print $phonename[$n]."</td><td>";
	if ($old==$new) {
		print "*** duplicate ***";
		$extn_errors++;
	}
	$old=$new;
	print "</td><tr>";
}
print "</tbody>";
print "</table>";
if ($extn_errors>0) {
	print "<br/>Error count = $extn_errors <br>";
	echo "<script type='text/javascript'>$('#error').show();$('#errors').append('Sort by Extension Errors: " . $extn_errors . "<br/>');</script>";
}
echo "</fieldset><br/>";



array_multisort($phonename, $name, $extension, $title, $phone);
$old="";
$initial_errors=0;
echo "<br/><fieldset><legend><h1>Sort by Initial Phone and check for duplicates</h1></legend>";
print "<table>";
print "<tbody class='fbody'><th width='250px'>Phone</th><th width='250px'>Name</th><th width='250px'>Extension</th>";
for($n=0; $n<count($phonename);$n++) {
	if ($title[$n]==" [Group]") continue;
	if ($title[$n]==" [Department]") continue;
	$new =	$phonename[$n];
	print "<tr><td>";
	print $phonename[$n]."</td><td>";
	print $name[$n].$title[$n]."</td><td>".$extension[$n]."</td><td>";
	if (($new!="")&&($old==$new)) {
		if ( in_array($new, $phonespnp) ) {
			print "*** Shared Device ***";
		} else { 
			print "*** duplicate ***";
			$initial_errors++;
		}
	}
	$old=$new;
	if ($old =="00000000-0000-0000-0000-000000000000") $old="";
   print "</td><tr>";
}
print "</tbody>";
print "</table>";
if ($initial_errors>0) {
	print "<br/>Error count = $initial_errors <br>";
	echo "<script type='text/javascript'>$('#error').show();$('#errors').append('Sort by Initial Phone Errors: " . $initial_errors . "<br/>');</script>";
} 
echo "</fieldset><br/>";


echo "<br/><fieldset><legend><h1>List by physical phone</h1></legend>";
$sr = ldap_search($ds,"cn=Modules","objectclass=Phone");
$info=ldap_get_entries($ds,$sr);
print "Phone count = ".$info['count']."<br/><br/>";
if ($info['count']>0) {
	print "<table>";
	print "<tbody class='fbody'><th width='250px'>Phone</th><th width='250px'>name</th><th width='250px'>Extension</th>";
	for($n=0; $n<$info['count'];$n++) {
		$s = $info[$n]['dn'];
		$s=str_replace(",cn=Modules","",$s);
		$s=str_replace("cn=","",$s);
		print "<tr><td>".$s."</td><td>";
		$find ="initialPhone=".$info[$n]['guid'][0];
		$sr2 = ldap_list($ds,"cn=Users",$find);
		$info2=ldap_get_entries($ds,$sr2);
//	print "count=".$info2['count']." ";
//	print $find." ";
		print (isset($info2[0]['cn'][0])) ? $info2[0]['cn'][0]."</td><td>" : "</td><td>";
		//print $info2[0]['cn'][0]."</td><td>";
		print (isset($info2[0]['telephonenumber'][0])) ? $info2[0]['telephonenumber'][0]."</td><td>" : "</td><td>";
		//print $info2[0]['telephonenumber'][0]."</td></tr>";
	}
	print "</tbody>";
	print "</table>";
}
echo "</fieldset><br/>";

ldap_close($ds);
echo date(" H:i:s l, jS F Y",time());
?>
<p>Done.</p>
</BODY>
</HTML>

