<?php
# bobg 5dec11 9dec 15dec

$find="";
$guid=$agents=array();
if (isset($_SERVER['HTTP_HOST'])) die("Run from command line.");
$script=basename($_SERVER['SCRIPT_NAME']);
print "\nSearches a Vision log for the Call Center Connection, CRC interface, conversations with the Call Servers.\n";
if(isset($argv[1])) $infile = $argv[1];
else {
   if(substr(phpversion(),0,1)=="5") $s=""; else $s=" -x";
   exit("Syntax:: php$s $script <input file> [output file] [search guid or string]\nIf only input file is specified will generate .ccc file, for use as smaller source.\n");
}
if(isset($argv[2])) {
   $outfile = $argv[2];
   $outcccfile="";
}
else {
   $outfile="";
   $outcccfile=$argv[1].'.ccc';
}

if(isset($argv[3])) {
   if (strlen($argv[3])==36) {
      $guid[]=$argv[3];
      $find="";
   } else $find=$argv[3];
}

$agents=@file($script.'.agents');
if ($agents===false) $agents=array();
foreach ($agents as $k => $v){
   $agents[$k]=rtrim($v);
}

while (1){
   $in = @fopen($infile, "r") or die ("ERROR: failed to open infile - $infile\n");
   if($outfile) $out = @fopen($outfile, "w") or die ("ERROR: failed to open outfile - $outfile\n");
   if($outcccfile) $outccc = @fopen($outcccfile, "w") or die ("ERROR: failed to open outcccfile - $outcccfile\n");
         
   if (!$outcccfile) {
      if ($find){
         $s = "Find lines containing: $find\n"; print $s; if($outfile) fputs($out,$s);
      } else {
         $s = "Find call using GUID:\n"; print $s; if($outfile) fputs($out,$s);
         foreach ($guid as $k => $v){
            $s = "$v\n"; print $s; if($outfile) fputs($out,$s);
         }
         $s = "\n"; print $s; if($outfile) fputs($out,$s);
      }
   }

   $countguid=count($guid);

   $line=$stf=$restart=0;
   $crid=array();

   $t1=$t2=$t3=0;
   while (!feof($in)) {
      $buffer = fgets($in, 4096);
      $t1++;
      if (strpos($buffer,'Started Version')){
         $restart++;
         $s = "########## RESTARTED $restart ########## $buffer"; print $s; if($outfile) fputs($out,$s);
      }
      $s='CallCentreConnection[';
      if ($p=strpos($buffer,$s)) {
         if ($outcccfile) {
            fputs($outccc,$buffer);
            $show=1;
         }  else $show=0;
         $pb=strpos($buffer,':',$p);
         $pc=strpos($buffer,']',$pb);
         $ipa=substr($buffer,$pb+1,$pc-$pb-1);
         if (!isset($crid[$ipa])) $crid[$ipa]=array('CRID?');
         $ipa16=substr($ipa."         ",0,16);
         $sa = substr($buffer,$p-26,12)." - $ipa16".substr($buffer,$pc+1);
         $sb = str_replace(array('::ReceiveCommand - ','::SendCommand - '),array('>  ','<< '),$sa);
         $sc=substr($sb,34);
         $item=explode(',',rtrim($sc));
         $t2++;
         if (!isset($item[1])) $show=1;
         elseif (substr($item[1],0,6)=='Users.'){
            $agent=substr($item[1],6);
            if (in_array($agent,$agents)) {
               $sb=str_replace('AGENT','_ _ AGENT',$sb);
               $show=1;
            }
         }
         elseif (substr($item[0],0,8)=='TRANSFER'){
            if(in_array($item[2],$guid)){
               if(!in_array($item[1],$crid[$ipa])) $crid[$ipa][]=$item[1];
               if(!in_array($item[3],$crid[$ipa])) $crid[$ipa][]=$item[3];
               if(!in_array($item[4],$guid)) $guid[]=$item[4];
            }
            if(in_array($item[4],$guid)){
               if(!in_array($item[1],$crid[$ipa])) $crid[$ipa][]=$item[1];
               if(!in_array($item[3],$crid[$ipa])) $crid[$ipa][]=$item[3];
               if(!in_array($item[2],$guid)) $guid[]=$item[2];
            }
         }
         elseif($item[0]=='QUEUEING' or $item[0]=='DISTRIBUTING' or $item[0]=='CONNECTED' or $item[0]=='GONE'){
            if(in_array($item[2],$guid)){
               if(!in_array($item[1],$crid[$ipa])) $crid[$ipa][]=$item[1];
            } else {
               if(in_array($item[1],$crid[$ipa])){
                  $k=array_search($item[1],$crid[$ipa]);
                  unset($crid[$ipa][$k]);
               }
            }
         }
         if ($find!="") {
            if (strpos($sc,$find)===false);
            else $show=1;
         }
         if (in_array($item[1],$crid[$ipa])) $show=1;

         if ($show){
            $line++;
            $t3++;
            if ($line>9999)$line=0;
            $sl=sprintf("%04d ",$line);
            print $sl.$sb;
            if($outfile) fputs($out,$sl.$sb);
         }
      }
   }
   $s = "\nCrid still involved:\n"; print $s; if($outfile) fputs($out,$s); 
   foreach($crid as $k => $v){                                                                                                                                                                              
      foreach($crid[$k] as $k2 => $v2){                                                                                                                                                                     
         $s = "$v2 - $k\n"; print $s; if($outfile) fputs($out,$s);
      }                                                                                                                                                                                                     
   }
   $s =  "File $infile contains: $t1 lines, $t2 ccc lines, $t3 = filtered lines."; print $s; if($outfile) fputs($out,$s);
         
   fclose($in);
   if ($outfile) fclose($out);
   if ($outcccfile) fclose($outccc);
   if (count($guid)==$countguid) break;
   print "\n\n\n\n\n##### New calls - restarting #####\n\n\n\n\n";
}
print "\nDone.\n";
?>
