<?php

// PJC 20-07-2020 - Include SV10000 Managed User count in total when creating config.
// PJC 14-08-2019
// PJC 27-06-2016
// Update for NSG Licence
// update added for dedicated servers.
// 1 = container 2 = dedicated
// add two users to mailGroup

$welcomedone = '0';
$container = (isset($_REQUEST['container']) && strlen($_REQUEST['container']) >=1) ? $_REQUEST['container'] : NULL;
$recordingoff = (isset($_REQUEST['recordingoff']) && $_REQUEST['recordingoff'] === '1') ? '1' : '0';

if ($container == '1') {
	if ($container == '1') $welcomedone = '1';
	$ds = ldap_connect("127.0.0.1",4000);
		if ( ! $ds) {
			echo "LDAP connect failure<br>";
		} else {
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			$r = ldap_bind($ds,"INTERNAL","0123456");
			if ( ! $r) {
				echo "LDAP bind failure<br>";
				$ds = false;
		}
	}

} else {
	require('../admin/assets/inc/ldapConnect.php');
}

$adminpassword = (isset($_REQUEST['adminpassword']) && strlen($_REQUEST['adminpassword']) >=1) ? trim($_REQUEST['adminpassword']) : NULL;
$mohport = (isset($_REQUEST['mohport']) && strlen($_REQUEST['mohport']) >=1) ? $_REQUEST['mohport'] : NULL;

$system_name = (isset($_REQUEST['system_name']) && strlen($_REQUEST['system_name']) >=1) ? $_REQUEST['system_name'] : NULL;
$system_supplier = (isset($_REQUEST['system_supplier']) && strlen($_REQUEST['system_supplier']) >=1) ? $_REQUEST['system_supplier'] : NULL;
$system_description = (isset($_REQUEST['system_description']) && strlen($_REQUEST['system_description']) >=1) ? $_REQUEST['system_description'] : NULL;
$softpbx_name = (isset($_REQUEST['softpbx_name']) && strlen($_REQUEST['softpbx_name']) >=1) ? $_REQUEST['softpbx_name'] : NULL;
$softpbx_description = (isset($_REQUEST['softpbx_description']) && strlen($_REQUEST['softpbx_description']) >=1) ? $_REQUEST['softpbx_description'] : NULL;

$licence_select = (isset($_REQUEST['licence_select']) && strlen($_REQUEST['licence_select']) >=1) ? $_REQUEST['licence_select'] : NULL;
$licence = (isset($_REQUEST['licence']) && strlen($_REQUEST['licence']) >=1) ? $_REQUEST['licence'] : NULL;

$password_calllogging = (isset($_REQUEST['password_calllogging']) && strlen($_REQUEST['password_calllogging']) >=1) ? trim($_REQUEST['password_calllogging']) : NULL;
$password_diagnostics = (isset($_REQUEST['password_diagnostics']) && strlen($_REQUEST['password_diagnostics']) >=1) ? trim($_REQUEST['password_diagnostics']) : NULL;
$password_web = (isset($_REQUEST['password_web']) && strlen($_REQUEST['password_web']) >=1) ? trim($_REQUEST['password_web']) : NULL;
$password_maintainer = (isset($_REQUEST['password_maintainer']) && strlen($_REQUEST['password_maintainer']) >=1) ? trim($_REQUEST['password_maintainer']) : NULL;
$password_select = (isset($_REQUEST['password_select']) && strlen($_REQUEST['password_select']) >=1) ? trim($_REQUEST['password_select']) : NULL;

$default_config = (isset($_REQUEST['default_config']) && strlen($_REQUEST['default_config']) >=1) ? $_REQUEST['default_config'] : NULL;

$ipaddress = (isset($_REQUEST['ipaddress']) && strlen($_REQUEST['ipaddress']) >=1) ? $_REQUEST['ipaddress'] : '192.168.0.1';
$dnsPrimary = (isset($_REQUEST['dnsPrimary']) && strlen($_REQUEST['dnsPrimary']) >=1) ? $_REQUEST['dnsPrimary'] : '192.168.0.1';

$base_user_extn = (isset($_REQUEST['base_user_extn']) && strlen($_REQUEST['base_user_extn']) >=1) ? $_REQUEST['base_user_extn'] : '2001';
$base_dept_extn = (isset($_REQUEST['base_dept_extn']) && strlen($_REQUEST['base_dept_extn']) >=1) ? $_REQUEST['base_dept_extn'] : '8001';

if ($recordingoff === '0') {
	$inboundrecording = (isset($_REQUEST['inboundrecording']) && strlen($_REQUEST['inboundrecording']) >=1) ? $_REQUEST['inboundrecording'] : '9000';
	$outboundrecording = (isset($_REQUEST['outboundrecording']) && strlen($_REQUEST['outboundrecording']) >=1) ? $_REQUEST['outboundrecording'] : '9500';
}

$user_dp_entry = $base_user_extn[0] . str_repeat('?', strlen($base_user_extn) -1);
$dept_dp_entry = $base_dept_extn[0] . str_repeat('?', strlen($base_dept_extn) -1);

if ($system_name) ldap_modify($ds,"cn=system", array('administrationdomain' => $system_name));
if ($system_supplier) ldap_modify($ds,"cn=system", array('supplier' => $system_supplier));
if ($system_description) ldap_modify($ds,"cn=system", array('description' => $system_description));

if ($softpbx_name) {
	$sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $loc = $info[0]['location'][0];
    $sr = ldap_list($ds,"cn=Modules","(&(objectclass=*)(guid=".$loc."))",array('dn'));
	$info = ldap_get_entries($ds,$sr); $dn = $info[0]['dn'];
	ldap_rename($ds,$dn,"cn=$softpbx_name","cn=Modules",true);
}

if ($softpbx_description) ldap_modify($ds,"cn=$softpbx_name, cn=Modules", array('description' => $softpbx_description));

if ($dnsPrimary) ldap_modify($ds,"cn=1, cn=$softpbx_name, cn=Modules", array('dnsPrimary' => $dnsPrimary));

if ($password_calllogging) ldap_modify($ds,"cn=system", array('callloggingpassword' => $password_calllogging));
if ($password_diagnostics) ldap_modify($ds,"cn=system", array('diagnosticengineeringpassword' => $password_diagnostics));
if ($password_web) ldap_modify($ds,"cn=system", array('webpassword' => $password_web));
if ($password_maintainer) ldap_modify($ds,"cn=system", array('maintainerpassword' => $password_maintainer));

ldap_modify($ds,"cn=system", array('welcomedone' => $welcomedone));

if ($licence) {
	// delete old licences
	$sr = ldap_list($ds,"cn=system","(objectclass=license)",array('dn'));
	$info = ldap_get_entries($ds,$sr);
    for ($n=0; $n<$info['count']; $n++) {
		ldap_delete ($ds, $info[$n]['dn']);
	}

	// add new licences
	$voicemailPortCapacity = '';
	if ($container >= '1') {
		$licence = file('/SpliceCom/Web/licences');
	} else {
		$licence = explode(PHP_EOL, $licence);
	}
	foreach ($licence as $lk => $lv) {
		if (strlen($lv)>= 1) {
			$lv = explode (",",$lv);
			if (isset($lv[1]) && $lv[1] === 'IPUser' || $lv[1] === 'ISIP' || $lv[1] === 'Trunk' || $lv[1] === 'MessageBox' || $lv[1] === 'VoicemailPort') continue;
			ldap_add($ds,"key=$lv[2],cn=system",array('license'=>$lv[1], 'objectclass'=>'License', 'qty'=>$lv[0]));
		}
	}
}

    // get module self
	$sr=ldap_read($ds,"cn=Self,cn=Modules","objectclass=*");
	$info=ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];

	// get S8000 CN
	$sr=ldap_list($ds,"cn=Modules", "guid=$self", array('cn'));
	$info=ldap_get_entries($ds,$sr); $cn = $info[0]['cn'][0];

	// add SIP PnP File Location
	ldap_modify($ds,"cn=1,cn=$cn,cn=Modules",array('sipPnPFileLoc' => "http://$ipaddress/prov"));
	
	// set callflow & SIP to detail
	ldap_modify($ds,"cn=1,cn=$cn,cn=Modules",array('debugCalls' => '2', 'debugSIP' => '2'));

if ($licence_select) {

	// get licence guid
	$licence = explode(",",$licence_select);
	$sr=ldap_read($ds,"key=$licence[2],cn=System","objectclass=License");
	$info=ldap_get_entries($ds,$sr); $key_guid = $info[0]['guid'][0];

	// add module licence
	ldap_modify($ds,"cn=1,cn=$cn,cn=Modules", array('moduleLicenseGUID' => $key_guid, 'autoAddPhones'=>'0'));

	//Trunk, ESP, Voice Processing Port, Voicemail Boxes, Vision Reports, Managed Users
	//Trunk, Voice Processing Port, Voicemail Boxes are MAX Values
	$SV1000001 = array('Trunk'=>'240','ESPSession'=>'4','VoicemailPort'=>'240','MessageBox'=>'1000','VisionReport'=>'1000','ManagedUser'=>'0','VisionMobility'=>'1000');
	$SV1000SC = array('Trunk'=>'30','ESPSession'=>'4','VoicemailPort'=>'30','MessageBox'=>'90','VisionReport'=>'80','ManagedUser'=>'0','VisionMobility'=>'80');
	$SV1000MAPS = array('Trunk'=>'15','ESPSession'=>'4','VoicemailPort'=>'15','MessageBox'=>'20','VisionReport'=>'16','ManagedUser'=>'5','VisionMobility'=>'16');

	$SV1000VMAP = array('Trunk'=>'90','ESPSession'=>'4','VoicemailPort'=>'90','MessageBox'=>'500','VisionReport'=>'500','ManagedUser'=>'0','VisionMobility'=>'500');
	$SV1000MAP = array('Trunk'=>'90','ESPSession'=>'4','VoicemailPort'=>'90','MessageBox'=>'500','VisionReport'=>'500','ManagedUser'=>'0','VisionMobility'=>'500');
	$SV1000NSG = array('Trunk'=>'90','ESPSession'=>'4','VoicemailPort'=>'90','MessageBox'=>'500','VisionReport'=>'0','ManagedUser'=>'0','VisionMobility'=>'0');
	$SV1000OFF01 = array('Trunk'=>'90','ESPSession'=>'4','VoicemailPort'=>'90','MessageBox'=>'500','VisionReport'=>'0','ManagedUser'=>'0','VisionMobility'=>'500');
	$SV1000020 = array('Trunk'=>'15','ESPSession'=>'4','VoicemailPort'=>'15','MessageBox'=>'30','VisionReport'=>'20','ManagedUser'=>'20','VisionMobility'=>'20');

	$SVType = str_replace('-','',$licence[1]);
	$voicemailPortCapacity = (strpos($SVType, 'SV1000') !== false) ? ${$SVType}['VoicemailPort'] : '0';
	$ESPSession = (strpos($SVType, 'SV1000') !== false) ? ${$SVType}['ESPSession'] : '0';
	$ManagedUserCount = (strpos($SVType, 'SV1000') !== false) ? ${$SVType}['ManagedUser'] : '0';
	error_log ("ManagerUsers = $ManagedUserCount");
}

//// Default Config ////
if ($default_config && strlen($default_config) >0) {

	// create voicemail port dialplan plan
	ldap_add($ds,"cn=Vmail,cn=DialPlans",array('objectclass'=>'DialPlan','description'=>'VoicemailPort DialPlan', 'dialDelayCount'=>'4', 'dialDelayTime'=>'1500'));
	ldap_add($ds,"numbermatch=$user_dp_entry.,cn=Vmail,cn=DialPlans",array('objectclass'=>'DPEntry','action'=>'1','translateTo'=>'%n'));
	ldap_add($ds,"numbermatch=$dept_dp_entry.,cn=Vmail,cn=DialPlans",array('objectclass'=>'DPEntry','action'=>'1','translateTo'=>'%n'));

	// add vmail DialPlan to BuiltIn
	$sr=ldap_read($ds,"cn=Vmail,cn=DialPlans","objectclass=DialPlan", array("guid"));
	$info=ldap_get_entries($ds,$sr); $vmail_guid = $info[0]['guid'][0];
	$vmarray['dialPlan'] = $vmail_guid;
	$vmarray['capacity'] = $voicemailPortCapacity;
	$vmarray['capacityESP'] = $ESPSession;
	$vmarray['location'] = $self;
	
	if ($recordingoff === '1') {
		$vmarray['capabilityRecording'] = '0';
	}
	ldap_modify($ds,"id=1,cn=VoicemailPorts",$vmarray);
	
	//update MOH Port
	if ($mohport) {
		ldap_modify($ds,"id=1,cn=MusicChannels",array('multicastPort'=>$mohport));
	}
	

	// add Standard DialPlan entries
	//numberMatch,action,translateTo,translateCLITo
  	ldap_delete($ds, "cn=Standard, cn=DialPlans");

	$sr=ldap_read($ds,"cn=Standard,cn=LeastCostCallPlans","objectclass=LeastCostCallPlan");
	$info=ldap_get_entries($ds,$sr); $lcr_guid = $info[0]['guid'][0];

	ldap_add($ds,"cn=Standard,cn=DialPlans",array('objectclass'=>'DialPlan','description'=>'Default Dial Plan for whole system', 'dialDelayCount'=>'4', 'dialDelayTime'=>'1500'));
	if (file_exists('/SpliceCom/ftp/dialplan.txt')) {
		$dialplan_entries = file('/SpliceCom/ftp/dialplan.txt');
		unset($dialplan_entries[0]);

	$addLCR = array('','999','112','141','9','100','192','9112','1280','1470');
		
	foreach ($dialplan_entries as $dpK => $dpV){
		if (strlen(trim($dpV)) < 1) continue;
		$dpEntry = explode(",",trim($dpV));
		$translateTo = (isset($dpEntry[2])) ? $dpEntry[2] : NULL;
		$translateCLITo = (isset($dpEntry[3])) ? $dpEntry[3] : NULL;
		
		$set_guid = (in_array($dpEntry[0], $addLCR)) ? $lcr_guid : '';
		ldap_add($ds,"numbermatch=$dpEntry[0],cn=Standard,cn=DialPlans",array('objectclass'=>'DPEntry','action'=>$dpEntry[1],'translateTo'=>$translateTo, 'translateCLITo'=>$translateCLITo, 'LeastCostCallPlan'=>$set_guid));
		}
	}

	ldap_add($ds,"numbermatch=$user_dp_entry.,cn=Standard,cn=DialPlans",array('objectclass'=>'DPEntry','action'=>'1','translateTo'=>'%n', 'leastCostCallPlan'=>$lcr_guid));
	ldap_add($ds,"numbermatch=$dept_dp_entry.,cn=Standard,cn=DialPlans",array('objectclass'=>'DPEntry','action'=>'1','translateTo'=>'%n', 'leastCostCallPlan'=>$lcr_guid));
	
	//update Standard LCRPlan blank number match
	$sr = ldap_search($ds,"cn=Standard,cn=LeastCostCallPlans","(&(objectclass=LCREntry)(numbermatch=))"); 
	$info = ldap_get_entries($ds,$sr); $lcr_guid=$info[0]['guid'][0];
	if (strlen($lcr_guid) > 1) {
		$recordingactionprimary = ($recordingoff === '0') ? '61' : '1';
		$att=array('actionPrimary'=> $recordingactionprimary);
		ldap_modify($ds,"guid=$lcr_guid,cn=LeastCostCallPlans",$att);
	}

	$sr=ldap_read($ds,"cn=Standard,cn=DialPlans","objectclass=dialPlan");
	$info=ldap_get_entries($ds,$sr); $standard_dialplan = $info[0]['guid'][0];

	//add Trunk2Trunk LCRPlan
	$sr = ldap_read($ds,"cn=AllTrunks, cn=TrunkGroups","objectclass=trunkgroup", array('guid'));
	$info = ldap_get_entries($ds,$sr); $guid = $info[0]['guid'][0];

	ldap_add($ds,"cn=Trunk2Trunk,cn=leastcostcallplans",array('objectclass'=>'leastcostcallplan','description'=>'used to route calls out via trunk'));
	ldap_add($ds,"actionprimary=1,cn=Trunk2Trunk,cn=leastcostcallplans",array('objectclass'=>'lcrentry','dialprimary'=>'%n','timeplan'=>'bb480000-cce4-f518-8576-080027bafd18','trunkgroupprimary'=>$guid));

		
	//update Standard DDIPlan blank number match
	$sr = ldap_search($ds,"cn=Standard,cn=DDICallPlans","(&(objectclass=DDIEntry)(numbermatch=))"); 
	$info = ldap_get_entries($ds,$sr); $ddi_guid=$info[0]['guid'][0]; $ddi_trans=$info[0]['translateto'][0];
	if (strlen($ddi_guid) > 1) {
		//$att=array('translateto'=>"=$ddi_trans");
		$recordingtranslateto = ($recordingoff === '0') ? "=$ddi_trans" : $ddi_trans;
		$att=array('translateto'=> $recordingtranslateto);
		ldap_modify($ds,"guid=$ddi_guid,cn=DDICallPlans",$att);
	}

	
	// create users

	//get ManagedUserLicence Count
	//$ManagedUserCount = '0';
	$sr = ldap_list($ds,"cn=system","(&(objectclass=license)(license=ManagedUser))",array('qty'));
	$info = ldap_get_entries($ds,$sr);
    for ($n=0; $n<$info['count']; $n++) {
		$ManagedUserCount = $ManagedUserCount+$info[$n]['qty'][0];
	}

	error_log ("ManagedUserCount = $ManagedUserCount");
	$users = '10';
	if (isset($ManagedUserCount) && $ManagedUserCount > 0) $users = $ManagedUserCount;
	$users = ($users <= 1000) ? $users : '1000';

	$user_extn = $base_user_extn;
	for ($k = 0 ; $k < $users; $k++) {
		ldap_add($ds,"telephonenumber=$user_extn,cn=users",array('cn'=>"User$user_extn", 'objectclass'=>'user', 'noAnswerTime'=>'20', 'CurrentHome'=>$self,'dialPlan'=>$standard_dialplan,'loginaccesscode'=>$user_extn, 'userType'=>'0'));
		if ($k > 0 && $k % 100 == 0) sleep(2);
		$user_extn++;
	}

	// get first 10 users GUIDs
	for ($k = $base_user_extn ; $k <= $base_user_extn+10; $k++) {
		$sr= @ldap_read($ds,"cn=user$k,cn=Users","objectclass=user", array("guid"));
		$info= @ldap_get_entries($ds,$sr); $user_list[] = $info[0]['guid'][0];
	}
	// shift array to work 1-10 not 0-9
	array_unshift($user_list, "");
	unset($user_list[0]);

	// create groups
	for ($k = 1 ; $k < 11; $k++) {
		$user_id = $k; $k = sprintf("%02d", $k);
		ldap_add($ds,"cn=Group$k,cn=groups",array('objectclass'=>'group'));
		$opts = array('objectclass'=>'member', 'priority'=>'0','member'=>$user_list[$user_id]);
		ldap_add($ds,"id=1,cn=Group$k,cn=groups",$opts); $opts = NULL;
	}

	// get first 10 Groups GUIDs
	for ($k = 1 ; $k <= 10; $k++) {
		$k = sprintf("%02d", $k);
		$sr=ldap_read($ds,"cn=Group$k,cn=Groups","objectclass=group", array("guid"));
		$info=ldap_get_entries($ds,$sr); $group_list[] = $info[0]['guid'][0];
	}

	// create departments
	$dept_extn = $base_dept_extn;
	for ($k = 0 ; $k < 10; $k++) {
		ldap_add($ds,"telephonenumber=$dept_extn,cn=departments",array('cn'=>"Department$dept_extn", 'objectclass'=>'department','distributionGroup'=>$group_list[$k], 'distributionMode'=>'1'));
		$dept_extn++;
	}
	
	// add two users to MainGroup
	for ($k = 1 ; $k <=2; $k++) {
		ldap_add($ds,"id=$k, cn=MainGroup, cn=Groups",array('member'=>$user_list[$k], 'objectclass'=>'member','priority'=>'0'));
	}
	

	if ($recordingoff === '0') {
		//check VisionRecord Licences
		$addArchiveDeliverDelete = '0';
		$sr = ldap_search($ds, "cn=system", "(&(objectclass=license)(license=VisionRecording)(valid=1))", array('cn'));
		$info=ldap_get_entries($ds,$sr);  $count = $info['count'];
		if ($count >= '1') { $addArchiveDeliverDelete = '1';  }
		
		//InboundRecordings
		ldap_add($ds,"telephonenumber=$inboundrecording,cn=departments",array('cn'=>"InboundRecordings", 'objectclass'=>'department','description'=>'InboundRecordings - Do Not Delete', 'exdirectory'=>'1', 'recordmode'=>'5', 'messageboxlicense'=>'1'));
		
		//OutboundRecordings
		ldap_add($ds,"telephonenumber=$outboundrecording,cn=departments",array('cn'=>"OutboundRecordings", 'objectclass'=>'department','description'=>'OutboundRecordings - Do Not Delete', 'exdirectory'=>'1', 'recordmode'=>'5', 'messageboxlicense'=>'1'));
		
		if ($addArchiveDeliverDelete === '1') {
			$ent = array();
			$ent['type'] = '5'; $ent['method'] = '6';
			$ent['objectclass']= 'voicemailcontact';
		
			$dn = "telephonenumber=cn,cn=InboundRecordings,cn=Departments";
			ldap_add($ds, $dn, $ent);
		
			$dn = "telephonenumber=cn,cn=OutboundRecordings,cn=Departments";
			ldap_add($ds, $dn, $ent);
		}
	}
	
	// create working day timeplan
	ldap_add($ds,"cn=WorkingDay,cn=TimePlans",array('objectclass'=>'TimePlan','description'=>'Working Day Monday - Friday 09:00 - 17:30'));
	ldap_add($ds,"startTime=900,cn=WorkingDay,cn=TimePlans",array('objectclass'=>'TimeBand','endTime'=>'1729','startDayofWeek'=>'1','endDayofWeek'=>'5'));

	// create EMPTY timeplan
	ldap_add($ds,"cn=EMPTY,cn=TimePlans",array('objectclass'=>'TimePlan','description'=>'EMPTY TimePlan - Do Not Delete'));

	// create AutoAttendant Entries
	$aa_options = $base_dept_extn;
	for ($k = 0 ; $k <= 9; $k++) {
		ldap_add($ds,"cn=$k,cn=AutoAttendant",array('objectclass'=>'AutoAttendantKey','telephoneNumber'=>$aa_options));
		$aa_options++;
	}

	//create Select AdminUser
	$att = array('objectclass'=>'administrator','userpassword'=>$password_select,'description'=>'Admin Portal User','showenabled'=>'1',
			 'defaultpage'=>'users','company'=>'00000000-0000-0000-0000-000000000000', 'showEnabled'=>'1', 'admintype'=>'1' );
	ldap_add($ds,"cn=Select,cn=system", $att);

	// Set permissions
	$att=array('objectclass'=>'accessright','createAllowed'=>'1','deleteAllowed'=>'1','readAllowed'=>'1','writeAllowed'=>'1');
	ldap_add($ds,"createAllowed=1,cn=Select,cn=system",$att);

	// find Selects Guid
	$sr = ldap_read($ds,"cn=Select, cn=system","objectclass=administrator");
	$info = ldap_get_entries($ds,$sr); $select_guid = $info[0]['guid'][0];

	// add to Manager
	$att=array('objectclass'=>'owneraccess','createAllowed'=>'1','deleteallowed'=>'1','readAllowed'=>'1','writeallowed'=>'1');
	ldap_add($ds,"admin=$select_guid,cn=Manager,cn=system",$att);
	
	if ($adminpassword) {
		$item = array ('userpassword'=>$adminpassword);
		ldap_modify($ds,"cn=Manager, cn=System",$item);
	}

}
//// Default Config ////

	ldap_modify($ds,"cn=Commands", array('doBackup' => '1'));

	$msg = "Last cleared on ". date(DATE_RFC2822);
	$cmd = "echo  $msg > /SpliceCom/WebManager/warnings.txt";
	exec ($cmd, $res);
	ldap_close ($ds);


	$cmd = "echo $password_diagnostics | sudo -S systemctl restart adminmodule";
	system($cmd,$rv);
	sleep(2);

?>
