	var popupWindow = null;
	function centeredPopup(url,winName,w,h,scroll){
		LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
		TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
		settings =
		'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
		popupWindow = window.open(url,winName,settings)
	}
	
	$(document).ready(function(){
		
		document.onkeydown = KeyPress;
		$('#wizard').smartWizard({transitionEffect:'slideleft',keyNavigation:false,onLeaveStep:leaveAStepCallback,onFinish:onFinishCallback,enableFinishButton:false});
		
		$('#password_calllogging').strength();
		$('#password_diagnostics').strength();
		$('#password_web').strength();
		$('#password_maintainer').strength();
		$('#password_select').strength();
		
		idleNoty = null;
		var state = "active";
		var stopCheckIdle = false;
		$(document).on("idle.idleTimer", function(event, elem, obj) {
			if (stopCheckIdle == false) {
				idleNoty = noty({type:'information', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "<br>No Activity Detected. Please Click <span style='font-weight:700; color:#444444'>Next</span> To Continue.<br><br>"}); 
				state = "idle";
			}
	
		});
	
		$(document).on("active.idleTimer", function(event, elem, obj, triggerevent) {
			if (state == "idle") {
			stopCheckIdle = true;
			}
			state = "active";
			if(typeof(idleNoty) != "undefined" && idleNoty !== null) {
				idleNoty.close();
			}
		});
	
		$.idleTimer(300000);
		
		internet_access = $('#internet_access').text(); 
		if (internet_access.toLowerCase().indexOf("offline") >= 0) {
			$('#uemail').prop('readonly', true)
			$('#upassword').prop('readonly', true)
			$('#get_licences').prop('disabled', true)
		}
		
		$('body').on('change', '#config input[name=system_name]', function(){
			var str = $(this).val(); str = $.trim(str);
			$('#softpbx_description').val(str)
		});
		
		$('body').on('change', '#default_config', function(){
			if ($("#default_config").prop("checked") == true) {
					console.log ('checked')
				$("#base_user_extn").prop("disabled",false);
				$("#base_dept_extn").prop("disabled",false);
				$("#inboundrecording").prop("disabled",false);
				$("#outboundrecording").prop("disabled",false);
			} else {
					console.log ('unchecked')
				$("#base_user_extn").prop("disabled",true);
				$("#base_dept_extn").prop("disabled",true);
				$("#inboundrecording").prop("disabled",true);
				$("#outboundrecording").prop("disabled",true);
			}
		});
		
		
			
      function leaveAStepCallback(obj, context){
		  
		if (context.toStep > 0) {
			stopCheckIdle = true;
			state = "active";
		}
		  // skip validation going back
        if (context.toStep < context.fromStep) {
			$('#wizard').smartWizard('hideMessage');
			licence_accept = false;
			return true;
		}
			
        var step_num = obj.attr('rel');
        return validateSteps(step_num);
      }
      
      function onFinishCallback(){
       if(validateAllSteps()){
		   
		var veryweakClass = $('.veryweak').length;
		var weakClass = $('.weak').length;

		if (veryweakClass > 0 || weakClass > 0 ) {
			var finishMsg = 'Warning: weak and insecure passwords detected. Are you sure you want to continue with the passwords entered ?<br><br>';
			var finishMsgMode = 'error';
		} else {
			var finishMsg = '';
			var finishMsgMode = 'warning';
		}

		var n = noty({
        type: finishMsgMode, layout: 'center', text: finishMsg + '<b>Please ensure you\'ve checked the system passwords entered.</b><br/><br/>Save Configuration Settings ?', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
		buttons     : [{ addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
			$noty.close();
			install_msg = (licenced == null) ? 'Manager' : 'SIP Wizard'

			var n_install = noty({type:'information', layout:'center', modal: 'true', closeWith: [], theme: 'relax', text: "Please Wait. Creating Configuration and redirecting to " + install_msg + "..<br/><img src='../admin/assets/images/save_banner.gif'>"}); 
				var datastring = $("#config").serialize();
				$.ajax({
					type: "POST",
					url: "save.php",
					data: datastring,
					dataType: "text",
					success: function(str) {
						console.log(str)
						redirect = (licenced == null) ? '/manager/' : '/manager/admin/sipwizard'
					    $("body").fadeOut(500,function(){
							$(location).attr('href',redirect);
						});
						return false;
					},
					error: function(str) {
						$noty.close();
					}
				});
			}
                },
                {addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
                    $noty.close(); 
					}
                }]
        });
       }
      }
		var licence_accept = false;	
		$('#get_licences').click(function() {
			$('#licence_link').css('display', 'none');
			
			internet_access = $('#internet_access').val(); 
			if (internet_access.toLowerCase().indexOf("offline") >= 0){
				$('#wizard').smartWizard('showMessage','Please check your Internet connection');
				return false;
			}

			
			system_name = $('#system_name').val();
			if (!system_name && system_name.length <=0) {
				$('#wizard').smartWizard('showMessage','No System Name Configured');
				$("#system_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#system_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			supplier = $('#system_supplier').val();
			if (!supplier && supplier.length <=0) {
				$('#wizard').smartWizard('showMessage','No Supplier Configured');
				$("#system_supplier").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#system_supplier").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			registered_email = $('#uemail').val();
			if (!registered_email && registered_email.length <=0) {
				$('#wizard').smartWizard('showMessage','No Forum Username Configured');
				$("#uemail").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#uemail").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			registered_password = $('#upassword').val();
			if (!registered_password && registered_password.length <=0) {
				$('#wizard').smartWizard('showMessage','No Forum Password Configured');
				$("#upassword").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				return false;
			} else {
				$('#wizard').smartWizard('hideMessage');
				$("#upassword").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
			}
			
			
		
		$('#licence_msg').html("");
		$('#licence_status').html("<img src='../admin/assets/images/loading.gif'/>");

		var credentials = '&uemail=' + encodeURIComponent($("#uemail").val()) + '&upassword=' + encodeURIComponent($("#upassword").val()) + '&supplier=' + encodeURIComponent($("#system_supplier").val()) + '&system=' + encodeURIComponent($("#system_name").val());
		
		$.ajax({
			url: 'helper.php?mode=licences' + credentials,
			dataType: 'json',
			success: function(data) {
				if (data[0].toLowerCase().indexOf("error") >= 0) {
					$('#licence_msg').html("1An Error has Occurred: " + data[0]).css('color', '#bf0000');
					$('#licence_status').html("<img src='../admin/assets/images/fail.png'/>");
					licence_accept = false;
				} else {
					$('input[name="licence"]').val(data[0]);
					$('#wizard').smartWizard('showMessage','Licences Successfully Retrieved');
					$('#licence_status').html("<img src='../admin/assets/images/success.png'/>");
					$('#licence_link').css('display', 'inline');

					if (data[1].length >=1) {
						$('#wizard').smartWizard('setError',{stepnum:3,iserror:false});
						$('#licence_select').empty()
						$('#softpbx_multiple_licences').show();
						jQuery.each(data[1], function(index, item) {
							licence = item.split(',');
							var o = new Option(licence[1] + " (" + licence[2] + ")", item);
							$(o).html(licence[1] + " (" + licence[2] + ")");
							$('#licence_select').append(o);
						});
						licence_accept = true;
						$('#defaultConfig').show();
					    $("#default_config").prop("checked",true);
						$("#default_config").prop("disabled",false);
						$("#base_user_extn").prop("disabled",false);
						$("#base_dept_extn").prop("disabled",false);
						$("#inboundrecording").prop("disabled",false);
						$("#outboundrecording").prop("disabled",false);
						$('#nolicenceConfig').hide();
					} else {
						$('#wizard').smartWizard('showMessage','No SV Licence Retrieved');
					}
					if (data[2] >=1) { 
						svusercount = data[2]
						$("#userCount").text(svusercount);
					}
				}
			},
			error: function(data){
				$('#licence_msg').html("2An Error has Occurred: " + data[0]).css('color', '#bf0000');
				$('#licence_status').html("<img src='../admin/assets/images/fail.png'/>");
			},
		});
	});		
	
	error = '0';
	function validateAllSteps(){
		var isStepValid = true;
       
		if(validateStep3() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:3,iserror:false});
		}
       
		if(validateStep4() == false){
			isStepValid = false;
			$('#wizard').smartWizard('setError',{stepnum:4,iserror:true});         
		}else{
			$('#wizard').smartWizard('setError',{stepnum:4,iserror:false});
		}
       
       if(!isStepValid){
          if (error > 1) 
			  $('#wizard').smartWizard('showMessage','Please correct the errors in the steps and continue');
       }
              
       return isStepValid;
    } 	
		
		
		function validateSteps(step){
			var isStepValid = true;
			
		// validate step 3
		if(step == 3) {
			
			if(validateStep3() == false ){
			isStepValid = false; 
			//$('#wizard').smartWizard('showMessage','Please correct the errors in step'+step+ ' and click next.');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		} else {
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			
			// SV Managed Users licences
			if ( $('#licence_select').val() !== null ) {
				SVManagerUsers = {'SV1000001' : 0, 'SV1000SC' : 0, 'SV1000MAPS' : 5, 'SV1000VMAP' : 0, 'SV1000MAP' : 0, 'SV1000NSG' : 0, 'SV1000OFF01' : 0, 'SV1000020' : 20};

				svlicence = $('#licence_select').val().split(',')[1].replace('-',''); // get selected licence, get SV1000 & remove -
				svcount = SVManagerUsers[svlicence];
				updatedcount = parseInt(svcount) + parseInt(svusercount)
				$('#userCount').text(updatedcount)
				}
			}
		}
      
		// validate step4
		if(step == 4){
			if(validateStep4() == false ){
			isStepValid = false; 
			//$('#wizard').smartWizard('showMessage','Please correct the errors in step'+step+ ' and click next.');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:true});         
		}else{
			$('#wizard').smartWizard('hideMessage');
			$('#wizard').smartWizard('setError',{stepnum:step,iserror:false});
			}
		}
      
		return isStepValid;
    }
		
		function validateStep3() {
			currentStep = ( $('#wizard').smartWizard('currentStep')  )
			var isValid = true; 
			system_name = $('#system_name').val();
			system_supplier = $('#system_supplier').val();
			licenced = $('#licence_select').val();
			
			if(!system_name && system_name.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter System Name');   
				$("#system_name").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;
			} else {
				$("#system_name").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				error--;
			}
			
			if(!system_supplier && system_supplier.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Supplier Name');
				$("#system_supplier").css({ 'border': '2pt solid #D00', 'color': '#D00'});				
				error++; isValid = false;  return false;
			} else {
				$("#system_supplier").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				error--;
			}
			
			if(licenced == null && licence_accept == false) {
				isValid = false; 
				var n = noty({
					type: 'error', layout: 'center', text: 'No System Licence has been downloaded. A default configuration will be created using the System, Supplier and Password details provided.', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1,
					buttons : [
						{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
							licence_accept = true;
							$('#defaultConfig').hide();
							$("#default_config").prop("checked",false);
							$("#default_config").prop("disabled",true);
							$("#base_user_extn").prop("disabled",true);
							$("#base_dept_extn").prop("disabled",true);
							$("#inboundrecording").prop("disabled",true);
							$("#outboundrecording").prop("disabled",true);
							$('#nolicenceConfig').show();
							$noty.close(); 
							}
						}
					]
				});
			}
			
			
			if (currentStep === 3 && licenced != null && licenced.indexOf("SV1000") === -1) {
				var n = noty({
					type: 'error', layout: 'center', text: 'No SV Licence has been selected. A default configuration will be created using the System, Supplier and Password details provided.', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1,
					buttons : [
						{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
							licence_accept = true;
							$('#defaultConfig').hide();
							$("#default_config").prop("checked",false);
							$("#default_config").prop("disabled",true);
							$("#base_user_extn").prop("disabled",true);
							$("#base_dept_extn").prop("disabled",true);
							$("#inboundrecording").prop("disabled",true);
							$("#outboundrecording").prop("disabled",true);
							$('#nolicenceConfig').show();
							$noty.close();
							}
						}
					]
				});
			}
			
			
			if (currentStep === 3 && licenced != null && licenced.indexOf("SV1000") >= 0) {
				$('#defaultConfig').show();
				$("#default_config").prop("checked",true);
				$("#default_config").prop("disabled",false);
				$("#base_user_extn").prop("disabled",false);
				$("#base_dept_extn").prop("disabled",false);
				$("#inboundrecording").prop("disabled",false);
				$("#outboundrecording").prop("disabled",false);
				$('#nolicenceConfig').hide();
			}
			
			return isValid;
		}
    
		function validateStep4(){
			var isValid = true;
			password_web = $('#password_web').val();
			password_diagnostics = $('#password_diagnostics').val();
			password_maintainer = $('#password_maintainer').val();
			password_select = $('#password_select').val();
			
			base_user_extn = $('#base_user_extn').val();
			base_dept_extn = $('#base_dept_extn').val();
			inboundrecording = $('#inboundrecording').val();
			outboundrecording = $('#outboundrecording').val();
		
			if(!password_diagnostics && password_diagnostics.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Diagnostics Engineering Password');   
				$("#password_diagnostics").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#password_diagnostics").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				error--;
			}
		
			if(!password_web && password_web.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Web Password');   
				$("#password_web").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#password_web").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});
				error--;
			}
		
			if(!password_maintainer && password_maintainer.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Maintainer Password');
				$("#password_maintainer").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#password_maintainer").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			if(!password_select && password_select.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Select Password');
				$("#password_select").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#password_select").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			if(!base_user_extn || base_user_extn.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Staring Users Extension Number');
				$("#base_user_extn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#base_user_extn").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			if(!base_dept_extn || base_dept_extn.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Starting Departments Extension Number');
				$("#base_dept_extn").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#base_dept_extn").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			if(!inboundrecording || inboundrecording.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Inbound Recording Department Extension Number');
				$("#inboundrecording").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#inboundrecording").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			if(!outboundrecording || outboundrecording.length <= 0) {
				$('#wizard').smartWizard('showMessage', 'Please enter Outbound Recording Department Extension Number');
				$("#outboundrecording").css({ 'border': '2pt solid #D00', 'color': '#D00'});
				error++; isValid = false;  return false;				
			} else {
				$("#outboundrecording").css({ 'border': '1pt solid #DFDFDF', 'color': '#222'});   
				error--;
			}
			
			$('#wizard').smartWizard('hideMessage');
			return isValid;
		}
		
		function KeyPress(e) {
			var currentStep = $('#wizard').smartWizard('currentStep');
			if (currentStep === 1) {
				var evtobj = window.event ? event : e
				console.log (evtobj)
				if (evtobj.keyCode == 81 && evtobj.ctrlKey && evtobj.altKey) {
					//alert("Ctrl+Alt+Q");
					var n = noty({
					type: 'error', layout: 'center', text: 'Quitting the setup wizard will result in you not being able to access it again.<br/><b>Quit Setup Wizard ?</b>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
					buttons     : [
						{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
							location.href = "helper.php?mode=exit";
							$noty.close(); }
						},
						{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
							$noty.close(); }
						}
					]
					});
				} else if (evtobj.keyCode == 77 && evtobj.ctrlKey && evtobj.altKey) {
					//alert("Ctrl+Alt+M");
					var n = noty({
					type: 'error', layout: 'center', text: 'Configure Ask Master ?</b><br/><b>Quit Setup Wizard ?</b>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1, 
					buttons     : [
						{addClass: 'btn btn-primary', text: 'OK', onClick: function ($noty) {
							location.href = "helper.php?mode=askmaster";
							$noty.close(); }
						},
						{addClass: 'btn btn-danger', text: 'Cancel', onClick: function ($noty) {
							$noty.close(); }
						}
					]
					});
				}
			}
		}
				
		$("body").on('click', '#showPasswords', function(e) {
		    e.preventDefault();
			console.log ('click')
			if ($('#password_diagnostics').prop('type') == 'password') {
				$('#showPasswords').html("<span class='icon-notification showpassword'></span> HIDE PASSWORDS");
		        $('#password_calllogging').prop('type', 'text');
				$('#password_diagnostics').prop('type', 'text');
				$('#password_web').prop('type', 'text');
				$('#password_maintainer').prop('type', 'text');
				$('#password_select').prop('type', 'text');
			} else {
				$('#showPasswords').html("<span class='icon-notification showpassword'></span> SHOW PASSWORDS");
				$('#password_calllogging').prop('type', 'password');
				$('#password_diagnostics').prop('type', 'password');
				$('#password_web').prop('type', 'password');
				$('#password_maintainer').prop('type', 'password');
				$('#password_select').prop('type', 'password');
			}
		});
		
		$('body').on('change', '#base_user_extn, #base_dept_extn, #inboundrecording, #outboundrecording', function(){
		  if (document.hasFocus()) {
			base_user_extn = parseInt($('#base_user_extn').val());  
			base_dept_extn = parseInt($('#base_dept_extn').val());  
			
			max_user_extn = parseInt($('#base_user_extn').val()) + parseInt($('#userCount').text());
			max_dept_extn = parseInt($('#base_dept_extn').val()) + 10;
			
			inboundrecording = parseInt($('#inboundrecording').val());  
			outboundrecording = parseInt($('#outboundrecording').val());
			main = '8000';
			
			$('#wizard').smartWizard('hideMessage');

			
			if ($(this).val().length < 2) {
				extnAlert ('Warning: Extension numbers must be 2 digits or more');
				$(this).val('');
				return false;
			}
			
			if(!$.isNumeric($('#base_user_extn, #base_dept_extn, #inboundrecording, #outboundrecording').val())) {
				extnAlert ('Warning: Extension numbers can only contain digits');
				$(this).val('');
				return false;
			}
			
			if ($(this).val() === main) {
				extnAlert ('Warning: Extension Number 8000 is in use');
				$(this).val('');				
				return false;
			}
			
			if (base_user_extn == base_dept_extn) {
				extnAlert ('Warning: Starting User Extension clashes with Department Starting Extension');
				$(this).val('');				
				return false;
			}
			
			if (base_user_extn == inboundrecording || base_user_extn == outboundrecording) {
				extnAlert ('Warning: Starting Users Extension clashes with Recording Department Number'); 
				$(this).val('');
				return false;
			}
			
			if (base_dept_extn == inboundrecording || base_dept_extn == outboundrecording) {
				extnAlert ('Warning: Starting Department Extension clashes with Recording Department Number');
				$(this).val('');
				return false;
			}
			
			if (main == inboundrecording || main == outboundrecording) {
				extnAlert ('Warning: Extension 8000 is in use and clashes with Recording Department Number'); 
				$(this).val('');
				return false;
			}
			
			if (base_user_extn >= base_dept_extn && base_user_extn <= max_dept_extn) {
				extnAlert ('Warning: User Extension is in Department extension range');
				$(this).val('');
				return false;
			}
			
			if (base_dept_extn >= base_user_extn && base_dept_extn <= max_user_extn) {
				extnAlert ('Warning: Department Extension is in User extension range');
				$(this).val('');
				return false;
			}
			
			if ((inboundrecording >= base_user_extn && inboundrecording <= max_user_extn) || (inboundrecording >= base_dept_extn && inboundrecording <= max_dept_extn)) {
				extnAlert ('Warning: Inboundrecording extension is in User or Department extension range')
				$(this).val('');
				return false;
			}
			
			if ((outboundrecording >= base_user_extn && outboundrecording <= max_user_extn) || (outboundrecording >= base_dept_extn && outboundrecording <= max_dept_extn)) {
				extnAlert ('Warning: Outboundrecording extension is in User or Department extension range')
				$(this).val('');
				return false;
			}
			
			if ((main >= base_user_extn && main <= max_user_extn) || (main >= base_dept_extn && main <= max_dept_extn)) {
				extnAlert ('Warning: Extension 8000 is in use and clashes with the User or Department extension range')
				$(this).val('');
				return false;
			}
			
		  }
		});
		
		function extnAlert(msg) {
			var n = noty({type: 'error', layout: 'center', text: msg + '<br><br><i>click to close<i>', dismissQueue: true, theme: 'relax', modal: true, maxVisible:1});
			return false;
		}
		
});