<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<title>Help - Speed Dials</title>
<head>
<script type="text/javascript">
	var state = {};
	var title = 'Help';
	var url   = '/manager/assist/help';
	history.pushState(state, title, url);
</script>
<link href="/manager/assist/css/Styles.css" rel="stylesheet" type="text/css">
<script src="/manager/assist/js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script type="text/javascript">
$(function() {
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) {
			$('#toTop').fadeIn();
		} else {
			$('#toTop').fadeOut();
		}
	});

	$('#toTop').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});
});
</script>
</head>
<body>
<div id="toTop">^ Back to Top</div>
<div id="contain">
<h2><img src='/manager/assist/images/help.png' style="vertical-align:middle;">&nbsp;Help - Speed Dials</h2>
<b>Speed Dials - Add, Import, Export and Update</b><br/>
This page provides a simple and convenient way to manage speed dials on the system. Options are available to add, remove, update, import and export speed dials.<br/><br/>
From the drop down list select which action you would like to perform. The page will request the appropriate information related to the action selected.<br/><br/>
Where applicable the 'Extension Range' field is used to enter the extension numbers where the speed dial amendments are to be applied. Enter either a comma between each extension number or use a hyphen to indicate a range of extensions.<br/><br/>EG: 2001,2003,2005 would specify those three extensions, 2001-2005 specifies 2001 throught to and including 2005. If an extension is missing from the range entered it will be skipped and the script will continue.<br/><br/>

Ticking the 'Create System Backup' check box will ensure a system backup is created prior to the speed dials being added.<br/><br/>
Ticking the 'Delete all existing speed dials from range' check box will delete any existing speed dials from the extensions entered in the extension range field.<br/><br/>

<b>Add New Speed Dials</b><br/>From the drop down list select 'Add New Speed Dials' the page will refresh to show the add speed dials form.<br/><br/>
The Speed Dial form is made up of three fields. New Number, Shortcode and Description. The new number field is used for the telephone number of the speed dial. The description field is the description you would like displaying for the speed dial and the shortcode field can be used for any shortcode you wish to apply to this speed dial. Only the new number and description fields are needed to add a new speed dial.<br/><br/>
If you wish to add multiple speed dials, click the 'Add Row' button to add a new row to the speed dial form. You can remove additional rows using the 'Remove Row' button. Only visible rows will be added.<br/><br/>
Click 'Add Speed Dials' to add the speed dials to the selected extension range.<br/><br/>
<b>eg:</b><br/>Extension Range: 2001-2005<br/>New Number: 01923 282200<br/>Description: SpliceCom<br/>
Will add a new speed dial to 2001-2005 inclusive with the telephone number of 01923 282200 and the description of SpliceCom<br/><br/><br/>

<b>Update Existing Speed Dials</b><br/>From the drop down list select 'Update Existing Speed Dials' the page will refresh to show the update speed dials form.<br/><br/>
The Update Speed Dial form is made up of four fields. Old Number, New Number, Shortcode and Description. The old number field is the number of the speed dial you wish to update, the new number field is used for the telephone number of the speed dial. The description field is the description you would like displaying for the speed dial and the shortcode field can be used for any shortcode you wish to apply to this speed dial. Only the old number, new number and description fields are needed to update a speed dial.<br/><br/>
If you wish to update multiple speed dials, click the 'Add Row' button to add a new row to the speed dial form. You can remove additional rows using the 'Remove Row' button. Only visible rows will be updated.<br/><br/>
Click 'Update Speed Dials' to update the speed dials for the selected extension range.<br/><br/>
<b>eg:</b><br/>Extension Range: 2001, 2003<br/>Old Number: 2005<br/>New Number: 2005<br/>Description: Bob<br/>
Will update any speed dial with a telephone number of 2005, keeping the number as 2005 and setting the description to Bob for 2001 & 2003<br/><br/><br/>

<b>Remove Existing Speed Dials</b><br/>From the drop down list select 'Remove Existing Speed Dials' the page will refresh to show the remove speed dials form.<br/><br/>
The Remove Speed Dial form is made up of one field. Telephone Number. Enter in this field the telephone number of the speed dial you wish to delete.<br/><br/>
Click 'Remove Speed Dials' to remove the speed dial for the selected extension range.<br/><br/>
<b>eg:</b><br/>Extension Range: 2001, 2003<br/>Telephone Number: 2005<br/>
Will remove any speed dial with a telephone number of 2005 from 2001 & 2003<br/><br/><br/>

<b>Import Speed Dials</b><br/>From the drop down list select 'Import Speed Dials' the page will refresh to show the import speed dials form.<br/><br/>
Speed Dials can be imported from a formatted csv file. The delimiter used must be a semi-colon (;)<br/><br/>
The Import file needs to be in the following format:<br/>
telephone;shortcode;description<br/>
2001;;Extn 2001<br/>
2002;G:1;Extn 2002<br/><br/>
Enter the extension range you wish the speed dials to be applied to and select the import file using the 'import speeddials' file chooser.<br/>
Click 'Import Speed Dials' to apply the speed dial from the csv file to the selected extension range.<br/><br/>
<br/><br/>

<b>Export Speed Dials</b><br/>From the drop down list select 'Export Speed Dials' the page will refresh to show the export speed dials form.<br/><br/>
Speed Dials can be exported from an exising user and then re imported to other users using the 'Import Speed Dials' option.<br/><br/>
Select your required user, then click 'Export Speed Dials'.<br/><br/>
The page will update to allow you to download the speed dials from your user. The file name is UserName-speeddials.csv<br/><br/><br/>

<b>Delete All Existing Speed Dials</b><br/>
Using the 'Delete all existing speed dials from range' check box it is possible to remove all speed dials from a user or range of users.<br/>
From the drop down list select 'Add New Speed Dials' the page will refresh to show the add speed dials form.<br/><br/>
Enter the extension number/s you wish to remove the speed dials from in the extension range field.<br/>
Ensure the 'Delete all existing speed dials from range' is ticked, DON'T enter anything in the speed dial form.<br/>
Click 'Add Speed Dials'. The existing speed dials will be remove and nothing new will be added.<br/><br/><br/>


</div>
</body>
</html>
