<?php
// v1.0 PJC 25MAR2016
if(!isset($_SESSION)) session_start();
$page_id = "087";
include ".access.php";
header('Content-type: text/html; charset=UTF-8') ;
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];


$manager_user = (isset($_SERVER['PHP_AUTH_USER'])) ? $_SERVER['PHP_AUTH_USER'] : '';
$file = "/SpliceCom/Web/download/.$manager_user.notes.list";

if ( !file_exists( $file ) ) {
	$fp = fopen ( $file, "w+" ) or die ("Cannot open $file for writing, check permissions");
	fwrite ( $fp, "Example Note|".date("d-m-Y H:i:s")."|0\n" );
	fclose ( $fp ) ;
}

$modified = filemtime ( $file );
$hash = sha1_file ( $file );

if ( isset ( $_POST["mode"] ) && $_POST["ohash"] == $hash ) {

	if ( $_POST["mode"] == "Add" && ! empty ( $_POST["data"]) ) {

		$fp = fopen ( $file, "a+" ) or die ("Cannot open $file for writing, check permissions");
		fwrite ( $fp, stripslashes(makeLinks($_POST["data"])."|".date("d-m-Y H:i:s")."|0\n" ));
		fclose ( $fp ) ;

	} elseif ( $_POST["mode"] == "Remove" ) {

		$data = file ( $file );
		$fp = fopen ( $file , "w+" ) or die ("Cannot open $file for writing, check permissions");
		$n = 0;

		foreach ( $data as $line ) {
			if ( empty ( $_POST["line"][$n] ) ) {
				fwrite ( $fp, $line );
			}
			$n++;
		}
		fclose ( $fp );

	} elseif ( $_POST["mode"] == "Update" ) { 

		$data = file ( $file );
		$fp = fopen ( $file , "w+" ) or die ("Cannot open $file for writing, check permissions");
		$n = 0;

		foreach ( $data as $line ) {
			if ( empty ( $_POST["line"][$n] ) ) {
				fwrite ( $fp, $line );
			} else {
				fwrite ( $fp, stripslashes(makeLinks($_POST["data"])."|".date("d-m-Y H:i:s")."|0\n" ));
			}
			$n++;
		}
		fclose ( $fp );
	} elseif ( $_POST["mode"] == "Complete" ) { 

		$data = file ( $file );
		$fp = fopen ( $file , "w+" ) or die ("Cannot open $file for writing, check permissions");
		$n = 0;

		foreach ( $data as $line ) {
			if ( empty ( $_POST["line"][$n] ) ) {
				fwrite ( $fp, $line );
			} else {
				$val = explode ("|",$line);
				if ( !strstr ( $val[2] , "1") ) {
					$line = trim($val[0])."|".trim($val[1])."|1";
					fwrite ( $fp, $line."\n" );
				} else {
					$line = trim($val[0])."|".trim($val[1])."|0";
					fwrite ( $fp, $line."\n");
				}
			}
			$n++;
		}
		fclose ( $fp );
	}

	$hash = sha1_file ( $file );

}
?>

<html>
<head>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href='css/Styles.css' rel='stylesheet' type='text/css'>
<style>
input#data {position:relative;top:-10px;}
</style>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script language="javascript">
function checkAll(){
	for (var i=0;i<document.forms[0].elements.length;i++)
	{
		var e=document.forms[0].elements[i];
		if ((e.name != 'allbox') && (e.type=='checkbox'))
		{
			e.checked=document.forms[0].allbox.checked;
			$('#data').val("");
		}
	}
}
$(document).ready(function () {
	var count;
	$(':checkbox:not("#allbox")').change(function() {
        var $checkboxes = $('input[type="checkbox"]:checked:not("#allbox")');
        count = ( $checkboxes.length ) ;
		
		str = $(this).closest('tr').find('.note').html();
		str_text = $checkboxes.closest('tr').find('.note').text();
		if (str.indexOf("<strike") >= 0) return false;
		if (count == "1" ) {
            var txt = 
			$('#data').val( str_text );
		} else {
			$('#data').val("");
		}
	});
	
	$("#add").click(function(e){
		console.log (count);
		data_count = ( $('#data').val().length );
		
		if (count == 1 ) {
			if (!confirm('Are you sure you want to duplicate the selected entry ?')) return false;
		} else if (data_count <= 0) {
			alert("Please enter note details.");
			return false;
		} 
	});
	
	$("#remove").click(function(e){
		console.log (count);
		if (count < 1) {
			alert("Please Select An Entry.");
			return false;
		} else {
			if (!confirm('Are you sure you want to remove the selected entry ?')) {
				return false;
			}
		}
	});
	
	$("#complete").click(function(e){
		console.log (count);
		if (count < 1) {
			alert("Please Select An Entry.");
			return false;
		} else {
			if (!confirm('Are you sure you want to update the selected entry ?')) {
				return false;
			}
		}
	});
	
    $("#update").click(function(e){
		console.log (count);
		if (count < 1) {
			alert("Please Select An Entry.");
			return false;
		} else if (count > 1) {
			alert("Please Select Only One Entry.");
		    $("input:checkbox").prop('checked', $(this).prop("checked"));
			$('#data').val( " " );
			return false;
		} else {
			if  ($('#data').val().length <1) return false;
			if (!confirm('Are you sure you want to update the selected entry ?')) {
				return false;
			}
		}
	});

});
</script>
</head>

<body>

<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_notes.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div id="contain">
<h2><img src='images/backup.png' style="vertical-align:middle;">&nbsp;Notes list</h2>
Logged In As: <b><?php echo $manager_user ?></b><br/>
Last Update: <?php echo date ("F d Y H:i:s T", $modified ) . " ::: " . timeSince ( $modified );?><br />

<br />
This page will allow you to keep simple notes on the system. Notes can be a maximum of 160 characters.<br />
Notes are stored per manager and are visible when logged in with Manager Assist permissions.<br />
<br />
<hr />
<form action="<?php echo $_SERVER["PHP_SELF"]?>" method="POST" name="note">
<input type="hidden" name="ohash" value="<?php echo $hash ?>" />
<table border="0">
<?php

	$data = file ( $file );
	$n = 0;
	$entry = array();

	foreach ( $data as $line ) {
		$entry = explode ("|", $line);
		$entry[0] = substr(trim($entry[0]),0,160); 
		$entry[1] = trim($entry[1]);
		echo "<tr><td>";
		echo $n+1;
		echo "</td><td><input type='checkbox' name='line[$n]' id='$n'/></td>";
		if ($entry[2] == 0) {
			echo "<td class='note'><span>$entry[0]</span></td><td><span class='small'> ($entry[1])</span></td>";
		} else {
			echo "<td class='note'><strike style='color:red'><span style='color:black'>$entry[0]</span></td><td><span class='small'> ($entry[1])</span></strike></td>";
		}
		echo "</tr>";
		$n++;
	}
?>
</table>
<hr /><br />
<input type="checkbox" value="on" name="allbox" id="allbox" onclick="checkAll();"/><img src="images/select_all.png" title="Toggle All"/><br />
<div style="vertical-align: middle;">
<input type="text" name="data" id="data" size="50" maxlength="160"/>
<input type="hidden" name="mode" value="" />

<input type="image" id="add" title="Add New Entry" alt="Add New Entry" src="images/plus.png" border="0"  onclick="this.form.mode.value = 'Add'" />
<input type="image" id="update" title="Edit Entry" alt="Edit Entry" src="images/pencil.png" border="0" onclick="this.form.mode.value = 'Update'" />
<input type="image" id="remove" title="Remove Entry" alt="Remove Entry" src="images/trash.png" border="0" onclick="this.form.mode.value = 'Remove'" />
<input type="image" id="complete" title="Toggle Completion" alt="Toggle Completion" src="images/tick.png" border="0" onclick="this.form.mode.value = 'Complete'" />
</div>
</form>

</body>
</div>
</html>

<?php
/* FUNCTIONS */

function timeSince ( $timestamp ) {

	$diff = time() - $timestamp;

	if ( $diff < 4000 ) {
		$diff = ceil ( $diff / 60 );
		$unit = "minute";

	} elseif ( $diff < 100000 ) {
		$diff = ceil ( $diff / 3600 );
		$unit = "hour";

	} else {
		$diff = ceil ( $diff / 86400 );
		$unit = "day";
	}

	$end = ( $diff <= 1 ) ? NULL : "s";

	return "$diff $unit$end ago";
}

function makeLinks($str) {
	$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
	$urls = array();
	$urlsToReplace = array();
	if(preg_match_all($reg_exUrl, $str, $urls)) {
		$numOfMatches = count($urls[0]);
		$numOfUrlsToReplace = 0;
		for($i=0; $i<$numOfMatches; $i++) {
			$alreadyAdded = false;
			$numOfUrlsToReplace = count($urlsToReplace);
			for($j=0; $j<$numOfUrlsToReplace; $j++) {
				if($urlsToReplace[$j] == $urls[0][$i]) {
					$alreadyAdded = true;
				}
			}
			if(!$alreadyAdded) {
				array_push($urlsToReplace, $urls[0][$i]);
			}
		}
		$numOfUrlsToReplace = count($urlsToReplace);
		for($i=0; $i<$numOfUrlsToReplace; $i++) {
			$str = str_replace($urlsToReplace[$i], "<a href=\"".$urlsToReplace[$i]."\" target='_blank'>".$urlsToReplace[$i]."</a> ", $str);
		}
		return $str;
	} else {
		return $str;
	}
}
?>