<?php
//v1.1 PJC MON 15MAY2017
session_start();
$page_id = "089";
include ".access.php";


if (!file_exists('/SpliceCom/WebManager/admin/')) header("Location: /manager/assist");

$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}


$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); 
$info = ldap_get_entries($ds,$sr); 
$self = $info[0]['location'][0];

$sr = ldap_read($ds,"cn=$self,cn=Modules","objectclass=module"); 
$info = ldap_get_entries($ds,$sr); 
$productversion = $info[0]['productversion'][0];


if (strpos($productversion, 'SV') === false) {
	header("Location: /manager/assist");
	exit;
}

include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME']; 	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>AdminPortal Audit Logs</title>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>

<style type="text/css">
	.statictable table th { color: #770000; }
</style>
<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
	//$('body').on('click', '#search', function(){
	$("#searchLogs").submit(function( event ) {
		event.preventDefault();
		var auditLog = $('#auditLog').val();
		var search = $('#searchInput').val();
		
	if (auditLog.length < 1) {
		var n = noty({ type: 'error', layout: 'center', text: '<br>No Portal Log File Selected<br><br><i>(Click to Close)</i><br><br>', dismissQueue: true, theme: 'relax', modal: true  });
		return false; 
	}
	if (search.length < 1) {
		var n = noty({ type: 'error', layout: 'center', text: '<br>No Search Criteria Entered<br><br><i>(Click to Close)</i><br><br>', dismissQueue: true, theme: 'relax', modal: true  });
		return false; 
		
	}
		
		$.ajax({ type: "GET",   
         url: "portallog.php?log=" + auditLog + "&search=" + search,   
         async: true,
         success : function(text) {
			 console.log(text)
			$("#audit").find('tr').not('#thead').not('#tfoot').not('#nodata').remove();
			if (text.length >= 1 ) {
				$('#nodata').hide();
				var td = text.split('\n');
				$.each(td, function (index, value) {
					var val = value.split(',')
					var color = (val[3] !== undefined && val[3].toLowerCase().indexOf("delete") >= 0) ? '#ff5e5e' : '';
					if (val[0].length >= 1) $('#audit tr:last').before("<tr style='background-color:" + color + "'><td>" + val[0] + "</td><td>" + val[1] + "</td><td>" + val[2] + "</td><td>" + val[3] + "</td></tr>");
    			});
			}
			else {
				$('#nodata').show();
				}
			}
		});
	});
	
	$('body').on('change', '#auditLog', function(){
		if ($('#auditLog option:selected').text().length >= 1) {
	        $('#download').show(200);
			logFile = $('#auditLog option:selected').text().split(' ');
			$('#downloadLog').attr("href", "download.php?download=/SpliceCom/logs/portalLogs/" + logFile[0])
		} else {
			$('#download').hide(200);
		}
		
	});
	
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings = 'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body id="dt_excodes">
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script ?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_portalaudit.php','help','850','550','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain"><div id="codes">
<h3><img src='images/ok.png' style="vertical-align:middle;">&nbsp;AdminPortal Audit Logs</h3>


<form method='post' id='searchLogs' action='<?php echo $script ?>'>
<div class='block'>
<label><a href='#' class='tooltip' title='Select the portal audit log to search'><img src='images/tooltip.jpg'></a>&nbsp;<b>Select Portal Audit Log : </b></label> 
<select name="auditLog" id="auditLog">
<option></option>
<?php 
foreach (glob("/SpliceCom/logs/portalLogs/portalAudit.log*") as $filename) {
    $logname = str_replace("/SpliceCom/logs/portalLogs/","",$filename);
	$date = date('d/m/y H:i:s', filemtime($filename));
	//$i= ($logname === 'portalAudit.log') ? '0' : str_replace("portalAudit.log.","",$logname);
    echo "<option value='$logname'>$logname ($date)</option> ";
}
?>
</select>
</div><br/>


<div class='block'>
<label><a href='#' class='tooltip' title='Search the selected log for key word. eg: add, edit, delete, user, device, phone, department, autoattendant, IP Address, UserName '><img src='images/tooltip.jpg'></a>&nbsp;<b>Search Log:</b></label>
<input class='filter' id='searchInput' name='searchInput' size='28' placeholder='Enter Search Criteria'>&nbsp;&nbsp;<input type='submit' name='search' id='search' value='Search'> 
</div><br/>


<div id='download' style='display:none'>
<a href='#' class='tooltip' title='Download selected portal audit log'><img src='images/tooltip.jpg'></a>&nbsp;<b><a id='downloadLog' href=''>Download Log File</a></b>
</div><br/><br/>
</form>

<div class='statictable'>

<table cellpadding='0' cellspacing='0' border='0' id='audit' width='100%'>
<thead><tr id='thead'><th width='15%'>Date / Time</th><th width='15%'>IP Address</th><th width='15%'>EndUser</th><th width='55%'>Event</th></tr></thead>
<tfoot><tr id='tfoot'><th width='15%'>Date / Time</th><th width='15%'>IP Address</th><th width='15%'>EndUser</th><th width='55%'>Event</th></tr></tfoot>

<tbody class='fbody'>
<tr id='nodata'><td colspan='4'>NO DATA - Enter Search Criteria</td>
</tbody>

</table>

</div>
</body>
</html>