<?php
// v1.35
// PJC 26-JAN-2017 Link Updates
// PJC 25-June-2014 - updated table wording when no data is returned
// PJC 16-April-2014 - updated table header LCPlan
// PJC AUG
session_start();
$page_id = "037";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$action = (isset ($_REQUEST['action'] )) ? $_REQUEST['action'] : "0";

switch ($action) {
  case "1":
    $noData = "Recording is not configured against any User"; break;
  case "2":
    $noData = "Recording is not configured against any Department"; break;
  case "3":
    $noData = "Dial Record is not configured in any Dial Plans"; break;
  case "4":
    $noData = "Dial Record is not configured in any LCR Plans"; break;
  case "5":
    $noData = "Recording is not configured in any DDI Plans"; break;
  default:
    $noData = "Recording is not configured";
}

	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		echo "LDAP connect failure<br>";
	} else {
		$r = ldap_bind($ds,"INTERNAL","0123456");
		if ( ! $r) {
			echo "LDAP bind failure<br>";
			$ds = false;
		}
	}

       $sr = ldap_list($ds,"cn=Modules","(&(objectclass=module)(moduletype=20))",array('cn','telephonenumber','guid','recordmode'));
 	   $info = ldap_get_entries($ds, $sr);	$vision = $info['count'];
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Call Recording - Check how recording is configured</title>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<style type="text/css">
	@import "css/codes/codes_page.css";
	@import "css/codes/codes_table.css";
	@import "css/codes/custom.css";
</style>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/codes/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="js/codes/jquery.jeditable.js" type="text/javascript"></script>
<script src="js/codes/jquery.dataTables.editable.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script type="text/javascript" charset="utf-8">
	$(document).ready(function() {
		oTable = $('#excodes').dataTable({
			"bJQueryUI": true,
			"sPaginationType": "full_numbers",
			"oLanguage": { "sEmptyTable": "<?php echo $noData; ?>" },
			"aLengthMenu": [[10, 25, 50, 100, 250, 500, 1000, -1], [10, 25, 50, 100, 250, 500, 1000, "All"]]
			});
	$('#excodes').dataTable().makeEditable({
			sUpdateURL: "sparenumbersupdate.php",
	 	});
	});
</script>

<?php if (!isset($_SESSION['alert'])) { ?>
<script type="text/javascript">
	 	msg = <?php echo $vision ?>;
	 	if (msg <1) {
		$(function() {
			$('#overlay').fadeIn('fast',function(){
            $('#alert').animate({'top':'100px'},500);
        });
        $('#alertclose').click(function(){
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
        	});
        });
	});
}
</script>
<?php
        $_SESSION['alert'] =1;
    	}
?>


<script type="text/javascript">
	function formSubmit()
		{
		document.getElementById("frm1").submit();
		}
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body id="dt_excodes">
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script."?action=".$action ?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_recording.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="container"><div id="codes">
<h3><img src='images/ok.png' style="vertical-align:middle;">&nbsp;Call Recording - Check how recording is configured</h3>
<?php

	$mode = array('None','Resource','Mandatory','Random','Disable','Trunk');
	$type = array('','Telephone','Email','SMS','Lamp','Archive','Archive Email','SMS Web','Custom Email','','','Missed Call Email');
	$method = array('None','Alert','Deliver','Copy','Access','Prompt','Deliver and Delete','Deliver New','Deliver Link');

	echo "<h3><font class='oboldtext'>Recordings</font></h3>";
	echo "This script shows if recording is enabled on a User, Department or configured in a DialPlan, LCRPlan or DDIPlan.<br/>";
	echo "The results are fully searchable and sortable.<br/>";
 	?>

 	<form id="frm1" method="post" action="<?php echo $_SERVER['PHP_SELF']?>">
	<br><font class='oboldtext'>Select Action : </font>
	<select name="action" onchange="formSubmit()">
	<option></option>
	<option value='1' <?php if ($action == '1') echo 'selected'; ?> >Users</option>
	<option value='2' <?php if ($action == '2') echo 'selected'; ?> >Departments</option>
	<option value='3' <?php if ($action == '3') echo 'selected'; ?> >DialPlan</option>
	<option value='4' <?php if ($action == '4') echo 'selected'; ?> >LCRPlan</option>
	<option value='5' <?php if ($action == '5') echo 'selected'; ?> >DDIPlan</option>
	</select>&nbsp;<a href='#' class='tooltip' title='Select The Action To Perform'><img src='images/tooltip.jpg'></a></form><br/><br/>

	<?php
	If (isset($_REQUEST['action'])) {

	if ($_REQUEST['action'] =='1') {

	echo "<h3>Users</h3>";
	echo "This script will show who has recording enabled and if there are any potential issues.<br/><br/>";
	echo "<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:50%' ><legend><b>Key :</b></legend>";
	echo "<a href='#' class='tooltip' title='It Is Strongly Recommended That The Method Is Set As &#39Deliver And Delete&#39 As This Minimizes The Hard Disc Space Consumed By Call Recording.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:YELLOW'>Yellow - Voicemail contact with type Archive configured. Method Deliver & Delete not set.</span><br/>";
	echo "<a href='#' class='tooltip' title='Archive Enables An External Application To Collect Call Recordings.<Br/>It Is Strongly Recommended That The Method Is Set As &#39Deliver And Delete&#39 As This Minimizes The Hard Disc Space Consumed By Call Recording.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:#A9F6FF'>Cyan - Recording is enabled however a voicemail contact with Archive is not set.</span><br/>";
	echo "<a href='#' class='tooltip' title='It Is Advised To Set Only One Voicemail Contact With The Type Archive. Multiple Could Entries Cause Delivery Issues.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:#BC65FF'>Violet - Recording is enabled however multiple voicemail contacts with Archive are set.</span></fieldset><br/><br/>";

	echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='25%'>Name</th><th>Extension</th><th>Record Mode</th><th>Status</th></tr></thead>
		<tfoot><tr><th>Name</th><th>Extension</th><th>Record Mode</th><th>Status</th></tr></tfoot><tbody>";

       $sr = ldap_list($ds,"cn=Users","(&(objectclass=user)(!(recordmode=0))(!(recordmode=4)))",array('cn','telephonenumber','guid','recordmode'));
 	   $info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$name[$m] = $info[$m]['cn'][0]; $guid[$m] = $info[$m]['guid'][0];
				$telephone[$m] = $info[$m]['telephonenumber'][0]; $recordmode[$m] = $info[$m]['recordmode'][0];
			}

if (isset($name) && count($name) >0) {			
			foreach($name as $k => $v) {

       		$sr = ldap_list($ds,"cn=$v, cn=Users","(&(objectclass=voicemailcontact)(type=5))",array('telephonenumber','type','method'));
       		$info = ldap_get_entries($ds, $sr);
       		if ($info['count']>"0") {
       			for ($n=0; $n<$info['count']; $n++) {
	       			$color = ""; $status = "OK";
	       			$vmtele = $info[$n]['telephonenumber'][0];
	       			$vmtype = $info[$n]['type'][0]; $vmmethod = $info[$n]['method'][0];

				if ($vmtype=="5" && $vmmethod!="6") { $color = "YELLOW"; $status = "Archive Enabled - Deliver & Delete Not Set"; };
				if ($info['count']>1) { $color = "#BC65FF"; $status = "Recording Enabled - Multiple Archive Entries"; };
				}
   			} else {
	   			$color = "#A9F6FF"; $status = "Recording Enabled - Archive Not Set";
   			}
			echo "<tr class='even_gradeX' id='user:{$guid[$k]}' style='background-color:{$color}; text-align: left;'><td class='read_only'><a href='../manager.cgi?pagename=user&index={$guid[$k]}&tab=7' target='_blank'>{$name[$k]}</a></td><td class='read_only'>{$telephone[$k]}</td><td class='read_only'>{$mode[$recordmode[$k]]}</td><td class='read_only'>$status</td></tr>";
			}
		}			
		echo "</table>";
	}


if ($_REQUEST['action'] =='2') {
	echo "<h3>Departments</h3>";
	echo "This script will show which departments have recording enabled and if there are any potential issues.<br/><br/>";
	echo "<fieldset style='border: 1px solid #A0A0A0; background: #CCCCCC; width:50%' ><legend><b>Key :</b></legend>";
	echo "<a href='#' class='tooltip' title='It Is Strongly Recommended That The Method Is Set As &#39Deliver And Delete&#39 As This Minimizes The Hard Disc Space Consumed By Call Recording.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:YELLOW'>Yellow - Voicemail contact with type Archive configured. Method Deliver & Delete not set.</span><br/>";
	echo "<a href='#' class='tooltip' title='Archive Enables An External Application To Collect Call Recordings.<Br/>It Is Strongly Recommended That The Method Is Set As &#39Deliver And Delete&#39 As This Minimizes The Hard Disc Space Consumed By Call Recording.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:#A9F6FF'>Cyan - Recording is enabled however a voicemail contact with Archive is not set.</span><br/>";
	echo "<a href='#' class='tooltip' title='It Is Advised To Set Only One Voicemail Contact With The Type Archive. Multiple Could Entries Cause Delivery Issues.'><img src='images/tooltip.gif'></a>&nbsp;<span style='font-weight:bold;color:#BC65FF'>Violet - Recording is enabled however multiple voicemail contacts with Archive are set.</span></fieldset><br/><br/>";

	echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='25%'>Name</th><th>Extension</th><th>Record Mode</th><th>Status</th></tr></thead>
		<tfoot><tr><th>Name</th><th>Extension</th><th>Record Mode</th><th>Status</th></tr></tfoot><tbody>";

		$sr = ldap_list($ds,"cn=Departments","(&(objectclass=department)(!(recordmode=0))(!(recordmode=4)))",array('cn','telephonenumber','guid','recordmode'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$name[$m] = $info[$m]['cn'][0]; $guid[$m] = $info[$m]['guid'][0];
				$telephone[$m] = $info[$m]['telephonenumber'][0]; $recordmode[$m] = $info[$m]['recordmode'][0];
			}

if (isset($name) && count($name) >0) {						
			foreach($name as $k => $v) {

       		$sr = ldap_list($ds,"cn=$v, cn=Departments","(&(objectclass=voicemailcontact)(type=5))",array('telephonenumber','type','method'));
       		$info = ldap_get_entries($ds, $sr);
       		if ($info['count']>"0") {
       			for ($n=0; $n<$info['count']; $n++) {
	       			$color = ""; $status = "OK";
	       			$vmtele = $info[$n]['telephonenumber'][0];
	       			$vmtype = $info[$n]['type'][0]; $vmmethod = $info[$n]['method'][0];

				if ($vmtype=="5" && $vmmethod!="6") { $color = "YELLOW"; $status = "Archive Enabled - Deliver & Delete Not Set"; };
				if ($info['count']>1) { $color = "#BC65FF"; $status = "Recording Enabled - Multiple Archive Entries"; };
				}
   			} else {
	   			$color = "#A9F6FF"; $status = "Recording Enabled - Archive Not Set";
   			}
			echo "<tr class='even_gradeX' id='dept:{$guid[$k]}' style='background-color:{$color}; text-align: left;'><td class='read_only'><a href='../manager.cgi?pagename=dept&index={$guid[$k]}&tab=3' target='_blank'>{$name[$k]}</a></td><td class='read_only'>{$telephone[$k]}</td><td class='read_only'>{$mode[$recordmode[$k]]}</td><td class='read_only'>$status</td></tr>";
			}
		}
			echo "</table>";
}


if ($_REQUEST['action'] =='3') {
		echo "<h3>DialPlans</h3>";
		echo "This script will show which DialPlans have recording configured in a DialPlan entry.<br/><br/>";

		$sr = ldap_list($ds,"cn=dialplans","(objectclass=dialplan)",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$name[$m] = $info[$m]['cn'][0]; $guid[$m] = $info[$m]['guid'][0];
			}

		$actions = array('','Dial','Busy','Dial Number Unavailable','Page','Dial Emergency','Dial Auto Answer','Dial Force Call Waiting','Out Of Office Enable','Out Of Office Disable','Forward On Busy Enable','Forward On Busy Disable','Forward On Busy Toggle','Forward On Busy Set','Forward On No Answer Enable','Forward On No Answer Disable','Forward On No Answer Toggle','Forward On No Answer Set','FollowMe Enable','FollowMe Disable','FollowMe Toggle','Follow Me Set','Cancel All Forwarding','Do Not Disturb Enable','Do Not Disturb Disable','Do Not Disturb Toggle','Do Not Disturb Exception Add','Do Not Disturb Exception Remove','Do Not Disturb Exception Remove All','Call Waiting Enable','Call Waiting Disable','Call Waiting Phone Tools','Voicemail Enable','Voicemail Disable','Voicemail Retrieve','Voicemail Add Call Me','Voicemail Remove Call Me','Voicemail Remove All Call Me','Night Service In Hours','Night Service Out Of Hours','Night Service Timed','','Park','Pickup','Login','Logout','Relay Open','Relay Pulse','Relay Close','Set Event','Dial Trunk','Set Mobile Number','Set Home Number','Set Spare1 Number','Set Spare2 Number','Follow Me All','Follow Me Both Personal','Follow Me Both All','Dial Recall','Dial Account','Dial Auto Conference','Dial Record','Dial Priority','Dial Hash','Dial Transparent','Dial Auto Listen','Conference','Voicemail Greeting','Voicemail Greeting Permanent','Dial Force Call Waiting and Recall','Time Plan Enable','Time Plan Disable','Time Plan Timed','Malicious Call Trace','Ring Back When Free','Out Of Office Lunch','Out Of Office Holiday','Out Of Office OffSite');
		$sr = ldap_list($ds,"cn=leastcostcallplans","(objectclass=leastcostcallplan)",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$lcrplans[$info[$m]['guid'][0]] = $info[$m]['cn'][0];
			}

		echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='25%'>DialPlan</th><th>Number Match</th><th>Action</th><th>Translate To</th><th>LCRPLan</th></tr></thead>
		<tfoot><tr><th width='25%'>DialPlan</th><th>Number Match</th><th>Action</th><th>Translate To</th><th>LCRPLan</th></tr></tfoot><tbody>";

		foreach ($name as $k => $v) {

		$sr = ldap_list($ds,"cn=$v, cn=dialplans","(objectclass=dpentry)",array('numbermatch','action','translateto','leastcostcallplan','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$numbermatch = $info[$m]['numbermatch'][0]; $action = $info[$m]['action'][0];
				$translateto = $info[$m]['translateto'][0]; $lcr = $info[$m]['leastcostcallplan'][0]; $guid = $info[$m]['guid'][0];

			if ($action=="61") echo "<tr class='even_gradeX' id='dplan:{$guid}' style='text-align: left;'><td class='read_only'><a href='../manager.cgi?pagename=dialplanentry&index={$guid}' target='_blank'>{$name[$k]}</a></td><td class='read_only'>{$numbermatch}</td><td class='read_only'>{$actions[$action]}</td><td class='read_only'>{$translateto}</td><td class='read_only'>{$lcrplans[$lcr]}</td></tr>";
			}
		}
		echo "</table>";
}


if ($_REQUEST['action'] =='4') {
		echo "<h3>LCRPlans</h3>";
		echo "This script will show which LCRPlan have recording configured in a LCRPlan entry.<br/><br/>";

		$actions = array('','Dial','Busy','Dial Number Unavailable','Page','Dial Emergency','Dial Auto Answer','Dial Force Call Waiting','Out Of Office Enable','Out Of Office Disable','Forward On Busy Enable','Forward On Busy Disable','Forward On Busy Toggle','Forward On Busy Set','Forward On No Answer Enable','Forward On No Answer Disable','Forward On No Answer Toggle','Forward On No Answer Set','FollowMe Enable','FollowMe Disable','FollowMe Toggle','Follow Me Set','Cancel All Forwarding','Do Not Disturb Enable','Do Not Disturb Disable','Do Not Disturb Toggle','Do Not Disturb Exception Add','Do Not Disturb Exception Remove','Do Not Disturb Exception Remove All','Call Waiting Enable','Call Waiting Disable','Call Waiting Phone Tools','Voicemail Enable','Voicemail Disable','Voicemail Retrieve','Voicemail Add Call Me','Voicemail Remove Call Me','Voicemail Remove All Call Me','Night Service In Hours','Night Service Out Of Hours','Night Service Timed','','Park','Pickup','Login','Logout','Relay Open','Relay Pulse','Relay Close','Set Event','Dial Trunk','Set Mobile Number','Set Home Number','Set Spare1 Number','Set Spare2 Number','Follow Me All','Follow Me Both Personal','Follow Me Both All','Dial Recall','Dial Account','Dial Auto Conference','Dial Record','Dial Priority','Dial Hash','Dial Transparent','Dial Auto Listen','Conference','Voicemail Greeting','Voicemail Greeting Permanent','Dial Force Call Waiting and Recall','Time Plan Enable','Time Plan Disable','Time Plan Timed','Malicious Call Trace','Ring Back When Free','Out Of Office Lunch','Out Of Office Holiday','Out Of Office OffSite');
		$sr = ldap_list($ds,"cn=leastcostcallplans","(objectclass=leastcostcallplan)",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$name[$m] = $info[$m]['cn'][0]; $guid[$m] = $info[$m]['guid'][0];
			}

		$sr = ldap_list($ds,"cn=trunkgroups","(objectclass=trunkgroup)",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$trunkgroups[$info[$m]['guid'][0]] = $info[$m]['cn'][0];
			}

		echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='25%'>LCRPlan</th><th>Number Match</th><th>ActionPrimary</th><th>DialPrimary</th><th>TrunkGroup</th><th>ActionSecondary</th><th>DialSecondary</th><th>TrunkGroup</th></tr></thead>
		<tfoot><tr><th width='25%'>LCRPlan</th><th>Number Match</th><th>ActionPrimary</th><th>DialPrimary</th><th>TrunkGroup</th><th>ActionSecondary</th><th>DialSecondary</th><th>TrunkGroup</th></tr></tfoot><tbody>";

		foreach ($name as $k => $v) {
		$sr = ldap_list($ds,"cn=$v, cn=leastcostcallplans","(objectclass=lcrentry)",array('numbermatch','actionprimary','dialprimary','trunkgroupprimary','actionsecondary','dialsecondary','trunkgroupsecondary','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$numbermatch = $info[$m]['numbermatch'][0];  $guid = $info[$m]['guid'][0];
				$actionprimary = $info[$m]['actionprimary'][0]; $actionsecondary = $info[$m]['actionsecondary'][0];
				$dialprimary = $info[$m]['dialprimary'][0]; $dialsecondary = $info[$m]['dialsecondary'][0];
				$trunkgroupprimary = $info[$m]['trunkgroupprimary'][0]; $trunkgroupsecondary = $info[$m]['trunkgroupsecondary'][0];


			if ($actionprimary=="61" || $actionsecondary =="61")
			echo "<tr class='even_gradeX' id='dplan:{$guid}' style='text-align: left;'><td class='read_only'><a href='../manager.cgi?pagename=lcrplanentry&index={$guid}' target='_blank'>{$name[$k]}</a></td><td class='read_only'>{$numbermatch}</td><td class='read_only'>{$actions[$actionprimary]}</td><td class='read_only'>{$dialprimary}</td><td class='read_only'>{$trunkgroups[$trunkgroupprimary]}</td>
			<td class='read_only'>{$actions[$actionsecondary]}</td><td class='read_only'>{$dialsecondary}</td><td class='read_only'>{$trunkgroups[$trunkgroupsecondary]}</td></tr>";
			}
		}
		echo "</table>";
	}


if ($_REQUEST['action'] =='5') {
		echo "<h3>DDIPlans</h3>";
		echo "This script will show which DDIPlan have recording configured in a DDIPlan entry.<br/><br/>";

		$bearer = array('','Voice','Data','Video');
		$sr = ldap_list($ds,"cn=ddicallplans","(objectclass=ddicallplan)",array('cn','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$name[$m] = $info[$m]['cn'][0]; $guid[$m] = $info[$m]['guid'][0];
			}

		echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='10%'>DDIPlan</th><th>ID</th><th>Number Match</th><th>TranslateTo</th><th>Bearer</th><th>Description</th></tr></thead>
		<tfoot><tr><th width='10%'>DDIPlan</th><th>ID</th><th>Number Match</th><th>TranslateTo</th><th>Bearer</th><th>Description</th></tr></tfoot><tbody>";

		foreach ($name as $k => $v) {
		$sr = ldap_list($ds,"cn=$v, cn=ddicallplans","(objectclass=ddientry)",array('numbermatch','id','translateto','bc','description','guid'));
 	   	$info = ldap_get_entries($ds, $sr);
       		for ($m=0; $m<$info['count']; $m++) {
				$numbermatch = $info[$m]['numbermatch'][0]; $guid = $info[$m]['guid'][0]; $id = $info[$m]['id'][0];
				$translateto = $info[$m]['translateto'][0]; $bc = $info[$m]['bc'][0]; $description = $info[$m]['description'][0];

			if (strpos($translateto,'=') !== false)
			echo "<tr class='even_gradeX' id='dplan:{$guid}' style='text-align: left;'><td class='read_only'>{$name[$k]}</td><td class='read_only'><a href='../manager.cgi?pagename=directdialplanentry&index={$guid}' target='_blank'>{$id}</a></td><td class='read_only'>{$numbermatch}</td><td class='read_only'>{$translateto}</td><td class='read_only'>{$bearer[$bc]}</td><td class='read_only'>{$description}</td></tr>";

				}
		}
		echo "</table>";
	}

}
?>
</div></div>
</body>
</html>

<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
            <h1>Warning</h1>
            <p><span style="color:#605F61; font-weight:bold;">No Vision Server has been detected.</span><br/><br/>
           	If you are Call Recording without using Vision, you must ensure to manage the recordings on your CallServer / S8000.<br/><br/>
            Failure to do so could result in the hard disc space being consumed by the call recordings.</p>
           </p>
</div>