<?php
session_start();

// MATT PHP5+ detection added
// v3.03
// PJC 23APR2019 Update external server used for IP Address lookup
// PJC 19DEC2018 Added support for DNS Srv, Registration Contact, Registration Domain
// PJC 10JUN2016 Add Emergency Numbers to LCRPlan
// PJC 10JUN2016 Add tIPicall Notice
// PJC 02JUN2016 Add SIP NAT IP Address Check
// PJC 15FEB2016 Remove hello
// PJC 29DEC2015 Added ptime field, set ptime to 20ms if DNS/IP contains gamma/88.215, remove description validation, add presentationnumber validation
// PJC 18-JUN-2015 SIP Wizard Warning
// PJC 10-APR-2015 Add warning for compression type - new alert
// PJC 11-Dec-2014 Fix issue with Additional DialPlan entries
// PJC 11-Dec-2014 Fix issue with SIP Compression summary
// PJC 30-OCT-2014 Check DP entries - update additional matches '9','141','9112','112','999','12809','1280141','1280112'
// Change to goo.gl for short faster URL
// PJC 13-Oct-2014 - Link to SIP Config
// PJC 16-May-2014 - NSG support
// PJC sip dialplan blank reporting wrong value on summary page
//PJC 16Jan2013

$page_id = "074";
include ".access.php";
include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
    echo "LDAP connect failure<br>";
} else {
    $r = @ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
	    echo "LDAP bind failure<br>";
		$ds = false;
	}
}
$step = $sip_rtp_ports = NULL;
if (isset($_REQUEST['step'])) {
	$step = $_REQUEST['step'];
	$cmd = "cat /proc/version";
	exec($cmd,$a); $a=$a[0];
	$sip_rtp_ports = (preg_match('~\b(suse|centos)\b~i',$a)) ? "6900 - 7859" : "6300 - 6699";
}

// Find Self
    $sr = ldap_read($ds,"cn=self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr);
    $sr = ldap_search($ds,"cn=Modules","(&(objectclass=*)(guid=".$info[0]['location'][0]."))"); $info = ldap_get_entries($ds,$sr);
	$cn=$info[0]['cn'][0];
	$dn=$info[0]['dn'];
	$selfGUID = $info[0]['guid'][0];
		
	$_SESSION['sip_self'] = (substr(phpversion(),0,1)>="5") ? "00000000-0000-0000-0000-000000000000" : $selfGUID;
	$_SESSION['sip_wan'] = (@file_get_contents("https://splicepbx.uk/ip.php")) ? @file_get_contents("https://splicepbx.uk/ip.php") : "";
	$q="??????????";

foreach($_REQUEST as $RequestKey=>$RequestValue) {
   $_SESSION[$RequestKey] = $_REQUEST["$RequestKey"];
   
   $_SESSION['sip_nat_server'] = (isset($_SESSION['sipnatserver']) && strlen($_SESSION['sipnatserver'])!=0)  ? $_SESSION['sipnatserver'] : $_SESSION['sip_nat_server'];
   $_SESSION['sip_RegContact'] = (isset($_SESSION['sip_RegContact']) && strlen($_SESSION['sip_RegContact'])!=0)  ? $_SESSION['sip_RegContact'] : NULL;
   $_SESSION['sip_RegDomain'] = (isset($_SESSION['sip_RegDomain']) && strlen($_SESSION['sip_RegDomain'])!=0) ? $_SESSION['sip_RegDomain'] : NULL;
   $_SESSION['sip_dialplan_blank'] = (isset($_SESSION['sip_dialplan_blank']) && strlen($_SESSION['sip_dialplan_blank'])!=0) ? $_SESSION['sip_dialplan_blank'] : NULL;
   $_SESSION['sip_dialplan_additional'] = (isset($_SESSION['sip_dialplan_additional']) && strlen($_SESSION['sip_dialplan_additional'])!=0) ? $_SESSION['sip_dialplan_additional'] : NULL;
   $_SESSION['sip_dialplan_blank'] = (isset($_SESSION['sip_dialplan_blank']) && strlen($_SESSION['sip_dialplan_blank'])!=0) ? $_SESSION['sip_dialplan_blank'] : NULL;
   $_SESSION['sip_dialplan'] = (isset($_SESSION['sip_dialplan']) && strlen($_SESSION['sip_dialplan'])!=0) ? $_SESSION['sip_dialplan'] : NULL;
   $_SESSION['sip_dialplan_name'] = (isset($_SESSION['sip_dialplan_name']) && strlen($_SESSION['sip_dialplan_name'])!=0) ? $_SESSION['sip_dialplan_name'] : NULL;
  }

  
?>
<html>
<head>
<title>SIP Trunks - Guided Wizard</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link rel="stylesheet" type="text/css" href="css/wiz//jquery.validate.css" />
<link rel="stylesheet" type="text/css" href="css/Styles.css" />
<link href="log/alert.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/wiz/extra.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script src="js/jquery.noty.packaged.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validate.js" type="text/javascript"></script>
<script src="js/wiz/jquery.validation.functions.js" type="text/javascript"></script>
<script language="javascript">
$(document).ready(function() {
	
	function alert(type, layout, text) {
        var n = noty({
            type: type, layout: layout, text: text, dismissQueue: true, theme: 'relax', modal: true,
        });
   	}	
	
	
		var step = "<?php echo $step ?>";
		
		if (step == "2"){
			sip_dnsip = "<?php if (isset($_SESSION['sip_dnsip'])) echo $_SESSION['sip_dnsip'] ?>";
			if (/gamma|88.215/i.test(sip_dnsip)) {
				$("#sip_ptime").val("20");
			}
		}
		
		if (step == "4") {
			$('#overlay').fadeIn('fast',function(){
				$('#sip_dnsip_address').html( "<?php if (isset($_SESSION['sip_dnsip'])) echo $_SESSION['sip_dnsip'] ?>" );
				$('#sip_port').html( "<?php if (isset($_SESSION['sip_source'])) echo $_SESSION['sip_source'] ?>" );
				$('#sip_rtp').html( "<?php echo $sip_rtp_ports ?>" );
				$('#alert').animate({'top':'100px'},500);
			});
		}

        $('#alertclose').click(function(){
			$.ajax({ url : 'log/reset.php?sipports_no=1' });
           	$('#alert').animate({'top':'-600px'},500,function(){
            $('#overlay').fadeOut('fast');
            document.location.href='assist.php';
        	});
        });

        $('#alertOK').click(function(){
	    	$.ajax({ url : 'log/reset.php?sipports=1' });
        	$('#alert').animate({'top':'-600px'},500,function(){
        	$('#overlay').fadeOut('fast');
           	});
        });

$('#sip_nat_mode').change(function(){
    if($(this).val()=="0"){
		$(function() {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" size="30" value="None">');
			$("#sip_nat_port").val("0"); $('#sipnatserver').hide().val('');
            $("#sip_nat_server").attr("disabled", "disabled");  $("#sip_nat_port").attr("disabled", "disabled");
      });
    }
    if($(this).val()=="1"){
		$(function() {
			$('#sip_nat_server').replaceWith('<input name="sip_nat_server" id="sip_nat_server" size="30" value="<?php echo $_SESSION['sip_wan']; ?>">');
			$("#sip_nat_port").val("5060"); $('#sipnatserver').hide().val('');
            $("#sip_nat_server").removeAttr("disabled"); $("#sip_nat_port").removeAttr("disabled");
      });
    }
    if($(this).val()=="2"){
		$(function() {
		    $('#sip_nat_server').replaceWith('<select name="sip_nat_server" id="sip_nat_server" style="width:219px"><option value="stunserver.org">stunserver.org</option><option value="stun.l.google.com">stun.l.google.com</option><option value="stun.sipgate.net">stun.sipgate.net</option><option value="stun.stunprotocol.org">stun.stunprotocol.org</option><option value="other">Other...</option></select>');
		    $("#sip_nat_port").val("3478");
		    $("#sip_nat_server").removeAttr("disabled"); $("#sip_nat_port").removeAttr("disabled");
      });
    }
});

	$('#sip_comp').on('change', function() {
		if($(this).val()=="0"){
			alert('warning', 'center', '<b>Compression Type: None</b><br/><br/>The only time you should use this compression type on a trunk, is if the trunk is going to connect to a device on the same network or LAN<br/>');
		}
	});
	
	$('#sip_dnsSrv').on('change', function() {
		console.log ('sip_dnsSrv')
		if ($(this).val() == "1") {
			$('#sip_RegContact, #sip_RegDomain').prop('disabled', '');
			$('#sip_dnsip').prop('disabled', 'disabled');
			$('#sipdnssrv').val('1');
		} else {
			$('#sip_RegContact, #sip_RegDomain').prop('disabled', 'disabled');
			$('#sip_dnsip').prop('disabled', '');
			$('#sipdnssrv').val('');
		}
	})
	

	$('#sip_dialplan').on('change', function() {
		$("#sip_dialplan_code").val('').css("background-color", "#FFFFFF");
		sel = $('#sip_dialplan option:selected').text()
		$.ajax({ url : 'log/reset.php?sipw=' + sel })
			.done(function(data) { 
			dp_array = data.split(';');
	  	});
	});
	
	$("#sip_dialplan_code").on('blur', function(){
      shortcode = $(this).val();
           if(jQuery.inArray(shortcode, dp_array)!==-1) {
	        	$("#sip_dialplan_code").css("background-color", "#FF0000");
        	    $('input[type="submit"]').attr('disabled','disabled');
        	    alert('warning', 'center', '<b>ShortCode:' + shortcode + '</b><br/>Already Exisits in DialPlan:' + sel + '<br/>');
           } else {
	           $("#sip_dialplan_code").css("background-color", "#FFFFFF");
               $('input[type="submit"]').removeAttr('disabled');
           }
    });


	$('form').on('change', 'select[name="sip_nat_server"]', function (event) {
		if($(this).val()=="stun.l.google.com") {
				$(function() { $('#sip_nat_port').val('19203'); }); $('#sipnatserver').hide().val('');
		}
		else if($(this).val()=="stun.sipgate.net") {
				$(function() { $('#sip_nat_port').val('10000'); }); $('#sipnatserver').hide().val('');
		}
		else if($(this).val()=="other") {
				$('#sipnatserver').show(); $("#sip_nat_port").val("3478");
		}
		else {
				$(function() { $('#sip_nat_port').val('3478');  });	$('#sipnatserver').hide().val('');
			}
		});
	
	$('input[id="sip_nat_server"]').focusout(function () {
			var sip_nat = $(this).val();
			var sip_nat_octets = sip_nat.split('.');
			var sip_first_octet = sip_nat_octets[0];
			if (sip_first_octet == "10" || sip_first_octet == "172" || sip_first_octet == "192") {
				alert('error', 'center', '<b>SIP NAT Server</b><br/>The IP Address entered appears to be a Local Network IP Address.<br/>Please confirn this is correct.<br/>');
			}
	});			
	
	$("#sip_dnsip").blur(function() {
		if ($('#sip_dnsip').val() == "91.146.112.10" || $('#sip_dnsip').val() == "91.146.114.10") {
				alert('warning', 'center', '<b>Please Note:</b><br/>tIPicall require the SIP Presentation Number field to be populated<br/>with a valid CLI from your tIPicall trunk.<br/><br/>Failure to do this may result in you being unable to make calls via this trunk.');
			}
	});
	
	$("#sip_noemerg_lcrplan").click( function(){
		if( $(this).is(':checked') ) alert('error', 'center', '<b>Emergency Services</b><br/>Removing these entries may result in you not being able to call emergency services.<br/>');
	});
	
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script;?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_sipwizard.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='images/wizards.png' style="vertical-align:middle;">&nbsp;SIP Trunks - Guided Wizard</h2>
This script will guide you through the basic configuration of a SIP Trunk.<br/>
Once completed you will have a new SIP module, Virtual SIP Trunk and LCR Plan.<br/><br/>
<!-- Start Step One -->
<?php if (!isset($_REQUEST['step'])) { ?>
<h3>SIP Module</h3>
<form id="form1" method="post" action="<?php echo $script ?>">
<div class='block'><label><b>Module / Trunk Name:</b></label><input type="text" name="sip_name" id="sip_name" size="30" maxlength="16" onkeyup="sip(this.value)" autocomplete="off" tabindex='1'/><a href='#' class="tooltip" title="The Name To Be Applied To The New Sip Module And Trunk. max 16 chars"><img src="images/tooltip.gif"></a>&nbsp;<span id="txtHint"></span></div>
<div class='block'><label><b>Module / Trunk Description:</b></label><input type="text" name="sip_desc" id="sip_desc" size="30" maxlength="64" autocomplete="off" tabindex='2'/><a href='#' class="tooltip" title="The Description To Be Applied To The New Sip Module And Trunk. max 64 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Authentication Type:</b></label><select name="sip_type" id="sip_type" tabindex='3'><option value="0"></option><option value="1">Username & Password</option><option value="2" selected="selected">IP Authentication</option></select><a href='#' class="tooltip" title="Authentication Method Required For SIP Registration"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>DNS SRV:</b></label><select name="sip_dnsSrv" id="sip_dnsSrv" tabindex='4'><option value="0"></option><option value="1">Enabled</option></select><a href='#' class="tooltip" title="SIP DNS SRV. Used By BT SIP"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>DNS/IP Address:</b></label><input type="text" name="sip_dnsip" id="sip_dnsip" size="30" maxlength="64"/ tabindex='4'><a href='#' class="tooltip" title="Your SIP Providers Registration Gateway DNS / IP Address. max 64 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>CallServer:</b></label><select name="sip_cs" id="sip_cs" tabindex='5'>
<option value="0"></option>
<?php
    $dn = "cn=Modules";
	$filter="(&(objectclass=module)(|(|(|(|(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=19)))))))";
	$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {
		$cn = $info[$m]['cn'][0]; $guid = $info[$m]['guid'][0];
		$selected = ($_SESSION['sip_self']==$guid) ? "selected=selected":"";
		echo "<option value='$guid' $selected >$cn</option>";
		}
?>
</select><a href='#' class="tooltip" title="Select The CallServer To Which This SIP Gateway Is To Be Registered"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>Trunk Capacity:</b></label><input type="text" name="sip_caps" id="sip_caps" size="30" maxlength="3" tabindex='6'/><a href='#' class="tooltip" title="SIP Trunk Capacity - Number Of Channels. max 3 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Presentation Number:</b></label><input type="text" name="sip_pres" id="sip_pres" size="30" maxlength="16" tabindex='7'/><a href='#' class="tooltip" title="Outbound SIP Presentation Number. max 16 chars"><img src="images/tooltip.gif"></a></div><br/>
<input type="hidden" name="step" value="2" /><input type="hidden" name="sipdnssrv" id="sipdnssrv" value="" /><input type="submit" value="Next Page" id="submit"/></form>
Page (1/5)
<!-- End Step One -->
<?php } elseif (isset($_SESSION['step']) && $_SESSION['step'] == "2") { ?> <!-- Start Step Two -->
<h3>SIP Trunk Configuration</h3>
<form id="form1" method="post" action="<?php echo $script ?>">
<?php

if ($_SESSION['sip_type'] == "1") {
?>
<div class='block'><label><b>Registrar DNS/IP Address:</b></label><input type="text" name="sip_dnsip_user" id="sip_dnsip_user" size="30" value="<?php echo $_SESSION['sip_dnsip_user'] ?>" maxlength="64" tabindex='1'/><a href='#' class="tooltip" title="Your SIP Providers Registrar Gateway DNS / IP Address. max 64 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Registration User Name:</b></label><input type="text" name="sip_username" id="sip_username" size="30" maxlength="64" tabindex='2'/><a href='#' class="tooltip" title="Your SIP Username. Provided By The SIP Carrier. max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Registration Password:</b></label><input type="text" name="sip_password" id="sip_password" size="30" maxlength="64" tabindex='3'/><a href='#' class="tooltip" title="Your SIP Password. Provided By The SIP Carrier. max 16 chars"><img src="images/tooltip.gif"></a></div><br/>
<?php 
	} 
	$sipdnssrv = (isset($_SESSION['sipdnssrv']) && $_SESSION['sipdnssrv'] == '1') ? '' : 'disabled';
?>


<div class='block'><label><b>Registration Contact:</b></label><input type="text" name="sip_RegContact" id="sip_RegContact" size="30" value="" maxlength="64" tabindex='5' <?php echo $sipdnssrv ?>/><a href='#' class="tooltip" title="Registration Contact. Used By BT SIP"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Registration Domain:</b></label><input type="text" name="sip_RegDomain" id="sip_RegDomain" size="30" value="" maxlength="64" tabindex='6' <?php echo $sipdnssrv ?>/><a href='#' class="tooltip" title="Registration Domain. Used By BT SIP"><img src="images/tooltip.gif"></a></div><br/>

<div class='block'><label><b>Packet Time (ptime):</b></label><select name="sip_ptime" id="sip_ptime" tabindex='7'><option value="0">Default</option><option value="30">30ms</option><option value="20">20ms</option><option value="10">10ms</option></select><a href='#' class="tooltip" title="Packet Time (ptime)<br/>The length of time in milliseconds represented by the media in a packet."><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>SIP Source Port:</b></label><input type="text" name="sip_source" id="sip_source" size="30" value="5060" maxlength="16" tabindex='8'/><a href='#' class="tooltip" title="SIP Source Port. Default Is 5060. max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Compression Type:</b></label><select name="sip_comp" id="sip_comp" tabindex='9'><option value="0">None</option><option value="11">G729a 8K</option><option value="12" selected="selected">Relay</option></select><a href='#' class="tooltip" title="Compression Type. If Using Compression Select G729A 8K. Relay May Help RTP Packets Go Through A NAT/Firewall. Otherwise Select None."><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>NAT Server:</b></label><input type="text" name="sip_nat_server" id="sip_nat_server" size="30" value="<?php echo $_SESSION['sip_wan'] ?>" maxlength="32" tabindex='10'/><input type="text" name="sipnatserver" id="sipnatserver" style="display: none;" placeholder="other..."/><a href='#' class="tooltip" title="NAT Server. IP Address Provided By Your Adsl Provider. If STUN Select From One Of The Suggested STUN Servers.  Eg: stunserver.org  max 32 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>NAT Port:</b></label><input type="text" name="sip_nat_port" id="sip_nat_port" size="30" value="5060" maxlength="16" tabindex='11'/><a href='#' class="tooltip" title="NAT Port Number. Typically 5060. If STUN Is Being Used Enter STUN Port Number. eg: port 3478  max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>NAT Mode:</b></label><select name="sip_nat_mode" id="sip_nat_mode" tabindex='12'><option value="0">None</option><option value="1" <?php echo (strlen($_SESSION['sip_wan'])>1) ? "selected=selected" : ""?> >Static</option><option value="2">STUN</option></select><a href='#' class="tooltip" title="NAT Mode<br/>Static - Use IP Address Entered Above<br/>None - Don't Use NAT<br/>STUN - Select STUN Server Above. "><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>Receive On Port:</b></label><input type="text" name="sip_rec_port" id="sip_rec_port" size="30" value="5060" maxlength="16" tabindex='13'/><a href='#' class="tooltip" title="SIP Receive On Port. Default Is 5060. max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>CallServer:</b></label><select name="sip_cs_trunk" id="sip_cs_trunk" tabindex='14'>
<option value="0"></option>
<?php
    $dn = "cn=Modules";
	$filter="(&(objectclass=module)(|(|(|(|(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=19)))))))";
	$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {
		$cn = $info[$m]['cn'][0];$guid = $info[$m]['guid'][0];
		$selected = ($_SESSION['sip_cs']==$guid) ? "selected=selected":"";
		echo "<option value='$guid' $selected>$cn</option>";
		}
?>
</select><a href='#' class="tooltip" title="Select The Callserver To Which This SIP Trunk Is To Be Registered"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>DDIPlan:</b></label><select name="sip_ddiplan" id="sip_ddiplan" tabindex='11'>
<option value=""></option>
<?php
    $dn = "cn=ddicallplans";
	$filter="(objectclass=ddicallplan)";
	$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {
		$cn = $info[$m]['cn'][0];$guid = $info[$m]['guid'][0];
		$selected = ($cn=="Standard") ? "selected=selected":"";
		echo "<option value='$guid' $selected>$cn</option>";
		}
?>
</select><a href='#' class="tooltip" title="DDIPlan To Be Assigned To This SIP Trunk"><img src="images/tooltip.gif"></a></div>
<input type="hidden" name="step" value="3" /><input type="submit" value="Next Page" /></form>
Page (2/5)
<!-- End Step Two -->
<?php } elseif (isset($_SESSION['step']) && $_SESSION['step'] == "3") { ?> <!-- Start Step Three -->
<h3>Trunk Group and LCRPlan</h3>
<form name="form1" id="form1" method="post" action="<?php echo $script ?>">
<div class='block'><label><b>New Trunk Group Name:</b></label><input type="text" name="sip_trunkgrp" id="sip_trunkgrp" size="30" maxlength="16" value="TrunkGroup<?php echo preg_replace('/\s+/', '', $_SESSION['sip_name']) ?>" tabindex='1'/><a href='#' class="tooltip" title="New Trunk Group For Your SIP Trunk. max 16 chars"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>New LCR Plan Name:</b></label><input type="text" name="sip_lcrplan" id="sip_lcrplan" size="30" maxlength="16" value="LCRPlan<?php echo preg_replace('/\s+/', '', $_SESSION['sip_name']) ?>" tabindex='2'/><a href='#' class="tooltip" title="New LCR Plan To Use The Trunk Group And SIP Trunk. max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Add Default LCR Plan Entry:</b></label><select name="sip_lcr_default" id="sip_lcr_default" tabindex='3'><option selected value="1">Yes</option><option value="2">No</option></select><a href='#' class="tooltip" title="This Will Create A Default LCRPlan Entry That Will Match 10 Or More Digits"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Add Local Number Matches:</b></label><input type="checkbox" name="sip_local" id="sip_local" value="local" tabindex='4'><a href='#' class="tooltip" title="Create LCRPlan Matches For Local Numbers. Your STD Code Will Be Prefixed To The Number You Call"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>Local STD Code:</b></label><input type="text" name="sip_lcrstd" id="sip_lcrstd" size="30" disabled="disabled" maxlength="16" tabindex='5'/><a href='#' class="tooltip" title="Enter Your Local STD Code. EG: 01923. max 16 chars"><img src="images/tooltip.gif"></a></div>
<div class='block'><br/><table border="1" id="tbllcrplan">
  <tr>
    <th colspan="1"  align="center">Local numbers start with <a href='#' class="tooltip" title="What Digits Do Local Number Start With. EG: 2 (282200)"><img src="images/tooltip.gif"></a></th>
    <th colspan="1"  align="center">Local numbers are x digits <a href='#' class="tooltip" title="Number Of Digits For Local Numbers. EG: 6 (282200)"><img src="images/tooltip.gif"></a></th>
  </tr>
  <tr>
    <td>
    <select name="local[]" id="local" disabled="disabled">
    <option  value=""></option>
	<option  value="1">1</option>
	<option  value="2">2</option>
	<option  value="3">3</option>
	<option  value="4">4</option>
	<option  value="5">5</option>
	<option  value="6">6</option>
	<option  value="7">7</option>
	<option  value="8">8</option>
	<option  value="9">9</option>
	</select>
	</td>
    <td>
    <select name="digits[]" id="digits" disabled="disabled">
    <option  value=""></option>
	<option  value="5">5</option>
	<option  value="6" selected>6</option>
	<option  value="7">7</option>
	<option  value="8">8</option>
    </select>
    </td>
 </tr>
<td colspan="3">
<input type="button" value="Add Row" onclick="SipaddRowToTable();" id="add" disabled="disabled"/>
<input type="button" value="Remove Row" onclick="SipremoveRowFromTable();" id="remove" disabled="disabled"/></td></table></div>

<br/><br/><b>Emergency Services</b><br/>
The following number matches will be added to the LCRPlan to allow calls to emergency serivces: 999, 911, 112, 101
<div class='block'><label><b>Don't add emergency entries:</b></label><input type="checkbox" name="sip_noemerg_lcrplan" id="sip_noemerg_lcrplan" value="noemerg_lcrplan"></div>
<br/><div class='block'><label><b>Add Emergency Entry:</b></label><input type="text" name="sip_emerg_lcrplan" id="sip_emerg_lcrplan" size="10" maxlength="16"/><a href='#' class="tooltip" title="Add A New Entry to the LCPan to allow calls to Emergency Numbers.  max 16 chars"><img src="images/tooltip.gif"></a></div>

<h3>DialPlan</h3>
<div class='block'><label><b>Update DialPlan:</b></label><input type="checkbox" name="sip_update_dialplan" id="sip_update_dialplan" value="update_dialplan"><a href='#' class="tooltip" title="Update Your DialPlan To Use The New LCRPlan"><img src="images/tooltip.gif"></a></div><br/>
<div class='block'><label><b>Select DialPlan:</b></label><select name="sip_dialplan" id="sip_dialplan" disabled="disabled">
<option value="0"></option>
<?php
    $dn = "cn=dialplans";
	$filter="(objectclass=dialplan)";
	$sr=ldap_list($ds, $dn, $filter); $info = ldap_get_entries($ds, $sr);
	for ($m=0; $m<$info['count']; $m++) {
		$cn = $info[$m]['cn'][0];$guid = $info[$m]['guid'][0];
		echo "<option value='$guid'>$cn</option>";
		}
?>
</select><a href='#' class="tooltip" title="Select DialPlan To Be Updated"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Update Blank Number Match:</b></label><select name="sip_dialplan_blank" id="sip_dialplan_blank" disabled="disabled"><option value=""></option><option value="1">Yes</option><option value="2">No</option></select><a href='#' class="tooltip" title="Update The LCRPlan Used By The Blank Number Entry To Use The New SIP LCRPlan"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Update Additional Matches:</b></label><select name="sip_dialplan_additional" id="sip_dialplan_additional" disabled="disabled"><option value="1">Yes</option><option value="2" selected>No</option></select><a href='#' class="tooltip" title="Update The LCRPlan Used By The Following DialPlan Entries To Use The New SIP LCRPlan. 9,141,9112,112,999,12809,1280141,1280112"><img src="images/tooltip.gif"></a></div>
<div class='block'><label><b>Add DialPlan Shortcode:</b></label><input type="text" name="sip_dialplan_code" id="sip_dialplan_code" size="10" disabled="disabled" maxlength="16"/><a href='#' class="tooltip" title="Add A New Shortcode To The DialPlan To Allow Dialling Via The New SIP LCRPlan. EG: *7. max 16 chars"><img src="images/tooltip.gif"></a></div>
<br/><input type="hidden" name="step" value="4" /><input type="submit" value="Next Page" /></form>
Page (3/5)
<!-- End Step Three -->
<?php } elseif (isset($_SESSION['step']) && $_SESSION['step'] == "4") { ?> <!-- Start Step Four -->
<h3>SIP Overview</h3>
<?php
// Module CallServer
if (isset($_SESSION['sip_cs']) && strlen($_SESSION['sip_cs']) >1) {
	$sr = ldap_search($ds,"cn=modules","(&(objectclass=*)(guid=".$_SESSION['sip_cs']."))"); $info = ldap_get_entries($ds,$sr); $_SESSION['sip_cs_name']=$info[0]['cn'][0];
}
// Trunk CallServer
if (isset($_SESSION['sip_cs_trunk']) && strlen($_SESSION['sip_cs_trunk']) >1) {
	$sr = ldap_search($ds,"cn=modules","(&(objectclass=*)(guid=".$_SESSION['sip_cs_trunk']."))"); $info = ldap_get_entries($ds,$sr); $_SESSION['sip_trunk_cs_name']=$info[0]['cn'][0];
}
// DialPlan
if (isset($_SESSION['sip_dialplan']) && strlen($_SESSION['sip_dialplan']) >1) {
	$sr = ldap_search($ds,"cn=dialplans","(&(objectclass=*)(guid=".$_SESSION['sip_dialplan']."))"); $info = ldap_get_entries($ds,$sr); $_SESSION['sip_dialplan_name']=$info[0]['cn'][0];
}
// DDIPlan
if (isset($_SESSION['sip_ddiplan']) && strlen($_SESSION['sip_ddiplan']) >1) {
	$sr = ldap_search($ds,"cn=ddicallplans","(&(objectclass=*)(guid=".$_SESSION['sip_ddiplan']."))"); $info = ldap_get_entries($ds,$sr); $_SESSION['sip_ddiplan_name']=$info[0]['cn'][0];
}
?>
<div class='block'><label><b>SIP Module Name:</b></label><?php echo $_SESSION['sip_name'] ?></div>
<div class='block'><label><b>SIP Module Description:</b></label><?php echo $_SESSION['sip_desc'] ?></div><br/>
<div class='block'><label><b>SIP Trunk Name:</b></label><?php echo $_SESSION['sip_name'] ?></div>
<div class='block'><label><b>SIP Trunk Description:</b></label><?php echo $_SESSION['sip_desc'] ?></div>
<div class='block'><label><b>SIP Trunk Capacity:</b></label><?php echo $_SESSION['sip_caps'] ?></div>
<div class='block'><label><b>SIP Presentation Number:</b></label><?php echo (strlen($_SESSION['sip_pres'])<1) ? "Not Set" : $_SESSION['sip_pres'] ?></div>
<div class='block'><label><b>SIP Authentication:</b></label><?php echo ($_SESSION['sip_type']==1) ? "Username & Password" : "IP Authentication" ?></div>
<div class='block'><label><b>DNS/IP Address :</b></label><?php echo $_SESSION['sip_dnsip'] ?></div><br/>
<?php if ($_SESSION['sip_type']=="1") { ?>
<div class='block'><label><b>Registration DNS/IP Address :</b></label><?php echo $_SESSION['sip_dnsip_user'] ?></div>
<div class='block'><label><b>SIP UserName :</b></label><?php echo $_SESSION['sip_username'] ?></div>
<div class='block'><label><b>SIP Password :</b></label><?php echo $_SESSION['sip_password'] ?></div><br/>
<?php } ?>

<div class='block'><label><b>DNS SRV :</b></label><?php echo ($_SESSION['sip_dnsSrv'] == "0" ) ? "" : "Enabled" ?></div>
<div class='block'><label><b>Registration Contact :</b></label><?php echo $_SESSION['sip_RegContact'] ?></div>
<div class='block'><label><b>Registration Domain :</b></label><?php echo $_SESSION['sip_RegDomain'] ?></div>

<div class='block'><label><b>Packet Time (ptime) :</b></label><?php echo ($_SESSION['sip_ptime'] =="0" ) ? "Default" : $_SESSION['sip_ptime'] ?></div>
<div class='block'><label><b>SIP Source Port :</b></label><?php echo $_SESSION['sip_source'] ?></div>
<div class='block'><label><b>Compression Type :</b></label><?php echo ($_SESSION['sip_comp']=="11") ? "G729a 8K" : ($_SESSION['sip_comp']=="12") ? "Relay" : "None" ?></div>
<div class='block'><label><b>NAT Server :</b></label><?php echo $_SESSION['sip_nat_server'] ?></div>
<div class='block'><label><b>NAT Port :</b></label><?php echo $_SESSION['sip_nat_port'] ?></div>
<div class='block'><label><b>NAT Mode :</b></label><?php echo ($_SESSION['sip_nat_mode'] == 1) ? "Static" : (($_SESSION['sip_nat_mode'] == 2) ? "Stun" : "None");?></div>
<div class='block'><label><b>Receive On Port :</b></label><?php echo $_SESSION['sip_rec_port'] ?></div>
<div class='block'><label><b>SIP Trunk DDIPlan:</b></label><?php echo (strlen($_SESSION['sip_ddiplan'])<1) ? "Not Set" : $_SESSION['sip_ddiplan_name'] ?></div>
<div class='block'><label><b>New Trunk Group :</b></label><?php echo $_SESSION['sip_trunkgrp'] ?></div>
<div class='block'><label><b>New LCRPlan :</b></label><?php echo $_SESSION['sip_lcrplan'] ?></div>
<div class='block'><label><b>Default LCRPlan Entry:</b></label><?php echo ($_SESSION['sip_lcr_default']=="1") ? "Yes" : "No" ?></div>
<?php if (isset($_SESSION['sip_local'])) { ?>
<div class='block'><label><b>Local STD Code :</b></label><?php echo ($_SESSION['sip_lcrstd']) ?></div><br/>
<div class='block'><label><b>&nbsp;</b></label>
<?php
	echo "<table border='1' width='10%'><tr><th>Local Number Match</th></tr>";
	foreach($_SESSION['digits'] as $key => $value) {
	$num_match = $_SESSION['local'][$key].substr($q, 0, $value-1);
	echo "<tr>";
	echo "<td>"; echo $_SESSION['sip_lcrstd']." ".$num_match ."</td>";
	echo "</tr>";
	}
?>
</table></div>
<?php } ?>
<div class='block'><label><b>LCRPlan Emergency Numbers :</b></label><?php echo (!isset($_SESSION['sip_noemerg_lcrplan']) || $_SESSION['sip_noemerg_lcrplan'] == "NULL") ? "999, 911, 112, 102" : "Not Enabled" ?></div>
<div class='block'><label><b>Additional Emergency Number :</b></label><?php echo (isset($_SESSION['sip_emerg_lcrplan']) && strlen($_SESSION['sip_emerg_lcrplan']) >= 1) ? $_SESSION['sip_emerg_lcrplan'] : "" ?></div>

<?php if (isset($_SESSION['sip_update_dialplan'])) { ?>

<br/><div class='block'><label><b>DialPlan :</b></label><?php echo (isset($_SESSION['sip_dialplan_name'])) ? $_SESSION['sip_dialplan_name'] : "Not Set" ?></div>
<div class='block'><label><b>Update Blank Number Match :</b></label><?php echo (isset($_SESSION['sip_dialplan_blank']) && $_SESSION['sip_dialplan_blank']=="1" ) ? "Yes" : "No" ?></div>
<div class='block'><label><b>Update Additional Matches :</b></label><?php echo (isset($_SESSION['sip_dialplan_additional']) && $_SESSION['sip_dialplan_additional']=="1" ) ? "Yes" : "No" ?></div>
<div class='block'><label><b>Add Dial New Prefix :</b></label><?php echo (isset($_SESSION['sip_dialplan_code'])) ? $_SESSION['sip_dialplan_code'] : "No" ?></div><br/>
<?php } ?>
<form name="form1" id="form1" method="post" action="<?php echo $script ?>"><br/>
<input type="hidden" name="step" value="5" /><input type="submit" value="Create Trunk Module" /></form>

<!-- End Step Four -->
<br/>Page (4/5)
<?php } elseif (isset($_SESSION['step']) && $_SESSION['step'] == "5") { ?> <!-- Start Step Five -->
<?php
//Standard TimePlan
$sr = ldap_read($ds,"cn=Standard, cn=timeplans","objectclass=timeplan"); $info = ldap_get_entries($ds,$sr);$_SESSION['std_timeplan']=$info[0]['guid'][0];
//Module
$att=array('objectclass'=>'Module','cn'=>$_SESSION['sip_name'], 'description'=>$_SESSION['sip_desc'],'moduleType'=>'7','ipaddress'=>$_SESSION['sip_dnsip'],'location'=>$_SESSION['sip_cs'],'lastseen'=>time());
ldap_add($ds,"cn=".$_SESSION['sip_name'].",cn=Modules",$att);
//ExternalGatewayModule
$att=array('objectclass'=>'ExternalGatewayModule','cn'=>'1');
ldap_add($ds,"cn=1,cn=".$_SESSION['sip_name'].",cn=Modules",$att);
//Virtual Trunk
$att=array('objectclass'=>'Trunk','cn'=>'Virtual', 'description'=>$_SESSION['sip_desc'],'typeoftrunk'=>'3','port'=>'5060','capacity'=>$_SESSION['sip_caps'], 'presentationnumber'=>$_SESSION['sip_pres']);
ldap_add($ds,"cn=Virtual,cn=".$_SESSION['sip_name'].",cn=Modules",$att);
//SIP Trunk
$att=array('objectclass'=>'siptrunk','sourceport'=>'0','natport'=>'0');
ldap_add($ds,"cn=1,cn=Virtual,cn=".$_SESSION['sip_name'].",cn=Modules",$att);
//Modify Virtual Trunk
$att=array('port'=>$_SESSION['sip_source'],'location'=>$_SESSION['sip_cs'],'ddicallplan'=>$_SESSION['sip_ddiplan']);
ldap_modify($ds,"cn=Virtual,cn=".$_SESSION['sip_name'].",cn=Modules",$att);

//Modify SIP Trunk
$_SESSION['sip_nat_server'] = ($_SESSION['sip_nat_server']=="None") ? "" : $_SESSION['sip_nat_server'];
if ($_SESSION['sip_type'] == "1") {
$att = array('sipregaddress'=>$_SESSION['sip_dnsip_user'],
			 'sipregusername'=>$_SESSION['sip_username'],
			 'sipregpassword'=>$_SESSION['sip_password'],
			 'sourceport'=>$_SESSION['sip_rec_port'],
			 'compressiontype'=>$_SESSION['sip_comp'],
			 'natserver'=>$_SESSION['sip_nat_server'],
			 'natport'=>$_SESSION['sip_nat_port'],
			 'natmode'=>$_SESSION['sip_nat_mode'],
			 'sourceport'=>$_SESSION['sip_rec_port']);
} else {			 
$att =  array('sourceport'=>$_SESSION['sip_rec_port'],
			  'compressiontype'=>$_SESSION['sip_comp'],
			  'natserver'=>$_SESSION['sip_nat_server'],
			  'natport'=>$_SESSION['sip_nat_port'],
			  'natmode'=>$_SESSION['sip_nat_mode'],
			  'sourceport'=>$_SESSION['sip_rec_port'],
			  'ptime'=>$_SESSION['sip_ptime']);
}

$btsip = NULL;
$sr = ldap_list($ds,"cn=Virtual, cn=".$_SESSION['sip_name'].", cn=Modules","(objectclass=*)", array('dnssrv')); 
$info = ldap_get_entries($ds,$sr); 
$btsip = ($info[0]['count'] > 0) ? '1' : NULL;

if ($_SESSION['sip_dnsSrv'] == '1' && $btsip) {
	$att['dnssrv'] = $_SESSION['sip_dnsSrv'];
	$att['sipRegContact'] = $_SESSION['sip_RegContact'];
	$att['sipRegDomain'] = $_SESSION['sip_RegDomain'];
}
	
ldap_modify($ds,"cn=1,cn=Virtual,cn=".$_SESSION['sip_name'].",cn=Modules",$att);

//Trunk Group
$att=array('objectclass'=>'TrunkGroup');
ldap_add($ds,"cn=".$_SESSION['sip_trunkgrp'].",cn=TrunkGroups",$att);
//Find Trunk
$sr = ldap_list($ds,"cn=".$_SESSION['sip_name'].", cn=Modules","objectclass=trunk"); $info = ldap_get_entries($ds,$sr);$_SESSION['trunk_guid']=$info[0]['guid'][0];
//Add Trunk to Trunk Group
$att=array('objectclass'=>'TrunkRef');
ldap_add($ds,"trunk=".$_SESSION['trunk_guid'].",cn=".$_SESSION['sip_trunkgrp'].",cn=TrunkGroups",$att);
//LCR Plan
$att=array('objectclass'=>'leastcostcallplan');
ldap_add($ds,"cn=".$_SESSION['sip_lcrplan'].",cn=LeastCostCallPlans",$att);
//Find Trunk Group Guid
$sr = ldap_list($ds,"cn=TrunkGroups","cn=".$_SESSION['sip_trunkgrp'].""); $info = ldap_get_entries($ds,$sr);$_SESSION['trunk_grp_guid']=$info[0]['guid'][0];
//Add Default 0?????????? entry
if ($_SESSION['sip_lcr_default'] == "1") {
$att=array('objectclass'=>'LCREntry','dialprimary'=>'%n','actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$_SESSION['trunk_grp_guid'],'timeplan'=>$_SESSION['std_timeplan']);
ldap_add($ds,"numbermatch=0?????????,cn=".$_SESSION['sip_lcrplan'].",cn=leastcostcallplans",$att);
}
// Add New LCRPlan Entries
if (isset($_SESSION['sip_local']) && $_SESSION['sip_local'] == "local") {
foreach ($_SESSION['digits'] as $k => $v) {
$num_match = $_SESSION['local'][$k].substr($q, 0, $v-1);
$att=array('objectclass'=>'LCREntry','dialprimary'=>$_SESSION['sip_lcrstd'].'%n','actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$_SESSION['trunk_grp_guid'],'timeplan'=>$_SESSION['std_timeplan']);
ldap_add($ds,"numbermatch=$num_match,cn=".$_SESSION['sip_lcrplan'].",cn=leastcostcallplans",$att);
	}
}


// Add Emergency LCRPlan Entries
if (!isset($_SESSION['sip_noemerg_lcrplan']) || $_SESSION['sip_noemerg_lcrplan'] == "NULL") {
	$emerg_no = array("999", "911", "112", "101");
	foreach ($emerg_no as $emergency) {
		$att=array('objectclass'=>'LCREntry','dialprimary'=>$emergency,'actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$_SESSION['trunk_grp_guid'],'timeplan'=>$_SESSION['std_timeplan']);
		ldap_add($ds,"numbermatch=$emergency,cn=".$_SESSION['sip_lcrplan'].",cn=leastcostcallplans",$att);
	}
}

// Add New Emergency LCRPlan Entry
if (isset($_SESSION['sip_emerg_lcrplan']) && strlen($_SESSION['sip_emerg_lcrplan']) >= 1) {
	$att=array('objectclass'=>'LCREntry','dialprimary'=>$_SESSION['sip_emerg_lcrplan'],'actionprimary'=>'1', 'timeout'=>'1200','trunkgroupprimary'=>$_SESSION['trunk_grp_guid'],'timeplan'=>$_SESSION['std_timeplan']);
	ldap_add($ds,"numbermatch=".$_SESSION['sip_emerg_lcrplan'].",cn=".$_SESSION['sip_lcrplan'].",cn=leastcostcallplans",$att);
}


//Find SIP Module GUID
$sr = ldap_read($ds,"cn=".$_SESSION['sip_name'].",cn=modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $_SESSION['sip_guid']=$info[0]['guid'][0];
//Find LCRPlan GUID
$sr = ldap_read($ds,"cn=".$_SESSION['sip_lcrplan'].",cn=leastcostcallplans","objectclass=*"); $info = ldap_get_entries($ds,$sr); $_SESSION['lcr_guid']=$info[0]['guid'][0];

if ($_SESSION['sip_dialplan_blank'] == "1") {
//Find Blank DialPlan Entry
$sr = ldap_search($ds,"cn=".$_SESSION['sip_dialplan'].",cn=DialPlans","(&(objectclass=dpentry)(numbermatch=))"); $info = ldap_get_entries($ds,$sr); @$_SESSION['dp_guid']=$info[0]['guid'][0];
if (strlen($_SESSION['dp_guid']) > 1) {
//Update Blank DialPlan Entry
$att=array('leastcostcallplan'=>$_SESSION['lcr_guid']);
ldap_modify($ds,"guid=".$_SESSION['dp_guid'].",cn=".$_SESSION['sip_dialplan'].",cn=Dialplans",$att);
	} else {
$dp_error = "No BLANK DialPlan entry to update";
	}
}
//Add Update Additional Entries
if ($_SESSION['sip_dialplan_additional'] == "1") {
$additional=array('9','141','9112','112','999','12809','1280141','1280112');
echo "Updated additional dialplan entries for: <b>".$_SESSION['sip_dialplan_name']."</b><br/>";
$sr = ldap_search($ds,"cn=".$_SESSION['sip_dialplan'].",cn=DialPlans","(objectclass=dpentry)",array('numbermatch')); $info = ldap_get_entries($ds,$sr);
for ($m=0; $m<$info['count']; $m++) {
		if (in_array($info[$m]['numbermatch'][0],$additional)) {
			$adn = $info[$m]['dn']; $att=array('leastcostcallplan'=>$_SESSION['lcr_guid']);
				echo "matches found:". $info[$m]['numbermatch'][0]."<br/>";
			ldap_modify($ds,$adn,$att);
			} else {
				echo "No number matches found.<br/>";
			}
		}
}


if ($_SESSION['sip_dialplan_blank'] == "2" && strlen($_SESSION['sip_dialplan_code']) >0){
//Add New DialPlan Entry
$att=array('leastcostcallplan'=>$_SESSION['lcr_guid'],'timeplan'=>$_SESSION['std_timeplan'],'numbermatch'=>$_SESSION['sip_dialplan_code'],'action'=>'1','objectclass'=>'DPEntry','translateto'=>'%r');
ldap_add($ds,"numbermatch=".$_SESSION['sip_dialplan_code'].",cn=".$_SESSION['sip_dialplan'].",cn=Dialplans",$att);
}
?>
<h3>SIP Trunk Complete</h3>
<div class='block'><label>New SIP Module:</label><a href="/manager/manager.cgi?pagename=module&index=<?php echo $_SESSION['sip_guid'] ?>" target="_blank"><?php echo $_SESSION['sip_name'] ?></a></div>
<div class='block'><label>New SIP Trunk:</label><a href="/manager/manager.cgi?pagename=trunk&index=<?php echo $_SESSION['trunk_guid'] ?>" target="_blank"><?php echo $_SESSION['sip_name'] ?></a></div>
<div class='block'><label>New Trunk Group:</label><a href="/manager/manager.cgi?pagename=trunkgroup&index=<?php echo $_SESSION['trunk_grp_guid'] ?>" target="_blank"><?php echo $_SESSION['sip_trunkgrp'] ?></a></div>
<div class='block'><label>New LCR Plan:</label><a href="/manager/manager.cgi?pagename=lcrplan&index=<?php echo  $_SESSION['lcr_guid'] ?>" target="_blank"><?php echo $_SESSION['sip_lcrplan'] ?></a></div>
<div class='block'><label>Dial Plan:</label><a href="/manager/manager.cgi?pagename=dialplan&index=<?php echo $_SESSION['sip_dialplan'] ?>" target="_blank"><?php echo $_SESSION['sip_dialplan_name'] ?></a>&nbsp;<?php echo (isset($dp_error)) ? $dp_error : "" ?></div><br/><br/>
The new SIP Trunks Status can be viewed in <a href = "../sipconfig.php" target="_blank"><b>SIPConfig</b></a>


<?php 
	session_destroy();
} 
?>
<!-- End Step Five -->
</div>

<div class="overlay" id="overlay" style="display:none;"></div>
        <div class="alert" id="alert">
            <a class="alertclose" id="alertclose"></a>
			<a class="alertOK" id="alertOK"></a>
            <h1>Warning</h1>
            <p>
            <b>Please Note:</b><br/>
			Sites firewall will need to be configured to allow access from the SIP Registration DNS/IP Address : <b><span id="sip_dnsip_address"></span></b> on Port <b><span id="sip_port"></span></b> and for UDP RTP Port Range : <b><span id="sip_rtp"></span></b><br/><br/>
           	SpliceCom recommends that the firewall be configured to only allow access to the maximiser system from recognised external IP addresses for the ports required.<br/>
			For example, the address of the SIP provider, as stated above and your own IP address for remote access to complete diagnostic and configuration work.<br/><br/>
			Please refer to the Protocols and Ports document for port information. All other access should be blocked to minimise the risk of access from undesirable sources.<br/><br/>
            Please select the <span style="color:#329C24; font-weight:bold";>Green Tick</span> to proceed, otherwise select the  <span style="color:#605F61; font-weight:bold";>Grey X</span> to return to Manager Assist.</p>
           </p>
</div>
