<?php

// v4.18
// 20MAR2019 - Update GUID 
// 30NOV2018 - Allow in VMAP
// 04OCT2018 - Hide from VMAP
// 30MAR2016 - Add example URLS for Server fields
// 30MAR2016 - Change Set Update, Set Mode layout, add refresh
// 18MAR2016 - Add Clear Update Time. Add Update Time Column
// 29DEC2015 - Wording change - alert colour change
// 29DEC2015 - Added Firmware Version
// 14-July-2014 - Change SSL Wording
// PJC 04-06-2014 MAC Address case insensitive
// PJC 29MAY2014
session_start();
$page_id = "052";
include ".access.php";
$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
	$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}

include "tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME']; 	
$url = $_SERVER['SERVER_ADDR'];
$getIp = NULL;
$ctx = stream_context_create(array('http'=>
    array(
        'timeout' => 5,  //5 Seconds
    )
));
ini_set('default_socket_timeout', 5); // 5 Seconds
$getIp = @file_get_contents('http://splicepbx.uk/ip/index.php?mode=ip');
$externalIp = (isset($getIp) && strlen($getIp > 1)) ? trim($getIp) : "x.x.x.x";


$sr = @ldap_read($ds,"cn=ssl,cn=system","objectclass=updateserver"); 
if ($sr) { $info = ldap_get_entries($ds,$sr); $sslserver = $info[0]['url'][0]; }
$sslserver = (isset($sslserver) && strlen($sslserver)>1) ? $sslserver : "";

$sr = @ldap_read($ds,"cn=pcs,cn=system","objectclass=updateserver"); 
if ($sr) { $info = ldap_get_entries($ds,$sr); $pcsserver = $info[0]['url'][0]; }
$pcsserver = (isset($pcsserver) && strlen($pcsserver)>1) ? $pcsserver : "";
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>PCS 5xx/SSL Update Server</title>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<style type="text/css">
	@import "css/codes/codes_page.css";
	@import "css/codes/codes_table.css";
	@import "css/codes/custom.css";
	div.srv {overflow:hidden; }
	div.srv label {width:175px; display:block; float:left; text-align:left; vertical-align:middle; }
	div.srv.input {margin-left:4px; float:left; vertical-align:middle; }
</style>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script src="js/wiz/jquery-1.8.0.js" type="text/javascript"></script>
<script src="js/codes/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="js/wiz/main.js" type="text/javascript"></script>
<script type="text/javascript" src="js/jquery.timepicker.js"></script>
<link rel="stylesheet" type="text/css" href="css/jquery.timepicker.css" />

<script type="text/javascript" charset="utf-8">
	$(document).ready(function() {
		oTable = $('#excodes').dataTable({
			"bJQueryUI": true,
			"sPaginationType": "full_numbers",
			"aLengthMenu": [[10, 25, 50, 100, 250, 500], [10, 25, 50, 100, 250, 500]]
			});
			
			$("#setpcs").click(function () { 
				$.ajax({ url : 'ssl_update.php?pcsserver=1&url=' + $("#pcs").val() })
			    .done(function(data) { if (data.toLowerCase().indexOf("warning") >= 0) { pcsStatus = "Fail"; color = '#8C0000'; } else { pcsStatus = "PCS Server Value Updated"; color = '#008C00'; };
				$("#srvStatus").css("color", color).html(pcsStatus+data.slice(0, 100)).show().fadeOut(12000); 
				});
			});
			
			$("#setssl").click(function () { 
				$.ajax({ url : 'ssl_update.php?sslserver=1&url=' + $("#ssl").val() })	 
				.done(function(data) { if (data.toLowerCase().indexOf("warning") >= 0) { sslStatus = "Fail"; color = '#8C0000';  } else { sslStatus = "SSL Server Value Updated"; color = '#006600'; };
				$("#srvStatus").css("color", color).html(sslStatus+data.slice(0, 100)).show().fadeOut(12000); 
				});
			});

			$('#frm').on('submit',function(e) {
				var mode = $("#mode").val();
				console.log ('Mode: ' + mode);
				var mode_txt = (mode == "update") ? "Amended" : "Removed";
				if (mode == "update") {
					if ($('[name=time]').val() == "") { alert('Time Must Be Set'); return false; };
				}
				if (!$('[name^="phones[]"]').is(':checked')) { alert('A Phone Must Be Selected'); return false; };

				$.ajax({
				url:'ssl_update.php',
				data:$(this).serialize(),
				type:'POST'	})
				.done(function(data) { 
					if (data.toLowerCase().indexOf("warning") >= 0) { 
						phoneStatus = "An Error Has Occured - Please Try Again"; color = '#8C0000';  
					} else { 
						phoneStatus = "All Phones Have Had Their Update Times " + mode_txt; color = '#006600'; 
						$("#Status").css("color", color).html(phoneStatus+data.slice(0, 100)).show(); 
						setTimeout(function (){
							location.reload();
						}, 1000);
					};
				});
				e.preventDefault();
				});
		});
</script>
<script type="text/javascript">
checked=false;
function checkedAll (frm) {
	var aa= document.getElementById('frm');
	 if (checked == false)
          {
           checked = true
          }
        else
          {
          checked = false
          }
	for (var i =0; i < aa.elements.length; i++)
	{
	 if (aa.elements[i].getAttribute('id') == 'backup')	continue;
	 aa.elements[i].checked = checked;
	}
      }
</script>
<script>
$(function() {
    $('#setUpdateTime').timepicker({ 'timeFormat': 'H:i','scrollDefaultNow': true,'noneOption': [{'label': 'NOW','value': 'now'}] });
    $('#setNow').on('click', function (){
        $('#setUpdateTime').val('now');  return false;
    });
});
</script>
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings = 'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body id="dt_excodes">
<div style="position:absolute; top:8px; right:8px" >
<img onClick="window.location = '<?php echo $script ?>'" src="images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('help/help_sslupgrade.php','help','600','500','yes');return false" src="images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist.php'" src="images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="images/home16.gif" alt="home" title="home" border="0">
</div>

<div style="position:absolute; top:30px; right:8px">
<?php link_check("094","<a href='sipphones.php' class='orange'>SIP Phone Update</a>", $ma_acl); ?>
</div>

<div id="container"><div id="codes">
<h3><img src='images/settings.png' style="vertical-align:middle;">&nbsp;PCS 5xx/SSL Update Server</h3>

<br/><b>Server Settings</b><br/><br/>
<div class='srv'><label><a href='#' class='tooltip' title='Enter PCS Server Address. eg: http://<?php echo $url?>/update/'><img src='images/tooltip.jpg'></a>&nbsp;<b>PCS Upgrade Server:</b></label><img src='images/blank.gif' width='18px'><input type='text' name='pcs' id='pcs' value='<?php echo $pcsserver ?>' size='25''><input type='button' id='setpcs' name='setpcs' value='Update PCS Server'></div>
<div class='srv'><label><a href='#' class='tooltip' title='Enter SSL Server Address. eg: http://<?php echo $externalIp?>/update/'><img src='images/tooltip.jpg'></a>&nbsp;<b>SSL Upgrade Server:</b></label><img src='images/blank.gif' width='18px'><input type='text' name='ssl' id='ssl' value='<?php echo $sslserver ?>' size='25'><input type='button' id='setssl' name='setssl' value='Update SSL Server'></div><br/>
<span id="srvStatus" style="display:none;"></span><br/>
<br/>
<?php

		// build user array
       $sr = ldap_list($ds,"cn=Users","objectclass=user",array('cn','telephonenumber','initialphone'));
 	   $info = ldap_get_entries($ds, $sr); 
       		for ($m=0; $m<$info['count']; $m++) {
				$users[$info[$m]['initialphone'][0]] = array("name"=>$info[$m]['cn'][0],"extn"=>$info[$m]['telephonenumber'][0]);
			}
			
			
		$sr = ldap_search($ds,"cn=Modules","(&(objectclass=Phone)(typeofphone=2))");
 	   	$info = ldap_get_entries($ds, $sr); 
       		for ($m=0; $m<$info['count']; $m++) {
	       		$dn[$m] = $info[$m]['dn'];
	       		$cn[$m] = $info[$m]['cn'][0];
	       		$guid[$m] = $info[$m]['guid'][0];
       		}
			
 	echo "<form method='post' id='frm' action='$script'>";
	echo "<table cellpadding='0' cellspacing='0' border='0' class='display' id='excodes'>
		<thead><tr><th width='5%'><input type='checkbox' name='select' onclick='checkedAll(frm)'><th width='25%'>Name (serial number)</th><th width='25%'>Username</th><th width='10%'>Extension</th><th width='25%'>Firmware Version</th><th width='15%'>Update Time</th></tr></thead>
		<tfoot><tr><th><input type='checkbox' name='select' onclick='checkedAll(frm)'><th>Name (serial number)</th><th>Username</th><th>Extension</th><th>Firmware Version</th><th>Update Time</th></tr></tfoot><tbody>";


       		foreach ($cn as $cnk => $cnv) {
   			$sr2 = ldap_read($ds,"cn=1,$dn[$cnk]","objectclass=SplicePhone"); $info2 = ldap_get_entries($ds,$sr2); $serial=$info2[0]['serialnumber'][0]; $update=$info2[0]['update'][0];
			$sr2 = ldap_read($ds,"$dn[$cnk]","objectclass=Phone"); $info2 = ldap_get_entries($ds,$sr2); $product_version=$info2[0]['productversion'][0];

   			if( preg_match( '/^00-07-d9.*/i', $serial)) {

   			
			if (array_key_exists($guid[$cnk],$users)) {
				$name = $users[$guid[$cnk]]['name']; $extn = $users[$guid[$cnk]]['extn'];
			} else {
				$name = $extn = "<b>Not Set</b>"; 
			}
				
			echo "<tr><td><input type='checkbox' id='phones' name='phones[]' value='{$guid[$cnk]}'></td><td>$cn[$cnk] <span style='font-size:6pt; font-style: italic;'>($serial)</span></td><td>{$name}</td><td>{$extn}</td><td>{$product_version}</td><td>{$update}</td></tr>";				
			}

}
?>

	</table>
	<b>Create System Backup :</b> <input type='checkbox' name='backup' id='backup' checked />&nbsp;<a href='#' class='tooltip' title='Selecting This Will Allow You To Turn Off Automatic Database Backup'><img src='images/tooltip.jpg'></a><br/><br/>
	
	<div class="srv"><label>Set Update Time Now: </label><input type='submit' id="setNow" value='Set Now' />&nbsp;&nbsp;&nbsp;<input type='hidden' name="sslset" value='set' /></div>
	<div class="srv"><label>Select Update Time: </label><input id='setUpdateTime' type='text' class='time' name='time' size='8' placeholder='click to set' /></div>
	<div class="srv"><label>Set Update Mode: </label><select name="mode" id="mode"><option value="update">Update Time</option><option value="clear">Clear Time</option></select></div>
	<input type='submit' name='update' id='update' value='Update Phone(s)' onclick="return confirm('Update Phone(s) ?')" >
	<input type='hidden' name='model' id='model' value='pcs'>
	<span id="Status" style="display:none;"></span>
</form>
</body>
</html>